/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtouchevent_touchpoint_wrapper.h"

// inner classes

// Extra includes
#include <QVector>
#include <QtGui/qevent.h>
#include <QtGui/qvector2d.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTouchEvent_TouchPoint_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTouchEvent::TouchPoint >()))
        return -1;

    ::QTouchEvent::TouchPoint *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTouchEvent_TouchPoint_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:TouchPoint", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: TouchPoint::TouchPoint(QTouchEvent::TouchPoint)
    // 1: TouchPoint::TouchPoint(int)
    if (numArgs == 0) {
        overloadId = 1; // TouchPoint(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // TouchPoint(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // TouchPoint(QTouchEvent::TouchPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPoint_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // TouchPoint(const QTouchEvent::TouchPoint & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTouchEvent_TouchPoint_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTouchEvent::TouchPoint cppArg0_local;
            ::QTouchEvent::TouchPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // TouchPoint(QTouchEvent::TouchPoint)
                cptr = new ::QTouchEvent::TouchPoint(*cppArg0);
            }
            break;
        }
        case 1: // TouchPoint(int id)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_id = Shiboken::String::createStaticString("id");
                if (PyDict_Contains(kwds, key_id)) {
                    value = PyDict_GetItem(kwds, key_id);
                    if (value && pyArgs[0]) {
                        errInfo = key_id;
                        Py_INCREF(errInfo);
                        goto Sbk_QTouchEvent_TouchPoint_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                            goto Sbk_QTouchEvent_TouchPoint_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_id);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTouchEvent_TouchPoint_Init_TypeError;
                }
            }
            int cppArg0 = -1;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // TouchPoint(int)
                cptr = new ::QTouchEvent::TouchPoint(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTouchEvent::TouchPoint >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTouchEvent_TouchPoint_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTouchEvent_TouchPoint_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_ellipseDiameters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.ellipseDiameters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ellipseDiameters()const
            QSizeF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->ellipseDiameters();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            QFlags<QTouchEvent::TouchPoint::InfoFlag> cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.id";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // id()const
            int cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->id();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_lastNormalizedPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.lastNormalizedPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastNormalizedPos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->lastNormalizedPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_lastPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.lastPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastPos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->lastPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_lastScenePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.lastScenePos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastScenePos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->lastScenePos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_lastScreenPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.lastScreenPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastScreenPos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->lastScreenPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_normalizedPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.normalizedPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // normalizedPos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->normalizedPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.pos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_pressure(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.pressure";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pressure()const
            qreal cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->pressure();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_rawScreenPositions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.rawScreenPositions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rawScreenPositions()const
            QVector<QPointF > cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->rawScreenPositions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_rect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.rect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rect()const
            QRectF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->rect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_rotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.rotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rotation()const
            qreal cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->rotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_scenePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.scenePos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scenePos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->scenePos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_sceneRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.sceneRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sceneRect()const
            QRectF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->sceneRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_screenPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.screenPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // screenPos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->screenPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_screenRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.screenRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // screenRect()const
            QRectF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->screenRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setEllipseDiameters(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setEllipseDiameters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setEllipseDiameters(QSizeF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArg)))) {
        overloadId = 0; // setEllipseDiameters(QSizeF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setEllipseDiameters_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSizeF cppArg0_local;
        ::QSizeF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setEllipseDiameters(QSizeF)
            cppSelf->setEllipseDiameters(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setEllipseDiameters_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setFlags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setFlags(QFlags<QTouchEvent::TouchPoint::InfoFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFlags(QFlags<QTouchEvent::TouchPoint::InfoFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setFlags_TypeError;

    // Call function/method
    {
        ::QFlags<QTouchEvent::TouchPoint::InfoFlag> cppArg0 = QFlags<QTouchEvent::TouchPoint::InfoFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFlags(QFlags<QTouchEvent::TouchPoint::InfoFlag>)
            cppSelf->setFlags(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setId(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setId(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setId_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setId(int)
            cppSelf->setId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setLastNormalizedPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setLastNormalizedPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setLastNormalizedPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setLastNormalizedPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setLastNormalizedPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLastNormalizedPos(QPointF)
            cppSelf->setLastNormalizedPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setLastNormalizedPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setLastPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setLastPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setLastPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setLastPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setLastPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLastPos(QPointF)
            cppSelf->setLastPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setLastPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setLastScenePos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setLastScenePos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setLastScenePos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setLastScenePos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setLastScenePos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLastScenePos(QPointF)
            cppSelf->setLastScenePos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setLastScenePos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setLastScreenPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setLastScreenPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setLastScreenPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setLastScreenPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setLastScreenPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLastScreenPos(QPointF)
            cppSelf->setLastScreenPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setLastScreenPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setNormalizedPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setNormalizedPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setNormalizedPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setNormalizedPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setNormalizedPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setNormalizedPos(QPointF)
            cppSelf->setNormalizedPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setNormalizedPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPos(QPointF)
            cppSelf->setPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setPressure(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setPressure";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setPressure(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setPressure(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setPressure_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPressure(qreal)
            cppSelf->setPressure(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setPressure_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setRawScreenPositions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setRawScreenPositions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setRawScreenPositions(QVector<QPointF>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], (pyArg)))) {
        overloadId = 0; // setRawScreenPositions(QVector<QPointF>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setRawScreenPositions_TypeError;

    // Call function/method
    {
        ::QVector<QPointF > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRawScreenPositions(QVector<QPointF>)
            cppSelf->setRawScreenPositions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setRawScreenPositions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setRect(QRectF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // setRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setRect(QRectF)
            cppSelf->setRect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setRotation(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRotation(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setRotation_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRotation(qreal)
            cppSelf->setRotation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setScenePos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setScenePos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setScenePos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setScenePos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setScenePos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScenePos(QPointF)
            cppSelf->setScenePos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setScenePos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setSceneRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setSceneRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setSceneRect(QRectF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // setSceneRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setSceneRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSceneRect(QRectF)
            cppSelf->setSceneRect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setSceneRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setScreenPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setScreenPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setScreenPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setScreenPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setScreenPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScreenPos(QPointF)
            cppSelf->setScreenPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setScreenPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setScreenRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setScreenRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setScreenRect(QRectF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // setScreenRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setScreenRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScreenRect(QRectF)
            cppSelf->setScreenRect(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setScreenRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setStartNormalizedPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setStartNormalizedPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setStartNormalizedPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setStartNormalizedPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setStartNormalizedPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setStartNormalizedPos(QPointF)
            cppSelf->setStartNormalizedPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setStartNormalizedPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setStartPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setStartPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setStartPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setStartPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setStartPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setStartPos(QPointF)
            cppSelf->setStartPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setStartPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setStartScenePos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setStartScenePos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setStartScenePos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setStartScenePos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setStartScenePos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setStartScenePos(QPointF)
            cppSelf->setStartScenePos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setStartScenePos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setStartScreenPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setStartScreenPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setStartScreenPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setStartScreenPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setStartScreenPos_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setStartScreenPos(QPointF)
            cppSelf->setStartScreenPos(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setStartScreenPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setState(QFlags<Qt::TouchPointState>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setState(QFlags<Qt::TouchPointState>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setState_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::TouchPointState> cppArg0 = QFlags<Qt::TouchPointState>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setState(QFlags<Qt::TouchPointState>)
            cppSelf->setState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setUniqueId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setUniqueId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setUniqueId(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setUniqueId(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setUniqueId_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUniqueId(qint64)
            cppSelf->setUniqueId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setUniqueId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_setVelocity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.setVelocity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::setVelocity(QVector2D)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // setVelocity(QVector2D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_setVelocity_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector2D cppArg0_local;
        ::QVector2D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setVelocity(QVector2D)
            cppSelf->setVelocity(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_setVelocity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_startNormalizedPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.startNormalizedPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startNormalizedPos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->startNormalizedPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_startPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.startPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startPos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->startPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_startScenePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.startScenePos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startScenePos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->startScenePos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_startScreenPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.startScreenPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startScreenPos()const
            QPointF cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->startScreenPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            Qt::TouchPointState cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TOUCHPOINTSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TouchPoint::swap(QTouchEvent::TouchPoint&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QTouchEvent::TouchPoint&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_TouchPointFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTouchEvent::TouchPoint cppArg0_local;
        ::QTouchEvent::TouchPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QTouchEvent::TouchPoint&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEvent_TouchPointFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_uniqueId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.uniqueId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uniqueId()const
            QPointingDeviceUniqueId cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->uniqueId();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPointFunc_velocity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.TouchPoint.velocity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // velocity()const
            QVector2D cppResult = const_cast<const ::QTouchEvent::TouchPoint *>(cppSelf)->velocity();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEvent_TouchPoint___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTouchEvent_TouchPoint_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTouchEvent_TouchPoint_methods[] = {
    {"ellipseDiameters", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_ellipseDiameters), METH_NOARGS},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_flags), METH_NOARGS},
    {"id", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_id), METH_NOARGS},
    {"lastNormalizedPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_lastNormalizedPos), METH_NOARGS},
    {"lastPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_lastPos), METH_NOARGS},
    {"lastScenePos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_lastScenePos), METH_NOARGS},
    {"lastScreenPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_lastScreenPos), METH_NOARGS},
    {"normalizedPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_normalizedPos), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_pos), METH_NOARGS},
    {"pressure", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_pressure), METH_NOARGS},
    {"rawScreenPositions", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_rawScreenPositions), METH_NOARGS},
    {"rect", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_rect), METH_NOARGS},
    {"rotation", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_rotation), METH_NOARGS},
    {"scenePos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_scenePos), METH_NOARGS},
    {"sceneRect", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_sceneRect), METH_NOARGS},
    {"screenPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_screenPos), METH_NOARGS},
    {"screenRect", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_screenRect), METH_NOARGS},
    {"setEllipseDiameters", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setEllipseDiameters), METH_O},
    {"setFlags", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setFlags), METH_O},
    {"setId", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setId), METH_O},
    {"setLastNormalizedPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setLastNormalizedPos), METH_O},
    {"setLastPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setLastPos), METH_O},
    {"setLastScenePos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setLastScenePos), METH_O},
    {"setLastScreenPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setLastScreenPos), METH_O},
    {"setNormalizedPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setNormalizedPos), METH_O},
    {"setPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setPos), METH_O},
    {"setPressure", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setPressure), METH_O},
    {"setRawScreenPositions", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setRawScreenPositions), METH_O},
    {"setRect", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setRect), METH_O},
    {"setRotation", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setRotation), METH_O},
    {"setScenePos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setScenePos), METH_O},
    {"setSceneRect", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setSceneRect), METH_O},
    {"setScreenPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setScreenPos), METH_O},
    {"setScreenRect", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setScreenRect), METH_O},
    {"setStartNormalizedPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setStartNormalizedPos), METH_O},
    {"setStartPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setStartPos), METH_O},
    {"setStartScenePos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setStartScenePos), METH_O},
    {"setStartScreenPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setStartScreenPos), METH_O},
    {"setState", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setState), METH_O},
    {"setUniqueId", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setUniqueId), METH_O},
    {"setVelocity", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_setVelocity), METH_O},
    {"startNormalizedPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_startNormalizedPos), METH_NOARGS},
    {"startPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_startPos), METH_NOARGS},
    {"startScenePos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_startScenePos), METH_NOARGS},
    {"startScreenPos", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_startScreenPos), METH_NOARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_state), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_swap), METH_O},
    {"uniqueId", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_uniqueId), METH_NOARGS},
    {"velocity", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPointFunc_velocity), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTouchEvent_TouchPoint___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTouchEvent_TouchPoint_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTouchEvent_TouchPoint_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QTouchEvent_TouchPoint__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTouchEvent_TouchPoint_Type = nullptr;
static SbkObjectType *Sbk_QTouchEvent_TouchPoint_TypeF(void)
{
    return _Sbk_QTouchEvent_TouchPoint_Type;
}

static PyType_Slot Sbk_QTouchEvent_TouchPoint_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QTouchEvent_TouchPoint__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTouchEvent_TouchPoint_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTouchEvent_TouchPoint_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTouchEvent_TouchPoint_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTouchEvent_TouchPoint_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTouchEvent_TouchPoint_spec = {
    "2:PySide2.QtGui.QTouchEvent.TouchPoint",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTouchEvent_TouchPoint_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QTouchEvent::TouchPoint::InfoFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTouchEvent::TouchPoint::InfoFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTouchEvent::TouchPoint::InfoFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTouchEvent::TouchPoint::InfoFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTouchEvent::TouchPoint::InfoFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QTouchEvent::TouchPoint::InfoFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTouchEvent::TouchPoint::InfoFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTouchEvent::TouchPoint::InfoFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTouchEvent::TouchPoint::InfoFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTouchEvent::TouchPoint::InfoFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTouchEvent::TouchPoint::InfoFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTouchEvent::TouchPoint::InfoFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTouchEvent::TouchPoint::InfoFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTouchEvent::TouchPoint::InfoFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTouchEvent::TouchPoint::InfoFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTouchEvent::TouchPoint::InfoFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])->converter, self, &cppSelf);
    ::QTouchEvent::TouchPoint::InfoFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QTouchEvent_TouchPoint_InfoFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTouchEvent::TouchPoint::InfoFlag *>(cppOut) =
        static_cast<::QTouchEvent::TouchPoint::InfoFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QTouchEvent_TouchPoint_InfoFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX]))
        return QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QTouchEvent_TouchPoint_InfoFlag;
    return {};
}
static PyObject *QTouchEvent_TouchPoint_InfoFlag_CppToPython_QTouchEvent_TouchPoint_InfoFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTouchEvent::TouchPoint::InfoFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX], castCppIn);

}

static void QFlags_QTouchEvent_TouchPoint_InfoFlag__PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTouchEvent::TouchPoint::InfoFlag> *>(cppOut) =
        ::QFlags<QTouchEvent::TouchPoint::InfoFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTouchEvent_TouchPoint_InfoFlag__PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX]))
        return QFlags_QTouchEvent_TouchPoint_InfoFlag__PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag_;
    return {};
}
static PyObject *QFlags_QTouchEvent_TouchPoint_InfoFlag__CppToPython_QFlags_QTouchEvent_TouchPoint_InfoFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTouchEvent::TouchPoint::InfoFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX]));

}

static void QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTouchEvent::TouchPoint::InfoFlag> *>(cppOut) =
        ::QFlags<QTouchEvent::TouchPoint::InfoFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX]))
        return QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTouchEvent::TouchPoint::InfoFlag> *>(cppOut) =
        ::QFlags<QTouchEvent::TouchPoint::InfoFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX]))
        return number_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void TouchPoint_PythonToCpp_TouchPoint_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTouchEvent_TouchPoint_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_TouchPoint_PythonToCpp_TouchPoint_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTouchEvent_TouchPoint_TypeF())))
        return TouchPoint_PythonToCpp_TouchPoint_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *TouchPoint_PTR_CppToPython_TouchPoint(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTouchEvent::TouchPoint *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTouchEvent_TouchPoint_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *TouchPoint_COPY_CppToPython_TouchPoint(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTouchEvent_TouchPoint_TypeF(), new ::QTouchEvent::TouchPoint(*reinterpret_cast<const ::QTouchEvent::TouchPoint *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void TouchPoint_PythonToCpp_TouchPoint_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTouchEvent::TouchPoint *>(cppOut) = *reinterpret_cast< ::QTouchEvent::TouchPoint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_TouchPoint_PythonToCpp_TouchPoint_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTouchEvent_TouchPoint_TypeF())))
        return TouchPoint_PythonToCpp_TouchPoint_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_int_PythonToCpp_QTouchEvent_TouchPoint(PyObject *pyIn, void *cppOut) {
    int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &cppIn);
    *reinterpret_cast<::QTouchEvent::TouchPoint *>(cppOut) = ::QTouchEvent::TouchPoint(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_int_PythonToCpp_QTouchEvent_TouchPoint_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PySide2_QtCore_int_PythonToCpp_QTouchEvent_TouchPoint;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTouchEvent_TouchPoint_SignatureStrings[] = {
    "1:PySide2.QtGui.QTouchEvent.TouchPoint(self,other:PySide2.QtGui.QTouchEvent.TouchPoint)",
    "0:PySide2.QtGui.QTouchEvent.TouchPoint(self,id:int=-1)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.ellipseDiameters(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.flags(self)->PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags",
    "PySide2.QtGui.QTouchEvent.TouchPoint.id(self)->int",
    "PySide2.QtGui.QTouchEvent.TouchPoint.lastNormalizedPos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.lastPos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.lastScenePos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.lastScreenPos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.normalizedPos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.pos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.pressure(self)->qreal",
    "PySide2.QtGui.QTouchEvent.TouchPoint.rawScreenPositions(self)->QVector[PySide2.QtCore.QPointF]",
    "PySide2.QtGui.QTouchEvent.TouchPoint.rect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.rotation(self)->qreal",
    "PySide2.QtGui.QTouchEvent.TouchPoint.scenePos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.sceneRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.screenPos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.screenRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setEllipseDiameters(self,dia:PySide2.QtCore.QSizeF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setFlags(self,flags:PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setId(self,id:int)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setLastNormalizedPos(self,lastNormalizedPos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setLastPos(self,lastPos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setLastScenePos(self,lastScenePos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setLastScreenPos(self,lastScreenPos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setNormalizedPos(self,normalizedPos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setPos(self,pos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setPressure(self,pressure:qreal)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setRawScreenPositions(self,positions:QVector[PySide2.QtCore.QPointF])",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setRect(self,rect:PySide2.QtCore.QRectF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setRotation(self,angle:qreal)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setScenePos(self,scenePos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setSceneRect(self,sceneRect:PySide2.QtCore.QRectF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setScreenPos(self,screenPos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setScreenRect(self,screenRect:PySide2.QtCore.QRectF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setStartNormalizedPos(self,startNormalizedPos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setStartPos(self,startPos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setStartScenePos(self,startScenePos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setStartScreenPos(self,startScreenPos:PySide2.QtCore.QPointF)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setState(self,state:PySide2.QtCore.Qt.TouchPointStates)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setUniqueId(self,uid:qint64)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.setVelocity(self,v:PySide2.QtGui.QVector2D)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.startNormalizedPos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.startPos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.startScenePos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.startScreenPos(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTouchEvent.TouchPoint.state(self)->PySide2.QtCore.Qt.TouchPointState",
    "PySide2.QtGui.QTouchEvent.TouchPoint.swap(self,other:PySide2.QtGui.QTouchEvent.TouchPoint)",
    "PySide2.QtGui.QTouchEvent.TouchPoint.uniqueId(self)->PySide2.QtGui.QPointingDeviceUniqueId",
    "PySide2.QtGui.QTouchEvent.TouchPoint.velocity(self)->PySide2.QtGui.QVector2D",
    "PySide2.QtGui.QTouchEvent.TouchPoint.__copy__()",
    nullptr}; // Sentinel

void init_QTouchEvent_TouchPoint(PyObject *enclosingClass)
{
    _Sbk_QTouchEvent_TouchPoint_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "TouchPoint",
        "QTouchEvent::TouchPoint",
        &Sbk_QTouchEvent_TouchPoint_spec,
        &Shiboken::callCppDestructor< ::QTouchEvent::TouchPoint >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTouchEvent_TouchPoint_Type);
    InitSignatureStrings(pyType, QTouchEvent_TouchPoint_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTouchEvent_TouchPoint_Type), Sbk_QTouchEvent_TouchPoint_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTouchEvent_TouchPoint_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTouchEvent_TouchPoint_TypeF(),
        TouchPoint_PythonToCpp_TouchPoint_PTR,
        is_TouchPoint_PythonToCpp_TouchPoint_PTR_Convertible,
        TouchPoint_PTR_CppToPython_TouchPoint,
        TouchPoint_COPY_CppToPython_TouchPoint);

    Shiboken::Conversions::registerConverterName(converter, "QTouchEvent::TouchPoint");
    Shiboken::Conversions::registerConverterName(converter, "QTouchEvent::TouchPoint*");
    Shiboken::Conversions::registerConverterName(converter, "QTouchEvent::TouchPoint&");
    Shiboken::Conversions::registerConverterName(converter, "TouchPoint");
    Shiboken::Conversions::registerConverterName(converter, "TouchPoint*");
    Shiboken::Conversions::registerConverterName(converter, "TouchPoint&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTouchEvent::TouchPoint).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        TouchPoint_PythonToCpp_TouchPoint_COPY,
        is_TouchPoint_PythonToCpp_TouchPoint_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_int_PythonToCpp_QTouchEvent_TouchPoint,
        is_PySide2_QtCore_int_PythonToCpp_QTouchEvent_TouchPoint_Convertible);

    // Initialization of enums.

    // Initialization of enum 'InfoFlag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags", SbkPySide2_QtGui_QTouchEvent_TouchPoint_InfoFlag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTouchEvent_TouchPoint_TypeF(),
        "InfoFlag",
        "2:PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlag",
        "QTouchEvent::TouchPoint::InfoFlag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX],
        Sbk_QTouchEvent_TouchPoint_TypeF(), "Pen", (long) QTouchEvent::TouchPoint::InfoFlag::Pen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX],
        Sbk_QTouchEvent_TouchPoint_TypeF(), "Token", (long) QTouchEvent::TouchPoint::InfoFlag::Token))
        return;
    // Register converter for enum 'QTouchEvent::TouchPoint::InfoFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX],
            QTouchEvent_TouchPoint_InfoFlag_CppToPython_QTouchEvent_TouchPoint_InfoFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QTouchEvent_TouchPoint_InfoFlag,
            is_QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QTouchEvent_TouchPoint_InfoFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTouchEvent::TouchPoint::InfoFlag");
        Shiboken::Conversions::registerConverterName(converter, "TouchPoint::InfoFlag");
        Shiboken::Conversions::registerConverterName(converter, "InfoFlag");
    }
    // Register converter for flag 'QFlags<QTouchEvent::TouchPoint::InfoFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX],
            QFlags_QTouchEvent_TouchPoint_InfoFlag__CppToPython_QFlags_QTouchEvent_TouchPoint_InfoFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag_,
            is_QTouchEvent_TouchPoint_InfoFlag_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTouchEvent_TouchPoint_InfoFlag__PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag_,
            is_QFlags_QTouchEvent_TouchPoint_InfoFlag__PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag_,
            is_number_PythonToCpp_QFlags_QTouchEvent_TouchPoint_InfoFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHEVENT_TOUCHPOINT_INFOFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTouchEvent::TouchPoint::InfoFlags");
        Shiboken::Conversions::registerConverterName(converter, "TouchPoint::InfoFlags");
        Shiboken::Conversions::registerConverterName(converter, "InfoFlags");
    }
    // End of 'InfoFlag' enum/flags.

    qRegisterMetaType< ::QTouchEvent::TouchPoint::InfoFlag >("TouchPoint::InfoFlag");
    qRegisterMetaType< ::QTouchEvent::TouchPoint::InfoFlag >("QTouchEvent::TouchPoint::InfoFlag");
    qRegisterMetaType< ::QTouchEvent::TouchPoint::InfoFlags >("QTouchEvent::TouchPoint::InfoFlags");
}
