/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtouchevent_wrapper.h"

// inner classes
#include "qtouchevent_touchpoint_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTouchEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTouchEventWrapper::QTouchEventWrapper(::QEvent::Type eventType, ::QTouchDevice * device, ::QFlags<Qt::KeyboardModifier> modifiers, ::QFlags<Qt::TouchPointState> touchPointStates, const ::QList<QTouchEvent::TouchPoint > & touchPoints) : QTouchEvent(eventType, device, modifiers, touchPointStates, touchPoints)
{
    resetPyMethodCache();
    // ... middle
}

QTouchEventWrapper::~QTouchEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTouchEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTouchEvent >()))
        return -1;

    ::QTouchEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTouchEvent_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTouchEvent_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:QTouchEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QTouchEvent::QTouchEvent(QEvent::Type,QTouchDevice*,QFlags<Qt::KeyboardModifier>,QFlags<Qt::TouchPointState>,QList<QTouchEvent::TouchPoint>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QTouchEvent(QEvent::Type,QTouchDevice*,QFlags<Qt::KeyboardModifier>,QFlags<Qt::TouchPointState>,QList<QTouchEvent::TouchPoint>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // QTouchEvent(QEvent::Type,QTouchDevice*,QFlags<Qt::KeyboardModifier>,QFlags<Qt::TouchPointState>,QList<QTouchEvent::TouchPoint>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // QTouchEvent(QEvent::Type,QTouchDevice*,QFlags<Qt::KeyboardModifier>,QFlags<Qt::TouchPointState>,QList<QTouchEvent::TouchPoint>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // QTouchEvent(QEvent::Type,QTouchDevice*,QFlags<Qt::KeyboardModifier>,QFlags<Qt::TouchPointState>,QList<QTouchEvent::TouchPoint>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTOUCHEVENT_TOUCHPOINT_IDX], (pyArgs[4])))) {
                        overloadId = 0; // QTouchEvent(QEvent::Type,QTouchDevice*,QFlags<Qt::KeyboardModifier>,QFlags<Qt::TouchPointState>,QList<QTouchEvent::TouchPoint>)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEvent_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_device = Shiboken::String::createStaticString("device");
            if (PyDict_Contains(kwds, key_device)) {
                value = PyDict_GetItem(kwds, key_device);
                if (value && pyArgs[1]) {
                    errInfo = key_device;
                    Py_INCREF(errInfo);
                    goto Sbk_QTouchEvent_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]), (pyArgs[1]))))
                        goto Sbk_QTouchEvent_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_device);
            }
            static PyObject *const key_modifiers = Shiboken::String::createStaticString("modifiers");
            if (PyDict_Contains(kwds, key_modifiers)) {
                value = PyDict_GetItem(kwds, key_modifiers);
                if (value && pyArgs[2]) {
                    errInfo = key_modifiers;
                    Py_INCREF(errInfo);
                    goto Sbk_QTouchEvent_Init_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QTouchEvent_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_modifiers);
            }
            static PyObject *const key_touchPointStates = Shiboken::String::createStaticString("touchPointStates");
            if (PyDict_Contains(kwds, key_touchPointStates)) {
                value = PyDict_GetItem(kwds, key_touchPointStates);
                if (value && pyArgs[3]) {
                    errInfo = key_touchPointStates;
                    Py_INCREF(errInfo);
                    goto Sbk_QTouchEvent_Init_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QTouchEvent_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_touchPointStates);
            }
            static PyObject *const key_touchPoints = Shiboken::String::createStaticString("touchPoints");
            if (PyDict_Contains(kwds, key_touchPoints)) {
                value = PyDict_GetItem(kwds, key_touchPoints);
                if (value && pyArgs[4]) {
                    errInfo = key_touchPoints;
                    Py_INCREF(errInfo);
                    goto Sbk_QTouchEvent_Init_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTOUCHEVENT_TOUCHPOINT_IDX], (pyArgs[4]))))
                        goto Sbk_QTouchEvent_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_touchPoints);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTouchEvent_Init_TypeError;
            }
        }
        ::QEvent::Type cppArg0{QEvent::None};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QTouchDevice *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QFlags<Qt::TouchPointState> cppArg3 = Qt::TouchPointStates();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QList<QTouchEvent::TouchPoint > cppArg4;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // QTouchEvent(QEvent::Type,QTouchDevice*,QFlags<Qt::KeyboardModifier>,QFlags<Qt::TouchPointState>,QList<QTouchEvent::TouchPoint>)
            cptr = new ::QTouchEventWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTouchEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTouchEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTouchEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTouchEventFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QTouchDevice * cppResult = const_cast<const ::QTouchEvent *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEventFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTouchEvent::setDevice(QTouchDevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QTouchDevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEventFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTouchDevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QTouchDevice*)
            cppSelf->setDevice(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEventFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEventFunc_setTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.setTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTouchEvent::setTarget(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // setTarget(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEventFunc_setTarget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTarget(QObject*)
            cppSelf->setTarget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEventFunc_setTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEventFunc_setTouchPointStates(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.setTouchPointStates";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTouchEvent::setTouchPointStates(QFlags<Qt::TouchPointState>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTouchPointStates(QFlags<Qt::TouchPointState>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEventFunc_setTouchPointStates_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::TouchPointState> cppArg0 = QFlags<Qt::TouchPointState>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTouchPointStates(QFlags<Qt::TouchPointState>)
            cppSelf->setTouchPointStates(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEventFunc_setTouchPointStates_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEventFunc_setTouchPoints(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.setTouchPoints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTouchEvent::setTouchPoints(QList<QTouchEvent::TouchPoint>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTOUCHEVENT_TOUCHPOINT_IDX], (pyArg)))) {
        overloadId = 0; // setTouchPoints(QList<QTouchEvent::TouchPoint>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEventFunc_setTouchPoints_TypeError;

    // Call function/method
    {
        ::QList<QTouchEvent::TouchPoint > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTouchPoints(QList<QTouchEvent::TouchPoint>)
            cppSelf->setTouchPoints(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEventFunc_setTouchPoints_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEventFunc_setWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.setWindow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTouchEvent::setWindow(QWindow*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArg)))) {
        overloadId = 0; // setWindow(QWindow*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchEventFunc_setWindow_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWindow(QWindow*)
            cppSelf->setWindow(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchEventFunc_setWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchEventFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            QObject * cppResult = const_cast<const ::QTouchEvent *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEventFunc_touchPointStates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.touchPointStates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // touchPointStates()const
            QFlags<Qt::TouchPointState> cppResult = const_cast<const ::QTouchEvent *>(cppSelf)->touchPointStates();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_TOUCHPOINTSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEventFunc_touchPoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.touchPoints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // touchPoints()const
            const QList<QTouchEvent::TouchPoint > & cppResult = const_cast<const ::QTouchEvent *>(cppSelf)->touchPoints();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTOUCHEVENT_TOUCHPOINT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchEventFunc_window(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchEvent.window";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // window()const
            QWindow * cppResult = const_cast<const ::QTouchEvent *>(cppSelf)->window();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTouchEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTouchEvent_methods[] = {
    {"device", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_device), METH_NOARGS},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_setDevice), METH_O},
    {"setTarget", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_setTarget), METH_O},
    {"setTouchPointStates", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_setTouchPointStates), METH_O},
    {"setTouchPoints", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_setTouchPoints), METH_O},
    {"setWindow", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_setWindow), METH_O},
    {"target", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_target), METH_NOARGS},
    {"touchPointStates", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_touchPointStates), METH_NOARGS},
    {"touchPoints", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_touchPoints), METH_NOARGS},
    {"window", reinterpret_cast<PyCFunction>(Sbk_QTouchEventFunc_window), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTouchEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTouchEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_QTouchEvent_get__target(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppSelf->_target);
    return pyOut;
}
static int Sbk_QTouchEvent_set__target(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTouchEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'_target' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to '_target', 'QObject' or convertible type expected");
        return -1;
    }

    ::QObject *& cppOut_ptr = cppSelf->_target;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "_target", pyIn);
    return 0;
}

// Getters and Setters for QTouchEvent
static PyGetSetDef Sbk_QTouchEvent_getsetlist[] = {
    {const_cast<char *>("_target"), Sbk_QTouchEvent_get__target, Sbk_QTouchEvent_set__target},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTouchEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTouchEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTouchEvent_Type = nullptr;
static SbkObjectType *Sbk_QTouchEvent_TypeF(void)
{
    return _Sbk_QTouchEvent_Type;
}

static PyType_Slot Sbk_QTouchEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTouchEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTouchEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTouchEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTouchEvent_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QTouchEvent_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTouchEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTouchEvent_spec = {
    "2:PySide2.QtGui.QTouchEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTouchEvent_slots
};

} //extern "C"

static void *Sbk_QTouchEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QEvent >()))
        return dynamic_cast< ::QTouchEvent *>(reinterpret_cast< ::QEvent *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTouchEvent_PythonToCpp_QTouchEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTouchEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTouchEvent_PythonToCpp_QTouchEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTouchEvent_TypeF())))
        return QTouchEvent_PythonToCpp_QTouchEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTouchEvent_PTR_CppToPython_QTouchEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTouchEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTouchEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTouchEvent_SignatureStrings[] = {
    "PySide2.QtGui.QTouchEvent(self,eventType:PySide2.QtCore.QEvent.Type,device:PySide2.QtGui.QTouchDevice=nullptr,modifiers:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,touchPointStates:PySide2.QtCore.Qt.TouchPointStates=Qt.TouchPointStates(),touchPoints:QList[PySide2.QtGui.QTouchEvent.TouchPoint]=QList< QTouchEvent.TouchPoint >())",
    "PySide2.QtGui.QTouchEvent.device(self)->PySide2.QtGui.QTouchDevice",
    "PySide2.QtGui.QTouchEvent.setDevice(self,adevice:PySide2.QtGui.QTouchDevice)",
    "PySide2.QtGui.QTouchEvent.setTarget(self,atarget:PySide2.QtCore.QObject)",
    "PySide2.QtGui.QTouchEvent.setTouchPointStates(self,aTouchPointStates:PySide2.QtCore.Qt.TouchPointStates)",
    "PySide2.QtGui.QTouchEvent.setTouchPoints(self,atouchPoints:QList[PySide2.QtGui.QTouchEvent.TouchPoint])",
    "PySide2.QtGui.QTouchEvent.setWindow(self,awindow:PySide2.QtGui.QWindow)",
    "PySide2.QtGui.QTouchEvent.target(self)->PySide2.QtCore.QObject",
    "PySide2.QtGui.QTouchEvent.touchPointStates(self)->PySide2.QtCore.Qt.TouchPointStates",
    "PySide2.QtGui.QTouchEvent.touchPoints(self)->QList[PySide2.QtGui.QTouchEvent.TouchPoint]",
    "PySide2.QtGui.QTouchEvent.window(self)->PySide2.QtGui.QWindow",
    nullptr}; // Sentinel

void init_QTouchEvent(PyObject *module)
{
    _Sbk_QTouchEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTouchEvent",
        "QTouchEvent*",
        &Sbk_QTouchEvent_spec,
        &Shiboken::callCppDestructor< ::QTouchEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTouchEvent_Type);
    InitSignatureStrings(pyType, QTouchEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTouchEvent_Type), Sbk_QTouchEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTouchEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTouchEvent_TypeF(),
        QTouchEvent_PythonToCpp_QTouchEvent_PTR,
        is_QTouchEvent_PythonToCpp_QTouchEvent_PTR_Convertible,
        QTouchEvent_PTR_CppToPython_QTouchEvent);

    Shiboken::Conversions::registerConverterName(converter, "QTouchEvent");
    Shiboken::Conversions::registerConverterName(converter, "QTouchEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QTouchEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTouchEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTouchEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QTouchEvent_TypeF(), &Sbk_QTouchEvent_typeDiscovery);

}
