/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qwheelevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QWheelEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QWheelEventWrapper::QWheelEventWrapper(::QPointF pos, ::QPointF globalPos, ::QPoint pixelDelta, ::QPoint angleDelta, ::QFlags<Qt::MouseButton> buttons, ::QFlags<Qt::KeyboardModifier> modifiers, ::Qt::ScrollPhase phase, bool inverted, ::Qt::MouseEventSource source) : QWheelEvent(pos, globalPos, pixelDelta, angleDelta, buttons, modifiers, phase, inverted, source)
{
    resetPyMethodCache();
    // ... middle
}

QWheelEventWrapper::QWheelEventWrapper(const ::QPointF & pos, const ::QPointF & globalPos, ::QPoint pixelDelta, ::QPoint angleDelta, int qt4Delta, ::Qt::Orientation qt4Orientation, ::QFlags<Qt::MouseButton> buttons, ::QFlags<Qt::KeyboardModifier> modifiers) : QWheelEvent(pos, globalPos, pixelDelta, angleDelta, qt4Delta, qt4Orientation, buttons, modifiers)
{
    resetPyMethodCache();
    // ... middle
}

QWheelEventWrapper::QWheelEventWrapper(const ::QPointF & pos, const ::QPointF & globalPos, ::QPoint pixelDelta, ::QPoint angleDelta, int qt4Delta, ::Qt::Orientation qt4Orientation, ::QFlags<Qt::MouseButton> buttons, ::QFlags<Qt::KeyboardModifier> modifiers, ::Qt::ScrollPhase phase) : QWheelEvent(pos, globalPos, pixelDelta, angleDelta, qt4Delta, qt4Orientation, buttons, modifiers, phase)
{
    resetPyMethodCache();
    // ... middle
}

QWheelEventWrapper::QWheelEventWrapper(const ::QPointF & pos, const ::QPointF & globalPos, ::QPoint pixelDelta, ::QPoint angleDelta, int qt4Delta, ::Qt::Orientation qt4Orientation, ::QFlags<Qt::MouseButton> buttons, ::QFlags<Qt::KeyboardModifier> modifiers, ::Qt::ScrollPhase phase, ::Qt::MouseEventSource source) : QWheelEvent(pos, globalPos, pixelDelta, angleDelta, qt4Delta, qt4Orientation, buttons, modifiers, phase, source)
{
    resetPyMethodCache();
    // ... middle
}

QWheelEventWrapper::QWheelEventWrapper(const ::QPointF & pos, const ::QPointF & globalPos, ::QPoint pixelDelta, ::QPoint angleDelta, int qt4Delta, ::Qt::Orientation qt4Orientation, ::QFlags<Qt::MouseButton> buttons, ::QFlags<Qt::KeyboardModifier> modifiers, ::Qt::ScrollPhase phase, ::Qt::MouseEventSource source, bool inverted) : QWheelEvent(pos, globalPos, pixelDelta, angleDelta, qt4Delta, qt4Orientation, buttons, modifiers, phase, source, inverted)
{
    resetPyMethodCache();
    // ... middle
}

QWheelEventWrapper::QWheelEventWrapper(const ::QPointF & pos, const ::QPointF & globalPos, int delta, ::QFlags<Qt::MouseButton> buttons, ::QFlags<Qt::KeyboardModifier> modifiers, ::Qt::Orientation orient) : QWheelEvent(pos, globalPos, delta, buttons, modifiers, orient)
{
    resetPyMethodCache();
    // ... middle
}

QWheelEventWrapper::QWheelEventWrapper(const ::QPointF & pos, int delta, ::QFlags<Qt::MouseButton> buttons, ::QFlags<Qt::KeyboardModifier> modifiers, ::Qt::Orientation orient) : QWheelEvent(pos, delta, buttons, modifiers, orient)
{
    resetPyMethodCache();
    // ... middle
}

QWheelEventWrapper::~QWheelEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWheelEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWheelEvent >()))
        return -1;

    ::QWheelEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 11) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWheelEvent_Init_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWheelEvent_Init_TypeError;
    } else if (numArgs == 7)
        goto Sbk_QWheelEvent_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOOOOOO:QWheelEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10])))
        return -1;


    // Overloaded function decisor
    // 0: QWheelEvent::QWheelEvent(QPointF,QPointF,QPoint,QPoint,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,bool,Qt::MouseEventSource)
    // 1: QWheelEvent::QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>)
    // 2: QWheelEvent::QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase)
    // 3: QWheelEvent::QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,Qt::MouseEventSource)
    // 4: QWheelEvent::QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,Qt::MouseEventSource,bool)
    // 5: QWheelEvent::QWheelEvent(QPointF,QPointF,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
    // 6: QWheelEvent::QWheelEvent(QPointF,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        if (numArgs >= 4
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 6; // QWheelEvent(QPointF,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyArgs[4])))) {
                overloadId = 6; // QWheelEvent(QPointF,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
            if (numArgs >= 5
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 5; // QWheelEvent(QPointF,QPointF,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyArgs[5])))) {
                    overloadId = 5; // QWheelEvent(QPointF,QPointF,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
                }
            } else if (numArgs >= 4
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3])))) {
                if (numArgs >= 8
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyArgs[5])))
                    && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[6])))
                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[7])))) {
                    if (numArgs == 8) {
                        overloadId = 1; // QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>)
                    } else if (numArgs >= 9
                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX])->converter, (pyArgs[8])))) {
                        if (numArgs == 9) {
                            overloadId = 2; // QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase)
                        } else if (numArgs >= 10
                            && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX])->converter, (pyArgs[9])))) {
                            if (numArgs == 10) {
                                overloadId = 3; // QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,Qt::MouseEventSource)
                            } else if (numArgs == 11
                                && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[10])))) {
                                overloadId = 4; // QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,Qt::MouseEventSource,bool)
                            }
                        }
                    }
                } else if (numArgs >= 8
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[4])))
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[5])))
                    && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX])->converter, (pyArgs[6])))
                    && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[7])))) {
                    if (numArgs == 8) {
                        overloadId = 0; // QWheelEvent(QPointF,QPointF,QPoint,QPoint,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,bool,Qt::MouseEventSource)
                    } else if (numArgs >= 9
                        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX])->converter, (pyArgs[8])))) {
                        overloadId = 0; // QWheelEvent(QPointF,QPointF,QPoint,QPoint,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,bool,Qt::MouseEventSource)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWheelEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QWheelEvent(QPointF pos, QPointF globalPos, QPoint pixelDelta, QPoint angleDelta, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::ScrollPhase phase, bool inverted, Qt::MouseEventSource source)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_source = Shiboken::String::createStaticString("source");
                if (PyDict_Contains(kwds, key_source)) {
                    value = PyDict_GetItem(kwds, key_source);
                    if (value && pyArgs[8]) {
                        errInfo = key_source;
                        Py_INCREF(errInfo);
                        goto Sbk_QWheelEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[8] = value;
                        if (!(pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX])->converter, (pyArgs[8]))))
                            goto Sbk_QWheelEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_source);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QWheelEvent_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPoint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QPoint cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<Qt::MouseButton> cppArg4 = QFlags<Qt::MouseButton>(0);
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QFlags<Qt::KeyboardModifier> cppArg5 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::Qt::ScrollPhase cppArg6{Qt::NoScrollPhase};
            pythonToCpp[6](pyArgs[6], &cppArg6);
            bool cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::Qt::MouseEventSource cppArg8 = Qt::MouseEventNotSynthesized;
            if (pythonToCpp[8]) pythonToCpp[8](pyArgs[8], &cppArg8);

            if (!PyErr_Occurred()) {
                // QWheelEvent(QPointF,QPointF,QPoint,QPoint,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,bool,Qt::MouseEventSource)
                cptr = new ::QWheelEventWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
            }
            break;
        }
        case 1: // QWheelEvent(const QPointF & pos, const QPointF & globalPos, QPoint pixelDelta, QPoint angleDelta, int qt4Delta, Qt::Orientation qt4Orientation, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QWheelEvent_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPoint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QPoint cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::Qt::Orientation cppArg5 = static_cast< ::Qt::Orientation>(0);
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QFlags<Qt::MouseButton> cppArg6 = QFlags<Qt::MouseButton>(0);
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QFlags<Qt::KeyboardModifier> cppArg7 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[7](pyArgs[7], &cppArg7);

            if (!PyErr_Occurred()) {
                // QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>)
                cptr = new ::QWheelEventWrapper(*cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QWheelEvent.QWheelEvent(const QPointF & pos, const QPointF & globalPos, QPoint pixelDelta, QPoint angleDelta, int qt4Delta, Qt::Orientation qt4Orientation, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers) is deprecated", 1);
            break;
        }
        case 2: // QWheelEvent(const QPointF & pos, const QPointF & globalPos, QPoint pixelDelta, QPoint angleDelta, int qt4Delta, Qt::Orientation qt4Orientation, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::ScrollPhase phase)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QWheelEvent_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPoint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QPoint cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::Qt::Orientation cppArg5 = static_cast< ::Qt::Orientation>(0);
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QFlags<Qt::MouseButton> cppArg6 = QFlags<Qt::MouseButton>(0);
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QFlags<Qt::KeyboardModifier> cppArg7 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::Qt::ScrollPhase cppArg8{Qt::NoScrollPhase};
            pythonToCpp[8](pyArgs[8], &cppArg8);

            if (!PyErr_Occurred()) {
                // QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase)
                cptr = new ::QWheelEventWrapper(*cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QWheelEvent.QWheelEvent(const QPointF & pos, const QPointF & globalPos, QPoint pixelDelta, QPoint angleDelta, int qt4Delta, Qt::Orientation qt4Orientation, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::ScrollPhase phase) is deprecated", 1);
            break;
        }
        case 3: // QWheelEvent(const QPointF & pos, const QPointF & globalPos, QPoint pixelDelta, QPoint angleDelta, int qt4Delta, Qt::Orientation qt4Orientation, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::ScrollPhase phase, Qt::MouseEventSource source)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QWheelEvent_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPoint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QPoint cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::Qt::Orientation cppArg5 = static_cast< ::Qt::Orientation>(0);
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QFlags<Qt::MouseButton> cppArg6 = QFlags<Qt::MouseButton>(0);
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QFlags<Qt::KeyboardModifier> cppArg7 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::Qt::ScrollPhase cppArg8{Qt::NoScrollPhase};
            pythonToCpp[8](pyArgs[8], &cppArg8);
            ::Qt::MouseEventSource cppArg9{Qt::MouseEventNotSynthesized};
            pythonToCpp[9](pyArgs[9], &cppArg9);

            if (!PyErr_Occurred()) {
                // QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,Qt::MouseEventSource)
                cptr = new ::QWheelEventWrapper(*cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QWheelEvent.QWheelEvent(const QPointF & pos, const QPointF & globalPos, QPoint pixelDelta, QPoint angleDelta, int qt4Delta, Qt::Orientation qt4Orientation, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::ScrollPhase phase, Qt::MouseEventSource source) is deprecated", 1);
            break;
        }
        case 4: // QWheelEvent(const QPointF & pos, const QPointF & globalPos, QPoint pixelDelta, QPoint angleDelta, int qt4Delta, Qt::Orientation qt4Orientation, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::ScrollPhase phase, Qt::MouseEventSource source, bool inverted)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QWheelEvent_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPoint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QPoint cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::Qt::Orientation cppArg5 = static_cast< ::Qt::Orientation>(0);
            pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QFlags<Qt::MouseButton> cppArg6 = QFlags<Qt::MouseButton>(0);
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QFlags<Qt::KeyboardModifier> cppArg7 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::Qt::ScrollPhase cppArg8{Qt::NoScrollPhase};
            pythonToCpp[8](pyArgs[8], &cppArg8);
            ::Qt::MouseEventSource cppArg9{Qt::MouseEventNotSynthesized};
            pythonToCpp[9](pyArgs[9], &cppArg9);
            bool cppArg10;
            pythonToCpp[10](pyArgs[10], &cppArg10);

            if (!PyErr_Occurred()) {
                // QWheelEvent(QPointF,QPointF,QPoint,QPoint,int,Qt::Orientation,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::ScrollPhase,Qt::MouseEventSource,bool)
                cptr = new ::QWheelEventWrapper(*cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QWheelEvent.QWheelEvent(const QPointF & pos, const QPointF & globalPos, QPoint pixelDelta, QPoint angleDelta, int qt4Delta, Qt::Orientation qt4Orientation, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::ScrollPhase phase, Qt::MouseEventSource source, bool inverted) is deprecated", 1);
            break;
        }
        case 5: // QWheelEvent(const QPointF & pos, const QPointF & globalPos, int delta, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::Orientation orient)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_orient = Shiboken::String::createStaticString("orient");
                if (PyDict_Contains(kwds, key_orient)) {
                    value = PyDict_GetItem(kwds, key_orient);
                    if (value && pyArgs[5]) {
                        errInfo = key_orient;
                        Py_INCREF(errInfo);
                        goto Sbk_QWheelEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyArgs[5]))))
                            goto Sbk_QWheelEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_orient);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QWheelEvent_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::MouseButton> cppArg3 = QFlags<Qt::MouseButton>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<Qt::KeyboardModifier> cppArg4 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::Qt::Orientation cppArg5 = Qt::Vertical;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // QWheelEvent(QPointF,QPointF,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
                cptr = new ::QWheelEventWrapper(*cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QWheelEvent.QWheelEvent(const QPointF & pos, const QPointF & globalPos, int delta, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::Orientation orient) is deprecated", 1);
            break;
        }
        case 6: // QWheelEvent(const QPointF & pos, int delta, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::Orientation orient)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_orient = Shiboken::String::createStaticString("orient");
                if (PyDict_Contains(kwds, key_orient)) {
                    value = PyDict_GetItem(kwds, key_orient);
                    if (value && pyArgs[4]) {
                        errInfo = key_orient;
                        Py_INCREF(errInfo);
                        goto Sbk_QWheelEvent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyArgs[4]))))
                            goto Sbk_QWheelEvent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_orient);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QWheelEvent_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::MouseButton> cppArg2 = QFlags<Qt::MouseButton>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::KeyboardModifier> cppArg3 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::Qt::Orientation cppArg4 = Qt::Vertical;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QWheelEvent(QPointF,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
                cptr = new ::QWheelEventWrapper(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QWheelEvent.QWheelEvent(const QPointF & pos, int delta, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::Orientation orient) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWheelEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWheelEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QWheelEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWheelEventFunc_angleDelta(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.angleDelta";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // angleDelta()const
            QPoint cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->angleDelta();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_buttons(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.buttons";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buttons()const
            QFlags<Qt::MouseButton> cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->buttons();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_delta(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.delta";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // delta()const
            int cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->delta();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_globalPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.globalPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalPos()const
            QPoint cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->globalPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_globalPosF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.globalPosF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalPosF()const
            const QPointF & cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->globalPosF();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_globalPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.globalPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalPosition()const
            QPointF cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->globalPosition();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_globalX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.globalX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalX()const
            int cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->globalX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_globalY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.globalY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalY()const
            int cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->globalY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_inverted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.inverted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inverted()const
            bool cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->inverted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_orientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.orientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // orientation()const
            Qt::Orientation cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->orientation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_phase(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.phase";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // phase()const
            Qt::ScrollPhase cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->phase();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SCROLLPHASE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_pixelDelta(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.pixelDelta";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelDelta()const
            QPoint cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->pixelDelta();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.pos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            QPoint cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_posF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.posF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // posF()const
            const QPointF & cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->posF();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            QPointF cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_source(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.source";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // source()const
            Qt::MouseEventSource cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->source();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEEVENTSOURCE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_x(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.x";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x()const
            int cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->x();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWheelEventFunc_y(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QWheelEvent.y";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y()const
            int cppResult = const_cast<const ::QWheelEvent *>(cppSelf)->y();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWheelEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWheelEvent_methods[] = {
    {"angleDelta", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_angleDelta), METH_NOARGS},
    {"buttons", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_buttons), METH_NOARGS},
    {"delta", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_delta), METH_NOARGS},
    {"globalPos", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_globalPos), METH_NOARGS},
    {"globalPosF", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_globalPosF), METH_NOARGS},
    {"globalPosition", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_globalPosition), METH_NOARGS},
    {"globalX", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_globalX), METH_NOARGS},
    {"globalY", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_globalY), METH_NOARGS},
    {"inverted", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_inverted), METH_NOARGS},
    {"orientation", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_orientation), METH_NOARGS},
    {"phase", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_phase), METH_NOARGS},
    {"pixelDelta", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_pixelDelta), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_pos), METH_NOARGS},
    {"posF", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_posF), METH_NOARGS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_position), METH_NOARGS},
    {"source", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_source), METH_NOARGS},
    {"x", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_x), METH_NOARGS},
    {"y", reinterpret_cast<PyCFunction>(Sbk_QWheelEventFunc_y), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QWheelEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QWheelEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_QWheelEvent_get_pixelD(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->pixelD)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->pixelD))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->pixelD)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &(cppSelf->pixelD), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QWheelEvent_set_pixelD(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'pixelD' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'pixelD', 'QPoint' or convertible type expected");
        return -1;
    }

    ::QPoint& cppOut_ptr = cppSelf->pixelD;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QWheelEvent_get_angleD(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->angleD)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->angleD))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->angleD)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &(cppSelf->angleD), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QWheelEvent_set_angleD(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'angleD' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'angleD', 'QPoint' or convertible type expected");
        return -1;
    }

    ::QPoint& cppOut_ptr = cppSelf->angleD;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QWheelEvent_get_qt4D(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->qt4D;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QWheelEvent_set_qt4D(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'qt4D' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'qt4D', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->qt4D;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->qt4D = cppOut_local;

    return 0;
}

static PyObject *Sbk_QWheelEvent_get_qt4O(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::Orientation cppOut_local = cppSelf->qt4O;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QWheelEvent_set_qt4O(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'qt4O' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'qt4O', 'Orientation' or convertible type expected");
        return -1;
    }

    ::Qt::Orientation cppOut_local = cppSelf->qt4O;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->qt4O = cppOut_local;

    return 0;
}

static PyObject *Sbk_QWheelEvent_get__unused_(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    uint cppOut_local = cppSelf->_unused_;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QWheelEvent_set__unused_(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'_unused_' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to '_unused_', 'uint' or convertible type expected");
        return -1;
    }

    uint cppOut_local = cppSelf->_unused_;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->_unused_ = cppOut_local;

    return 0;
}

static PyObject *Sbk_QWheelEvent_get_src(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    uint cppOut_local = cppSelf->src;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QWheelEvent_set_src(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'src' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'src', 'uint' or convertible type expected");
        return -1;
    }

    uint cppOut_local = cppSelf->src;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->src = cppOut_local;

    return 0;
}

static PyObject *Sbk_QWheelEvent_get_invertedScrolling(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->invertedScrolling;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QWheelEvent_set_invertedScrolling(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'invertedScrolling' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'invertedScrolling', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->invertedScrolling;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->invertedScrolling = cppOut_local;

    return 0;
}

static PyObject *Sbk_QWheelEvent_get_ph(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    uint cppOut_local = cppSelf->ph;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QWheelEvent_set_ph(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'ph' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'ph', 'uint' or convertible type expected");
        return -1;
    }

    uint cppOut_local = cppSelf->ph;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->ph = cppOut_local;

    return 0;
}

static PyObject *Sbk_QWheelEvent_get_reserved(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->reserved;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QWheelEvent_set_reserved(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QWheelEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'reserved' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'reserved', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->reserved;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->reserved = cppOut_local;

    return 0;
}

// Getters and Setters for QWheelEvent
static PyGetSetDef Sbk_QWheelEvent_getsetlist[] = {
    {const_cast<char *>("pixelD"), Sbk_QWheelEvent_get_pixelD, Sbk_QWheelEvent_set_pixelD},
    {const_cast<char *>("angleD"), Sbk_QWheelEvent_get_angleD, Sbk_QWheelEvent_set_angleD},
    {const_cast<char *>("qt4D"), Sbk_QWheelEvent_get_qt4D, Sbk_QWheelEvent_set_qt4D},
    {const_cast<char *>("qt4O"), Sbk_QWheelEvent_get_qt4O, Sbk_QWheelEvent_set_qt4O},
    {const_cast<char *>("_unused_"), Sbk_QWheelEvent_get__unused_, Sbk_QWheelEvent_set__unused_},
    {const_cast<char *>("src"), Sbk_QWheelEvent_get_src, Sbk_QWheelEvent_set_src},
    {const_cast<char *>("invertedScrolling"), Sbk_QWheelEvent_get_invertedScrolling, Sbk_QWheelEvent_set_invertedScrolling},
    {const_cast<char *>("ph"), Sbk_QWheelEvent_get_ph, Sbk_QWheelEvent_set_ph},
    {const_cast<char *>("reserved"), Sbk_QWheelEvent_get_reserved, Sbk_QWheelEvent_set_reserved},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QWheelEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWheelEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWheelEvent_Type = nullptr;
static SbkObjectType *Sbk_QWheelEvent_TypeF(void)
{
    return _Sbk_QWheelEvent_Type;
}

static PyType_Slot Sbk_QWheelEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QWheelEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWheelEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWheelEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWheelEvent_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QWheelEvent_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWheelEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWheelEvent_spec = {
    "2:PySide2.QtGui.QWheelEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWheelEvent_slots
};

} //extern "C"

static void *Sbk_QWheelEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QWheelEvent *>(cptr)->type() == QEvent::Wheel)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWheelEvent_PythonToCpp_QWheelEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWheelEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWheelEvent_PythonToCpp_QWheelEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWheelEvent_TypeF())))
        return QWheelEvent_PythonToCpp_QWheelEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWheelEvent_PTR_CppToPython_QWheelEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWheelEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWheelEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWheelEvent_SignatureStrings[] = {
    "6:PySide2.QtGui.QWheelEvent(self,pos:PySide2.QtCore.QPointF,globalPos:PySide2.QtCore.QPointF,pixelDelta:PySide2.QtCore.QPoint,angleDelta:PySide2.QtCore.QPoint,buttons:PySide2.QtCore.Qt.MouseButtons,modifiers:PySide2.QtCore.Qt.KeyboardModifiers,phase:PySide2.QtCore.Qt.ScrollPhase,inverted:bool,source:PySide2.QtCore.Qt.MouseEventSource=Qt.MouseEventNotSynthesized)",
    "5:PySide2.QtGui.QWheelEvent(self,pos:PySide2.QtCore.QPointF,globalPos:PySide2.QtCore.QPointF,pixelDelta:PySide2.QtCore.QPoint,angleDelta:PySide2.QtCore.QPoint,qt4Delta:int,qt4Orientation:PySide2.QtCore.Qt.Orientation,buttons:PySide2.QtCore.Qt.MouseButtons,modifiers:PySide2.QtCore.Qt.KeyboardModifiers)",
    "4:PySide2.QtGui.QWheelEvent(self,pos:PySide2.QtCore.QPointF,globalPos:PySide2.QtCore.QPointF,pixelDelta:PySide2.QtCore.QPoint,angleDelta:PySide2.QtCore.QPoint,qt4Delta:int,qt4Orientation:PySide2.QtCore.Qt.Orientation,buttons:PySide2.QtCore.Qt.MouseButtons,modifiers:PySide2.QtCore.Qt.KeyboardModifiers,phase:PySide2.QtCore.Qt.ScrollPhase)",
    "3:PySide2.QtGui.QWheelEvent(self,pos:PySide2.QtCore.QPointF,globalPos:PySide2.QtCore.QPointF,pixelDelta:PySide2.QtCore.QPoint,angleDelta:PySide2.QtCore.QPoint,qt4Delta:int,qt4Orientation:PySide2.QtCore.Qt.Orientation,buttons:PySide2.QtCore.Qt.MouseButtons,modifiers:PySide2.QtCore.Qt.KeyboardModifiers,phase:PySide2.QtCore.Qt.ScrollPhase,source:PySide2.QtCore.Qt.MouseEventSource)",
    "2:PySide2.QtGui.QWheelEvent(self,pos:PySide2.QtCore.QPointF,globalPos:PySide2.QtCore.QPointF,pixelDelta:PySide2.QtCore.QPoint,angleDelta:PySide2.QtCore.QPoint,qt4Delta:int,qt4Orientation:PySide2.QtCore.Qt.Orientation,buttons:PySide2.QtCore.Qt.MouseButtons,modifiers:PySide2.QtCore.Qt.KeyboardModifiers,phase:PySide2.QtCore.Qt.ScrollPhase,source:PySide2.QtCore.Qt.MouseEventSource,inverted:bool)",
    "1:PySide2.QtGui.QWheelEvent(self,pos:PySide2.QtCore.QPointF,globalPos:PySide2.QtCore.QPointF,delta:int,buttons:PySide2.QtCore.Qt.MouseButtons,modifiers:PySide2.QtCore.Qt.KeyboardModifiers,orient:PySide2.QtCore.Qt.Orientation=Qt.Vertical)",
    "0:PySide2.QtGui.QWheelEvent(self,pos:PySide2.QtCore.QPointF,delta:int,buttons:PySide2.QtCore.Qt.MouseButtons,modifiers:PySide2.QtCore.Qt.KeyboardModifiers,orient:PySide2.QtCore.Qt.Orientation=Qt.Vertical)",
    "PySide2.QtGui.QWheelEvent.angleDelta(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QWheelEvent.buttons(self)->PySide2.QtCore.Qt.MouseButtons",
    "PySide2.QtGui.QWheelEvent.delta(self)->int",
    "PySide2.QtGui.QWheelEvent.globalPos(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QWheelEvent.globalPosF(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QWheelEvent.globalPosition(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QWheelEvent.globalX(self)->int",
    "PySide2.QtGui.QWheelEvent.globalY(self)->int",
    "PySide2.QtGui.QWheelEvent.inverted(self)->bool",
    "PySide2.QtGui.QWheelEvent.orientation(self)->PySide2.QtCore.Qt.Orientation",
    "PySide2.QtGui.QWheelEvent.phase(self)->PySide2.QtCore.Qt.ScrollPhase",
    "PySide2.QtGui.QWheelEvent.pixelDelta(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QWheelEvent.pos(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QWheelEvent.posF(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QWheelEvent.position(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QWheelEvent.source(self)->PySide2.QtCore.Qt.MouseEventSource",
    "PySide2.QtGui.QWheelEvent.x(self)->int",
    "PySide2.QtGui.QWheelEvent.y(self)->int",
    nullptr}; // Sentinel

void init_QWheelEvent(PyObject *module)
{
    _Sbk_QWheelEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWheelEvent",
        "QWheelEvent*",
        &Sbk_QWheelEvent_spec,
        &Shiboken::callCppDestructor< ::QWheelEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWheelEvent_Type);
    InitSignatureStrings(pyType, QWheelEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWheelEvent_Type), Sbk_QWheelEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWheelEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWheelEvent_TypeF(),
        QWheelEvent_PythonToCpp_QWheelEvent_PTR,
        is_QWheelEvent_PythonToCpp_QWheelEvent_PTR_Convertible,
        QWheelEvent_PTR_CppToPython_QWheelEvent);

    Shiboken::Conversions::registerConverterName(converter, "QWheelEvent");
    Shiboken::Conversions::registerConverterName(converter, "QWheelEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QWheelEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWheelEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWheelEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QWheelEvent_TypeF(), &Sbk_QWheelEvent_typeDiscovery);

}
