/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qgeocodereply_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoCodeReplyWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoCodeReplyWrapper::QGeoCodeReplyWrapper(::QGeoCodeReply::Error error, const ::QString & errorString, ::QObject * parent) : QGeoCodeReply(error, errorString, parent)
{
    resetPyMethodCache();
    // ... middle
}

QGeoCodeReplyWrapper::QGeoCodeReplyWrapper(::QObject * parent) : QGeoCodeReply(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QGeoCodeReplyWrapper::abort()
{
    if (m_PyMethodCache[0]) {
        return this->::QGeoCodeReply::abort();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "abort";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGeoCodeReply::abort();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoCodeReplyWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoCodeReplyWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoCodeReplyWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoCodeReplyWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGeoCodeReplyWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoCodeReply.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGeoCodeReplyWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoCodeReply.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGeoCodeReplyWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGeoCodeReplyWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGeoCodeReply::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGeoCodeReplyWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGeoCodeReply::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGeoCodeReplyWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGeoCodeReplyWrapper *>(this));
        return QGeoCodeReply::qt_metacast(_clname);
}

QGeoCodeReplyWrapper::~QGeoCodeReplyWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoCodeReply_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoCodeReply >()))
        return -1;

    ::QGeoCodeReplyWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOO:QGeoCodeReply", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoCodeReply::QGeoCodeReply(QGeoCodeReply::Error,QString,QObject*)
    // 1: QGeoCodeReply::QGeoCodeReply(QObject*)
    if (numArgs == 0) {
        overloadId = 1; // QGeoCodeReply(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGeoCodeReply(QObject*)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // QGeoCodeReply(QGeoCodeReply::Error,QString,QObject*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
            overloadId = 0; // QGeoCodeReply(QGeoCodeReply::Error,QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCodeReply_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoCodeReply(QGeoCodeReply::Error error, const QString & errorString, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QGeoCodeReply_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QGeoCodeReply_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QGeoCodeReply::Error cppArg0{QGeoCodeReply::NoError};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QGeoCodeReply(QGeoCodeReply::Error,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QGeoCodeReplyWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QGeoCodeReplyWrapper(cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
        case 1: // QGeoCodeReply(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QGeoCodeReply_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QGeoCodeReply_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGeoCodeReply(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QGeoCodeReplyWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QGeoCodeReplyWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoCodeReply >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoCodeReply_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGeoCodeReply_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGeoCodeReply_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoCodeReplyFunc_abort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.abort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // abort()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGeoCodeReply::abort()
                : cppSelf->abort();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGeoCodeReplyFunc_addLocation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.addLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCodeReply::addLocation(QGeoLocation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), (pyArg)))) {
        overloadId = 0; // addLocation(QGeoLocation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCodeReplyFunc_addLocation_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoLocation cppArg0_local;
        ::QGeoLocation *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addLocation(QGeoLocation)
            cppSelf->addLocation(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCodeReplyFunc_addLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCodeReplyFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QGeoCodeReply::Error cppResult = const_cast<const ::QGeoCodeReply *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCodeReplyFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QGeoCodeReply *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCodeReplyFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.isFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = const_cast<const ::QGeoCodeReply *>(cppSelf)->isFinished();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCodeReplyFunc_limit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.limit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // limit()const
            int cppResult = const_cast<const ::QGeoCodeReply *>(cppSelf)->limit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCodeReplyFunc_locations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.locations";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // locations()const
            QList<QGeoLocation > cppResult = const_cast<const ::QGeoCodeReply *>(cppSelf)->locations();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOLOCATION_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCodeReplyFunc_offset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.offset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // offset()const
            int cppResult = const_cast<const ::QGeoCodeReply *>(cppSelf)->offset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCodeReplyFunc_setError(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.setError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setError", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoCodeReply::setError(QGeoCodeReply::Error,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // setError(QGeoCodeReply::Error,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCodeReplyFunc_setError_TypeError;

    // Call function/method
    {
        ::QGeoCodeReply::Error cppArg0{QGeoCodeReply::NoError};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setError(QGeoCodeReply::Error,QString)
            cppSelf->setError(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCodeReplyFunc_setError_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCodeReplyFunc_setFinished(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.setFinished";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCodeReply::setFinished(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFinished(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCodeReplyFunc_setFinished_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFinished(bool)
            cppSelf->setFinished(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCodeReplyFunc_setFinished_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCodeReplyFunc_setLimit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.setLimit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCodeReply::setLimit(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLimit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCodeReplyFunc_setLimit_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLimit(int)
            cppSelf->setLimit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCodeReplyFunc_setLimit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCodeReplyFunc_setLocations(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.setLocations";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCodeReply::setLocations(QList<QGeoLocation>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOLOCATION_IDX], (pyArg)))) {
        overloadId = 0; // setLocations(QList<QGeoLocation>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCodeReplyFunc_setLocations_TypeError;

    // Call function/method
    {
        ::QList<QGeoLocation > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLocations(QList<QGeoLocation>)
            cppSelf->setLocations(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCodeReplyFunc_setLocations_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCodeReplyFunc_setOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.setOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCodeReply::setOffset(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setOffset(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCodeReplyFunc_setOffset_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOffset(int)
            cppSelf->setOffset(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCodeReplyFunc_setOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCodeReplyFunc_setViewport(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.setViewport";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCodeReply::setViewport(QGeoShape)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), (pyArg)))) {
        overloadId = 0; // setViewport(QGeoShape)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCodeReplyFunc_setViewport_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoShape cppArg0_local;
        ::QGeoShape *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setViewport(QGeoShape)
            cppSelf->setViewport(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCodeReplyFunc_setViewport_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCodeReplyFunc_viewport(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoCodeReply.viewport";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewport()const
            QGeoShape cppResult = const_cast<const ::QGeoCodeReply *>(cppSelf)->viewport();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoCodeReply_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoCodeReply_methods[] = {
    {"abort", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_abort), METH_NOARGS},
    {"addLocation", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_addLocation), METH_O},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_errorString), METH_NOARGS},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_isFinished), METH_NOARGS},
    {"limit", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_limit), METH_NOARGS},
    {"locations", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_locations), METH_NOARGS},
    {"offset", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_offset), METH_NOARGS},
    {"setError", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_setError), METH_VARARGS},
    {"setFinished", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_setFinished), METH_O},
    {"setLimit", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_setLimit), METH_O},
    {"setLocations", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_setLocations), METH_O},
    {"setOffset", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_setOffset), METH_O},
    {"setViewport", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_setViewport), METH_O},
    {"viewport", reinterpret_cast<PyCFunction>(Sbk_QGeoCodeReplyFunc_viewport), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoCodeReply_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoCodeReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoCodeReplyWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoCodeReply_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoCodeReply_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoCodeReply_Type = nullptr;
static SbkObjectType *Sbk_QGeoCodeReply_TypeF(void)
{
    return _Sbk_QGeoCodeReply_Type;
}

static PyType_Slot Sbk_QGeoCodeReply_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoCodeReply_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoCodeReply_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoCodeReply_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoCodeReply_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoCodeReply_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoCodeReply_spec = {
    "2:PySide2.QtLocation.QGeoCodeReply",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoCodeReply_slots
};

} //extern "C"

static void *Sbk_QGeoCodeReply_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGeoCodeReply *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoCodeReply_Error_PythonToCpp_QGeoCodeReply_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoCodeReply::Error *>(cppOut) =
        static_cast<::QGeoCodeReply::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoCodeReply_Error_PythonToCpp_QGeoCodeReply_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX]))
        return QGeoCodeReply_Error_PythonToCpp_QGeoCodeReply_Error;
    return {};
}
static PyObject *QGeoCodeReply_Error_CppToPython_QGeoCodeReply_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoCodeReply::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoCodeReply_PythonToCpp_QGeoCodeReply_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoCodeReply_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoCodeReply_PythonToCpp_QGeoCodeReply_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoCodeReply_TypeF())))
        return QGeoCodeReply_PythonToCpp_QGeoCodeReply_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoCodeReply_PTR_CppToPython_QGeoCodeReply(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGeoCodeReply *>(const_cast<void *>(cppIn)), Sbk_QGeoCodeReply_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoCodeReply_SignatureStrings[] = {
    "1:PySide2.QtLocation.QGeoCodeReply(self,error:PySide2.QtLocation.QGeoCodeReply.Error,errorString:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtLocation.QGeoCodeReply(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtLocation.QGeoCodeReply.abort(self)",
    "PySide2.QtLocation.QGeoCodeReply.addLocation(self,location:PySide2.QtPositioning.QGeoLocation)",
    "PySide2.QtLocation.QGeoCodeReply.error(self)->PySide2.QtLocation.QGeoCodeReply.Error",
    "PySide2.QtLocation.QGeoCodeReply.errorString(self)->QString",
    "PySide2.QtLocation.QGeoCodeReply.isFinished(self)->bool",
    "PySide2.QtLocation.QGeoCodeReply.limit(self)->int",
    "PySide2.QtLocation.QGeoCodeReply.locations(self)->QList[PySide2.QtPositioning.QGeoLocation]",
    "PySide2.QtLocation.QGeoCodeReply.offset(self)->int",
    "PySide2.QtLocation.QGeoCodeReply.setError(self,error:PySide2.QtLocation.QGeoCodeReply.Error,errorString:QString)",
    "PySide2.QtLocation.QGeoCodeReply.setFinished(self,finished:bool)",
    "PySide2.QtLocation.QGeoCodeReply.setLimit(self,limit:int)",
    "PySide2.QtLocation.QGeoCodeReply.setLocations(self,locations:QList[PySide2.QtPositioning.QGeoLocation])",
    "PySide2.QtLocation.QGeoCodeReply.setOffset(self,offset:int)",
    "PySide2.QtLocation.QGeoCodeReply.setViewport(self,viewport:PySide2.QtPositioning.QGeoShape)",
    "PySide2.QtLocation.QGeoCodeReply.viewport(self)->PySide2.QtPositioning.QGeoShape",
    nullptr}; // Sentinel

void init_QGeoCodeReply(PyObject *module)
{
    _Sbk_QGeoCodeReply_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoCodeReply",
        "QGeoCodeReply*",
        &Sbk_QGeoCodeReply_spec,
        &Shiboken::callCppDestructor< ::QGeoCodeReply >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoCodeReply_Type);
    InitSignatureStrings(pyType, QGeoCodeReply_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoCodeReply_Type), Sbk_QGeoCodeReply_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoCodeReply_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoCodeReply_TypeF(),
        QGeoCodeReply_PythonToCpp_QGeoCodeReply_PTR,
        is_QGeoCodeReply_PythonToCpp_QGeoCodeReply_PTR_Convertible,
        QGeoCodeReply_PTR_CppToPython_QGeoCodeReply);

    Shiboken::Conversions::registerConverterName(converter, "QGeoCodeReply");
    Shiboken::Conversions::registerConverterName(converter, "QGeoCodeReply*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoCodeReply&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoCodeReply).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoCodeReplyWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGeoCodeReply_TypeF(), &Sbk_QGeoCodeReply_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoCodeReply_TypeF(),
        "Error",
        "2:PySide2.QtLocation.QGeoCodeReply.Error",
        "QGeoCodeReply::Error");
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX],
        Sbk_QGeoCodeReply_TypeF(), "NoError", (long) QGeoCodeReply::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX],
        Sbk_QGeoCodeReply_TypeF(), "EngineNotSetError", (long) QGeoCodeReply::Error::EngineNotSetError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX],
        Sbk_QGeoCodeReply_TypeF(), "CommunicationError", (long) QGeoCodeReply::Error::CommunicationError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX],
        Sbk_QGeoCodeReply_TypeF(), "ParseError", (long) QGeoCodeReply::Error::ParseError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX],
        Sbk_QGeoCodeReply_TypeF(), "UnsupportedOptionError", (long) QGeoCodeReply::Error::UnsupportedOptionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX],
        Sbk_QGeoCodeReply_TypeF(), "CombinationError", (long) QGeoCodeReply::Error::CombinationError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX],
        Sbk_QGeoCodeReply_TypeF(), "UnknownError", (long) QGeoCodeReply::Error::UnknownError))
        return;
    // Register converter for enum 'QGeoCodeReply::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX],
            QGeoCodeReply_Error_CppToPython_QGeoCodeReply_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoCodeReply_Error_PythonToCpp_QGeoCodeReply_Error,
            is_QGeoCodeReply_Error_PythonToCpp_QGeoCodeReply_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOCODEREPLY_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoCodeReply::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    PySide::Signal::registerSignals(Sbk_QGeoCodeReply_TypeF(), &::QGeoCodeReply::staticMetaObject);
    qRegisterMetaType< ::QGeoCodeReply::Error >("QGeoCodeReply::Error");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGeoCodeReply_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGeoCodeReply_TypeF(), &::QGeoCodeReply::staticMetaObject, sizeof(QGeoCodeReplyWrapper));
}
