/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qgeomaneuver_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QtLocation/qgeomaneuver.h>
#include <QtPositioning/qgeocoordinate.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoManeuver_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoManeuver >()))
        return -1;

    ::QGeoManeuver *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoManeuver", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoManeuver::QGeoManeuver()
    // 1: QGeoManeuver::QGeoManeuver(QGeoManeuver)
    if (numArgs == 0) {
        overloadId = 0; // QGeoManeuver()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGeoManeuver(QGeoManeuver)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoManeuver_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoManeuver()
        {

            if (!PyErr_Occurred()) {
                // QGeoManeuver()
                cptr = new ::QGeoManeuver();
            }
            break;
        }
        case 1: // QGeoManeuver(const QGeoManeuver & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoManeuver cppArg0_local;
            ::QGeoManeuver *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGeoManeuver(QGeoManeuver)
                cptr = new ::QGeoManeuver(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoManeuver >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoManeuver_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGeoManeuver_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoManeuverFunc_direction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.direction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // direction()const
            QGeoManeuver::InstructionDirection cppResult = const_cast<const ::QGeoManeuver *>(cppSelf)->direction();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoManeuverFunc_distanceToNextInstruction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.distanceToNextInstruction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // distanceToNextInstruction()const
            qreal cppResult = const_cast<const ::QGeoManeuver *>(cppSelf)->distanceToNextInstruction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoManeuverFunc_extendedAttributes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.extendedAttributes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // extendedAttributes()const
            QMap<QString,QVariant > cppResult = const_cast<const ::QGeoManeuver *>(cppSelf)->extendedAttributes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoManeuverFunc_instructionText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.instructionText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // instructionText()const
            QString cppResult = const_cast<const ::QGeoManeuver *>(cppSelf)->instructionText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoManeuverFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QGeoManeuver *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoManeuverFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            QGeoCoordinate cppResult = const_cast<const ::QGeoManeuver *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoManeuverFunc_setDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.setDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoManeuver::setDirection(QGeoManeuver::InstructionDirection)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDirection(QGeoManeuver::InstructionDirection)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoManeuverFunc_setDirection_TypeError;

    // Call function/method
    {
        ::QGeoManeuver::InstructionDirection cppArg0{QGeoManeuver::NoDirection};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDirection(QGeoManeuver::InstructionDirection)
            cppSelf->setDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoManeuverFunc_setDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoManeuverFunc_setDistanceToNextInstruction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.setDistanceToNextInstruction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoManeuver::setDistanceToNextInstruction(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setDistanceToNextInstruction(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoManeuverFunc_setDistanceToNextInstruction_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDistanceToNextInstruction(qreal)
            cppSelf->setDistanceToNextInstruction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoManeuverFunc_setDistanceToNextInstruction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoManeuverFunc_setExtendedAttributes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.setExtendedAttributes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoManeuver::setExtendedAttributes(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setExtendedAttributes(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoManeuverFunc_setExtendedAttributes_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExtendedAttributes(QMap<QString,QVariant>)
            cppSelf->setExtendedAttributes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoManeuverFunc_setExtendedAttributes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoManeuverFunc_setInstructionText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.setInstructionText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoManeuver::setInstructionText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setInstructionText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoManeuverFunc_setInstructionText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInstructionText(QString)
            cppSelf->setInstructionText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoManeuverFunc_setInstructionText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoManeuverFunc_setPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.setPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoManeuver::setPosition(QGeoCoordinate)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
        overloadId = 0; // setPosition(QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoManeuverFunc_setPosition_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoCoordinate cppArg0_local;
        ::QGeoCoordinate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPosition(QGeoCoordinate)
            cppSelf->setPosition(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoManeuverFunc_setPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoManeuverFunc_setTimeToNextInstruction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.setTimeToNextInstruction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoManeuver::setTimeToNextInstruction(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTimeToNextInstruction(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoManeuverFunc_setTimeToNextInstruction_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTimeToNextInstruction(int)
            cppSelf->setTimeToNextInstruction(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoManeuverFunc_setTimeToNextInstruction_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoManeuverFunc_setWaypoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.setWaypoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoManeuver::setWaypoint(QGeoCoordinate)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
        overloadId = 0; // setWaypoint(QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoManeuverFunc_setWaypoint_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoCoordinate cppArg0_local;
        ::QGeoCoordinate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setWaypoint(QGeoCoordinate)
            cppSelf->setWaypoint(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoManeuverFunc_setWaypoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoManeuverFunc_timeToNextInstruction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.timeToNextInstruction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timeToNextInstruction()const
            int cppResult = const_cast<const ::QGeoManeuver *>(cppSelf)->timeToNextInstruction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoManeuverFunc_waypoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoManeuver.waypoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // waypoint()const
            QGeoCoordinate cppResult = const_cast<const ::QGeoManeuver *>(cppSelf)->waypoint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoManeuver___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoManeuver_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoManeuver_methods[] = {
    {"direction", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_direction), METH_NOARGS},
    {"distanceToNextInstruction", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_distanceToNextInstruction), METH_NOARGS},
    {"extendedAttributes", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_extendedAttributes), METH_NOARGS},
    {"instructionText", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_instructionText), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_isValid), METH_NOARGS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_position), METH_NOARGS},
    {"setDirection", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_setDirection), METH_O},
    {"setDistanceToNextInstruction", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_setDistanceToNextInstruction), METH_O},
    {"setExtendedAttributes", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_setExtendedAttributes), METH_O},
    {"setInstructionText", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_setInstructionText), METH_O},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_setPosition), METH_O},
    {"setTimeToNextInstruction", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_setTimeToNextInstruction), METH_O},
    {"setWaypoint", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_setWaypoint), METH_O},
    {"timeToNextInstruction", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_timeToNextInstruction), METH_NOARGS},
    {"waypoint", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuverFunc_waypoint), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGeoManeuver___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QGeoManeuver_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX]), (pyArg)))) {
                // operator!=(const QGeoManeuver & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoManeuver cppArg0_local;
                ::QGeoManeuver *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX]), (pyArg)))) {
                // operator==(const QGeoManeuver & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoManeuver cppArg0_local;
                ::QGeoManeuver *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGeoManeuver_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGeoManeuver_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGeoManeuver_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoManeuver_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoManeuver_Type = nullptr;
static SbkObjectType *Sbk_QGeoManeuver_TypeF(void)
{
    return _Sbk_QGeoManeuver_Type;
}

static PyType_Slot Sbk_QGeoManeuver_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoManeuver_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoManeuver_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGeoManeuver_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoManeuver_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoManeuver_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoManeuver_spec = {
    "2:PySide2.QtLocation.QGeoManeuver",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoManeuver_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoManeuver_InstructionDirection_PythonToCpp_QGeoManeuver_InstructionDirection(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoManeuver::InstructionDirection *>(cppOut) =
        static_cast<::QGeoManeuver::InstructionDirection>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoManeuver_InstructionDirection_PythonToCpp_QGeoManeuver_InstructionDirection_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX]))
        return QGeoManeuver_InstructionDirection_PythonToCpp_QGeoManeuver_InstructionDirection;
    return {};
}
static PyObject *QGeoManeuver_InstructionDirection_CppToPython_QGeoManeuver_InstructionDirection(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoManeuver::InstructionDirection *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoManeuver_PythonToCpp_QGeoManeuver_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoManeuver_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoManeuver_PythonToCpp_QGeoManeuver_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoManeuver_TypeF())))
        return QGeoManeuver_PythonToCpp_QGeoManeuver_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoManeuver_PTR_CppToPython_QGeoManeuver(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoManeuver *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoManeuver_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGeoManeuver_COPY_CppToPython_QGeoManeuver(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGeoManeuver_TypeF(), new ::QGeoManeuver(*reinterpret_cast<const ::QGeoManeuver *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGeoManeuver_PythonToCpp_QGeoManeuver_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoManeuver *>(cppOut) = *reinterpret_cast< ::QGeoManeuver *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGeoManeuver_PythonToCpp_QGeoManeuver_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoManeuver_TypeF())))
        return QGeoManeuver_PythonToCpp_QGeoManeuver_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoManeuver_SignatureStrings[] = {
    "1:PySide2.QtLocation.QGeoManeuver(self)",
    "0:PySide2.QtLocation.QGeoManeuver(self,other:PySide2.QtLocation.QGeoManeuver)",
    "PySide2.QtLocation.QGeoManeuver.direction(self)->PySide2.QtLocation.QGeoManeuver.InstructionDirection",
    "PySide2.QtLocation.QGeoManeuver.distanceToNextInstruction(self)->qreal",
    "PySide2.QtLocation.QGeoManeuver.extendedAttributes(self)->QMap[QString, QVariant]",
    "PySide2.QtLocation.QGeoManeuver.instructionText(self)->QString",
    "PySide2.QtLocation.QGeoManeuver.isValid(self)->bool",
    "PySide2.QtLocation.QGeoManeuver.position(self)->PySide2.QtPositioning.QGeoCoordinate",
    "PySide2.QtLocation.QGeoManeuver.setDirection(self,direction:PySide2.QtLocation.QGeoManeuver.InstructionDirection)",
    "PySide2.QtLocation.QGeoManeuver.setDistanceToNextInstruction(self,distance:qreal)",
    "PySide2.QtLocation.QGeoManeuver.setExtendedAttributes(self,extendedAttributes:QMap[QString, QVariant])",
    "PySide2.QtLocation.QGeoManeuver.setInstructionText(self,instructionText:QString)",
    "PySide2.QtLocation.QGeoManeuver.setPosition(self,position:PySide2.QtPositioning.QGeoCoordinate)",
    "PySide2.QtLocation.QGeoManeuver.setTimeToNextInstruction(self,secs:int)",
    "PySide2.QtLocation.QGeoManeuver.setWaypoint(self,coordinate:PySide2.QtPositioning.QGeoCoordinate)",
    "PySide2.QtLocation.QGeoManeuver.timeToNextInstruction(self)->int",
    "PySide2.QtLocation.QGeoManeuver.waypoint(self)->PySide2.QtPositioning.QGeoCoordinate",
    "PySide2.QtLocation.QGeoManeuver.__copy__()",
    nullptr}; // Sentinel

void init_QGeoManeuver(PyObject *module)
{
    _Sbk_QGeoManeuver_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoManeuver",
        "QGeoManeuver",
        &Sbk_QGeoManeuver_spec,
        &Shiboken::callCppDestructor< ::QGeoManeuver >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoManeuver_Type);
    InitSignatureStrings(pyType, QGeoManeuver_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoManeuver_Type), Sbk_QGeoManeuver_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoManeuver_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoManeuver_TypeF(),
        QGeoManeuver_PythonToCpp_QGeoManeuver_PTR,
        is_QGeoManeuver_PythonToCpp_QGeoManeuver_PTR_Convertible,
        QGeoManeuver_PTR_CppToPython_QGeoManeuver,
        QGeoManeuver_COPY_CppToPython_QGeoManeuver);

    Shiboken::Conversions::registerConverterName(converter, "QGeoManeuver");
    Shiboken::Conversions::registerConverterName(converter, "QGeoManeuver*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoManeuver&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoManeuver).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGeoManeuver_PythonToCpp_QGeoManeuver_COPY,
        is_QGeoManeuver_PythonToCpp_QGeoManeuver_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'InstructionDirection'.
    SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoManeuver_TypeF(),
        "InstructionDirection",
        "2:PySide2.QtLocation.QGeoManeuver.InstructionDirection",
        "QGeoManeuver::InstructionDirection");
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "NoDirection", (long) QGeoManeuver::InstructionDirection::NoDirection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionForward", (long) QGeoManeuver::InstructionDirection::DirectionForward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionBearRight", (long) QGeoManeuver::InstructionDirection::DirectionBearRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionLightRight", (long) QGeoManeuver::InstructionDirection::DirectionLightRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionRight", (long) QGeoManeuver::InstructionDirection::DirectionRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionHardRight", (long) QGeoManeuver::InstructionDirection::DirectionHardRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionUTurnRight", (long) QGeoManeuver::InstructionDirection::DirectionUTurnRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionUTurnLeft", (long) QGeoManeuver::InstructionDirection::DirectionUTurnLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionHardLeft", (long) QGeoManeuver::InstructionDirection::DirectionHardLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionLeft", (long) QGeoManeuver::InstructionDirection::DirectionLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionLightLeft", (long) QGeoManeuver::InstructionDirection::DirectionLightLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
        Sbk_QGeoManeuver_TypeF(), "DirectionBearLeft", (long) QGeoManeuver::InstructionDirection::DirectionBearLeft))
        return;
    // Register converter for enum 'QGeoManeuver::InstructionDirection'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX],
            QGeoManeuver_InstructionDirection_CppToPython_QGeoManeuver_InstructionDirection);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoManeuver_InstructionDirection_PythonToCpp_QGeoManeuver_InstructionDirection,
            is_QGeoManeuver_InstructionDirection_PythonToCpp_QGeoManeuver_InstructionDirection_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOMANEUVER_INSTRUCTIONDIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoManeuver::InstructionDirection");
        Shiboken::Conversions::registerConverterName(converter, "InstructionDirection");
    }
    // End of 'InstructionDirection' enum.

    qRegisterMetaType< ::QGeoManeuver >("QGeoManeuver");
    qRegisterMetaType< ::QGeoManeuver::InstructionDirection >("QGeoManeuver::InstructionDirection");
}
