/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qgeoserviceproviderfactoryv2_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoServiceProviderFactoryV2Wrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoServiceProviderFactoryV2Wrapper::QGeoServiceProviderFactoryV2Wrapper() : QGeoServiceProviderFactoryV2()
{
    resetPyMethodCache();
    // ... middle
}

::QGeoCodingManagerEngine * QGeoServiceProviderFactoryV2Wrapper::createGeocodingManagerEngine(const ::QMap<QString,QVariant > & parameters, ::QGeoServiceProvider::Error * error, ::QString * errorString) const
{
    if (m_PyMethodCache[0])
        return this->::QGeoServiceProviderFactory::createGeocodingManagerEngine(parameters, error, errorString);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createGeocodingManagerEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGeoServiceProviderFactory::createGeocodingManagerEngine(parameters, error, errorString);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], &parameters),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &error),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &errorString)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOCODINGMANAGERENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoServiceProviderFactoryV2.createGeocodingManagerEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoCodingManagerEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoCodingManagerEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPlaceManagerEngine * QGeoServiceProviderFactoryV2Wrapper::createPlaceManagerEngine(const ::QMap<QString,QVariant > & parameters, ::QGeoServiceProvider::Error * error, ::QString * errorString) const
{
    if (m_PyMethodCache[1])
        return this->::QGeoServiceProviderFactory::createPlaceManagerEngine(parameters, error, errorString);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createPlaceManagerEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QGeoServiceProviderFactory::createPlaceManagerEngine(parameters, error, errorString);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], &parameters),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &error),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &errorString)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEMANAGERENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoServiceProviderFactoryV2.createPlaceManagerEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPlaceManagerEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPlaceManagerEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QGeoRoutingManagerEngine * QGeoServiceProviderFactoryV2Wrapper::createRoutingManagerEngine(const ::QMap<QString,QVariant > & parameters, ::QGeoServiceProvider::Error * error, ::QString * errorString) const
{
    if (m_PyMethodCache[2])
        return this->::QGeoServiceProviderFactory::createRoutingManagerEngine(parameters, error, errorString);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createRoutingManagerEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QGeoServiceProviderFactory::createRoutingManagerEngine(parameters, error, errorString);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], &parameters),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &error),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &errorString)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoServiceProviderFactoryV2.createRoutingManagerEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoRoutingManagerEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoRoutingManagerEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QGeoServiceProviderFactoryV2Wrapper::~QGeoServiceProviderFactoryV2Wrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoServiceProviderFactoryV2_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoServiceProviderFactoryV2 >()))
        return -1;

    ::QGeoServiceProviderFactoryV2Wrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProviderFactoryV2.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QGeoServiceProviderFactoryV2()
            cptr = new ::QGeoServiceProviderFactoryV2Wrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoServiceProviderFactoryV2 >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}


static const char *Sbk_QGeoServiceProviderFactoryV2_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoServiceProviderFactoryV2_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoServiceProviderFactoryV2_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoServiceProviderFactoryV2 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDERFACTORYV2_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoServiceProviderFactoryV2Wrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoServiceProviderFactoryV2_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoServiceProviderFactoryV2_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoServiceProviderFactoryV2_Type = nullptr;
static SbkObjectType *Sbk_QGeoServiceProviderFactoryV2_TypeF(void)
{
    return _Sbk_QGeoServiceProviderFactoryV2_Type;
}

static PyType_Slot Sbk_QGeoServiceProviderFactoryV2_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactoryV2_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactoryV2_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactoryV2_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactoryV2_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactoryV2_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoServiceProviderFactoryV2_spec = {
    "2:PySide2.QtLocation.QGeoServiceProviderFactoryV2",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoServiceProviderFactoryV2_slots
};

} //extern "C"

static void *Sbk_QGeoServiceProviderFactoryV2_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QGeoServiceProviderFactory >()))
        return dynamic_cast< ::QGeoServiceProviderFactoryV2 *>(reinterpret_cast< ::QGeoServiceProviderFactory *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoServiceProviderFactoryV2_PythonToCpp_QGeoServiceProviderFactoryV2_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoServiceProviderFactoryV2_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoServiceProviderFactoryV2_PythonToCpp_QGeoServiceProviderFactoryV2_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoServiceProviderFactoryV2_TypeF())))
        return QGeoServiceProviderFactoryV2_PythonToCpp_QGeoServiceProviderFactoryV2_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoServiceProviderFactoryV2_PTR_CppToPython_QGeoServiceProviderFactoryV2(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoServiceProviderFactoryV2 *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoServiceProviderFactoryV2_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoServiceProviderFactoryV2_SignatureStrings[] = {
    "PySide2.QtLocation.QGeoServiceProviderFactoryV2(self)",
    nullptr}; // Sentinel

void init_QGeoServiceProviderFactoryV2(PyObject *module)
{
    _Sbk_QGeoServiceProviderFactoryV2_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoServiceProviderFactoryV2",
        "QGeoServiceProviderFactoryV2*",
        &Sbk_QGeoServiceProviderFactoryV2_spec,
        &Shiboken::callCppDestructor< ::QGeoServiceProviderFactoryV2 >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDERFACTORY_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoServiceProviderFactoryV2_Type);
    InitSignatureStrings(pyType, QGeoServiceProviderFactoryV2_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoServiceProviderFactoryV2_Type), Sbk_QGeoServiceProviderFactoryV2_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDERFACTORYV2_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoServiceProviderFactoryV2_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoServiceProviderFactoryV2_TypeF(),
        QGeoServiceProviderFactoryV2_PythonToCpp_QGeoServiceProviderFactoryV2_PTR,
        is_QGeoServiceProviderFactoryV2_PythonToCpp_QGeoServiceProviderFactoryV2_PTR_Convertible,
        QGeoServiceProviderFactoryV2_PTR_CppToPython_QGeoServiceProviderFactoryV2);

    Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProviderFactoryV2");
    Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProviderFactoryV2*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProviderFactoryV2&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoServiceProviderFactoryV2).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoServiceProviderFactoryV2Wrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGeoServiceProviderFactoryV2_TypeF(), &Sbk_QGeoServiceProviderFactoryV2_typeDiscovery);

}
