/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QPLACEMANAGERENGINEWRAPPER_H
#define SBK_QPLACEMANAGERENGINEWRAPPER_H

#define protected public

#include <QtLocation/qplacemanagerengine.h>


// Extra includes
#include <qobject.h>
#include <QMap>
#include <QtLocation/qplacedetailsreply.h>
#include <QtLocation/qplacecontentreply.h>
#include <QtLocation/qplacecontentrequest.h>
#include <QtLocation/qplacesearchreply.h>
#include <QtLocation/qplacesearchrequest.h>
#include <QtLocation/qplacesearchsuggestionreply.h>
#include <QtLocation/qplaceidreply.h>
#include <QtLocation/qplace.h>
#include <QtLocation/qplacecategory.h>
#include <QtLocation/qplacereply.h>
#include <QList>
#include <qlocale.h>
#include <qurl.h>
#include <QtLocation/qplaceicon.h>
#include <qsize.h>
#include <QtLocation/qplacematchreply.h>
#include <QtLocation/qplacematchrequest.h>
#include <QtLocation/qplacemanager.h>
#include <qthread.h>
#include <qobjectdefs.h>
#include <qmetaobject.h>
#include <qcoreevent.h>
#include <qbytearray.h>
namespace PySide { class DynamicQMetaObject; }

class QPlaceManagerEngineWrapper : public QPlaceManagerEngine
{
public:
    QPlaceManagerEngineWrapper(const ::QMap<QString,QVariant > & parameters, ::QObject * parent = nullptr);
    ::QPlaceCategory category(const ::QString & categoryId) const override;
    ::QList<QPlaceCategory > childCategories(const ::QString & parentId) const override;
    ::QStringList childCategoryIds(const ::QString & categoryId) const override;
    void childEvent(::QChildEvent * event) override;
    ::QPlace compatiblePlace(const ::QPlace & original) const override;
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QUrl constructIconUrl(const ::QPlaceIcon & icon, const ::QSize & size) const override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QPlaceContentReply * getPlaceContent(const ::QPlaceContentRequest & request) override;
    ::QPlaceDetailsReply * getPlaceDetails(const ::QString & placeId) override;
    ::QPlaceReply * initializeCategories() override;
    ::QList<QLocale > locales() const override;
    ::QPlaceMatchReply * matchingPlaces(const ::QPlaceMatchRequest & request) override;
    const ::QMetaObject * metaObject() const override;
    ::QString parentCategoryId(const ::QString & categoryId) const override;
    ::QPlaceIdReply * removeCategory(const ::QString & categoryId) override;
    ::QPlaceIdReply * removePlace(const ::QString & placeId) override;
    ::QPlaceIdReply * saveCategory(const ::QPlaceCategory & category, const ::QString & parentId) override;
    ::QPlaceIdReply * savePlace(const ::QPlace & place) override;
    ::QPlaceSearchReply * search(const ::QPlaceSearchRequest & request) override;
    ::QPlaceSearchSuggestionReply * searchSuggestions(const ::QPlaceSearchRequest & request) override;
    void setLocales(const ::QList<QLocale > & locales) override;
    void timerEvent(::QTimerEvent * event) override;
    ~QPlaceManagerEngineWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[26];
};

#endif // SBK_QPLACEMANAGERENGINEWRAPPER_H

