/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtlocation_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtLocationTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtLocationModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtLocationTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtLocation_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtLocationTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef QtLocation_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QPlaceUser(PyObject *module);
void init_QPlaceSupplier(PyObject *module);
void init_QPlaceSearchResult(PyObject *module);
void init_QPlaceSearchRequest(PyObject *module);
void init_QPlaceResult(PyObject *module);
void init_QPlaceRatings(PyObject *module);
void init_QPlaceProposedSearchResult(PyObject *module);
void init_QPlaceMatchRequest(PyObject *module);
void init_QPlaceMatchRequestStaticFields();
void init_QPlaceContentRequest(PyObject *module);
void init_QPlaceContent(PyObject *module);
void init_QPlaceImage(PyObject *module);
void init_QPlaceEditorial(PyObject *module);
void init_QPlaceReview(PyObject *module);
void init_QPlaceContactDetail(PyObject *module);
void init_QPlaceContactDetailStaticFields();
void init_QPlaceCategory(PyObject *module);
void init_QPlaceAttribute(PyObject *module);
void init_QPlaceAttributeStaticFields();
void init_QPlace(PyObject *module);
void init_QGeoServiceProviderFactory(PyObject *module);
void init_QGeoServiceProviderFactoryV2(PyObject *module);
void init_QGeoRouteSegment(PyObject *module);
void init_QGeoRouteRequest(PyObject *module);
void init_QGeoRoute(PyObject *module);
void init_QGeoManeuver(PyObject *module);
void init_QPlaceIcon(PyObject *module);
void init_QPlaceIconStaticFields();
void init_QGeoRouteReply(PyObject *module);
void init_QGeoCodingManagerEngine(PyObject *module);
void init_QGeoCodingManager(PyObject *module);
void init_QGeoCodeReply(PyObject *module);
void init_QPlaceReply(PyObject *module);
void init_QPlaceIdReply(PyObject *module);
void init_QPlaceSearchSuggestionReply(PyObject *module);
void init_QPlaceDetailsReply(PyObject *module);
void init_QPlaceContentReply(PyObject *module);
void init_QPlaceSearchReply(PyObject *module);
void init_QPlaceMatchReply(PyObject *module);
void init_QPlaceManagerEngine(PyObject *module);
void init_QPlaceManager(PyObject *module);
void init_QGeoServiceProvider(PyObject *module);
void init_QGeoRoutingManagerEngine(PyObject *module);
void init_QGeoRoutingManager(PyObject *module);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;
PyTypeObject **SbkPySide2_QtPositioningTypes;
SbkConverter **SbkPySide2_QtPositioningTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QList<QGeoLocation >'.
static PyObject *_QList_QGeoLocation__CppToPython__QList_QGeoLocation_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGeoLocation > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGeoLocation >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGeoLocation cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QGeoLocation__PythonToCpp__QList_QGeoLocation_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGeoLocation > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGeoLocation cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QGeoLocation__PythonToCpp__QList_QGeoLocation__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), pyIn))
        return _QList_QGeoLocation__PythonToCpp__QList_QGeoLocation_;
    return {};
}

// C++ to Python conversion for type 'const QMap<QString,QVariant > &'.
static PyObject *_constQMap_QString_QVariant_REF_CppToPython__constQMap_QString_QVariant_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QGeoCoordinate >'.
static PyObject *_QList_QGeoCoordinate__CppToPython__QList_QGeoCoordinate_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGeoCoordinate > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGeoCoordinate >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGeoCoordinate cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QGeoCoordinate__PythonToCpp__QList_QGeoCoordinate_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGeoCoordinate > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGeoCoordinate cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QGeoCoordinate__PythonToCpp__QList_QGeoCoordinate__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pyIn))
        return _QList_QGeoCoordinate__PythonToCpp__QList_QGeoCoordinate_;
    return {};
}

// C++ to Python conversion for type 'const QList<QGeoRoute > &'.
static PyObject *_constQList_QGeoRoute_REF_CppToPython__constQList_QGeoRoute_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGeoRoute > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGeoRoute >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGeoRoute cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QGeoRoute_REF_PythonToCpp__constQList_QGeoRoute_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGeoRoute > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGeoRoute cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QGeoRoute_REF_PythonToCpp__constQList_QGeoRoute_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTE_IDX]), pyIn))
        return _constQList_QGeoRoute_REF_PythonToCpp__constQList_QGeoRoute_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QGeoRectangle >'.
static PyObject *_QList_QGeoRectangle__CppToPython__QList_QGeoRectangle_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGeoRectangle > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGeoRectangle >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGeoRectangle cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEORECTANGLE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QGeoRectangle__PythonToCpp__QList_QGeoRectangle_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGeoRectangle > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGeoRectangle cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEORECTANGLE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QGeoRectangle__PythonToCpp__QList_QGeoRectangle__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEORECTANGLE_IDX]), pyIn))
        return _QList_QGeoRectangle__PythonToCpp__QList_QGeoRectangle_;
    return {};
}

// C++ to Python conversion for type 'QList<QGeoRouteRequest::FeatureType >'.
static PyObject *_QList_QGeoRouteRequest_FeatureType__CppToPython__QList_QGeoRouteRequest_FeatureType_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGeoRouteRequest::FeatureType > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGeoRouteRequest::FeatureType >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGeoRouteRequest::FeatureType cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QGeoRouteRequest_FeatureType__PythonToCpp__QList_QGeoRouteRequest_FeatureType_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGeoRouteRequest::FeatureType > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGeoRouteRequest::FeatureType cppItem{QGeoRouteRequest::NoFeature};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QGeoRouteRequest_FeatureType__PythonToCpp__QList_QGeoRouteRequest_FeatureType__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, pyIn))
        return _QList_QGeoRouteRequest_FeatureType__PythonToCpp__QList_QGeoRouteRequest_FeatureType_;
    return {};
}

// C++ to Python conversion for type 'const QList<QMap< QString,QVariant > > &'.
static PyObject *_constQList_QMap_QString_QVariant__REF_CppToPython__constQList_QMap_QString_QVariant__REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QMap< QString,QVariant > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QMap< QString,QVariant > >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QMap<QString,QVariant > cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QMap_QString_QVariant__REF_PythonToCpp__constQList_QMap_QString_QVariant__REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QMap< QString,QVariant > > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QMap<QString,QVariant > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QMap_QString_QVariant__REF_PythonToCpp__constQList_QMap_QString_QVariant__REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], pyIn))
        return _constQList_QMap_QString_QVariant__REF_PythonToCpp__constQList_QMap_QString_QVariant__REF;
    return {};
}

// C++ to Python conversion for type 'QList<QPlaceCategory >'.
static PyObject *_QList_QPlaceCategory__CppToPython__QList_QPlaceCategory_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPlaceCategory > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPlaceCategory >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPlaceCategory cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECATEGORY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPlaceCategory__PythonToCpp__QList_QPlaceCategory_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPlaceCategory > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPlaceCategory cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECATEGORY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPlaceCategory__PythonToCpp__QList_QPlaceCategory__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECATEGORY_IDX]), pyIn))
        return _QList_QPlaceCategory__PythonToCpp__QList_QPlaceCategory_;
    return {};
}

// C++ to Python conversion for type 'QList<QPlaceContactDetail >'.
static PyObject *_QList_QPlaceContactDetail__CppToPython__QList_QPlaceContactDetail_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPlaceContactDetail > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPlaceContactDetail >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPlaceContactDetail cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTACTDETAIL_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPlaceContactDetail__PythonToCpp__QList_QPlaceContactDetail_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPlaceContactDetail > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPlaceContactDetail cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTACTDETAIL_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPlaceContactDetail__PythonToCpp__QList_QPlaceContactDetail__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTACTDETAIL_IDX]), pyIn))
        return _QList_QPlaceContactDetail__PythonToCpp__QList_QPlaceContactDetail_;
    return {};
}

// C++ to Python conversion for type 'QMap<int,QPlaceContent >'.
static PyObject *_QMap_int_QPlaceContent__CppToPython__QMap_int_QPlaceContent_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<int,QPlaceContent > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<int,QPlaceContent >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        int key = it.key();
        ::QPlaceContent value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENT_IDX]), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_int_QPlaceContent__PythonToCpp__QMap_int_QPlaceContent_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<int,QPlaceContent > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QPlaceContent cppValue;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENT_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_int_QPlaceContent__PythonToCpp__QMap_int_QPlaceContent__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, *PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENT_IDX])->converter, false, pyIn))
        return _QMap_int_QPlaceContent__PythonToCpp__QMap_int_QPlaceContent_;
    return {};
}

// C++ to Python conversion for type 'QList<QLocale >'.
static PyObject *_QList_QLocale__CppToPython__QList_QLocale_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QLocale > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QLocale >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QLocale cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QLocale__PythonToCpp__QList_QLocale_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QLocale > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QLocale cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QLocale__PythonToCpp__QList_QLocale__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pyIn))
        return _QList_QLocale__PythonToCpp__QList_QLocale_;
    return {};
}

// C++ to Python conversion for type 'QList<QPlace >'.
static PyObject *_QList_QPlace__CppToPython__QList_QPlace_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPlace > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPlace >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPlace cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPlace__PythonToCpp__QList_QPlace_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPlace > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPlace cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPlace__PythonToCpp__QList_QPlace__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACE_IDX]), pyIn))
        return _QList_QPlace__PythonToCpp__QList_QPlace_;
    return {};
}

// C++ to Python conversion for type 'const QList<QPlaceSearchResult > &'.
static PyObject *_constQList_QPlaceSearchResult_REF_CppToPython__constQList_QPlaceSearchResult_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPlaceSearchResult > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPlaceSearchResult >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPlaceSearchResult cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QPlaceSearchResult_REF_PythonToCpp__constQList_QPlaceSearchResult_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPlaceSearchResult > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPlaceSearchResult cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QPlaceSearchResult_REF_PythonToCpp__constQList_QPlaceSearchResult_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX]), pyIn))
        return _constQList_QPlaceSearchResult_REF_PythonToCpp__constQList_QPlaceSearchResult_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtLocation",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtLocation_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtLocation_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtLocation)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtPositioning"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtPositioningTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtPositioningTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtLocation_IDX_COUNT];
    SbkPySide2_QtLocationTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtLocation_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtLocationTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtLocation", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtLocation", QtLocation_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtLocationModuleObject = module;

    // Initialize classes in the type system
    init_QPlaceUser(module);
    init_QPlaceSupplier(module);
    init_QPlaceSearchResult(module);
    init_QPlaceSearchRequest(module);
    init_QPlaceResult(module);
    init_QPlaceRatings(module);
    init_QPlaceProposedSearchResult(module);
    init_QPlaceMatchRequest(module);
    init_QPlaceContentRequest(module);
    init_QPlaceContent(module);
    init_QPlaceImage(module);
    init_QPlaceEditorial(module);
    init_QPlaceReview(module);
    init_QPlaceContactDetail(module);
    init_QPlaceCategory(module);
    init_QPlaceAttribute(module);
    init_QPlace(module);
    init_QGeoServiceProviderFactory(module);
    init_QGeoServiceProviderFactoryV2(module);
    init_QGeoRouteSegment(module);
    init_QGeoRouteRequest(module);
    init_QGeoRoute(module);
    init_QGeoManeuver(module);
    init_QPlaceIcon(module);
    init_QGeoRouteReply(module);
    init_QGeoCodingManagerEngine(module);
    init_QGeoCodingManager(module);
    init_QGeoCodeReply(module);
    init_QPlaceReply(module);
    init_QPlaceIdReply(module);
    init_QPlaceSearchSuggestionReply(module);
    init_QPlaceDetailsReply(module);
    init_QPlaceContentReply(module);
    init_QPlaceSearchReply(module);
    init_QPlaceMatchReply(module);
    init_QPlaceManagerEngine(module);
    init_QPlaceManager(module);
    init_QGeoServiceProvider(module);
    init_QGeoRoutingManagerEngine(module);
    init_QGeoRoutingManager(module);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QList<QGeoLocation>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOLOCATION_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QGeoLocation__CppToPython__QList_QGeoLocation_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOLOCATION_IDX], "QList<QGeoLocation>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOLOCATION_IDX],
        _QList_QGeoLocation__PythonToCpp__QList_QGeoLocation_,
        is__QList_QGeoLocation__PythonToCpp__QList_QGeoLocation__Convertible);

    // Register converter for type 'const QMap<QString,QVariant>&'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _constQMap_QString_QVariant_REF_CppToPython__constQMap_QString_QVariant_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], "const QMap<QString,QVariant>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX],
        _constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF,
        is__constQMap_QString_QVariant_REF_PythonToCpp__constQMap_QString_QVariant_REF_Convertible);

    // Register converter for type 'QList<QGeoCoordinate>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOCOORDINATE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QGeoCoordinate__CppToPython__QList_QGeoCoordinate_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOCOORDINATE_IDX], "QList<QGeoCoordinate>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOCOORDINATE_IDX],
        _QList_QGeoCoordinate__PythonToCpp__QList_QGeoCoordinate_,
        is__QList_QGeoCoordinate__PythonToCpp__QList_QGeoCoordinate__Convertible);

    // Register converter for type 'const QList<QGeoRoute>&'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QGeoRoute_REF_CppToPython__constQList_QGeoRoute_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTE_IDX], "const QList<QGeoRoute>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTE_IDX], "QList<QGeoRoute>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTE_IDX],
        _constQList_QGeoRoute_REF_PythonToCpp__constQList_QGeoRoute_REF,
        is__constQList_QGeoRoute_REF_PythonToCpp__constQList_QGeoRoute_REF_Convertible);

    // Register converter for type 'QList<QGeoRectangle>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEORECTANGLE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QGeoRectangle__CppToPython__QList_QGeoRectangle_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEORECTANGLE_IDX], "QList<QGeoRectangle>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEORECTANGLE_IDX],
        _QList_QGeoRectangle__PythonToCpp__QList_QGeoRectangle_,
        is__QList_QGeoRectangle__PythonToCpp__QList_QGeoRectangle__Convertible);

    // Register converter for type 'QList<QGeoRouteRequest::FeatureType>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTEREQUEST_FEATURETYPE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QGeoRouteRequest_FeatureType__CppToPython__QList_QGeoRouteRequest_FeatureType_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTEREQUEST_FEATURETYPE_IDX], "QList<QGeoRouteRequest::FeatureType>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        _QList_QGeoRouteRequest_FeatureType__PythonToCpp__QList_QGeoRouteRequest_FeatureType_,
        is__QList_QGeoRouteRequest_FeatureType__PythonToCpp__QList_QGeoRouteRequest_FeatureType__Convertible);

    // Register converter for type 'const QList<QMap<QString,QVariant>>&'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QMap_QString_QVariant__REF_CppToPython__constQList_QMap_QString_QVariant__REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QMAP_QSTRING_QVARIANT_IDX], "const QList<QMap<QString,QVariant>>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QMAP_QSTRING_QVARIANT_IDX], "QList<QMap<QString,QVariant>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QMAP_QSTRING_QVARIANT_IDX],
        _constQList_QMap_QString_QVariant__REF_PythonToCpp__constQList_QMap_QString_QVariant__REF,
        is__constQList_QMap_QString_QVariant__REF_PythonToCpp__constQList_QMap_QString_QVariant__REF_Convertible);

    // Register converter for type 'QList<QPlaceCategory>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACECATEGORY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPlaceCategory__CppToPython__QList_QPlaceCategory_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACECATEGORY_IDX], "QList<QPlaceCategory>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACECATEGORY_IDX],
        _QList_QPlaceCategory__PythonToCpp__QList_QPlaceCategory_,
        is__QList_QPlaceCategory__PythonToCpp__QList_QPlaceCategory__Convertible);

    // Register converter for type 'QList<QPlaceContactDetail>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACECONTACTDETAIL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPlaceContactDetail__CppToPython__QList_QPlaceContactDetail_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACECONTACTDETAIL_IDX], "QList<QPlaceContactDetail>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACECONTACTDETAIL_IDX],
        _QList_QPlaceContactDetail__PythonToCpp__QList_QPlaceContactDetail_,
        is__QList_QPlaceContactDetail__PythonToCpp__QList_QPlaceContactDetail__Convertible);

    // Register converter for type 'QMap<int,QPlaceContent>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_INT_QPLACECONTENT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_int_QPlaceContent__CppToPython__QMap_int_QPlaceContent_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_INT_QPLACECONTENT_IDX], "QMap<int,QPlaceContent>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_INT_QPLACECONTENT_IDX],
        _QMap_int_QPlaceContent__PythonToCpp__QMap_int_QPlaceContent_,
        is__QMap_int_QPlaceContent__PythonToCpp__QMap_int_QPlaceContent__Convertible);

    // Register converter for type 'QList<QLocale>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QLOCALE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QLocale__CppToPython__QList_QLocale_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QLOCALE_IDX], "QList<QLocale>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QLOCALE_IDX],
        _QList_QLocale__PythonToCpp__QList_QLocale_,
        is__QList_QLocale__PythonToCpp__QList_QLocale__Convertible);

    // Register converter for type 'QList<QPlace>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPlace__CppToPython__QList_QPlace_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACE_IDX], "QList<QPlace>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACE_IDX],
        _QList_QPlace__PythonToCpp__QList_QPlace_,
        is__QList_QPlace__PythonToCpp__QList_QPlace__Convertible);

    // Register converter for type 'const QList<QPlaceSearchResult>&'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACESEARCHRESULT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QPlaceSearchResult_REF_CppToPython__constQList_QPlaceSearchResult_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACESEARCHRESULT_IDX], "const QList<QPlaceSearchResult>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACESEARCHRESULT_IDX], "QList<QPlaceSearchResult>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACESEARCHRESULT_IDX],
        _constQList_QPlaceSearchResult_REF_PythonToCpp__constQList_QPlaceSearchResult_REF,
        is__constQList_QPlaceSearchResult_REF_PythonToCpp__constQList_QPlaceSearchResult_REF_Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtLocationTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtLocationTypeConverters);

// Static field initialization
init_QPlaceMatchRequestStaticFields();
init_QPlaceContactDetailStaticFields();
init_QPlaceAttributeStaticFields();
init_QPlaceIconStaticFields();

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtLocation");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtLocation_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
