/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qabstractaudiooutput_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractAudioOutputWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractAudioOutputWrapper::QAbstractAudioOutputWrapper() : QAbstractAudioOutput()
{
    resetPyMethodCache();
    // ... middle
}

int QAbstractAudioOutputWrapper::bufferSize() const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.bufferSize()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bufferSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.bufferSize()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.bufferSize", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QAbstractAudioOutputWrapper::bytesFree() const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.bytesFree()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesFree";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.bytesFree()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.bytesFree", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString QAbstractAudioOutputWrapper::category() const
{
    if (m_PyMethodCache[2])
        return this->::QAbstractAudioOutput::category();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "category";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QAbstractAudioOutput::category();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.category", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractAudioOutputWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractAudioOutputWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAudioOutputWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractAudioOutputWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

qint64 QAbstractAudioOutputWrapper::elapsedUSecs() const
{
    if (m_PyMethodCache[7]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.elapsedUSecs()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "elapsedUSecs";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.elapsedUSecs()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.elapsedUSecs", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QAudio::Error QAbstractAudioOutputWrapper::error() const
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.error()' not implemented.");
        return QAudio::NoError;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QAudio::NoError;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "error";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.error()' not implemented.");
        return QAudio::NoError;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QAudio::NoError;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.error", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAudio::Error >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QAudio::NoError;
    }
    ::QAudio::Error cppResult{QAudio::NoError};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractAudioOutputWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[9])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractAudioOutputWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[10])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QAudioFormat QAbstractAudioOutputWrapper::format() const
{
    if (m_PyMethodCache[11]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.format()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "format";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.format()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.format", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAudioFormat >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QAudioFormat cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QAbstractAudioOutputWrapper::notifyInterval() const
{
    if (m_PyMethodCache[13]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.notifyInterval()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "notifyInterval";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.notifyInterval()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.notifyInterval", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QAbstractAudioOutputWrapper::periodSize() const
{
    if (m_PyMethodCache[14]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.periodSize()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "periodSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.periodSize()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.periodSize", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QAbstractAudioOutputWrapper::processedUSecs() const
{
    if (m_PyMethodCache[15]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.processedUSecs()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "processedUSecs";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.processedUSecs()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.processedUSecs", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractAudioOutputWrapper::reset()
{
    if (m_PyMethodCache[16]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.reset()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.reset()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAudioOutputWrapper::resume()
{
    if (m_PyMethodCache[17]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.resume()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resume";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.resume()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAudioOutputWrapper::setBufferSize(int value)
{
    if (m_PyMethodCache[18]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.setBufferSize()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setBufferSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.setBufferSize()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    value
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAudioOutputWrapper::setCategory(const ::QString & arg__1)
{
    if (m_PyMethodCache[19]) {
        return this->::QAbstractAudioOutput::setCategory(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setCategory";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QAbstractAudioOutput::setCategory(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAudioOutputWrapper::setFormat(const ::QAudioFormat & fmt)
{
    if (m_PyMethodCache[20]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.setFormat()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setFormat";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.setFormat()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), &fmt)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAudioOutputWrapper::setNotifyInterval(int milliSeconds)
{
    if (m_PyMethodCache[21]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.setNotifyInterval()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setNotifyInterval";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.setNotifyInterval()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    milliSeconds
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAudioOutputWrapper::setVolume(qreal arg__1)
{
    if (m_PyMethodCache[22]) {
        return this->::QAbstractAudioOutput::setVolume(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setVolume";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QAbstractAudioOutput::setVolume(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(d)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QIODevice * QAbstractAudioOutputWrapper::start()
{
    if (m_PyMethodCache[23]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.start()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "start";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.start()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    bool invalidateArg0 = pyResult->ob_refcnt == 1;
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.start", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QIODevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QIODevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg0)
        Shiboken::Object::releaseOwnership(pyResult.object());
    return cppResult;
}

void QAbstractAudioOutputWrapper::start(::QIODevice * device)
{
    if (m_PyMethodCache[24]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.start()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "start";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.start()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), device)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QAudio::State QAbstractAudioOutputWrapper::state() const
{
    if (m_PyMethodCache[25]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.state()' not implemented.");
        return QAudio::ActiveState;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QAudio::ActiveState;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "state";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.state()' not implemented.");
        return QAudio::ActiveState;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QAudio::ActiveState;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.state", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAudio::State >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QAudio::ActiveState;
    }
    ::QAudio::State cppResult{QAudio::ActiveState};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractAudioOutputWrapper::stop()
{
    if (m_PyMethodCache[26]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.stop()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stop";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.stop()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAudioOutputWrapper::suspend()
{
    if (m_PyMethodCache[27]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.suspend()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "suspend";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.suspend()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractAudioOutputWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[28]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

qreal QAbstractAudioOutputWrapper::volume() const
{
    if (m_PyMethodCache[29])
        return this->::QAbstractAudioOutput::volume();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "volume";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QAbstractAudioOutput::volume();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractAudioOutput.volume", "qreal", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qreal cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QAbstractAudioOutputWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAbstractAudioOutput::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractAudioOutputWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAbstractAudioOutput::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractAudioOutputWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractAudioOutputWrapper *>(this));
        return QAbstractAudioOutput::qt_metacast(_clname);
}

QAbstractAudioOutputWrapper::~QAbstractAudioOutputWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractAudioOutput_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractAudioOutput' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractAudioOutput >()))
        return -1;

    ::QAbstractAudioOutputWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QAbstractAudioOutput()
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QAbstractAudioOutputWrapper();
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QAbstractAudioOutputWrapper();
            }

        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractAudioOutput >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAbstractAudioOutput_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAbstractAudioOutput_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_bufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.bufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bufferSize()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.bufferSize()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QAbstractAudioOutput *>(cppSelf)->bufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_bytesFree(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.bytesFree";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesFree()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.bytesFree()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QAbstractAudioOutput *>(cppSelf)->bytesFree();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_category(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.category";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // category()const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractAudioOutput *>(cppSelf)->::QAbstractAudioOutput::category()
                : const_cast<const ::QAbstractAudioOutput *>(cppSelf)->category();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_elapsedUSecs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.elapsedUSecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // elapsedUSecs()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.elapsedUSecs()' not implemented.");
                return {};
            }
            qint64 cppResult = const_cast<const ::QAbstractAudioOutput *>(cppSelf)->elapsedUSecs();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.error()' not implemented.");
                return {};
            }
            QAudio::Error cppResult = const_cast<const ::QAbstractAudioOutput *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.format()' not implemented.");
                return {};
            }
            QAudioFormat cppResult = const_cast<const ::QAbstractAudioOutput *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_notifyInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.notifyInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // notifyInterval()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.notifyInterval()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QAbstractAudioOutput *>(cppSelf)->notifyInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_periodSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.periodSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // periodSize()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.periodSize()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QAbstractAudioOutput *>(cppSelf)->periodSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_processedUSecs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.processedUSecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // processedUSecs()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.processedUSecs()' not implemented.");
                return {};
            }
            qint64 cppResult = const_cast<const ::QAbstractAudioOutput *>(cppSelf)->processedUSecs();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.reset()' not implemented.");
                return {};
            }
            cppSelf->reset();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.resume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resume()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.resume()' not implemented.");
                return {};
            }
            cppSelf->resume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_setBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.setBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAudioOutput::setBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAudioOutputFunc_setBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBufferSize(int)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.setBufferSize()' not implemented.");
                return {};
            }
            cppSelf->setBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAudioOutputFunc_setBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAudioOutputFunc_setCategory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.setCategory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAudioOutput::setCategory(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCategory(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAudioOutputFunc_setCategory_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCategory(QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractAudioOutput::setCategory(cppArg0)
                : cppSelf->setCategory(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAudioOutputFunc_setCategory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAudioOutputFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAudioOutput::setFormat(QAudioFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setFormat(QAudioFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAudioOutputFunc_setFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAudioFormat cppArg0_local;
        ::QAudioFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFormat(QAudioFormat)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.setFormat()' not implemented.");
                return {};
            }
            cppSelf->setFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAudioOutputFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAudioOutputFunc_setNotifyInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.setNotifyInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAudioOutput::setNotifyInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setNotifyInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAudioOutputFunc_setNotifyInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNotifyInterval(int)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.setNotifyInterval()' not implemented.");
                return {};
            }
            cppSelf->setNotifyInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAudioOutputFunc_setNotifyInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAudioOutputFunc_setVolume(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.setVolume";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractAudioOutput::setVolume(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setVolume(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAudioOutputFunc_setVolume_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVolume(qreal)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractAudioOutput::setVolume(cppArg0)
                : cppSelf->setVolume(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractAudioOutputFunc_setVolume_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAudioOutputFunc_start(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.start";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "start", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractAudioOutput::start(QIODevice*)
    // 1: QAbstractAudioOutput::start()
    if (numArgs == 0) {
        overloadId = 1; // start()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // start(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractAudioOutputFunc_start_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // start(QIODevice * device)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // start(QIODevice*)
                if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.start()' not implemented.");
                    return {};
                }
                cppSelf->start(cppArg0);

                // Ownership transferences.
                Shiboken::Object::releaseOwnership(pyArgs[0]);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // start()
        {

            if (!PyErr_Occurred()) {
                // start()
                if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.start()' not implemented.");
                    return {};
                }
                QIODevice * cppResult = cppSelf->start();
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);

                // Ownership transferences.
                Shiboken::Object::releaseOwnership(pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractAudioOutputFunc_start_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractAudioOutputFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.state()' not implemented.");
                return {};
            }
            QAudio::State cppResult = const_cast<const ::QAbstractAudioOutput *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.stop()' not implemented.");
                return {};
            }
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_suspend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.suspend";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // suspend()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractAudioOutput.suspend()' not implemented.");
                return {};
            }
            cppSelf->suspend();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractAudioOutputFunc_volume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractAudioOutput.volume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // volume()const
            qreal cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractAudioOutput *>(cppSelf)->::QAbstractAudioOutput::volume()
                : const_cast<const ::QAbstractAudioOutput *>(cppSelf)->volume();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAbstractAudioOutput_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractAudioOutput_methods[] = {
    {"bufferSize", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_bufferSize), METH_NOARGS},
    {"bytesFree", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_bytesFree), METH_NOARGS},
    {"category", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_category), METH_NOARGS},
    {"elapsedUSecs", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_elapsedUSecs), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_error), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_format), METH_NOARGS},
    {"notifyInterval", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_notifyInterval), METH_NOARGS},
    {"periodSize", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_periodSize), METH_NOARGS},
    {"processedUSecs", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_processedUSecs), METH_NOARGS},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_reset), METH_NOARGS},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_resume), METH_NOARGS},
    {"setBufferSize", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_setBufferSize), METH_O},
    {"setCategory", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_setCategory), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_setFormat), METH_O},
    {"setNotifyInterval", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_setNotifyInterval), METH_O},
    {"setVolume", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_setVolume), METH_O},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_start), METH_VARARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_state), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_stop), METH_NOARGS},
    {"suspend", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_suspend), METH_NOARGS},
    {"volume", reinterpret_cast<PyCFunction>(Sbk_QAbstractAudioOutputFunc_volume), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractAudioOutput_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractAudioOutput *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractAudioOutputWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAbstractAudioOutput_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractAudioOutput_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractAudioOutput_Type = nullptr;
static SbkObjectType *Sbk_QAbstractAudioOutput_TypeF(void)
{
    return _Sbk_QAbstractAudioOutput_Type;
}

static PyType_Slot Sbk_QAbstractAudioOutput_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractAudioOutput_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractAudioOutput_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractAudioOutput_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractAudioOutput_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractAudioOutput_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractAudioOutput_spec = {
    "2:PySide2.QtMultimedia.QAbstractAudioOutput",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractAudioOutput_slots
};

} //extern "C"

static void *Sbk_QAbstractAudioOutput_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QAbstractAudioOutput *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractAudioOutput_PythonToCpp_QAbstractAudioOutput_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractAudioOutput_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractAudioOutput_PythonToCpp_QAbstractAudioOutput_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractAudioOutput_TypeF())))
        return QAbstractAudioOutput_PythonToCpp_QAbstractAudioOutput_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractAudioOutput_PTR_CppToPython_QAbstractAudioOutput(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAbstractAudioOutput *>(const_cast<void *>(cppIn)), Sbk_QAbstractAudioOutput_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractAudioOutput_SignatureStrings[] = {
    "PySide2.QtMultimedia.QAbstractAudioOutput(self)",
    "PySide2.QtMultimedia.QAbstractAudioOutput.bufferSize(self)->int",
    "PySide2.QtMultimedia.QAbstractAudioOutput.bytesFree(self)->int",
    "PySide2.QtMultimedia.QAbstractAudioOutput.category(self)->QString",
    "PySide2.QtMultimedia.QAbstractAudioOutput.elapsedUSecs(self)->qint64",
    "PySide2.QtMultimedia.QAbstractAudioOutput.error(self)->PySide2.QtMultimedia.QAudio.Error",
    "PySide2.QtMultimedia.QAbstractAudioOutput.format(self)->PySide2.QtMultimedia.QAudioFormat",
    "PySide2.QtMultimedia.QAbstractAudioOutput.notifyInterval(self)->int",
    "PySide2.QtMultimedia.QAbstractAudioOutput.periodSize(self)->int",
    "PySide2.QtMultimedia.QAbstractAudioOutput.processedUSecs(self)->qint64",
    "PySide2.QtMultimedia.QAbstractAudioOutput.reset(self)",
    "PySide2.QtMultimedia.QAbstractAudioOutput.resume(self)",
    "PySide2.QtMultimedia.QAbstractAudioOutput.setBufferSize(self,value:int)",
    "PySide2.QtMultimedia.QAbstractAudioOutput.setCategory(self,arg__1:QString)",
    "PySide2.QtMultimedia.QAbstractAudioOutput.setFormat(self,fmt:PySide2.QtMultimedia.QAudioFormat)",
    "PySide2.QtMultimedia.QAbstractAudioOutput.setNotifyInterval(self,milliSeconds:int)",
    "PySide2.QtMultimedia.QAbstractAudioOutput.setVolume(self,arg__1:qreal)",
    "1:PySide2.QtMultimedia.QAbstractAudioOutput.start(self,device:PySide2.QtCore.QIODevice)",
    "0:PySide2.QtMultimedia.QAbstractAudioOutput.start(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtMultimedia.QAbstractAudioOutput.state(self)->PySide2.QtMultimedia.QAudio.State",
    "PySide2.QtMultimedia.QAbstractAudioOutput.stop(self)",
    "PySide2.QtMultimedia.QAbstractAudioOutput.suspend(self)",
    "PySide2.QtMultimedia.QAbstractAudioOutput.volume(self)->qreal",
    nullptr}; // Sentinel

void init_QAbstractAudioOutput(PyObject *module)
{
    _Sbk_QAbstractAudioOutput_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractAudioOutput",
        "QAbstractAudioOutput*",
        &Sbk_QAbstractAudioOutput_spec,
        &Shiboken::callCppDestructor< ::QAbstractAudioOutput >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractAudioOutput_Type);
    InitSignatureStrings(pyType, QAbstractAudioOutput_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractAudioOutput_Type), Sbk_QAbstractAudioOutput_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTAUDIOOUTPUT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractAudioOutput_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractAudioOutput_TypeF(),
        QAbstractAudioOutput_PythonToCpp_QAbstractAudioOutput_PTR,
        is_QAbstractAudioOutput_PythonToCpp_QAbstractAudioOutput_PTR_Convertible,
        QAbstractAudioOutput_PTR_CppToPython_QAbstractAudioOutput);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractAudioOutput");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractAudioOutput*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractAudioOutput&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractAudioOutput).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractAudioOutputWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAbstractAudioOutput_TypeF(), &Sbk_QAbstractAudioOutput_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QAbstractAudioOutput_TypeF(), &::QAbstractAudioOutput::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAbstractAudioOutput_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAbstractAudioOutput_TypeF(), &::QAbstractAudioOutput::staticMetaObject, sizeof(QAbstractAudioOutputWrapper));
}
