/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qaudio_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QAudioFunc_convertVolume(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudio.convertVolume";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "convertVolume", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QAudio::convertVolume(qreal,QAudio::VolumeScale,QAudio::VolumeScale)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // convertVolume(qreal,QAudio::VolumeScale,QAudio::VolumeScale)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFunc_convertVolume_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QAudio::VolumeScale cppArg1{QAudio::LinearVolumeScale};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QAudio::VolumeScale cppArg2{QAudio::LinearVolumeScale};
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // convertVolume(qreal,QAudio::VolumeScale,QAudio::VolumeScale)
            qreal cppResult = ::QAudio::convertVolume(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioFunc_convertVolume_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QAudio_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAudio_methods[] = {
    {"convertVolume", reinterpret_cast<PyCFunction>(Sbk_QAudioFunc_convertVolume), METH_VARARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QAudio_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAudio_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAudio_Type = nullptr;
static SbkObjectType *Sbk_QAudio_TypeF(void)
{
    return _Sbk_QAudio_Type;
}

static PyType_Slot Sbk_QAudio_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAudio_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAudio_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAudio_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAudio_spec = {
    "2:PySide2.QtMultimedia.QAudio",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAudio_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QAudio_Error_PythonToCpp_QAudio_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudio::Error *>(cppOut) =
        static_cast<::QAudio::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAudio_Error_PythonToCpp_QAudio_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX]))
        return QAudio_Error_PythonToCpp_QAudio_Error;
    return {};
}
static PyObject *QAudio_Error_CppToPython_QAudio_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAudio::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX], castCppIn);

}

static void QAudio_State_PythonToCpp_QAudio_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudio::State *>(cppOut) =
        static_cast<::QAudio::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAudio_State_PythonToCpp_QAudio_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX]))
        return QAudio_State_PythonToCpp_QAudio_State;
    return {};
}
static PyObject *QAudio_State_CppToPython_QAudio_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAudio::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX], castCppIn);

}

static void QAudio_Mode_PythonToCpp_QAudio_Mode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudio::Mode *>(cppOut) =
        static_cast<::QAudio::Mode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAudio_Mode_PythonToCpp_QAudio_Mode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX]))
        return QAudio_Mode_PythonToCpp_QAudio_Mode;
    return {};
}
static PyObject *QAudio_Mode_CppToPython_QAudio_Mode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAudio::Mode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX], castCppIn);

}

static void QAudio_Role_PythonToCpp_QAudio_Role(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudio::Role *>(cppOut) =
        static_cast<::QAudio::Role>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAudio_Role_PythonToCpp_QAudio_Role_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX]))
        return QAudio_Role_PythonToCpp_QAudio_Role;
    return {};
}
static PyObject *QAudio_Role_CppToPython_QAudio_Role(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAudio::Role *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX], castCppIn);

}

static void QAudio_VolumeScale_PythonToCpp_QAudio_VolumeScale(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudio::VolumeScale *>(cppOut) =
        static_cast<::QAudio::VolumeScale>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAudio_VolumeScale_PythonToCpp_QAudio_VolumeScale_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX]))
        return QAudio_VolumeScale_PythonToCpp_QAudio_VolumeScale;
    return {};
}
static PyObject *QAudio_VolumeScale_CppToPython_QAudio_VolumeScale(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAudio::VolumeScale *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX], castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtMultimediaQAudio_SignatureStrings[] = {
    "PySide2.QtMultimedia.QAudio.convertVolume(volume:qreal,from:PySide2.QtMultimedia.QAudio.VolumeScale,to:PySide2.QtMultimedia.QAudio.VolumeScale)->qreal",
    nullptr}; // Sentinel

void init_QtMultimediaQAudio(PyObject *module)
{
    _Sbk_QAudio_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAudio",
        "QAudio",
        &Sbk_QAudio_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAudio_Type);
    InitSignatureStrings(pyType, QtMultimediaQAudio_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAudio_Type), Sbk_QAudio_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QtMultimediaQAUDIO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAudio_TypeF());


    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAudio_TypeF(),
        "Error",
        "2:PySide2.QtMultimedia.QAudio.Error",
        "QAudio::Error");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX],
        Sbk_QAudio_TypeF(), "NoError", (long) QAudio::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX],
        Sbk_QAudio_TypeF(), "OpenError", (long) QAudio::Error::OpenError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX],
        Sbk_QAudio_TypeF(), "IOError", (long) QAudio::Error::IOError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX],
        Sbk_QAudio_TypeF(), "UnderrunError", (long) QAudio::Error::UnderrunError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX],
        Sbk_QAudio_TypeF(), "FatalError", (long) QAudio::Error::FatalError))
        return;
    // Register converter for enum 'QAudio::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX],
            QAudio_Error_CppToPython_QAudio_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAudio_Error_PythonToCpp_QAudio_Error,
            is_QAudio_Error_PythonToCpp_QAudio_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAudio::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    // Initialization of enum 'State'.
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAudio_TypeF(),
        "State",
        "2:PySide2.QtMultimedia.QAudio.State",
        "QAudio::State");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX],
        Sbk_QAudio_TypeF(), "ActiveState", (long) QAudio::State::ActiveState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX],
        Sbk_QAudio_TypeF(), "SuspendedState", (long) QAudio::State::SuspendedState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX],
        Sbk_QAudio_TypeF(), "StoppedState", (long) QAudio::State::StoppedState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX],
        Sbk_QAudio_TypeF(), "IdleState", (long) QAudio::State::IdleState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX],
        Sbk_QAudio_TypeF(), "InterruptedState", (long) QAudio::State::InterruptedState))
        return;
    // Register converter for enum 'QAudio::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX],
            QAudio_State_CppToPython_QAudio_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAudio_State_PythonToCpp_QAudio_State,
            is_QAudio_State_PythonToCpp_QAudio_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAudio::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'Mode'.
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAudio_TypeF(),
        "Mode",
        "2:PySide2.QtMultimedia.QAudio.Mode",
        "QAudio::Mode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX],
        Sbk_QAudio_TypeF(), "AudioInput", (long) QAudio::Mode::AudioInput))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX],
        Sbk_QAudio_TypeF(), "AudioOutput", (long) QAudio::Mode::AudioOutput))
        return;
    // Register converter for enum 'QAudio::Mode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX],
            QAudio_Mode_CppToPython_QAudio_Mode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAudio_Mode_PythonToCpp_QAudio_Mode,
            is_QAudio_Mode_PythonToCpp_QAudio_Mode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAudio::Mode");
        Shiboken::Conversions::registerConverterName(converter, "Mode");
    }
    // End of 'Mode' enum.

    // Initialization of enum 'Role'.
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAudio_TypeF(),
        "Role",
        "2:PySide2.QtMultimedia.QAudio.Role",
        "QAudio::Role");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "UnknownRole", (long) QAudio::Role::UnknownRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "MusicRole", (long) QAudio::Role::MusicRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "VideoRole", (long) QAudio::Role::VideoRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "VoiceCommunicationRole", (long) QAudio::Role::VoiceCommunicationRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "AlarmRole", (long) QAudio::Role::AlarmRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "NotificationRole", (long) QAudio::Role::NotificationRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "RingtoneRole", (long) QAudio::Role::RingtoneRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "AccessibilityRole", (long) QAudio::Role::AccessibilityRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "SonificationRole", (long) QAudio::Role::SonificationRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "GameRole", (long) QAudio::Role::GameRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
        Sbk_QAudio_TypeF(), "CustomRole", (long) QAudio::Role::CustomRole))
        return;
    // Register converter for enum 'QAudio::Role'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX],
            QAudio_Role_CppToPython_QAudio_Role);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAudio_Role_PythonToCpp_QAudio_Role,
            is_QAudio_Role_PythonToCpp_QAudio_Role_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAudio::Role");
        Shiboken::Conversions::registerConverterName(converter, "Role");
    }
    // End of 'Role' enum.

    // Initialization of enum 'VolumeScale'.
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAudio_TypeF(),
        "VolumeScale",
        "2:PySide2.QtMultimedia.QAudio.VolumeScale",
        "QAudio::VolumeScale");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX],
        Sbk_QAudio_TypeF(), "LinearVolumeScale", (long) QAudio::VolumeScale::LinearVolumeScale))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX],
        Sbk_QAudio_TypeF(), "CubicVolumeScale", (long) QAudio::VolumeScale::CubicVolumeScale))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX],
        Sbk_QAudio_TypeF(), "LogarithmicVolumeScale", (long) QAudio::VolumeScale::LogarithmicVolumeScale))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX],
        Sbk_QAudio_TypeF(), "DecibelVolumeScale", (long) QAudio::VolumeScale::DecibelVolumeScale))
        return;
    // Register converter for enum 'QAudio::VolumeScale'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX],
            QAudio_VolumeScale_CppToPython_QAudio_VolumeScale);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAudio_VolumeScale_PythonToCpp_QAudio_VolumeScale,
            is_QAudio_VolumeScale_PythonToCpp_QAudio_VolumeScale_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_VOLUMESCALE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAudio::VolumeScale");
        Shiboken::Conversions::registerConverterName(converter, "VolumeScale");
    }
    // End of 'VolumeScale' enum.

    qRegisterMetaType< ::QAudio::Error >("QAudio::Error");
    qRegisterMetaType< ::QAudio::State >("QAudio::State");
    qRegisterMetaType< ::QAudio::Mode >("QAudio::Mode");
    qRegisterMetaType< ::QAudio::Role >("QAudio::Role");
    qRegisterMetaType< ::QAudio::VolumeScale >("QAudio::VolumeScale");
}
