/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qaudiodeviceinfo_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtMultimedia/qaudiodeviceinfo.h>
#include <QtMultimedia/qaudioformat.h>
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAudioDeviceInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAudioDeviceInfo >()))
        return -1;

    ::QAudioDeviceInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAudioDeviceInfo", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAudioDeviceInfo::QAudioDeviceInfo()
    // 1: QAudioDeviceInfo::QAudioDeviceInfo(QAudioDeviceInfo)
    if (numArgs == 0) {
        overloadId = 0; // QAudioDeviceInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QAudioDeviceInfo(QAudioDeviceInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioDeviceInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAudioDeviceInfo()
        {

            if (!PyErr_Occurred()) {
                // QAudioDeviceInfo()
                cptr = new ::QAudioDeviceInfo();
            }
            break;
        }
        case 1: // QAudioDeviceInfo(const QAudioDeviceInfo & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAudioDeviceInfo cppArg0_local;
            ::QAudioDeviceInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QAudioDeviceInfo(QAudioDeviceInfo)
                cptr = new ::QAudioDeviceInfo(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAudioDeviceInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAudioDeviceInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAudioDeviceInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_availableDevices(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.availableDevices";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QAudioDeviceInfo::availableDevices(QAudio::Mode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_MODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // availableDevices(QAudio::Mode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioDeviceInfoFunc_availableDevices_TypeError;

    // Call function/method
    {
        ::QAudio::Mode cppArg0{QAudio::AudioInput};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // availableDevices(QAudio::Mode)
            QList<QAudioDeviceInfo > cppResult = ::QAudioDeviceInfo::availableDevices(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIODEVICEINFO_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioDeviceInfoFunc_availableDevices_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioDeviceInfoFunc_defaultInputDevice(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.defaultInputDevice";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultInputDevice()
            QAudioDeviceInfo cppResult = ::QAudioDeviceInfo::defaultInputDevice();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_defaultOutputDevice(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.defaultOutputDevice";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultOutputDevice()
            QAudioDeviceInfo cppResult = ::QAudioDeviceInfo::defaultOutputDevice();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_deviceName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.deviceName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deviceName()const
            QString cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->deviceName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_isFormatSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.isFormatSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioDeviceInfo::isFormatSupported(QAudioFormat)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // isFormatSupported(QAudioFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioDeviceInfoFunc_isFormatSupported_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAudioFormat cppArg0_local;
        ::QAudioFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isFormatSupported(QAudioFormat)const
            bool cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->isFormatSupported(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioDeviceInfoFunc_isFormatSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioDeviceInfoFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_nearestFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.nearestFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioDeviceInfo::nearestFormat(QAudioFormat)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // nearestFormat(QAudioFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioDeviceInfoFunc_nearestFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAudioFormat cppArg0_local;
        ::QAudioFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // nearestFormat(QAudioFormat)const
            QAudioFormat cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->nearestFormat(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioDeviceInfoFunc_nearestFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioDeviceInfoFunc_preferredFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.preferredFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preferredFormat()const
            QAudioFormat cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->preferredFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_realm(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.realm";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // realm()const
            QString cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->realm();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_supportedByteOrders(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.supportedByteOrders";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedByteOrders()const
            QList<QAudioFormat::Endian > cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->supportedByteOrders();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIOFORMAT_ENDIAN_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_supportedChannelCounts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.supportedChannelCounts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedChannelCounts()const
            QList<int > cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->supportedChannelCounts();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_supportedCodecs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.supportedCodecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedCodecs()const
            QStringList cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->supportedCodecs();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_supportedSampleRates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.supportedSampleRates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSampleRates()const
            QList<int > cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->supportedSampleRates();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_supportedSampleSizes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.supportedSampleSizes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSampleSizes()const
            QList<int > cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->supportedSampleSizes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfoFunc_supportedSampleTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioDeviceInfo.supportedSampleTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSampleTypes()const
            QList<QAudioFormat::SampleType > cppResult = const_cast<const ::QAudioDeviceInfo *>(cppSelf)->supportedSampleTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIOFORMAT_SAMPLETYPE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioDeviceInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAudioDeviceInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAudioDeviceInfo_methods[] = {
    {"availableDevices", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_availableDevices), METH_O|METH_STATIC},
    {"defaultInputDevice", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_defaultInputDevice), METH_NOARGS|METH_STATIC},
    {"defaultOutputDevice", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_defaultOutputDevice), METH_NOARGS|METH_STATIC},
    {"deviceName", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_deviceName), METH_NOARGS},
    {"isFormatSupported", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_isFormatSupported), METH_O},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_isNull), METH_NOARGS},
    {"nearestFormat", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_nearestFormat), METH_O},
    {"preferredFormat", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_preferredFormat), METH_NOARGS},
    {"realm", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_realm), METH_NOARGS},
    {"supportedByteOrders", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_supportedByteOrders), METH_NOARGS},
    {"supportedChannelCounts", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_supportedChannelCounts), METH_NOARGS},
    {"supportedCodecs", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_supportedCodecs), METH_NOARGS},
    {"supportedSampleRates", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_supportedSampleRates), METH_NOARGS},
    {"supportedSampleSizes", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_supportedSampleSizes), METH_NOARGS},
    {"supportedSampleTypes", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfoFunc_supportedSampleTypes), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QAudioDeviceInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAudioDeviceInfo___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QAudioDeviceInfo_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), (pyArg)))) {
                // operator!=(const QAudioDeviceInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QAudioDeviceInfo cppArg0_local;
                ::QAudioDeviceInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), (pyArg)))) {
                // operator==(const QAudioDeviceInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QAudioDeviceInfo cppArg0_local;
                ::QAudioDeviceInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QAudioDeviceInfo_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QAudioDeviceInfo_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QAudioDeviceInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAudioDeviceInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAudioDeviceInfo_Type = nullptr;
static SbkObjectType *Sbk_QAudioDeviceInfo_TypeF(void)
{
    return _Sbk_QAudioDeviceInfo_Type;
}

static PyType_Slot Sbk_QAudioDeviceInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAudioDeviceInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAudioDeviceInfo_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QAudioDeviceInfo_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAudioDeviceInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAudioDeviceInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QAudioDeviceInfo___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QAudioDeviceInfo___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QAudioDeviceInfo_spec = {
    "2:PySide2.QtMultimedia.QAudioDeviceInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAudioDeviceInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAudioDeviceInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAudioDeviceInfo_TypeF())))
        return QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAudioDeviceInfo_PTR_CppToPython_QAudioDeviceInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAudioDeviceInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAudioDeviceInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QAudioDeviceInfo_COPY_CppToPython_QAudioDeviceInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QAudioDeviceInfo_TypeF(), new ::QAudioDeviceInfo(*reinterpret_cast<const ::QAudioDeviceInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudioDeviceInfo *>(cppOut) = *reinterpret_cast< ::QAudioDeviceInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAudioDeviceInfo_TypeF())))
        return QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAudioDeviceInfo_SignatureStrings[] = {
    "1:PySide2.QtMultimedia.QAudioDeviceInfo(self)",
    "0:PySide2.QtMultimedia.QAudioDeviceInfo(self,other:PySide2.QtMultimedia.QAudioDeviceInfo)",
    "PySide2.QtMultimedia.QAudioDeviceInfo.availableDevices(mode:PySide2.QtMultimedia.QAudio.Mode)->QList[PySide2.QtMultimedia.QAudioDeviceInfo]",
    "PySide2.QtMultimedia.QAudioDeviceInfo.defaultInputDevice()->PySide2.QtMultimedia.QAudioDeviceInfo",
    "PySide2.QtMultimedia.QAudioDeviceInfo.defaultOutputDevice()->PySide2.QtMultimedia.QAudioDeviceInfo",
    "PySide2.QtMultimedia.QAudioDeviceInfo.deviceName(self)->QString",
    "PySide2.QtMultimedia.QAudioDeviceInfo.isFormatSupported(self,format:PySide2.QtMultimedia.QAudioFormat)->bool",
    "PySide2.QtMultimedia.QAudioDeviceInfo.isNull(self)->bool",
    "PySide2.QtMultimedia.QAudioDeviceInfo.nearestFormat(self,format:PySide2.QtMultimedia.QAudioFormat)->PySide2.QtMultimedia.QAudioFormat",
    "PySide2.QtMultimedia.QAudioDeviceInfo.preferredFormat(self)->PySide2.QtMultimedia.QAudioFormat",
    "PySide2.QtMultimedia.QAudioDeviceInfo.realm(self)->QString",
    "PySide2.QtMultimedia.QAudioDeviceInfo.supportedByteOrders(self)->QList[PySide2.QtMultimedia.QAudioFormat.Endian]",
    "PySide2.QtMultimedia.QAudioDeviceInfo.supportedChannelCounts(self)->QList[int]",
    "PySide2.QtMultimedia.QAudioDeviceInfo.supportedCodecs(self)->QStringList",
    "PySide2.QtMultimedia.QAudioDeviceInfo.supportedSampleRates(self)->QList[int]",
    "PySide2.QtMultimedia.QAudioDeviceInfo.supportedSampleSizes(self)->QList[int]",
    "PySide2.QtMultimedia.QAudioDeviceInfo.supportedSampleTypes(self)->QList[PySide2.QtMultimedia.QAudioFormat.SampleType]",
    "PySide2.QtMultimedia.QAudioDeviceInfo.__copy__()",
    nullptr}; // Sentinel

void init_QAudioDeviceInfo(PyObject *module)
{
    _Sbk_QAudioDeviceInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAudioDeviceInfo",
        "QAudioDeviceInfo",
        &Sbk_QAudioDeviceInfo_spec,
        &Shiboken::callCppDestructor< ::QAudioDeviceInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAudioDeviceInfo_Type);
    InitSignatureStrings(pyType, QAudioDeviceInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAudioDeviceInfo_Type), Sbk_QAudioDeviceInfo_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAudioDeviceInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAudioDeviceInfo_TypeF(),
        QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_PTR,
        is_QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_PTR_Convertible,
        QAudioDeviceInfo_PTR_CppToPython_QAudioDeviceInfo,
        QAudioDeviceInfo_COPY_CppToPython_QAudioDeviceInfo);

    Shiboken::Conversions::registerConverterName(converter, "QAudioDeviceInfo");
    Shiboken::Conversions::registerConverterName(converter, "QAudioDeviceInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QAudioDeviceInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAudioDeviceInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_COPY,
        is_QAudioDeviceInfo_PythonToCpp_QAudioDeviceInfo_COPY_Convertible);

    qRegisterMetaType< ::QAudioDeviceInfo >("QAudioDeviceInfo");
}
