/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qcamerafocus_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QCameraFocusWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QCameraFocusWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraFocusWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCameraFocusWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraFocusWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QCameraFocusWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraFocus.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QCameraFocusWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraFocus.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QCameraFocusWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QCameraFocusWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QCameraFocus::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QCameraFocusWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QCameraFocus::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QCameraFocusWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QCameraFocusWrapper *>(this));
        return QCameraFocus::qt_metacast(_clname);
}

QCameraFocusWrapper::~QCameraFocusWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QCameraFocusFunc_customFocusPoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.customFocusPoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // customFocusPoint()const
            QPointF cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->customFocusPoint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusFunc_digitalZoom(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.digitalZoom";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // digitalZoom()const
            qreal cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->digitalZoom();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusFunc_focusMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.focusMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focusMode()const
            QFlags<QCameraFocus::FocusMode> cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->focusMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusFunc_focusPointMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.focusPointMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focusPointMode()const
            QCameraFocus::FocusPointMode cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->focusPointMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusFunc_focusZones(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.focusZones";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focusZones()const
            QList<QCameraFocusZone > cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->focusZones();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAFOCUSZONE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusFunc_isAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.isAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAvailable()const
            bool cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->isAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusFunc_isFocusModeSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.isFocusModeSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraFocus::isFocusModeSupported(QFlags<QCameraFocus::FocusMode>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isFocusModeSupported(QFlags<QCameraFocus::FocusMode>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFocusFunc_isFocusModeSupported_TypeError;

    // Call function/method
    {
        ::QFlags<QCameraFocus::FocusMode> cppArg0 = QFlags<QCameraFocus::FocusMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isFocusModeSupported(QFlags<QCameraFocus::FocusMode>)const
            bool cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->isFocusModeSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraFocusFunc_isFocusModeSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFocusFunc_isFocusPointModeSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.isFocusPointModeSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraFocus::isFocusPointModeSupported(QCameraFocus::FocusPointMode)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isFocusPointModeSupported(QCameraFocus::FocusPointMode)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFocusFunc_isFocusPointModeSupported_TypeError;

    // Call function/method
    {
        ::QCameraFocus::FocusPointMode cppArg0{QCameraFocus::FocusPointAuto};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isFocusPointModeSupported(QCameraFocus::FocusPointMode)const
            bool cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->isFocusPointModeSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraFocusFunc_isFocusPointModeSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFocusFunc_maximumDigitalZoom(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.maximumDigitalZoom";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumDigitalZoom()const
            qreal cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->maximumDigitalZoom();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusFunc_maximumOpticalZoom(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.maximumOpticalZoom";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumOpticalZoom()const
            qreal cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->maximumOpticalZoom();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusFunc_opticalZoom(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.opticalZoom";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // opticalZoom()const
            qreal cppResult = const_cast<const ::QCameraFocus *>(cppSelf)->opticalZoom();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusFunc_setCustomFocusPoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.setCustomFocusPoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraFocus::setCustomFocusPoint(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setCustomFocusPoint(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFocusFunc_setCustomFocusPoint_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setCustomFocusPoint(QPointF)
            cppSelf->setCustomFocusPoint(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFocusFunc_setCustomFocusPoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFocusFunc_setFocusMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.setFocusMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraFocus::setFocusMode(QFlags<QCameraFocus::FocusMode>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFocusMode(QFlags<QCameraFocus::FocusMode>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFocusFunc_setFocusMode_TypeError;

    // Call function/method
    {
        ::QFlags<QCameraFocus::FocusMode> cppArg0 = QFlags<QCameraFocus::FocusMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFocusMode(QFlags<QCameraFocus::FocusMode>)
            cppSelf->setFocusMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFocusFunc_setFocusMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFocusFunc_setFocusPointMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.setFocusPointMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraFocus::setFocusPointMode(QCameraFocus::FocusPointMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFocusPointMode(QCameraFocus::FocusPointMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFocusFunc_setFocusPointMode_TypeError;

    // Call function/method
    {
        ::QCameraFocus::FocusPointMode cppArg0{QCameraFocus::FocusPointAuto};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFocusPointMode(QCameraFocus::FocusPointMode)
            cppSelf->setFocusPointMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFocusFunc_setFocusPointMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFocusFunc_zoomTo(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocus.zoomTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "zoomTo", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCameraFocus::zoomTo(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // zoomTo(qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFocusFunc_zoomTo_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // zoomTo(qreal,qreal)
            cppSelf->zoomTo(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFocusFunc_zoomTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QCameraFocus_PropertyStrings[] = {
    "customFocusPoint::",
    "digitalZoom:",
    "focusMode::",
    "focusPointMode::",
    "focusZones:",
    "opticalZoom:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCameraFocus_methods[] = {
    {"customFocusPoint", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_customFocusPoint), METH_NOARGS},
    {"digitalZoom", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_digitalZoom), METH_NOARGS},
    {"focusMode", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_focusMode), METH_NOARGS},
    {"focusPointMode", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_focusPointMode), METH_NOARGS},
    {"focusZones", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_focusZones), METH_NOARGS},
    {"isAvailable", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_isAvailable), METH_NOARGS},
    {"isFocusModeSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_isFocusModeSupported), METH_O},
    {"isFocusPointModeSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_isFocusPointModeSupported), METH_O},
    {"maximumDigitalZoom", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_maximumDigitalZoom), METH_NOARGS},
    {"maximumOpticalZoom", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_maximumOpticalZoom), METH_NOARGS},
    {"opticalZoom", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_opticalZoom), METH_NOARGS},
    {"setCustomFocusPoint", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_setCustomFocusPoint), METH_O},
    {"setFocusMode", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_setFocusMode), METH_O},
    {"setFocusPointMode", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_setFocusPointMode), METH_O},
    {"zoomTo", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusFunc_zoomTo), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCameraFocus_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QCameraFocus *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QCameraFocusWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QCameraFocus_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCameraFocus_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCameraFocus_Type = nullptr;
static SbkObjectType *Sbk_QCameraFocus_TypeF(void)
{
    return _Sbk_QCameraFocus_Type;
}

static PyType_Slot Sbk_QCameraFocus_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QCameraFocus_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCameraFocus_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCameraFocus_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCameraFocus_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCameraFocus_spec = {
    "2:PySide2.QtMultimedia.QCameraFocus",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCameraFocus_slots
};

} //extern "C"

static void *Sbk_QCameraFocus_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QCameraFocus *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtMultimedia_QCameraFocus_FocusMode___and__(PyObject *self, PyObject *pyArg)
{
    ::QCameraFocus::FocusModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCameraFocus::FocusModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCameraFocus::FocusModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCameraFocus::FocusModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCameraFocus::FocusModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCameraFocus_FocusMode___or__(PyObject *self, PyObject *pyArg)
{
    ::QCameraFocus::FocusModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCameraFocus::FocusModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCameraFocus::FocusModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCameraFocus::FocusModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCameraFocus::FocusModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCameraFocus_FocusMode___xor__(PyObject *self, PyObject *pyArg)
{
    ::QCameraFocus::FocusModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCameraFocus::FocusModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCameraFocus::FocusModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCameraFocus::FocusModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCameraFocus::FocusModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCameraFocus_FocusMode___invert__(PyObject *self, PyObject *pyArg)
{
    ::QCameraFocus::FocusModes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, self, &cppSelf);
    ::QCameraFocus::FocusModes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtMultimedia_QCameraFocus_FocusMode_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtMultimedia_QCameraFocus_FocusMode__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtMultimedia_QCameraFocus_FocusMode_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraFocus_FocusMode_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QCameraFocus_FocusMode_PythonToCpp_QCameraFocus_FocusMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraFocus::FocusMode *>(cppOut) =
        static_cast<::QCameraFocus::FocusMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraFocus_FocusMode_PythonToCpp_QCameraFocus_FocusMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX]))
        return QCameraFocus_FocusMode_PythonToCpp_QCameraFocus_FocusMode;
    return {};
}
static PyObject *QCameraFocus_FocusMode_CppToPython_QCameraFocus_FocusMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraFocus::FocusMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX], castCppIn);

}

static void QFlags_QCameraFocus_FocusMode__PythonToCpp_QFlags_QCameraFocus_FocusMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCameraFocus::FocusMode> *>(cppOut) =
        ::QFlags<QCameraFocus::FocusMode>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QCameraFocus_FocusMode__PythonToCpp_QFlags_QCameraFocus_FocusMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX]))
        return QFlags_QCameraFocus_FocusMode__PythonToCpp_QFlags_QCameraFocus_FocusMode_;
    return {};
}
static PyObject *QFlags_QCameraFocus_FocusMode__CppToPython_QFlags_QCameraFocus_FocusMode_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QCameraFocus::FocusMode> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX]));

}

static void QCameraFocus_FocusMode_PythonToCpp_QFlags_QCameraFocus_FocusMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCameraFocus::FocusMode> *>(cppOut) =
        ::QFlags<QCameraFocus::FocusMode>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QCameraFocus_FocusMode_PythonToCpp_QFlags_QCameraFocus_FocusMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX]))
        return QCameraFocus_FocusMode_PythonToCpp_QFlags_QCameraFocus_FocusMode_;
    return {};
}
static void number_PythonToCpp_QFlags_QCameraFocus_FocusMode_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QCameraFocus::FocusMode> *>(cppOut) =
        ::QFlags<QCameraFocus::FocusMode>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QCameraFocus_FocusMode__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX]))
        return number_PythonToCpp_QFlags_QCameraFocus_FocusMode_;
    return {};
}
static void QCameraFocus_FocusPointMode_PythonToCpp_QCameraFocus_FocusPointMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraFocus::FocusPointMode *>(cppOut) =
        static_cast<::QCameraFocus::FocusPointMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraFocus_FocusPointMode_PythonToCpp_QCameraFocus_FocusPointMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX]))
        return QCameraFocus_FocusPointMode_PythonToCpp_QCameraFocus_FocusPointMode;
    return {};
}
static PyObject *QCameraFocus_FocusPointMode_CppToPython_QCameraFocus_FocusPointMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraFocus::FocusPointMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCameraFocus_PythonToCpp_QCameraFocus_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCameraFocus_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCameraFocus_PythonToCpp_QCameraFocus_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCameraFocus_TypeF())))
        return QCameraFocus_PythonToCpp_QCameraFocus_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCameraFocus_PTR_CppToPython_QCameraFocus(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QCameraFocus *>(const_cast<void *>(cppIn)), Sbk_QCameraFocus_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCameraFocus_SignatureStrings[] = {
    "PySide2.QtMultimedia.QCameraFocus.customFocusPoint(self)->PySide2.QtCore.QPointF",
    "PySide2.QtMultimedia.QCameraFocus.digitalZoom(self)->qreal",
    "PySide2.QtMultimedia.QCameraFocus.focusMode(self)->PySide2.QtMultimedia.QCameraFocus.FocusModes",
    "PySide2.QtMultimedia.QCameraFocus.focusPointMode(self)->PySide2.QtMultimedia.QCameraFocus.FocusPointMode",
    "PySide2.QtMultimedia.QCameraFocus.focusZones(self)->QList[PySide2.QtMultimedia.QCameraFocusZone]",
    "PySide2.QtMultimedia.QCameraFocus.isAvailable(self)->bool",
    "PySide2.QtMultimedia.QCameraFocus.isFocusModeSupported(self,mode:PySide2.QtMultimedia.QCameraFocus.FocusModes)->bool",
    "PySide2.QtMultimedia.QCameraFocus.isFocusPointModeSupported(self,arg__1:PySide2.QtMultimedia.QCameraFocus.FocusPointMode)->bool",
    "PySide2.QtMultimedia.QCameraFocus.maximumDigitalZoom(self)->qreal",
    "PySide2.QtMultimedia.QCameraFocus.maximumOpticalZoom(self)->qreal",
    "PySide2.QtMultimedia.QCameraFocus.opticalZoom(self)->qreal",
    "PySide2.QtMultimedia.QCameraFocus.setCustomFocusPoint(self,point:PySide2.QtCore.QPointF)",
    "PySide2.QtMultimedia.QCameraFocus.setFocusMode(self,mode:PySide2.QtMultimedia.QCameraFocus.FocusModes)",
    "PySide2.QtMultimedia.QCameraFocus.setFocusPointMode(self,mode:PySide2.QtMultimedia.QCameraFocus.FocusPointMode)",
    "PySide2.QtMultimedia.QCameraFocus.zoomTo(self,opticalZoom:qreal,digitalZoom:qreal)",
    nullptr}; // Sentinel

void init_QCameraFocus(PyObject *module)
{
    _Sbk_QCameraFocus_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCameraFocus",
        "QCameraFocus*",
        &Sbk_QCameraFocus_spec,
        &Shiboken::callCppDestructor< ::QCameraFocus >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCameraFocus_Type);
    InitSignatureStrings(pyType, QCameraFocus_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCameraFocus_Type), Sbk_QCameraFocus_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCameraFocus_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCameraFocus_TypeF(),
        QCameraFocus_PythonToCpp_QCameraFocus_PTR,
        is_QCameraFocus_PythonToCpp_QCameraFocus_PTR_Convertible,
        QCameraFocus_PTR_CppToPython_QCameraFocus);

    Shiboken::Conversions::registerConverterName(converter, "QCameraFocus");
    Shiboken::Conversions::registerConverterName(converter, "QCameraFocus*");
    Shiboken::Conversions::registerConverterName(converter, "QCameraFocus&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraFocus).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraFocusWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QCameraFocus_TypeF(), &Sbk_QCameraFocus_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'FocusMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX] = PySide::QFlags::create("2:PySide2.QtMultimedia.QCameraFocus.FocusModes", SbkPySide2_QtMultimedia_QCameraFocus_FocusMode_number_slots);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraFocus_TypeF(),
        "FocusMode",
        "2:PySide2.QtMultimedia.QCameraFocus.FocusMode",
        "QCameraFocus::FocusMode",
        SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX]);
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "ManualFocus", (long) QCameraFocus::FocusMode::ManualFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "HyperfocalFocus", (long) QCameraFocus::FocusMode::HyperfocalFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "InfinityFocus", (long) QCameraFocus::FocusMode::InfinityFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "AutoFocus", (long) QCameraFocus::FocusMode::AutoFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "ContinuousFocus", (long) QCameraFocus::FocusMode::ContinuousFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "MacroFocus", (long) QCameraFocus::FocusMode::MacroFocus))
        return;
    // Register converter for enum 'QCameraFocus::FocusMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX],
            QCameraFocus_FocusMode_CppToPython_QCameraFocus_FocusMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraFocus_FocusMode_PythonToCpp_QCameraFocus_FocusMode,
            is_QCameraFocus_FocusMode_PythonToCpp_QCameraFocus_FocusMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraFocus::FocusMode");
        Shiboken::Conversions::registerConverterName(converter, "FocusMode");
    }
    // Register converter for flag 'QFlags<QCameraFocus::FocusMode>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX],
            QFlags_QCameraFocus_FocusMode__CppToPython_QFlags_QCameraFocus_FocusMode_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraFocus_FocusMode_PythonToCpp_QFlags_QCameraFocus_FocusMode_,
            is_QCameraFocus_FocusMode_PythonToCpp_QFlags_QCameraFocus_FocusMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QCameraFocus_FocusMode__PythonToCpp_QFlags_QCameraFocus_FocusMode_,
            is_QFlags_QCameraFocus_FocusMode__PythonToCpp_QFlags_QCameraFocus_FocusMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QCameraFocus_FocusMode_,
            is_number_PythonToCpp_QFlags_QCameraFocus_FocusMode__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAFOCUS_FOCUSMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraFocus::FocusModes");
        Shiboken::Conversions::registerConverterName(converter, "FocusModes");
    }
    // End of 'FocusMode' enum/flags.

    // Initialization of enum 'FocusPointMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraFocus_TypeF(),
        "FocusPointMode",
        "2:PySide2.QtMultimedia.QCameraFocus.FocusPointMode",
        "QCameraFocus::FocusPointMode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "FocusPointAuto", (long) QCameraFocus::FocusPointMode::FocusPointAuto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "FocusPointCenter", (long) QCameraFocus::FocusPointMode::FocusPointCenter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "FocusPointFaceDetection", (long) QCameraFocus::FocusPointMode::FocusPointFaceDetection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX],
        Sbk_QCameraFocus_TypeF(), "FocusPointCustom", (long) QCameraFocus::FocusPointMode::FocusPointCustom))
        return;
    // Register converter for enum 'QCameraFocus::FocusPointMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX],
            QCameraFocus_FocusPointMode_CppToPython_QCameraFocus_FocusPointMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraFocus_FocusPointMode_PythonToCpp_QCameraFocus_FocusPointMode,
            is_QCameraFocus_FocusPointMode_PythonToCpp_QCameraFocus_FocusPointMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_FOCUSPOINTMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraFocus::FocusPointMode");
        Shiboken::Conversions::registerConverterName(converter, "FocusPointMode");
    }
    // End of 'FocusPointMode' enum.

    PySide::Signal::registerSignals(Sbk_QCameraFocus_TypeF(), &::QCameraFocus::staticMetaObject);
    qRegisterMetaType< ::QCameraFocus::FocusMode >("QCameraFocus::FocusMode");
    qRegisterMetaType< ::QCameraFocus::FocusModes >("QCameraFocus::FocusModes");
    qRegisterMetaType< ::QCameraFocus::FocusPointMode >("QCameraFocus::FocusPointMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QCameraFocus_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QCameraFocus_TypeF(), &::QCameraFocus::staticMetaObject, sizeof(QCameraFocusWrapper));
}
