/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qcameraimagecapture_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QCameraImageCaptureWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QCameraImageCaptureWrapper::QCameraImageCaptureWrapper(::QMediaObject * mediaObject, ::QObject * parent) : QCameraImageCapture(mediaObject, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QCameraImageCaptureWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraImageCaptureWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCameraImageCaptureWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraImageCaptureWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QCameraImageCaptureWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageCapture.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QCameraImageCaptureWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageCapture.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QMediaObject * QCameraImageCaptureWrapper::mediaObject() const
{
    if (m_PyMethodCache[6])
        return this->::QCameraImageCapture::mediaObject();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mediaObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QCameraImageCapture::mediaObject();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageCapture.mediaObject", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMediaObject >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMediaObject *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QCameraImageCaptureWrapper::setMediaObject(::QMediaObject * arg__1)
{
    if (m_PyMethodCache[8])
        return this->::QCameraImageCapture::setMediaObject(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setMediaObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QCameraImageCapture::setMediaObject(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageCapture.setMediaObject", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QCameraImageCaptureWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QCameraImageCaptureWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QCameraImageCapture::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QCameraImageCaptureWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QCameraImageCapture::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QCameraImageCaptureWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QCameraImageCaptureWrapper *>(this));
        return QCameraImageCapture::qt_metacast(_clname);
}

QCameraImageCaptureWrapper::~QCameraImageCaptureWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCameraImageCapture_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX]);
    if (type != myType)
        Shiboken::ObjectType::copyMultipleInheritance(type, myType);

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCameraImageCapture >()))
        return -1;

    ::QCameraImageCaptureWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QCameraImageCapture_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QCameraImageCapture", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QCameraImageCapture::QCameraImageCapture(QMediaObject*,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QCameraImageCapture(QMediaObject*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QCameraImageCapture(QMediaObject*,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageCapture_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QCameraImageCapture_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QCameraImageCapture_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QMediaObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QCameraImageCapture(QMediaObject*,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QCameraImageCaptureWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QCameraImageCaptureWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCameraImageCapture >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCameraImageCapture_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QCameraImageCapture_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QCameraImageCapture_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCameraImageCaptureFunc_availability(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.availability";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availability()const
            QMultimedia::AvailabilityStatus cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->availability();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_bufferFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.bufferFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bufferFormat()const
            QVideoFrame::PixelFormat cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->bufferFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_cancelCapture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.cancelCapture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cancelCapture()
            cppSelf->cancelCapture();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCameraImageCaptureFunc_capture(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.capture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCameraImageCaptureFunc_capture_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:capture", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCameraImageCapture::capture(QString)
    if (numArgs == 0) {
        overloadId = 0; // capture(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // capture(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageCaptureFunc_capture_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_location = Shiboken::String::createStaticString("location");
            if (PyDict_Contains(kwds, key_location)) {
                value = PyDict_GetItem(kwds, key_location);
                if (value && pyArgs[0]) {
                    errInfo = key_location;
                    Py_INCREF(errInfo);
                    goto Sbk_QCameraImageCaptureFunc_capture_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QCameraImageCaptureFunc_capture_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_location);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCameraImageCaptureFunc_capture_TypeError;
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // capture(QString)
            int cppResult = cppSelf->capture(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraImageCaptureFunc_capture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageCaptureFunc_captureDestination(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.captureDestination";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // captureDestination()const
            QFlags<QCameraImageCapture::CaptureDestination> cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->captureDestination();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_encodingSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.encodingSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // encodingSettings()const
            QImageEncoderSettings cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->encodingSettings();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QCameraImageCapture::Error cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_imageCodecDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.imageCodecDescription";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageCapture::imageCodecDescription(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // imageCodecDescription(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageCaptureFunc_imageCodecDescription_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // imageCodecDescription(QString)const
            QString cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->imageCodecDescription(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraImageCaptureFunc_imageCodecDescription_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageCaptureFunc_isAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.isAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAvailable()const
            bool cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->isAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_isCaptureDestinationSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.isCaptureDestinationSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageCapture::isCaptureDestinationSupported(QFlags<QCameraImageCapture::CaptureDestination>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isCaptureDestinationSupported(QFlags<QCameraImageCapture::CaptureDestination>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageCaptureFunc_isCaptureDestinationSupported_TypeError;

    // Call function/method
    {
        ::QFlags<QCameraImageCapture::CaptureDestination> cppArg0 = QFlags<QCameraImageCapture::CaptureDestination>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isCaptureDestinationSupported(QFlags<QCameraImageCapture::CaptureDestination>)const
            bool cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->isCaptureDestinationSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraImageCaptureFunc_isCaptureDestinationSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageCaptureFunc_isReadyForCapture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.isReadyForCapture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadyForCapture()const
            bool cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->isReadyForCapture();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_mediaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.mediaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaObject()const
            QMediaObject * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QCameraImageCapture *>(cppSelf)->::QCameraImageCapture::mediaObject()
                : const_cast<const ::QCameraImageCapture *>(cppSelf)->mediaObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_setBufferFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.setBufferFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageCapture::setBufferFormat(QVideoFrame::PixelFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBufferFormat(QVideoFrame::PixelFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageCaptureFunc_setBufferFormat_TypeError;

    // Call function/method
    {
        ::QVideoFrame::PixelFormat cppArg0{QVideoFrame::Format_Invalid};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBufferFormat(QVideoFrame::PixelFormat)
            cppSelf->setBufferFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageCaptureFunc_setBufferFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageCaptureFunc_setCaptureDestination(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.setCaptureDestination";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageCapture::setCaptureDestination(QFlags<QCameraImageCapture::CaptureDestination>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCaptureDestination(QFlags<QCameraImageCapture::CaptureDestination>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageCaptureFunc_setCaptureDestination_TypeError;

    // Call function/method
    {
        ::QFlags<QCameraImageCapture::CaptureDestination> cppArg0 = QFlags<QCameraImageCapture::CaptureDestination>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCaptureDestination(QFlags<QCameraImageCapture::CaptureDestination>)
            cppSelf->setCaptureDestination(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageCaptureFunc_setCaptureDestination_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageCaptureFunc_setEncodingSettings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.setEncodingSettings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageCapture::setEncodingSettings(QImageEncoderSettings)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), (pyArg)))) {
        overloadId = 0; // setEncodingSettings(QImageEncoderSettings)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageCaptureFunc_setEncodingSettings_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QImageEncoderSettings cppArg0_local;
        ::QImageEncoderSettings *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setEncodingSettings(QImageEncoderSettings)
            cppSelf->setEncodingSettings(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageCaptureFunc_setEncodingSettings_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageCaptureFunc_setMediaObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.setMediaObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaBindableInterface::setMediaObject(QMediaObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // setMediaObject(QMediaObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageCaptureFunc_setMediaObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMediaObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMediaObject(QMediaObject*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QCameraImageCapture::setMediaObject(cppArg0)
                : cppSelf->setMediaObject(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraImageCaptureFunc_setMediaObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageCaptureFunc_supportedBufferFormats(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.supportedBufferFormats";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedBufferFormats()const
            QList<QVideoFrame::PixelFormat > cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->supportedBufferFormats();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QVIDEOFRAME_PIXELFORMAT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageCaptureFunc_supportedImageCodecs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageCapture.supportedImageCodecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedImageCodecs()const
            QStringList cppResult = const_cast<const ::QCameraImageCapture *>(cppSelf)->supportedImageCodecs();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCameraImageCapture_PropertyStrings[] = {
    "readyForCapture:isReadyForCapture",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCameraImageCapture_methods[] = {
    {"availability", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_availability), METH_NOARGS},
    {"bufferFormat", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_bufferFormat), METH_NOARGS},
    {"cancelCapture", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_cancelCapture), METH_NOARGS},
    {"capture", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_capture), METH_VARARGS|METH_KEYWORDS},
    {"captureDestination", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_captureDestination), METH_NOARGS},
    {"encodingSettings", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_encodingSettings), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_errorString), METH_NOARGS},
    {"imageCodecDescription", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_imageCodecDescription), METH_O},
    {"isAvailable", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_isAvailable), METH_NOARGS},
    {"isCaptureDestinationSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_isCaptureDestinationSupported), METH_O},
    {"isReadyForCapture", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_isReadyForCapture), METH_NOARGS},
    {"mediaObject", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_mediaObject), METH_NOARGS},
    {"setBufferFormat", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_setBufferFormat), METH_O},
    {"setCaptureDestination", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_setCaptureDestination), METH_O},
    {"setEncodingSettings", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_setEncodingSettings), METH_O},
    {"setMediaObject", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_setMediaObject), METH_O},
    {"supportedBufferFormats", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_supportedBufferFormats), METH_NOARGS},
    {"supportedImageCodecs", reinterpret_cast<PyCFunction>(Sbk_QCameraImageCaptureFunc_supportedImageCodecs), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCameraImageCapture_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QCameraImageCapture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QCameraImageCaptureWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QCameraImageCapture_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCameraImageCapture_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static int mi_offsets[] = { -1, -1, -1, -1, -1 };
int *
Sbk_QCameraImageCapture_mi_init(const void *cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        const auto *class_ptr = reinterpret_cast<const QCameraImageCapture *>(cptr);
        const auto base = reinterpret_cast<uintptr_t>(class_ptr);
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(static_cast<const QCameraImageCapture *>(static_cast<const void *>(class_ptr)))) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QMediaBindableInterface *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QMediaBindableInterface *>(static_cast<const QCameraImageCapture *>(static_cast<const void *>(class_ptr)))) - base));

        offsets.erase(0);

        std::copy(offsets.cbegin(), offsets.cend(), mi_offsets);
    }
    return mi_offsets;
}
static void * Sbk_QCameraImageCaptureSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QCameraImageCapture *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIABINDABLEINTERFACE_IDX]))
        return static_cast< ::QMediaBindableInterface *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCameraImageCapture_Type = nullptr;
static SbkObjectType *Sbk_QCameraImageCapture_TypeF(void)
{
    return _Sbk_QCameraImageCapture_Type;
}

static PyType_Slot Sbk_QCameraImageCapture_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QCameraImageCapture_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCameraImageCapture_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCameraImageCapture_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCameraImageCapture_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCameraImageCapture_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCameraImageCapture_spec = {
    "2:PySide2.QtMultimedia.QCameraImageCapture",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCameraImageCapture_slots
};

} //extern "C"

static void *Sbk_QCameraImageCapture_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QCameraImageCapture *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QMediaBindableInterface >()))
        return dynamic_cast< ::QCameraImageCapture *>(reinterpret_cast< ::QMediaBindableInterface *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination___and__(PyObject *self, PyObject *pyArg)
{
    ::QCameraImageCapture::CaptureDestinations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCameraImageCapture::CaptureDestinations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCameraImageCapture::CaptureDestinations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCameraImageCapture::CaptureDestinations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCameraImageCapture::CaptureDestinations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination___or__(PyObject *self, PyObject *pyArg)
{
    ::QCameraImageCapture::CaptureDestinations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCameraImageCapture::CaptureDestinations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCameraImageCapture::CaptureDestinations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCameraImageCapture::CaptureDestinations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCameraImageCapture::CaptureDestinations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination___xor__(PyObject *self, PyObject *pyArg)
{
    ::QCameraImageCapture::CaptureDestinations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCameraImageCapture::CaptureDestinations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCameraImageCapture::CaptureDestinations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCameraImageCapture::CaptureDestinations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCameraImageCapture::CaptureDestinations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination___invert__(PyObject *self, PyObject *pyArg)
{
    ::QCameraImageCapture::CaptureDestinations cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, self, &cppSelf);
    ::QCameraImageCapture::CaptureDestinations cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QCameraImageCapture_Error_PythonToCpp_QCameraImageCapture_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraImageCapture::Error *>(cppOut) =
        static_cast<::QCameraImageCapture::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraImageCapture_Error_PythonToCpp_QCameraImageCapture_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX]))
        return QCameraImageCapture_Error_PythonToCpp_QCameraImageCapture_Error;
    return {};
}
static PyObject *QCameraImageCapture_Error_CppToPython_QCameraImageCapture_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraImageCapture::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX], castCppIn);

}

static void QCameraImageCapture_DriveMode_PythonToCpp_QCameraImageCapture_DriveMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraImageCapture::DriveMode *>(cppOut) =
        static_cast<::QCameraImageCapture::DriveMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraImageCapture_DriveMode_PythonToCpp_QCameraImageCapture_DriveMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_DRIVEMODE_IDX]))
        return QCameraImageCapture_DriveMode_PythonToCpp_QCameraImageCapture_DriveMode;
    return {};
}
static PyObject *QCameraImageCapture_DriveMode_CppToPython_QCameraImageCapture_DriveMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraImageCapture::DriveMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_DRIVEMODE_IDX], castCppIn);

}

static void QCameraImageCapture_CaptureDestination_PythonToCpp_QCameraImageCapture_CaptureDestination(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraImageCapture::CaptureDestination *>(cppOut) =
        static_cast<::QCameraImageCapture::CaptureDestination>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraImageCapture_CaptureDestination_PythonToCpp_QCameraImageCapture_CaptureDestination_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX]))
        return QCameraImageCapture_CaptureDestination_PythonToCpp_QCameraImageCapture_CaptureDestination;
    return {};
}
static PyObject *QCameraImageCapture_CaptureDestination_CppToPython_QCameraImageCapture_CaptureDestination(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraImageCapture::CaptureDestination *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX], castCppIn);

}

static void QFlags_QCameraImageCapture_CaptureDestination__PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCameraImageCapture::CaptureDestination> *>(cppOut) =
        ::QFlags<QCameraImageCapture::CaptureDestination>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QCameraImageCapture_CaptureDestination__PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX]))
        return QFlags_QCameraImageCapture_CaptureDestination__PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination_;
    return {};
}
static PyObject *QFlags_QCameraImageCapture_CaptureDestination__CppToPython_QFlags_QCameraImageCapture_CaptureDestination_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QCameraImageCapture::CaptureDestination> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX]));

}

static void QCameraImageCapture_CaptureDestination_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCameraImageCapture::CaptureDestination> *>(cppOut) =
        ::QFlags<QCameraImageCapture::CaptureDestination>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QCameraImageCapture_CaptureDestination_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX]))
        return QCameraImageCapture_CaptureDestination_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination_;
    return {};
}
static void number_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QCameraImageCapture::CaptureDestination> *>(cppOut) =
        ::QFlags<QCameraImageCapture::CaptureDestination>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX]))
        return number_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCameraImageCapture_PythonToCpp_QCameraImageCapture_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCameraImageCapture_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCameraImageCapture_PythonToCpp_QCameraImageCapture_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCameraImageCapture_TypeF())))
        return QCameraImageCapture_PythonToCpp_QCameraImageCapture_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCameraImageCapture_PTR_CppToPython_QCameraImageCapture(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QCameraImageCapture *>(const_cast<void *>(cppIn)), Sbk_QCameraImageCapture_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCameraImageCapture_SignatureStrings[] = {
    "PySide2.QtMultimedia.QCameraImageCapture(self,mediaObject:PySide2.QtMultimedia.QMediaObject,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtMultimedia.QCameraImageCapture.availability(self)->PySide2.QtMultimedia.QMultimedia.AvailabilityStatus",
    "PySide2.QtMultimedia.QCameraImageCapture.bufferFormat(self)->PySide2.QtMultimedia.QVideoFrame.PixelFormat",
    "PySide2.QtMultimedia.QCameraImageCapture.cancelCapture(self)",
    "PySide2.QtMultimedia.QCameraImageCapture.capture(self,location:QString=QString())->int",
    "PySide2.QtMultimedia.QCameraImageCapture.captureDestination(self)->PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations",
    "PySide2.QtMultimedia.QCameraImageCapture.encodingSettings(self)->PySide2.QtMultimedia.QImageEncoderSettings",
    "PySide2.QtMultimedia.QCameraImageCapture.error(self)->PySide2.QtMultimedia.QCameraImageCapture.Error",
    "PySide2.QtMultimedia.QCameraImageCapture.errorString(self)->QString",
    "PySide2.QtMultimedia.QCameraImageCapture.imageCodecDescription(self,codecName:QString)->QString",
    "PySide2.QtMultimedia.QCameraImageCapture.isAvailable(self)->bool",
    "PySide2.QtMultimedia.QCameraImageCapture.isCaptureDestinationSupported(self,destination:PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations)->bool",
    "PySide2.QtMultimedia.QCameraImageCapture.isReadyForCapture(self)->bool",
    "PySide2.QtMultimedia.QCameraImageCapture.mediaObject(self)->PySide2.QtMultimedia.QMediaObject",
    "PySide2.QtMultimedia.QCameraImageCapture.setBufferFormat(self,format:PySide2.QtMultimedia.QVideoFrame.PixelFormat)",
    "PySide2.QtMultimedia.QCameraImageCapture.setCaptureDestination(self,destination:PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations)",
    "PySide2.QtMultimedia.QCameraImageCapture.setEncodingSettings(self,settings:PySide2.QtMultimedia.QImageEncoderSettings)",
    "PySide2.QtMultimedia.QCameraImageCapture.setMediaObject(self,arg__1:PySide2.QtMultimedia.QMediaObject)->bool",
    "PySide2.QtMultimedia.QCameraImageCapture.supportedBufferFormats(self)->QList[PySide2.QtMultimedia.QVideoFrame.PixelFormat]",
    "PySide2.QtMultimedia.QCameraImageCapture.supportedImageCodecs(self)->QStringList",
    nullptr}; // Sentinel

void init_QCameraImageCapture(PyObject *module)
{
    PyObject *Sbk_QCameraImageCapture_Type_bases = PyTuple_Pack(2,
        reinterpret_cast<PyObject *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        reinterpret_cast<PyObject *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIABINDABLEINTERFACE_IDX]));

    _Sbk_QCameraImageCapture_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCameraImageCapture",
        "QCameraImageCapture*",
        &Sbk_QCameraImageCapture_spec,
        &Shiboken::callCppDestructor< ::QCameraImageCapture >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        Sbk_QCameraImageCapture_Type_bases,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCameraImageCapture_Type);
    InitSignatureStrings(pyType, QCameraImageCapture_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCameraImageCapture_Type), Sbk_QCameraImageCapture_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCameraImageCapture_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCameraImageCapture_TypeF(),
        QCameraImageCapture_PythonToCpp_QCameraImageCapture_PTR,
        is_QCameraImageCapture_PythonToCpp_QCameraImageCapture_PTR_Convertible,
        QCameraImageCapture_PTR_CppToPython_QCameraImageCapture);

    Shiboken::Conversions::registerConverterName(converter, "QCameraImageCapture");
    Shiboken::Conversions::registerConverterName(converter, "QCameraImageCapture*");
    Shiboken::Conversions::registerConverterName(converter, "QCameraImageCapture&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraImageCapture).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraImageCaptureWrapper).name());


    MultipleInheritanceInitFunction func = Sbk_QCameraImageCapture_mi_init;
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QCameraImageCapture_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QCameraImageCapture_TypeF(), &Sbk_QCameraImageCaptureSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QCameraImageCapture_TypeF(), &Sbk_QCameraImageCapture_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraImageCapture_TypeF(),
        "Error",
        "2:PySide2.QtMultimedia.QCameraImageCapture.Error",
        "QCameraImageCapture::Error");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX],
        Sbk_QCameraImageCapture_TypeF(), "NoError", (long) QCameraImageCapture::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX],
        Sbk_QCameraImageCapture_TypeF(), "NotReadyError", (long) QCameraImageCapture::Error::NotReadyError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX],
        Sbk_QCameraImageCapture_TypeF(), "ResourceError", (long) QCameraImageCapture::Error::ResourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX],
        Sbk_QCameraImageCapture_TypeF(), "OutOfSpaceError", (long) QCameraImageCapture::Error::OutOfSpaceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX],
        Sbk_QCameraImageCapture_TypeF(), "NotSupportedFeatureError", (long) QCameraImageCapture::Error::NotSupportedFeatureError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX],
        Sbk_QCameraImageCapture_TypeF(), "FormatError", (long) QCameraImageCapture::Error::FormatError))
        return;
    // Register converter for enum 'QCameraImageCapture::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX],
            QCameraImageCapture_Error_CppToPython_QCameraImageCapture_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraImageCapture_Error_PythonToCpp_QCameraImageCapture_Error,
            is_QCameraImageCapture_Error_PythonToCpp_QCameraImageCapture_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraImageCapture::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    // Initialization of enum 'DriveMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_DRIVEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraImageCapture_TypeF(),
        "DriveMode",
        "2:PySide2.QtMultimedia.QCameraImageCapture.DriveMode",
        "QCameraImageCapture::DriveMode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_DRIVEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_DRIVEMODE_IDX],
        Sbk_QCameraImageCapture_TypeF(), "SingleImageCapture", (long) QCameraImageCapture::DriveMode::SingleImageCapture))
        return;
    // Register converter for enum 'QCameraImageCapture::DriveMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_DRIVEMODE_IDX],
            QCameraImageCapture_DriveMode_CppToPython_QCameraImageCapture_DriveMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraImageCapture_DriveMode_PythonToCpp_QCameraImageCapture_DriveMode,
            is_QCameraImageCapture_DriveMode_PythonToCpp_QCameraImageCapture_DriveMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_DRIVEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraImageCapture::DriveMode");
        Shiboken::Conversions::registerConverterName(converter, "DriveMode");
    }
    // End of 'DriveMode' enum.

    // Initialization of enum 'CaptureDestination'.
    SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX] = PySide::QFlags::create("2:PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations", SbkPySide2_QtMultimedia_QCameraImageCapture_CaptureDestination_number_slots);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraImageCapture_TypeF(),
        "CaptureDestination",
        "2:PySide2.QtMultimedia.QCameraImageCapture.CaptureDestination",
        "QCameraImageCapture::CaptureDestination",
        SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX]);
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX],
        Sbk_QCameraImageCapture_TypeF(), "CaptureToFile", (long) QCameraImageCapture::CaptureDestination::CaptureToFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX],
        Sbk_QCameraImageCapture_TypeF(), "CaptureToBuffer", (long) QCameraImageCapture::CaptureDestination::CaptureToBuffer))
        return;
    // Register converter for enum 'QCameraImageCapture::CaptureDestination'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX],
            QCameraImageCapture_CaptureDestination_CppToPython_QCameraImageCapture_CaptureDestination);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraImageCapture_CaptureDestination_PythonToCpp_QCameraImageCapture_CaptureDestination,
            is_QCameraImageCapture_CaptureDestination_PythonToCpp_QCameraImageCapture_CaptureDestination_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraImageCapture::CaptureDestination");
        Shiboken::Conversions::registerConverterName(converter, "CaptureDestination");
    }
    // Register converter for flag 'QFlags<QCameraImageCapture::CaptureDestination>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX],
            QFlags_QCameraImageCapture_CaptureDestination__CppToPython_QFlags_QCameraImageCapture_CaptureDestination_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraImageCapture_CaptureDestination_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination_,
            is_QCameraImageCapture_CaptureDestination_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QCameraImageCapture_CaptureDestination__PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination_,
            is_QFlags_QCameraImageCapture_CaptureDestination__PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination_,
            is_number_PythonToCpp_QFlags_QCameraImageCapture_CaptureDestination__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAIMAGECAPTURE_CAPTUREDESTINATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraImageCapture::CaptureDestinations");
        Shiboken::Conversions::registerConverterName(converter, "CaptureDestinations");
    }
    // End of 'CaptureDestination' enum/flags.

    PySide::Signal::registerSignals(Sbk_QCameraImageCapture_TypeF(), &::QCameraImageCapture::staticMetaObject);
    qRegisterMetaType< ::QCameraImageCapture::Error >("QCameraImageCapture::Error");
    qRegisterMetaType< ::QCameraImageCapture::DriveMode >("QCameraImageCapture::DriveMode");
    qRegisterMetaType< ::QCameraImageCapture::CaptureDestination >("QCameraImageCapture::CaptureDestination");
    qRegisterMetaType< ::QCameraImageCapture::CaptureDestinations >("QCameraImageCapture::CaptureDestinations");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QCameraImageCapture_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QCameraImageCapture_TypeF(), &::QCameraImageCapture::staticMetaObject, sizeof(QCameraImageCaptureWrapper));
}
