/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qcameraimageprocessing_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QCameraImageProcessingWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QCameraImageProcessingWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraImageProcessingWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCameraImageProcessingWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraImageProcessingWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QCameraImageProcessingWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageProcessing.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QCameraImageProcessingWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageProcessing.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QCameraImageProcessingWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QCameraImageProcessingWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QCameraImageProcessing::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QCameraImageProcessingWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QCameraImageProcessing::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QCameraImageProcessingWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QCameraImageProcessingWrapper *>(this));
        return QCameraImageProcessing::qt_metacast(_clname);
}

QCameraImageProcessingWrapper::~QCameraImageProcessingWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QCameraImageProcessingFunc_brightness(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.brightness";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brightness()const
            qreal cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->brightness();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageProcessingFunc_colorFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.colorFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorFilter()const
            QCameraImageProcessing::ColorFilter cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->colorFilter();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageProcessingFunc_contrast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.contrast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contrast()const
            qreal cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->contrast();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageProcessingFunc_denoisingLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.denoisingLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // denoisingLevel()const
            qreal cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->denoisingLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageProcessingFunc_isAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.isAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAvailable()const
            bool cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->isAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageProcessingFunc_isColorFilterSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.isColorFilterSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::isColorFilterSupported(QCameraImageProcessing::ColorFilter)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isColorFilterSupported(QCameraImageProcessing::ColorFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_isColorFilterSupported_TypeError;

    // Call function/method
    {
        ::QCameraImageProcessing::ColorFilter cppArg0{QCameraImageProcessing::ColorFilterNone};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isColorFilterSupported(QCameraImageProcessing::ColorFilter)const
            bool cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->isColorFilterSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraImageProcessingFunc_isColorFilterSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_isWhiteBalanceModeSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.isWhiteBalanceModeSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::isWhiteBalanceModeSupported(QCameraImageProcessing::WhiteBalanceMode)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isWhiteBalanceModeSupported(QCameraImageProcessing::WhiteBalanceMode)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_isWhiteBalanceModeSupported_TypeError;

    // Call function/method
    {
        ::QCameraImageProcessing::WhiteBalanceMode cppArg0{QCameraImageProcessing::WhiteBalanceAuto};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isWhiteBalanceModeSupported(QCameraImageProcessing::WhiteBalanceMode)const
            bool cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->isWhiteBalanceModeSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraImageProcessingFunc_isWhiteBalanceModeSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_manualWhiteBalance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.manualWhiteBalance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // manualWhiteBalance()const
            qreal cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->manualWhiteBalance();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageProcessingFunc_saturation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.saturation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // saturation()const
            qreal cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->saturation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageProcessingFunc_setBrightness(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.setBrightness";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::setBrightness(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBrightness(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_setBrightness_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBrightness(qreal)
            cppSelf->setBrightness(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageProcessingFunc_setBrightness_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_setColorFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.setColorFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::setColorFilter(QCameraImageProcessing::ColorFilter)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setColorFilter(QCameraImageProcessing::ColorFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_setColorFilter_TypeError;

    // Call function/method
    {
        ::QCameraImageProcessing::ColorFilter cppArg0{QCameraImageProcessing::ColorFilterNone};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorFilter(QCameraImageProcessing::ColorFilter)
            cppSelf->setColorFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageProcessingFunc_setColorFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_setContrast(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.setContrast";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::setContrast(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setContrast(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_setContrast_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setContrast(qreal)
            cppSelf->setContrast(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageProcessingFunc_setContrast_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_setDenoisingLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.setDenoisingLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::setDenoisingLevel(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setDenoisingLevel(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_setDenoisingLevel_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDenoisingLevel(qreal)
            cppSelf->setDenoisingLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageProcessingFunc_setDenoisingLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_setManualWhiteBalance(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.setManualWhiteBalance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::setManualWhiteBalance(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setManualWhiteBalance(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_setManualWhiteBalance_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setManualWhiteBalance(qreal)
            cppSelf->setManualWhiteBalance(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageProcessingFunc_setManualWhiteBalance_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_setSaturation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.setSaturation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::setSaturation(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setSaturation(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_setSaturation_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSaturation(qreal)
            cppSelf->setSaturation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageProcessingFunc_setSaturation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_setSharpeningLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.setSharpeningLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::setSharpeningLevel(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setSharpeningLevel(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_setSharpeningLevel_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSharpeningLevel(qreal)
            cppSelf->setSharpeningLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageProcessingFunc_setSharpeningLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_setWhiteBalanceMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.setWhiteBalanceMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessing::setWhiteBalanceMode(QCameraImageProcessing::WhiteBalanceMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setWhiteBalanceMode(QCameraImageProcessing::WhiteBalanceMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingFunc_setWhiteBalanceMode_TypeError;

    // Call function/method
    {
        ::QCameraImageProcessing::WhiteBalanceMode cppArg0{QCameraImageProcessing::WhiteBalanceAuto};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWhiteBalanceMode(QCameraImageProcessing::WhiteBalanceMode)
            cppSelf->setWhiteBalanceMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageProcessingFunc_setWhiteBalanceMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingFunc_sharpeningLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.sharpeningLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sharpeningLevel()const
            qreal cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->sharpeningLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraImageProcessingFunc_whiteBalanceMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessing.whiteBalanceMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // whiteBalanceMode()const
            QCameraImageProcessing::WhiteBalanceMode cppResult = const_cast<const ::QCameraImageProcessing *>(cppSelf)->whiteBalanceMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCameraImageProcessing_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCameraImageProcessing_methods[] = {
    {"brightness", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_brightness), METH_NOARGS},
    {"colorFilter", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_colorFilter), METH_NOARGS},
    {"contrast", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_contrast), METH_NOARGS},
    {"denoisingLevel", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_denoisingLevel), METH_NOARGS},
    {"isAvailable", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_isAvailable), METH_NOARGS},
    {"isColorFilterSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_isColorFilterSupported), METH_O},
    {"isWhiteBalanceModeSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_isWhiteBalanceModeSupported), METH_O},
    {"manualWhiteBalance", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_manualWhiteBalance), METH_NOARGS},
    {"saturation", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_saturation), METH_NOARGS},
    {"setBrightness", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_setBrightness), METH_O},
    {"setColorFilter", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_setColorFilter), METH_O},
    {"setContrast", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_setContrast), METH_O},
    {"setDenoisingLevel", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_setDenoisingLevel), METH_O},
    {"setManualWhiteBalance", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_setManualWhiteBalance), METH_O},
    {"setSaturation", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_setSaturation), METH_O},
    {"setSharpeningLevel", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_setSharpeningLevel), METH_O},
    {"setWhiteBalanceMode", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_setWhiteBalanceMode), METH_O},
    {"sharpeningLevel", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_sharpeningLevel), METH_NOARGS},
    {"whiteBalanceMode", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingFunc_whiteBalanceMode), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCameraImageProcessing_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QCameraImageProcessing *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QCameraImageProcessingWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QCameraImageProcessing_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCameraImageProcessing_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCameraImageProcessing_Type = nullptr;
static SbkObjectType *Sbk_QCameraImageProcessing_TypeF(void)
{
    return _Sbk_QCameraImageProcessing_Type;
}

static PyType_Slot Sbk_QCameraImageProcessing_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QCameraImageProcessing_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCameraImageProcessing_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCameraImageProcessing_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCameraImageProcessing_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCameraImageProcessing_spec = {
    "2:PySide2.QtMultimedia.QCameraImageProcessing",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCameraImageProcessing_slots
};

} //extern "C"

static void *Sbk_QCameraImageProcessing_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QCameraImageProcessing *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QCameraImageProcessing_WhiteBalanceMode_PythonToCpp_QCameraImageProcessing_WhiteBalanceMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraImageProcessing::WhiteBalanceMode *>(cppOut) =
        static_cast<::QCameraImageProcessing::WhiteBalanceMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraImageProcessing_WhiteBalanceMode_PythonToCpp_QCameraImageProcessing_WhiteBalanceMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX]))
        return QCameraImageProcessing_WhiteBalanceMode_PythonToCpp_QCameraImageProcessing_WhiteBalanceMode;
    return {};
}
static PyObject *QCameraImageProcessing_WhiteBalanceMode_CppToPython_QCameraImageProcessing_WhiteBalanceMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraImageProcessing::WhiteBalanceMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX], castCppIn);

}

static void QCameraImageProcessing_ColorFilter_PythonToCpp_QCameraImageProcessing_ColorFilter(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraImageProcessing::ColorFilter *>(cppOut) =
        static_cast<::QCameraImageProcessing::ColorFilter>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraImageProcessing_ColorFilter_PythonToCpp_QCameraImageProcessing_ColorFilter_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX]))
        return QCameraImageProcessing_ColorFilter_PythonToCpp_QCameraImageProcessing_ColorFilter;
    return {};
}
static PyObject *QCameraImageProcessing_ColorFilter_CppToPython_QCameraImageProcessing_ColorFilter(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraImageProcessing::ColorFilter *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCameraImageProcessing_PythonToCpp_QCameraImageProcessing_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCameraImageProcessing_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCameraImageProcessing_PythonToCpp_QCameraImageProcessing_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCameraImageProcessing_TypeF())))
        return QCameraImageProcessing_PythonToCpp_QCameraImageProcessing_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCameraImageProcessing_PTR_CppToPython_QCameraImageProcessing(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QCameraImageProcessing *>(const_cast<void *>(cppIn)), Sbk_QCameraImageProcessing_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCameraImageProcessing_SignatureStrings[] = {
    "PySide2.QtMultimedia.QCameraImageProcessing.brightness(self)->qreal",
    "PySide2.QtMultimedia.QCameraImageProcessing.colorFilter(self)->PySide2.QtMultimedia.QCameraImageProcessing.ColorFilter",
    "PySide2.QtMultimedia.QCameraImageProcessing.contrast(self)->qreal",
    "PySide2.QtMultimedia.QCameraImageProcessing.denoisingLevel(self)->qreal",
    "PySide2.QtMultimedia.QCameraImageProcessing.isAvailable(self)->bool",
    "PySide2.QtMultimedia.QCameraImageProcessing.isColorFilterSupported(self,filter:PySide2.QtMultimedia.QCameraImageProcessing.ColorFilter)->bool",
    "PySide2.QtMultimedia.QCameraImageProcessing.isWhiteBalanceModeSupported(self,mode:PySide2.QtMultimedia.QCameraImageProcessing.WhiteBalanceMode)->bool",
    "PySide2.QtMultimedia.QCameraImageProcessing.manualWhiteBalance(self)->qreal",
    "PySide2.QtMultimedia.QCameraImageProcessing.saturation(self)->qreal",
    "PySide2.QtMultimedia.QCameraImageProcessing.setBrightness(self,value:qreal)",
    "PySide2.QtMultimedia.QCameraImageProcessing.setColorFilter(self,filter:PySide2.QtMultimedia.QCameraImageProcessing.ColorFilter)",
    "PySide2.QtMultimedia.QCameraImageProcessing.setContrast(self,value:qreal)",
    "PySide2.QtMultimedia.QCameraImageProcessing.setDenoisingLevel(self,value:qreal)",
    "PySide2.QtMultimedia.QCameraImageProcessing.setManualWhiteBalance(self,colorTemperature:qreal)",
    "PySide2.QtMultimedia.QCameraImageProcessing.setSaturation(self,value:qreal)",
    "PySide2.QtMultimedia.QCameraImageProcessing.setSharpeningLevel(self,value:qreal)",
    "PySide2.QtMultimedia.QCameraImageProcessing.setWhiteBalanceMode(self,mode:PySide2.QtMultimedia.QCameraImageProcessing.WhiteBalanceMode)",
    "PySide2.QtMultimedia.QCameraImageProcessing.sharpeningLevel(self)->qreal",
    "PySide2.QtMultimedia.QCameraImageProcessing.whiteBalanceMode(self)->PySide2.QtMultimedia.QCameraImageProcessing.WhiteBalanceMode",
    nullptr}; // Sentinel

void init_QCameraImageProcessing(PyObject *module)
{
    _Sbk_QCameraImageProcessing_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCameraImageProcessing",
        "QCameraImageProcessing*",
        &Sbk_QCameraImageProcessing_spec,
        &Shiboken::callCppDestructor< ::QCameraImageProcessing >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCameraImageProcessing_Type);
    InitSignatureStrings(pyType, QCameraImageProcessing_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCameraImageProcessing_Type), Sbk_QCameraImageProcessing_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCameraImageProcessing_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCameraImageProcessing_TypeF(),
        QCameraImageProcessing_PythonToCpp_QCameraImageProcessing_PTR,
        is_QCameraImageProcessing_PythonToCpp_QCameraImageProcessing_PTR_Convertible,
        QCameraImageProcessing_PTR_CppToPython_QCameraImageProcessing);

    Shiboken::Conversions::registerConverterName(converter, "QCameraImageProcessing");
    Shiboken::Conversions::registerConverterName(converter, "QCameraImageProcessing*");
    Shiboken::Conversions::registerConverterName(converter, "QCameraImageProcessing&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraImageProcessing).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraImageProcessingWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QCameraImageProcessing_TypeF(), &Sbk_QCameraImageProcessing_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'WhiteBalanceMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraImageProcessing_TypeF(),
        "WhiteBalanceMode",
        "2:PySide2.QtMultimedia.QCameraImageProcessing.WhiteBalanceMode",
        "QCameraImageProcessing::WhiteBalanceMode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceAuto", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceAuto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceManual", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceManual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceSunlight", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceSunlight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceCloudy", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceCloudy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceShade", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceShade))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceTungsten", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceTungsten))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceFluorescent", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceFluorescent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceFlash", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceFlash))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceSunset", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceSunset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "WhiteBalanceVendor", (long) QCameraImageProcessing::WhiteBalanceMode::WhiteBalanceVendor))
        return;
    // Register converter for enum 'QCameraImageProcessing::WhiteBalanceMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX],
            QCameraImageProcessing_WhiteBalanceMode_CppToPython_QCameraImageProcessing_WhiteBalanceMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraImageProcessing_WhiteBalanceMode_PythonToCpp_QCameraImageProcessing_WhiteBalanceMode,
            is_QCameraImageProcessing_WhiteBalanceMode_PythonToCpp_QCameraImageProcessing_WhiteBalanceMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_WHITEBALANCEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraImageProcessing::WhiteBalanceMode");
        Shiboken::Conversions::registerConverterName(converter, "WhiteBalanceMode");
    }
    // End of 'WhiteBalanceMode' enum.

    // Initialization of enum 'ColorFilter'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraImageProcessing_TypeF(),
        "ColorFilter",
        "2:PySide2.QtMultimedia.QCameraImageProcessing.ColorFilter",
        "QCameraImageProcessing::ColorFilter");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterNone", (long) QCameraImageProcessing::ColorFilter::ColorFilterNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterGrayscale", (long) QCameraImageProcessing::ColorFilter::ColorFilterGrayscale))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterNegative", (long) QCameraImageProcessing::ColorFilter::ColorFilterNegative))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterSolarize", (long) QCameraImageProcessing::ColorFilter::ColorFilterSolarize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterSepia", (long) QCameraImageProcessing::ColorFilter::ColorFilterSepia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterPosterize", (long) QCameraImageProcessing::ColorFilter::ColorFilterPosterize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterWhiteboard", (long) QCameraImageProcessing::ColorFilter::ColorFilterWhiteboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterBlackboard", (long) QCameraImageProcessing::ColorFilter::ColorFilterBlackboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterAqua", (long) QCameraImageProcessing::ColorFilter::ColorFilterAqua))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
        Sbk_QCameraImageProcessing_TypeF(), "ColorFilterVendor", (long) QCameraImageProcessing::ColorFilter::ColorFilterVendor))
        return;
    // Register converter for enum 'QCameraImageProcessing::ColorFilter'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX],
            QCameraImageProcessing_ColorFilter_CppToPython_QCameraImageProcessing_ColorFilter);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraImageProcessing_ColorFilter_PythonToCpp_QCameraImageProcessing_ColorFilter,
            is_QCameraImageProcessing_ColorFilter_PythonToCpp_QCameraImageProcessing_ColorFilter_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_COLORFILTER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraImageProcessing::ColorFilter");
        Shiboken::Conversions::registerConverterName(converter, "ColorFilter");
    }
    // End of 'ColorFilter' enum.

    PySide::Signal::registerSignals(Sbk_QCameraImageProcessing_TypeF(), &::QCameraImageProcessing::staticMetaObject);
    qRegisterMetaType< ::QCameraImageProcessing::WhiteBalanceMode >("QCameraImageProcessing::WhiteBalanceMode");
    qRegisterMetaType< ::QCameraImageProcessing::ColorFilter >("QCameraImageProcessing::ColorFilter");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QCameraImageProcessing_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QCameraImageProcessing_TypeF(), &::QCameraImageProcessing::staticMetaObject, sizeof(QCameraImageProcessingWrapper));
}
