/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qcameraimageprocessingcontrol_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QCameraImageProcessingControlWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QCameraImageProcessingControlWrapper::QCameraImageProcessingControlWrapper(::QObject * parent) : QCameraImageProcessingControl(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QCameraImageProcessingControlWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraImageProcessingControlWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCameraImageProcessingControlWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraImageProcessingControlWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QCameraImageProcessingControlWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageProcessingControl.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QCameraImageProcessingControlWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageProcessingControl.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QCameraImageProcessingControlWrapper::isParameterSupported(::QCameraImageProcessingControl::ProcessingParameter arg__1) const
{
    if (m_PyMethodCache[6]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.isParameterSupported()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isParameterSupported";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.isParameterSupported()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageProcessingControl.isParameterSupported", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QCameraImageProcessingControlWrapper::isParameterValueSupported(::QCameraImageProcessingControl::ProcessingParameter parameter, const ::QVariant & value) const
{
    if (m_PyMethodCache[7]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.isParameterValueSupported()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isParameterValueSupported";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.isParameterValueSupported()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX])->converter, &parameter),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageProcessingControl.isParameterValueSupported", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QCameraImageProcessingControlWrapper::parameter(::QCameraImageProcessingControl::ProcessingParameter parameter) const
{
    if (m_PyMethodCache[9]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.parameter()' not implemented.");
        return ::QVariant();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "parameter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.parameter()' not implemented.");
        return ::QVariant();
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX])->converter, &parameter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraImageProcessingControl.parameter", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QCameraImageProcessingControlWrapper::setParameter(::QCameraImageProcessingControl::ProcessingParameter parameter, const ::QVariant & value)
{
    if (m_PyMethodCache[10]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.setParameter()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setParameter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.setParameter()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX])->converter, &parameter),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCameraImageProcessingControlWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[11]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QCameraImageProcessingControlWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QCameraImageProcessingControl::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QCameraImageProcessingControlWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QCameraImageProcessingControl::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QCameraImageProcessingControlWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QCameraImageProcessingControlWrapper *>(this));
        return QCameraImageProcessingControl::qt_metacast(_clname);
}

QCameraImageProcessingControlWrapper::~QCameraImageProcessingControlWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCameraImageProcessingControl_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QCameraImageProcessingControl' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCameraImageProcessingControl >()))
        return -1;

    ::QCameraImageProcessingControlWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessingControl.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QCameraImageProcessingControl", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCameraImageProcessingControl::QCameraImageProcessingControl(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QCameraImageProcessingControl(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QCameraImageProcessingControl(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingControl_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QCameraImageProcessingControl_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QCameraImageProcessingControl_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QCameraImageProcessingControl(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QCameraImageProcessingControlWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QCameraImageProcessingControlWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCameraImageProcessingControl >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCameraImageProcessingControl_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QCameraImageProcessingControl_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QCameraImageProcessingControl_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCameraImageProcessingControlFunc_isParameterSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessingControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessingControl.isParameterSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessingControl::isParameterSupported(QCameraImageProcessingControl::ProcessingParameter)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isParameterSupported(QCameraImageProcessingControl::ProcessingParameter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingControlFunc_isParameterSupported_TypeError;

    // Call function/method
    {
        ::QCameraImageProcessingControl::ProcessingParameter cppArg0{QCameraImageProcessingControl::WhiteBalancePreset};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isParameterSupported(QCameraImageProcessingControl::ProcessingParameter)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.isParameterSupported()' not implemented.");
                return {};
            }
            bool cppResult = const_cast<const ::QCameraImageProcessingControl *>(cppSelf)->isParameterSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraImageProcessingControlFunc_isParameterSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingControlFunc_isParameterValueSupported(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessingControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessingControl.isParameterValueSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isParameterValueSupported", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCameraImageProcessingControl::isParameterValueSupported(QCameraImageProcessingControl::ProcessingParameter,QVariant)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // isParameterValueSupported(QCameraImageProcessingControl::ProcessingParameter,QVariant)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingControlFunc_isParameterValueSupported_TypeError;

    // Call function/method
    {
        ::QCameraImageProcessingControl::ProcessingParameter cppArg0{QCameraImageProcessingControl::WhiteBalancePreset};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isParameterValueSupported(QCameraImageProcessingControl::ProcessingParameter,QVariant)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.isParameterValueSupported()' not implemented.");
                return {};
            }
            bool cppResult = const_cast<const ::QCameraImageProcessingControl *>(cppSelf)->isParameterValueSupported(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraImageProcessingControlFunc_isParameterValueSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingControlFunc_parameter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessingControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessingControl.parameter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraImageProcessingControl::parameter(QCameraImageProcessingControl::ProcessingParameter)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // parameter(QCameraImageProcessingControl::ProcessingParameter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingControlFunc_parameter_TypeError;

    // Call function/method
    {
        ::QCameraImageProcessingControl::ProcessingParameter cppArg0{QCameraImageProcessingControl::WhiteBalancePreset};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // parameter(QCameraImageProcessingControl::ProcessingParameter)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.parameter()' not implemented.");
                return {};
            }
            QVariant cppResult = const_cast<const ::QCameraImageProcessingControl *>(cppSelf)->parameter(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraImageProcessingControlFunc_parameter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraImageProcessingControlFunc_setParameter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraImageProcessingControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraImageProcessingControl.setParameter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setParameter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCameraImageProcessingControl::setParameter(QCameraImageProcessingControl::ProcessingParameter,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setParameter(QCameraImageProcessingControl::ProcessingParameter,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraImageProcessingControlFunc_setParameter_TypeError;

    // Call function/method
    {
        ::QCameraImageProcessingControl::ProcessingParameter cppArg0{QCameraImageProcessingControl::WhiteBalancePreset};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setParameter(QCameraImageProcessingControl::ProcessingParameter,QVariant)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QCameraImageProcessingControl.setParameter()' not implemented.");
                return {};
            }
            cppSelf->setParameter(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraImageProcessingControlFunc_setParameter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QCameraImageProcessingControl_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCameraImageProcessingControl_methods[] = {
    {"isParameterSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingControlFunc_isParameterSupported), METH_O},
    {"isParameterValueSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingControlFunc_isParameterValueSupported), METH_VARARGS},
    {"parameter", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingControlFunc_parameter), METH_O},
    {"setParameter", reinterpret_cast<PyCFunction>(Sbk_QCameraImageProcessingControlFunc_setParameter), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCameraImageProcessingControl_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QCameraImageProcessingControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QCameraImageProcessingControlWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QCameraImageProcessingControl_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCameraImageProcessingControl_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCameraImageProcessingControl_Type = nullptr;
static SbkObjectType *Sbk_QCameraImageProcessingControl_TypeF(void)
{
    return _Sbk_QCameraImageProcessingControl_Type;
}

static PyType_Slot Sbk_QCameraImageProcessingControl_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QCameraImageProcessingControl_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCameraImageProcessingControl_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCameraImageProcessingControl_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCameraImageProcessingControl_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCameraImageProcessingControl_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCameraImageProcessingControl_spec = {
    "2:PySide2.QtMultimedia.QCameraImageProcessingControl",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCameraImageProcessingControl_slots
};

} //extern "C"

static void *Sbk_QCameraImageProcessingControl_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QCameraImageProcessingControl *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QCameraImageProcessingControl_ProcessingParameter_PythonToCpp_QCameraImageProcessingControl_ProcessingParameter(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraImageProcessingControl::ProcessingParameter *>(cppOut) =
        static_cast<::QCameraImageProcessingControl::ProcessingParameter>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraImageProcessingControl_ProcessingParameter_PythonToCpp_QCameraImageProcessingControl_ProcessingParameter_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX]))
        return QCameraImageProcessingControl_ProcessingParameter_PythonToCpp_QCameraImageProcessingControl_ProcessingParameter;
    return {};
}
static PyObject *QCameraImageProcessingControl_ProcessingParameter_CppToPython_QCameraImageProcessingControl_ProcessingParameter(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraImageProcessingControl::ProcessingParameter *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCameraImageProcessingControl_PythonToCpp_QCameraImageProcessingControl_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCameraImageProcessingControl_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCameraImageProcessingControl_PythonToCpp_QCameraImageProcessingControl_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCameraImageProcessingControl_TypeF())))
        return QCameraImageProcessingControl_PythonToCpp_QCameraImageProcessingControl_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCameraImageProcessingControl_PTR_CppToPython_QCameraImageProcessingControl(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QCameraImageProcessingControl *>(const_cast<void *>(cppIn)), Sbk_QCameraImageProcessingControl_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCameraImageProcessingControl_SignatureStrings[] = {
    "PySide2.QtMultimedia.QCameraImageProcessingControl(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtMultimedia.QCameraImageProcessingControl.isParameterSupported(self,arg__1:PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter)->bool",
    "PySide2.QtMultimedia.QCameraImageProcessingControl.isParameterValueSupported(self,parameter:PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter,value:QVariant)->bool",
    "PySide2.QtMultimedia.QCameraImageProcessingControl.parameter(self,parameter:PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter)->QVariant",
    "PySide2.QtMultimedia.QCameraImageProcessingControl.setParameter(self,parameter:PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter,value:QVariant)",
    nullptr}; // Sentinel

void init_QCameraImageProcessingControl(PyObject *module)
{
    _Sbk_QCameraImageProcessingControl_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCameraImageProcessingControl",
        "QCameraImageProcessingControl*",
        &Sbk_QCameraImageProcessingControl_spec,
        &Shiboken::callCppDestructor< ::QCameraImageProcessingControl >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTROL_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCameraImageProcessingControl_Type);
    InitSignatureStrings(pyType, QCameraImageProcessingControl_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCameraImageProcessingControl_Type), Sbk_QCameraImageProcessingControl_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCameraImageProcessingControl_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCameraImageProcessingControl_TypeF(),
        QCameraImageProcessingControl_PythonToCpp_QCameraImageProcessingControl_PTR,
        is_QCameraImageProcessingControl_PythonToCpp_QCameraImageProcessingControl_PTR_Convertible,
        QCameraImageProcessingControl_PTR_CppToPython_QCameraImageProcessingControl);

    Shiboken::Conversions::registerConverterName(converter, "QCameraImageProcessingControl");
    Shiboken::Conversions::registerConverterName(converter, "QCameraImageProcessingControl*");
    Shiboken::Conversions::registerConverterName(converter, "QCameraImageProcessingControl&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraImageProcessingControl).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraImageProcessingControlWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QCameraImageProcessingControl_TypeF(), &Sbk_QCameraImageProcessingControl_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ProcessingParameter'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraImageProcessingControl_TypeF(),
        "ProcessingParameter",
        "2:PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter",
        "QCameraImageProcessingControl::ProcessingParameter");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "WhiteBalancePreset", (long) QCameraImageProcessingControl::ProcessingParameter::WhiteBalancePreset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "ColorTemperature", (long) QCameraImageProcessingControl::ProcessingParameter::ColorTemperature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "Contrast", (long) QCameraImageProcessingControl::ProcessingParameter::Contrast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "Saturation", (long) QCameraImageProcessingControl::ProcessingParameter::Saturation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "Brightness", (long) QCameraImageProcessingControl::ProcessingParameter::Brightness))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "Sharpening", (long) QCameraImageProcessingControl::ProcessingParameter::Sharpening))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "Denoising", (long) QCameraImageProcessingControl::ProcessingParameter::Denoising))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "ContrastAdjustment", (long) QCameraImageProcessingControl::ProcessingParameter::ContrastAdjustment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "SaturationAdjustment", (long) QCameraImageProcessingControl::ProcessingParameter::SaturationAdjustment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "BrightnessAdjustment", (long) QCameraImageProcessingControl::ProcessingParameter::BrightnessAdjustment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "SharpeningAdjustment", (long) QCameraImageProcessingControl::ProcessingParameter::SharpeningAdjustment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "DenoisingAdjustment", (long) QCameraImageProcessingControl::ProcessingParameter::DenoisingAdjustment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "ColorFilter", (long) QCameraImageProcessingControl::ProcessingParameter::ColorFilter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
        Sbk_QCameraImageProcessingControl_TypeF(), "ExtendedParameter", (long) QCameraImageProcessingControl::ProcessingParameter::ExtendedParameter))
        return;
    // Register converter for enum 'QCameraImageProcessingControl::ProcessingParameter'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX],
            QCameraImageProcessingControl_ProcessingParameter_CppToPython_QCameraImageProcessingControl_ProcessingParameter);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraImageProcessingControl_ProcessingParameter_PythonToCpp_QCameraImageProcessingControl_ProcessingParameter,
            is_QCameraImageProcessingControl_ProcessingParameter_PythonToCpp_QCameraImageProcessingControl_ProcessingParameter_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSINGCONTROL_PROCESSINGPARAMETER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraImageProcessingControl::ProcessingParameter");
        Shiboken::Conversions::registerConverterName(converter, "ProcessingParameter");
    }
    // End of 'ProcessingParameter' enum.

    qRegisterMetaType< ::QCameraImageProcessingControl::ProcessingParameter >("QCameraImageProcessingControl::ProcessingParameter");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QCameraImageProcessingControl_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QCameraImageProcessingControl_TypeF(), &::QCameraImageProcessingControl::staticMetaObject, sizeof(QCameraImageProcessingControlWrapper));
}
