/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qcameraviewfindersettings_wrapper.h"

// inner classes

// Extra includes
#include <QtMultimedia/qcameraviewfindersettings.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCameraViewfinderSettings_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCameraViewfinderSettings >()))
        return -1;

    ::QCameraViewfinderSettings *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCameraViewfinderSettings", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCameraViewfinderSettings::QCameraViewfinderSettings()
    // 1: QCameraViewfinderSettings::QCameraViewfinderSettings(QCameraViewfinderSettings)
    if (numArgs == 0) {
        overloadId = 0; // QCameraViewfinderSettings()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCameraViewfinderSettings(QCameraViewfinderSettings)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraViewfinderSettings_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCameraViewfinderSettings()
        {

            if (!PyErr_Occurred()) {
                // QCameraViewfinderSettings()
                cptr = new ::QCameraViewfinderSettings();
            }
            break;
        }
        case 1: // QCameraViewfinderSettings(const QCameraViewfinderSettings & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCameraViewfinderSettings cppArg0_local;
            ::QCameraViewfinderSettings *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCameraViewfinderSettings(QCameraViewfinderSettings)
                cptr = new ::QCameraViewfinderSettings(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCameraViewfinderSettings >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCameraViewfinderSettings_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCameraViewfinderSettings_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QCameraViewfinderSettings *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_maximumFrameRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.maximumFrameRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumFrameRate()const
            qreal cppResult = const_cast<const ::QCameraViewfinderSettings *>(cppSelf)->maximumFrameRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_minimumFrameRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.minimumFrameRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumFrameRate()const
            qreal cppResult = const_cast<const ::QCameraViewfinderSettings *>(cppSelf)->minimumFrameRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_pixelAspectRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.pixelAspectRatio";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelAspectRatio()const
            QSize cppResult = const_cast<const ::QCameraViewfinderSettings *>(cppSelf)->pixelAspectRatio();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_pixelFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.pixelFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelFormat()const
            QVideoFrame::PixelFormat cppResult = const_cast<const ::QCameraViewfinderSettings *>(cppSelf)->pixelFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_resolution(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.resolution";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resolution()const
            QSize cppResult = const_cast<const ::QCameraViewfinderSettings *>(cppSelf)->resolution();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_setMaximumFrameRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.setMaximumFrameRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraViewfinderSettings::setMaximumFrameRate(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMaximumFrameRate(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraViewfinderSettingsFunc_setMaximumFrameRate_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumFrameRate(qreal)
            cppSelf->setMaximumFrameRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraViewfinderSettingsFunc_setMaximumFrameRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_setMinimumFrameRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.setMinimumFrameRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraViewfinderSettings::setMinimumFrameRate(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMinimumFrameRate(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraViewfinderSettingsFunc_setMinimumFrameRate_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinimumFrameRate(qreal)
            cppSelf->setMinimumFrameRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraViewfinderSettingsFunc_setMinimumFrameRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_setPixelAspectRatio(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.setPixelAspectRatio";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPixelAspectRatio", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCameraViewfinderSettings::setPixelAspectRatio(QSize)
    // 1: QCameraViewfinderSettings::setPixelAspectRatio(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // setPixelAspectRatio(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setPixelAspectRatio(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraViewfinderSettingsFunc_setPixelAspectRatio_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPixelAspectRatio(const QSize & ratio)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setPixelAspectRatio(QSize)
                cppSelf->setPixelAspectRatio(*cppArg0);
            }
            break;
        }
        case 1: // setPixelAspectRatio(int horizontal, int vertical)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setPixelAspectRatio(int,int)
                cppSelf->setPixelAspectRatio(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraViewfinderSettingsFunc_setPixelAspectRatio_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_setPixelFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.setPixelFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraViewfinderSettings::setPixelFormat(QVideoFrame::PixelFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPixelFormat(QVideoFrame::PixelFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraViewfinderSettingsFunc_setPixelFormat_TypeError;

    // Call function/method
    {
        ::QVideoFrame::PixelFormat cppArg0{QVideoFrame::Format_Invalid};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPixelFormat(QVideoFrame::PixelFormat)
            cppSelf->setPixelFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraViewfinderSettingsFunc_setPixelFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_setResolution(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.setResolution";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setResolution", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCameraViewfinderSettings::setResolution(QSize)
    // 1: QCameraViewfinderSettings::setResolution(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // setResolution(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setResolution(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraViewfinderSettingsFunc_setResolution_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setResolution(const QSize & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setResolution(QSize)
                cppSelf->setResolution(*cppArg0);
            }
            break;
        }
        case 1: // setResolution(int width, int height)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setResolution(int,int)
                cppSelf->setResolution(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraViewfinderSettingsFunc_setResolution_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraViewfinderSettingsFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraViewfinderSettings.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraViewfinderSettings::swap(QCameraViewfinderSettings&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QCameraViewfinderSettings&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraViewfinderSettingsFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCameraViewfinderSettings cppArg0_local;
        ::QCameraViewfinderSettings *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QCameraViewfinderSettings&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraViewfinderSettingsFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraViewfinderSettings___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCameraViewfinderSettings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCameraViewfinderSettings_methods[] = {
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_isNull), METH_NOARGS},
    {"maximumFrameRate", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_maximumFrameRate), METH_NOARGS},
    {"minimumFrameRate", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_minimumFrameRate), METH_NOARGS},
    {"pixelAspectRatio", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_pixelAspectRatio), METH_NOARGS},
    {"pixelFormat", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_pixelFormat), METH_NOARGS},
    {"resolution", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_resolution), METH_NOARGS},
    {"setMaximumFrameRate", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_setMaximumFrameRate), METH_O},
    {"setMinimumFrameRate", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_setMinimumFrameRate), METH_O},
    {"setPixelAspectRatio", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_setPixelAspectRatio), METH_VARARGS},
    {"setPixelFormat", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_setPixelFormat), METH_O},
    {"setResolution", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_setResolution), METH_VARARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettingsFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCameraViewfinderSettings___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCameraViewfinderSettings___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QCameraViewfinderSettings_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArg)))) {
                // operator!=(const QCameraViewfinderSettings & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCameraViewfinderSettings cppArg0_local;
                ::QCameraViewfinderSettings *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QCameraViewfinderSettings_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QCameraViewfinderSettings_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QCameraViewfinderSettings_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCameraViewfinderSettings_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCameraViewfinderSettings_Type = nullptr;
static SbkObjectType *Sbk_QCameraViewfinderSettings_TypeF(void)
{
    return _Sbk_QCameraViewfinderSettings_Type;
}

static PyType_Slot Sbk_QCameraViewfinderSettings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCameraViewfinderSettings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCameraViewfinderSettings_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QCameraViewfinderSettings_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCameraViewfinderSettings_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCameraViewfinderSettings_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QCameraViewfinderSettings___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QCameraViewfinderSettings___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QCameraViewfinderSettings_spec = {
    "2:PySide2.QtMultimedia.QCameraViewfinderSettings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCameraViewfinderSettings_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCameraViewfinderSettings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCameraViewfinderSettings_TypeF())))
        return QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCameraViewfinderSettings_PTR_CppToPython_QCameraViewfinderSettings(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCameraViewfinderSettings *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCameraViewfinderSettings_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QCameraViewfinderSettings_COPY_CppToPython_QCameraViewfinderSettings(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCameraViewfinderSettings_TypeF(), new ::QCameraViewfinderSettings(*reinterpret_cast<const ::QCameraViewfinderSettings *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraViewfinderSettings *>(cppOut) = *reinterpret_cast< ::QCameraViewfinderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCameraViewfinderSettings_TypeF())))
        return QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCameraViewfinderSettings_SignatureStrings[] = {
    "1:PySide2.QtMultimedia.QCameraViewfinderSettings(self)",
    "0:PySide2.QtMultimedia.QCameraViewfinderSettings(self,other:PySide2.QtMultimedia.QCameraViewfinderSettings)",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.isNull(self)->bool",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.maximumFrameRate(self)->qreal",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.minimumFrameRate(self)->qreal",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.pixelAspectRatio(self)->PySide2.QtCore.QSize",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.pixelFormat(self)->PySide2.QtMultimedia.QVideoFrame.PixelFormat",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.resolution(self)->PySide2.QtCore.QSize",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.setMaximumFrameRate(self,rate:qreal)",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.setMinimumFrameRate(self,rate:qreal)",
    "1:PySide2.QtMultimedia.QCameraViewfinderSettings.setPixelAspectRatio(self,ratio:PySide2.QtCore.QSize)",
    "0:PySide2.QtMultimedia.QCameraViewfinderSettings.setPixelAspectRatio(self,horizontal:int,vertical:int)",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.setPixelFormat(self,format:PySide2.QtMultimedia.QVideoFrame.PixelFormat)",
    "1:PySide2.QtMultimedia.QCameraViewfinderSettings.setResolution(self,arg__1:PySide2.QtCore.QSize)",
    "0:PySide2.QtMultimedia.QCameraViewfinderSettings.setResolution(self,width:int,height:int)",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.swap(self,other:PySide2.QtMultimedia.QCameraViewfinderSettings)",
    "PySide2.QtMultimedia.QCameraViewfinderSettings.__copy__()",
    nullptr}; // Sentinel

void init_QCameraViewfinderSettings(PyObject *module)
{
    _Sbk_QCameraViewfinderSettings_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCameraViewfinderSettings",
        "QCameraViewfinderSettings",
        &Sbk_QCameraViewfinderSettings_spec,
        &Shiboken::callCppDestructor< ::QCameraViewfinderSettings >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCameraViewfinderSettings_Type);
    InitSignatureStrings(pyType, QCameraViewfinderSettings_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCameraViewfinderSettings_Type), Sbk_QCameraViewfinderSettings_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCameraViewfinderSettings_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCameraViewfinderSettings_TypeF(),
        QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_PTR,
        is_QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_PTR_Convertible,
        QCameraViewfinderSettings_PTR_CppToPython_QCameraViewfinderSettings,
        QCameraViewfinderSettings_COPY_CppToPython_QCameraViewfinderSettings);

    Shiboken::Conversions::registerConverterName(converter, "QCameraViewfinderSettings");
    Shiboken::Conversions::registerConverterName(converter, "QCameraViewfinderSettings*");
    Shiboken::Conversions::registerConverterName(converter, "QCameraViewfinderSettings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraViewfinderSettings).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_COPY,
        is_QCameraViewfinderSettings_PythonToCpp_QCameraViewfinderSettings_COPY_Convertible);

    qRegisterMetaType< ::QCameraViewfinderSettings >("QCameraViewfinderSettings");
}
