/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qmediacontent_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtMultimedia/qmediacontent.h>
#include <QtMultimedia/qmediaplaylist.h>
#include <QtMultimedia/qmediaresource.h>
#include <QtNetwork/qnetworkrequest.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMediaContent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMediaContent >()))
        return -1;

    ::QMediaContent *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaContent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMediaContent_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QMediaContent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QMediaContent::QMediaContent()
    // 1: QMediaContent::QMediaContent(QMediaPlaylist*,QUrl,bool)
    // 2: QMediaContent::QMediaContent(QList<QMediaResource>)
    // 3: QMediaContent::QMediaContent(QMediaContent)
    // 4: QMediaContent::QMediaContent(QMediaResource)
    // 5: QMediaContent::QMediaContent(QNetworkRequest)
    // 6: QMediaContent::QMediaContent(QUrl)
    if (numArgs == 0) {
        overloadId = 0; // QMediaContent()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 6; // QMediaContent(QUrl)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArgs[0])))) {
        overloadId = 5; // QMediaContent(QNetworkRequest)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARESOURCE_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QMediaContent(QMediaResource)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIARESOURCE_IDX], (pyArgs[0])))) {
        overloadId = 2; // QMediaContent(QList<QMediaResource>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYLIST_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QMediaContent(QMediaPlaylist*,QUrl,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // QMediaContent(QMediaPlaylist*,QUrl,bool)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
                overloadId = 1; // QMediaContent(QMediaPlaylist*,QUrl,bool)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QMediaContent(QMediaContent)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaContent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMediaContent()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMediaContent_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QMediaContent()
                cptr = new ::QMediaContent();
            }
            break;
        }
        case 1: // QMediaContent(QMediaPlaylist * playlist, const QUrl & contentUrl, bool takeOwnership)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_contentUrl = Shiboken::String::createStaticString("contentUrl");
                if (PyDict_Contains(kwds, key_contentUrl)) {
                    value = PyDict_GetItem(kwds, key_contentUrl);
                    if (value && pyArgs[1]) {
                        errInfo = key_contentUrl;
                        Py_INCREF(errInfo);
                        goto Sbk_QMediaContent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                            goto Sbk_QMediaContent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_contentUrl);
                }
                static PyObject *const key_takeOwnership = Shiboken::String::createStaticString("takeOwnership");
                if (PyDict_Contains(kwds, key_takeOwnership)) {
                    value = PyDict_GetItem(kwds, key_takeOwnership);
                    if (value && pyArgs[2]) {
                        errInfo = key_takeOwnership;
                        Py_INCREF(errInfo);
                        goto Sbk_QMediaContent_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))
                            goto Sbk_QMediaContent_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_takeOwnership);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QMediaContent_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMediaPlaylist *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QUrl cppArg1_local = QUrl();
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }
            bool cppArg2 = false;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QMediaContent(QMediaPlaylist*,QUrl,bool)
                cptr = new ::QMediaContent(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 2: // QMediaContent(const QList<QMediaResource > & resources)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMediaContent_Init_TypeError;
            }
            ::QList<QMediaResource > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QMediaContent(QList<QMediaResource>)
                cptr = new ::QMediaContent(cppArg0);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QMediaContent.QMediaContent(const QList<QMediaResource > & resources) is deprecated", 1);
            break;
        }
        case 3: // QMediaContent(const QMediaContent & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMediaContent_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMediaContent cppArg0_local;
            ::QMediaContent *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMediaContent(QMediaContent)
                cptr = new ::QMediaContent(*cppArg0);
            }
            break;
        }
        case 4: // QMediaContent(const QMediaResource & contentResource)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMediaContent_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMediaResource cppArg0_local;
            ::QMediaResource *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARESOURCE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMediaContent(QMediaResource)
                cptr = new ::QMediaContent(*cppArg0);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QMediaContent.QMediaContent(const QMediaResource & contentResource) is deprecated", 1);
            break;
        }
        case 5: // QMediaContent(const QNetworkRequest & contentRequest)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMediaContent_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMediaContent(QNetworkRequest)
                cptr = new ::QMediaContent(*cppArg0);
            }
            break;
        }
        case 6: // QMediaContent(const QUrl & contentUrl)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QMediaContent_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMediaContent(QUrl)
                cptr = new ::QMediaContent(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMediaContent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMediaContent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMediaContent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMediaContentFunc_canonicalRequest(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaContent.canonicalRequest";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canonicalRequest()const
            QNetworkRequest cppResult = const_cast<const ::QMediaContent *>(cppSelf)->canonicalRequest();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaContentFunc_canonicalResource(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaContent.canonicalResource";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canonicalResource()const
            QMediaResource cppResult = const_cast<const ::QMediaContent *>(cppSelf)->canonicalResource();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARESOURCE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaContentFunc_canonicalUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaContent.canonicalUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canonicalUrl()const
            QUrl cppResult = const_cast<const ::QMediaContent *>(cppSelf)->canonicalUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaContentFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaContent.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QMediaContent *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaContentFunc_playlist(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaContent.playlist";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // playlist()const
            QMediaPlaylist * cppResult = const_cast<const ::QMediaContent *>(cppSelf)->playlist();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYLIST_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaContentFunc_request(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaContent.request";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // request()const
            QNetworkRequest cppResult = const_cast<const ::QMediaContent *>(cppSelf)->request();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaContentFunc_resources(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaContent.resources";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resources()const
            QList<QMediaResource > cppResult = const_cast<const ::QMediaContent *>(cppSelf)->resources();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIARESOURCE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaContent___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMediaContent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMediaContent_methods[] = {
    {"canonicalRequest", reinterpret_cast<PyCFunction>(Sbk_QMediaContentFunc_canonicalRequest), METH_NOARGS},
    {"canonicalResource", reinterpret_cast<PyCFunction>(Sbk_QMediaContentFunc_canonicalResource), METH_NOARGS},
    {"canonicalUrl", reinterpret_cast<PyCFunction>(Sbk_QMediaContentFunc_canonicalUrl), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QMediaContentFunc_isNull), METH_NOARGS},
    {"playlist", reinterpret_cast<PyCFunction>(Sbk_QMediaContentFunc_playlist), METH_NOARGS},
    {"request", reinterpret_cast<PyCFunction>(Sbk_QMediaContentFunc_request), METH_NOARGS},
    {"resources", reinterpret_cast<PyCFunction>(Sbk_QMediaContentFunc_resources), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMediaContent___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QMediaContent___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QMediaContent_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), (pyArg)))) {
                // operator!=(const QMediaContent & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMediaContent cppArg0_local;
                ::QMediaContent *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), (pyArg)))) {
                // operator==(const QMediaContent & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMediaContent cppArg0_local;
                ::QMediaContent *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QMediaContent_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QMediaContent_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QMediaContent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMediaContent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMediaContent_Type = nullptr;
static SbkObjectType *Sbk_QMediaContent_TypeF(void)
{
    return _Sbk_QMediaContent_Type;
}

static PyType_Slot Sbk_QMediaContent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMediaContent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMediaContent_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QMediaContent_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMediaContent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMediaContent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QMediaContent___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QMediaContent___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QMediaContent_spec = {
    "2:PySide2.QtMultimedia.QMediaContent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMediaContent_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMediaContent_PythonToCpp_QMediaContent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMediaContent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMediaContent_PythonToCpp_QMediaContent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaContent_TypeF())))
        return QMediaContent_PythonToCpp_QMediaContent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMediaContent_PTR_CppToPython_QMediaContent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMediaContent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMediaContent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMediaContent_COPY_CppToPython_QMediaContent(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMediaContent_TypeF(), new ::QMediaContent(*reinterpret_cast<const ::QMediaContent *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMediaContent_PythonToCpp_QMediaContent_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaContent *>(cppOut) = *reinterpret_cast< ::QMediaContent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMediaContent_PythonToCpp_QMediaContent_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaContent_TypeF())))
        return QMediaContent_PythonToCpp_QMediaContent_COPY;
    return {};
}

// Implicit conversions.
static void QMediaPlaylistPTR_PythonToCpp_QMediaContent(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaContent *>(cppOut) = ::QMediaContent(reinterpret_cast< ::QMediaPlaylist *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYLIST_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_QMediaPlaylistPTR_PythonToCpp_QMediaContent_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYLIST_IDX], pyIn))
        return QMediaPlaylistPTR_PythonToCpp_QMediaContent;
    return {};
}

static void _constQList_QMediaResource_REF_PythonToCpp_QMediaContent(PyObject *pyIn, void *cppOut) {
    ::QList<QMediaResource > cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIARESOURCE_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QMediaContent *>(cppOut) = ::QMediaContent(cppIn);
}
static PythonToCppFunc is__constQList_QMediaResource_REF_PythonToCpp_QMediaContent_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARESOURCE_IDX]), pyIn))
        return _constQList_QMediaResource_REF_PythonToCpp_QMediaContent;
    return {};
}

static void constQMediaResourceREF_PythonToCpp_QMediaContent(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaContent *>(cppOut) = ::QMediaContent( *reinterpret_cast< ::QMediaResource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARESOURCE_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQMediaResourceREF_PythonToCpp_QMediaContent_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARESOURCE_IDX], pyIn))
        return constQMediaResourceREF_PythonToCpp_QMediaContent;
    return {};
}

static void PySide2_QtNetwork_constQNetworkRequestREF_PythonToCpp_QMediaContent(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaContent *>(cppOut) = ::QMediaContent( *reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtNetwork_constQNetworkRequestREF_PythonToCpp_QMediaContent_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], pyIn))
        return PySide2_QtNetwork_constQNetworkRequestREF_PythonToCpp_QMediaContent;
    return {};
}

static void PySide2_QtCore_constQUrlREF_PythonToCpp_QMediaContent(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaContent *>(cppOut) = ::QMediaContent( *reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtCore_constQUrlREF_PythonToCpp_QMediaContent_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], pyIn))
        return PySide2_QtCore_constQUrlREF_PythonToCpp_QMediaContent;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMediaContent_SignatureStrings[] = {
    "6:PySide2.QtMultimedia.QMediaContent(self)",
    "5:PySide2.QtMultimedia.QMediaContent(self,playlist:PySide2.QtMultimedia.QMediaPlaylist,contentUrl:PySide2.QtCore.QUrl=QUrl(),takeOwnership:bool=false)",
    "4:PySide2.QtMultimedia.QMediaContent(self,resources:QList[PySide2.QtMultimedia.QMediaResource])",
    "3:PySide2.QtMultimedia.QMediaContent(self,other:PySide2.QtMultimedia.QMediaContent)",
    "2:PySide2.QtMultimedia.QMediaContent(self,contentResource:PySide2.QtMultimedia.QMediaResource)",
    "1:PySide2.QtMultimedia.QMediaContent(self,contentRequest:PySide2.QtNetwork.QNetworkRequest)",
    "0:PySide2.QtMultimedia.QMediaContent(self,contentUrl:PySide2.QtCore.QUrl)",
    "PySide2.QtMultimedia.QMediaContent.canonicalRequest(self)->PySide2.QtNetwork.QNetworkRequest",
    "PySide2.QtMultimedia.QMediaContent.canonicalResource(self)->PySide2.QtMultimedia.QMediaResource",
    "PySide2.QtMultimedia.QMediaContent.canonicalUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtMultimedia.QMediaContent.isNull(self)->bool",
    "PySide2.QtMultimedia.QMediaContent.playlist(self)->PySide2.QtMultimedia.QMediaPlaylist",
    "PySide2.QtMultimedia.QMediaContent.request(self)->PySide2.QtNetwork.QNetworkRequest",
    "PySide2.QtMultimedia.QMediaContent.resources(self)->QList[PySide2.QtMultimedia.QMediaResource]",
    "PySide2.QtMultimedia.QMediaContent.__copy__()",
    nullptr}; // Sentinel

void init_QMediaContent(PyObject *module)
{
    _Sbk_QMediaContent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMediaContent",
        "QMediaContent",
        &Sbk_QMediaContent_spec,
        &Shiboken::callCppDestructor< ::QMediaContent >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMediaContent_Type);
    InitSignatureStrings(pyType, QMediaContent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMediaContent_Type), Sbk_QMediaContent_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMediaContent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMediaContent_TypeF(),
        QMediaContent_PythonToCpp_QMediaContent_PTR,
        is_QMediaContent_PythonToCpp_QMediaContent_PTR_Convertible,
        QMediaContent_PTR_CppToPython_QMediaContent,
        QMediaContent_COPY_CppToPython_QMediaContent);

    Shiboken::Conversions::registerConverterName(converter, "QMediaContent");
    Shiboken::Conversions::registerConverterName(converter, "QMediaContent*");
    Shiboken::Conversions::registerConverterName(converter, "QMediaContent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaContent).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMediaContent_PythonToCpp_QMediaContent_COPY,
        is_QMediaContent_PythonToCpp_QMediaContent_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMediaPlaylistPTR_PythonToCpp_QMediaContent,
        is_QMediaPlaylistPTR_PythonToCpp_QMediaContent_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        _constQList_QMediaResource_REF_PythonToCpp_QMediaContent,
        is__constQList_QMediaResource_REF_PythonToCpp_QMediaContent_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQMediaResourceREF_PythonToCpp_QMediaContent,
        is_constQMediaResourceREF_PythonToCpp_QMediaContent_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtNetwork_constQNetworkRequestREF_PythonToCpp_QMediaContent,
        is_PySide2_QtNetwork_constQNetworkRequestREF_PythonToCpp_QMediaContent_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQUrlREF_PythonToCpp_QMediaContent,
        is_PySide2_QtCore_constQUrlREF_PythonToCpp_QMediaContent_Convertible);

    qRegisterMetaType< ::QMediaContent >("QMediaContent");
}
