/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qvideoencodersettings_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QtMultimedia/qmediaencodersettings.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QVideoEncoderSettings_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QVideoEncoderSettings >()))
        return -1;

    ::QVideoEncoderSettings *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVideoEncoderSettings", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QVideoEncoderSettings::QVideoEncoderSettings()
    // 1: QVideoEncoderSettings::QVideoEncoderSettings(QVideoEncoderSettings)
    if (numArgs == 0) {
        overloadId = 0; // QVideoEncoderSettings()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QVideoEncoderSettings(QVideoEncoderSettings)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettings_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QVideoEncoderSettings()
        {

            if (!PyErr_Occurred()) {
                // QVideoEncoderSettings()
                cptr = new ::QVideoEncoderSettings();
            }
            break;
        }
        case 1: // QVideoEncoderSettings(const QVideoEncoderSettings & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVideoEncoderSettings cppArg0_local;
            ::QVideoEncoderSettings *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QVideoEncoderSettings(QVideoEncoderSettings)
                cptr = new ::QVideoEncoderSettings(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QVideoEncoderSettings >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QVideoEncoderSettings_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QVideoEncoderSettings_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_bitRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.bitRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bitRate()const
            int cppResult = const_cast<const ::QVideoEncoderSettings *>(cppSelf)->bitRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_codec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.codec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // codec()const
            QString cppResult = const_cast<const ::QVideoEncoderSettings *>(cppSelf)->codec();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_encodingMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.encodingMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // encodingMode()const
            QMultimedia::EncodingMode cppResult = const_cast<const ::QVideoEncoderSettings *>(cppSelf)->encodingMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_encodingOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.encodingOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoEncoderSettings::encodingOption(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // encodingOption(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettingsFunc_encodingOption_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // encodingOption(QString)const
            QVariant cppResult = const_cast<const ::QVideoEncoderSettings *>(cppSelf)->encodingOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVideoEncoderSettingsFunc_encodingOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_encodingOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.encodingOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // encodingOptions()const
            QMap<QString,QVariant > cppResult = const_cast<const ::QVideoEncoderSettings *>(cppSelf)->encodingOptions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_frameRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.frameRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // frameRate()const
            qreal cppResult = const_cast<const ::QVideoEncoderSettings *>(cppSelf)->frameRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QVideoEncoderSettings *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_quality(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.quality";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quality()const
            QMultimedia::EncodingQuality cppResult = const_cast<const ::QVideoEncoderSettings *>(cppSelf)->quality();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_resolution(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.resolution";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resolution()const
            QSize cppResult = const_cast<const ::QVideoEncoderSettings *>(cppSelf)->resolution();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_setBitRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.setBitRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoEncoderSettings::setBitRate(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBitRate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettingsFunc_setBitRate_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBitRate(int)
            cppSelf->setBitRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoEncoderSettingsFunc_setBitRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_setCodec(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.setCodec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoEncoderSettings::setCodec(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCodec(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettingsFunc_setCodec_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCodec(QString)
            cppSelf->setCodec(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoEncoderSettingsFunc_setCodec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_setEncodingMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.setEncodingMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoEncoderSettings::setEncodingMode(QMultimedia::EncodingMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setEncodingMode(QMultimedia::EncodingMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettingsFunc_setEncodingMode_TypeError;

    // Call function/method
    {
        ::QMultimedia::EncodingMode cppArg0{QMultimedia::ConstantQualityEncoding};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEncodingMode(QMultimedia::EncodingMode)
            cppSelf->setEncodingMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoEncoderSettingsFunc_setEncodingMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_setEncodingOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.setEncodingOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setEncodingOption", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QVideoEncoderSettings::setEncodingOption(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setEncodingOption(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettingsFunc_setEncodingOption_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setEncodingOption(QString,QVariant)
            cppSelf->setEncodingOption(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoEncoderSettingsFunc_setEncodingOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_setEncodingOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.setEncodingOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoEncoderSettings::setEncodingOptions(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setEncodingOptions(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettingsFunc_setEncodingOptions_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEncodingOptions(QMap<QString,QVariant>)
            cppSelf->setEncodingOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoEncoderSettingsFunc_setEncodingOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_setFrameRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.setFrameRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoEncoderSettings::setFrameRate(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setFrameRate(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettingsFunc_setFrameRate_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFrameRate(qreal)
            cppSelf->setFrameRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoEncoderSettingsFunc_setFrameRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_setQuality(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.setQuality";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoEncoderSettings::setQuality(QMultimedia::EncodingQuality)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setQuality(QMultimedia::EncodingQuality)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettingsFunc_setQuality_TypeError;

    // Call function/method
    {
        ::QMultimedia::EncodingQuality cppArg0{QMultimedia::VeryLowQuality};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQuality(QMultimedia::EncodingQuality)
            cppSelf->setQuality(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoEncoderSettingsFunc_setQuality_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoEncoderSettingsFunc_setResolution(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoEncoderSettings.setResolution";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setResolution", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QVideoEncoderSettings::setResolution(QSize)
    // 1: QVideoEncoderSettings::setResolution(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // setResolution(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setResolution(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoEncoderSettingsFunc_setResolution_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setResolution(const QSize & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setResolution(QSize)
                cppSelf->setResolution(*cppArg0);
            }
            break;
        }
        case 1: // setResolution(int width, int height)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setResolution(int,int)
                cppSelf->setResolution(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoEncoderSettingsFunc_setResolution_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoEncoderSettings___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QVideoEncoderSettings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QVideoEncoderSettings_methods[] = {
    {"bitRate", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_bitRate), METH_NOARGS},
    {"codec", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_codec), METH_NOARGS},
    {"encodingMode", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_encodingMode), METH_NOARGS},
    {"encodingOption", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_encodingOption), METH_O},
    {"encodingOptions", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_encodingOptions), METH_NOARGS},
    {"frameRate", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_frameRate), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_isNull), METH_NOARGS},
    {"quality", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_quality), METH_NOARGS},
    {"resolution", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_resolution), METH_NOARGS},
    {"setBitRate", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_setBitRate), METH_O},
    {"setCodec", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_setCodec), METH_O},
    {"setEncodingMode", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_setEncodingMode), METH_O},
    {"setEncodingOption", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_setEncodingOption), METH_VARARGS},
    {"setEncodingOptions", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_setEncodingOptions), METH_O},
    {"setFrameRate", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_setFrameRate), METH_O},
    {"setQuality", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_setQuality), METH_O},
    {"setResolution", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettingsFunc_setResolution), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QVideoEncoderSettings___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QVideoEncoderSettings___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QVideoEncoderSettings_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), (pyArg)))) {
                // operator!=(const QVideoEncoderSettings & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVideoEncoderSettings cppArg0_local;
                ::QVideoEncoderSettings *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), (pyArg)))) {
                // operator==(const QVideoEncoderSettings & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVideoEncoderSettings cppArg0_local;
                ::QVideoEncoderSettings *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QVideoEncoderSettings_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QVideoEncoderSettings_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QVideoEncoderSettings_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QVideoEncoderSettings_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QVideoEncoderSettings_Type = nullptr;
static SbkObjectType *Sbk_QVideoEncoderSettings_TypeF(void)
{
    return _Sbk_QVideoEncoderSettings_Type;
}

static PyType_Slot Sbk_QVideoEncoderSettings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QVideoEncoderSettings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QVideoEncoderSettings_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QVideoEncoderSettings_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QVideoEncoderSettings_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QVideoEncoderSettings_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QVideoEncoderSettings___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QVideoEncoderSettings___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QVideoEncoderSettings_spec = {
    "2:PySide2.QtMultimedia.QVideoEncoderSettings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QVideoEncoderSettings_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QVideoEncoderSettings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVideoEncoderSettings_TypeF())))
        return QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QVideoEncoderSettings_PTR_CppToPython_QVideoEncoderSettings(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QVideoEncoderSettings *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QVideoEncoderSettings_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QVideoEncoderSettings_COPY_CppToPython_QVideoEncoderSettings(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QVideoEncoderSettings_TypeF(), new ::QVideoEncoderSettings(*reinterpret_cast<const ::QVideoEncoderSettings *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVideoEncoderSettings *>(cppOut) = *reinterpret_cast< ::QVideoEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVideoEncoderSettings_TypeF())))
        return QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QVideoEncoderSettings_SignatureStrings[] = {
    "1:PySide2.QtMultimedia.QVideoEncoderSettings(self)",
    "0:PySide2.QtMultimedia.QVideoEncoderSettings(self,other:PySide2.QtMultimedia.QVideoEncoderSettings)",
    "PySide2.QtMultimedia.QVideoEncoderSettings.bitRate(self)->int",
    "PySide2.QtMultimedia.QVideoEncoderSettings.codec(self)->QString",
    "PySide2.QtMultimedia.QVideoEncoderSettings.encodingMode(self)->PySide2.QtMultimedia.QMultimedia.EncodingMode",
    "PySide2.QtMultimedia.QVideoEncoderSettings.encodingOption(self,option:QString)->QVariant",
    "PySide2.QtMultimedia.QVideoEncoderSettings.encodingOptions(self)->QMap[QString, QVariant]",
    "PySide2.QtMultimedia.QVideoEncoderSettings.frameRate(self)->qreal",
    "PySide2.QtMultimedia.QVideoEncoderSettings.isNull(self)->bool",
    "PySide2.QtMultimedia.QVideoEncoderSettings.quality(self)->PySide2.QtMultimedia.QMultimedia.EncodingQuality",
    "PySide2.QtMultimedia.QVideoEncoderSettings.resolution(self)->PySide2.QtCore.QSize",
    "PySide2.QtMultimedia.QVideoEncoderSettings.setBitRate(self,bitrate:int)",
    "PySide2.QtMultimedia.QVideoEncoderSettings.setCodec(self,arg__1:QString)",
    "PySide2.QtMultimedia.QVideoEncoderSettings.setEncodingMode(self,arg__1:PySide2.QtMultimedia.QMultimedia.EncodingMode)",
    "PySide2.QtMultimedia.QVideoEncoderSettings.setEncodingOption(self,option:QString,value:QVariant)",
    "PySide2.QtMultimedia.QVideoEncoderSettings.setEncodingOptions(self,options:QMap[QString, QVariant])",
    "PySide2.QtMultimedia.QVideoEncoderSettings.setFrameRate(self,rate:qreal)",
    "PySide2.QtMultimedia.QVideoEncoderSettings.setQuality(self,quality:PySide2.QtMultimedia.QMultimedia.EncodingQuality)",
    "1:PySide2.QtMultimedia.QVideoEncoderSettings.setResolution(self,arg__1:PySide2.QtCore.QSize)",
    "0:PySide2.QtMultimedia.QVideoEncoderSettings.setResolution(self,width:int,height:int)",
    "PySide2.QtMultimedia.QVideoEncoderSettings.__copy__()",
    nullptr}; // Sentinel

void init_QVideoEncoderSettings(PyObject *module)
{
    _Sbk_QVideoEncoderSettings_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QVideoEncoderSettings",
        "QVideoEncoderSettings",
        &Sbk_QVideoEncoderSettings_spec,
        &Shiboken::callCppDestructor< ::QVideoEncoderSettings >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QVideoEncoderSettings_Type);
    InitSignatureStrings(pyType, QVideoEncoderSettings_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QVideoEncoderSettings_Type), Sbk_QVideoEncoderSettings_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QVideoEncoderSettings_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QVideoEncoderSettings_TypeF(),
        QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_PTR,
        is_QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_PTR_Convertible,
        QVideoEncoderSettings_PTR_CppToPython_QVideoEncoderSettings,
        QVideoEncoderSettings_COPY_CppToPython_QVideoEncoderSettings);

    Shiboken::Conversions::registerConverterName(converter, "QVideoEncoderSettings");
    Shiboken::Conversions::registerConverterName(converter, "QVideoEncoderSettings*");
    Shiboken::Conversions::registerConverterName(converter, "QVideoEncoderSettings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QVideoEncoderSettings).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_COPY,
        is_QVideoEncoderSettings_PythonToCpp_QVideoEncoderSettings_COPY_Convertible);

    qRegisterMetaType< ::QVideoEncoderSettings >("QVideoEncoderSettings");
}
