/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qabstractsocket_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractSocketWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractSocketWrapper::QAbstractSocketWrapper(::QAbstractSocket::SocketType socketType, ::QObject * parent) : QAbstractSocket(socketType, parent)
{
    resetPyMethodCache();
    // ... middle
}

bool QAbstractSocketWrapper::atEnd() const
{
    if (m_PyMethodCache[0])
        return this->::QAbstractSocket::atEnd();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "atEnd";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QAbstractSocket::atEnd();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.atEnd", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QAbstractSocketWrapper::bytesAvailable() const
{
    if (m_PyMethodCache[1])
        return this->::QAbstractSocket::bytesAvailable();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesAvailable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QAbstractSocket::bytesAvailable();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.bytesAvailable", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QAbstractSocketWrapper::bytesToWrite() const
{
    if (m_PyMethodCache[2])
        return this->::QAbstractSocket::bytesToWrite();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesToWrite";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QAbstractSocket::bytesToWrite();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.bytesToWrite", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractSocketWrapper::canReadLine() const
{
    if (m_PyMethodCache[3])
        return this->::QAbstractSocket::canReadLine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "canReadLine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QAbstractSocket::canReadLine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.canReadLine", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSocketWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSocketWrapper::close()
{
    if (m_PyMethodCache[5]) {
        return this->::QAbstractSocket::close();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "close";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QAbstractSocket::close();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractSocketWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractSocketWrapper::connectToHost(const ::QHostAddress & address, quint16 port, ::QFlags<QIODevice::OpenModeFlag> mode)
{
    if (m_PyMethodCache[7]) {
        return this->::QAbstractSocket::connectToHost(address, port, mode);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectToHost";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QAbstractSocket::connectToHost(address, port, mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NHN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &address),
    port,
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractSocketWrapper::connectToHost(const ::QString & hostName, quint16 port, ::QFlags<QIODevice::OpenModeFlag> mode, ::QAbstractSocket::NetworkLayerProtocol protocol)
{
    if (m_PyMethodCache[8]) {
        return this->::QAbstractSocket::connectToHost(hostName, port, mode, protocol);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectToHost";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QAbstractSocket::connectToHost(hostName, port, mode, protocol);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NHNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &hostName),
    port,
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &mode),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX])->converter, &protocol)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractSocketWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSocketWrapper::disconnectFromHost()
{
    if (m_PyMethodCache[10]) {
        return this->::QAbstractSocket::disconnectFromHost();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectFromHost";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QAbstractSocket::disconnectFromHost();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractSocketWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[11]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstractSocketWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[12])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractSocketWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[13])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QAbstractSocketWrapper::isSequential() const
{
    if (m_PyMethodCache[14])
        return this->::QAbstractSocket::isSequential();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSequential";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QAbstractSocket::isSequential();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.isSequential", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractSocketWrapper::open(::QFlags<QIODevice::OpenModeFlag> mode)
{
    if (m_PyMethodCache[16])
        return this->::QIODevice::open(mode);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "open";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QIODevice::open(mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.open", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QAbstractSocketWrapper::pos() const
{
    if (m_PyMethodCache[17])
        return this->::QIODevice::pos();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "pos";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QIODevice::pos();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.pos", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QAbstractSocketWrapper::readData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[18]) {
        return this->::QAbstractSocket::readData(data, maxlen);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QAbstractSocket::readData(data, maxlen);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

qint64 QAbstractSocketWrapper::readLineData(char * data, qint64 maxlen)
{
    if (m_PyMethodCache[19]) {
        return this->::QAbstractSocket::readLineData(data, maxlen);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readLineData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QAbstractSocket::readLineData(data, maxlen);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

bool QAbstractSocketWrapper::reset()
{
    if (m_PyMethodCache[20])
        return this->::QIODevice::reset();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QIODevice::reset();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.reset", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSocketWrapper::resume()
{
    if (m_PyMethodCache[21]) {
        return this->::QAbstractSocket::resume();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resume";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QAbstractSocket::resume();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstractSocketWrapper::seek(qint64 pos)
{
    if (m_PyMethodCache[22])
        return this->::QIODevice::seek(pos);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "seek";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    pos
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.seek", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSocketWrapper::setReadBufferSize(qint64 size)
{
    if (m_PyMethodCache[23]) {
        return this->::QAbstractSocket::setReadBufferSize(size);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setReadBufferSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QAbstractSocket::setReadBufferSize(size);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    size
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstractSocketWrapper::setSocketDescriptor(::qintptr socketDescriptor, ::QAbstractSocket::SocketState state, ::QFlags<QIODevice::OpenModeFlag> openMode)
{
    if (m_PyMethodCache[24])
        return this->::QAbstractSocket::setSocketDescriptor(socketDescriptor, state, openMode);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setSocketDescriptor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QAbstractSocket::setSocketDescriptor(socketDescriptor, state, openMode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX], &socketDescriptor),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX])->converter, &state),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &openMode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.setSocketDescriptor", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSocketWrapper::setSocketOption(::QAbstractSocket::SocketOption option, const ::QVariant & value)
{
    if (m_PyMethodCache[25]) {
        return this->::QAbstractSocket::setSocketOption(option, value);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setSocketOption";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QAbstractSocket::setSocketOption(option, value);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX])->converter, &option),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

qint64 QAbstractSocketWrapper::size() const
{
    if (m_PyMethodCache[26])
        return this->::QIODevice::size();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QIODevice::size();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.size", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::qintptr QAbstractSocketWrapper::socketDescriptor() const
{
    if (m_PyMethodCache[27])
        return this->::QAbstractSocket::socketDescriptor();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::qintptr();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "socketDescriptor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QAbstractSocket::socketDescriptor();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::qintptr();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.socketDescriptor", "qintptr", Py_TYPE(pyResult)->tp_name);
        return ::qintptr();
    }
    ::qintptr cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QAbstractSocketWrapper::socketOption(::QAbstractSocket::SocketOption option)
{
    if (m_PyMethodCache[28])
        return this->::QAbstractSocket::socketOption(option);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "socketOption";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QAbstractSocket::socketOption(option);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX])->converter, &option)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.socketOption", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSocketWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[29]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractSocketWrapper::waitForBytesWritten(int msecs)
{
    if (m_PyMethodCache[30])
        return this->::QAbstractSocket::waitForBytesWritten(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForBytesWritten";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QAbstractSocket::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.waitForBytesWritten", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractSocketWrapper::waitForConnected(int msecs)
{
    if (m_PyMethodCache[31])
        return this->::QAbstractSocket::waitForConnected(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForConnected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[31] = true;
        return this->::QAbstractSocket::waitForConnected(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.waitForConnected", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractSocketWrapper::waitForDisconnected(int msecs)
{
    if (m_PyMethodCache[32])
        return this->::QAbstractSocket::waitForDisconnected(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForDisconnected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[32] = true;
        return this->::QAbstractSocket::waitForDisconnected(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.waitForDisconnected", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QAbstractSocketWrapper::waitForReadyRead(int msecs)
{
    if (m_PyMethodCache[33])
        return this->::QAbstractSocket::waitForReadyRead(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForReadyRead";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[33] = true;
        return this->::QAbstractSocket::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.waitForReadyRead", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QAbstractSocketWrapper::writeData(const char * data, qint64 len)
{
    if (m_PyMethodCache[34])
        return this->::QAbstractSocket::writeData(data, len);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "writeData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[34] = true;
        return this->::QAbstractSocket::writeData(data, len);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NL)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data),
    len
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSocket.writeData", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QAbstractSocketWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAbstractSocket::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractSocketWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAbstractSocket::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractSocketWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractSocketWrapper *>(this));
        return QAbstractSocket::qt_metacast(_clname);
}

QAbstractSocketWrapper::~QAbstractSocketWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractSocket_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractSocket >()))
        return -1;

    ::QAbstractSocketWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAbstractSocket", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractSocket::QAbstractSocket(QAbstractSocket::SocketType,QObject*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // QAbstractSocket(QAbstractSocket::SocketType,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocket_Init_TypeError;

    // Call function/method
    {
        ::QAbstractSocket::SocketType cppArg0{QAbstractSocket::TcpSocket};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QAbstractSocket(QAbstractSocket::SocketType,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QAbstractSocketWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QAbstractSocketWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractSocket >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractSocket_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAbstractSocket_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAbstractSocket_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractSocketFunc_abort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.abort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // abort()
            cppSelf->abort();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractSocketFunc_atEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.atEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atEnd()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSocket *>(cppSelf)->::QAbstractSocket::atEnd()
                : const_cast<const ::QAbstractSocket *>(cppSelf)->atEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_bind(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.bind";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractSocketFunc_bind_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:bind", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractSocket::bind(QHostAddress,quint16,QFlags<QAbstractSocket::BindFlag>)
    // 1: QAbstractSocket::bind(quint16,QFlags<QAbstractSocket::BindFlag>)
    if (numArgs == 0) {
        overloadId = 1; // bind(quint16,QFlags<QAbstractSocket::BindFlag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // bind(quint16,QFlags<QAbstractSocket::BindFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // bind(quint16,QFlags<QAbstractSocket::BindFlag>)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // bind(QHostAddress,quint16,QFlags<QAbstractSocket::BindFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // bind(QHostAddress,quint16,QFlags<QAbstractSocket::BindFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // bind(QHostAddress,quint16,QFlags<QAbstractSocket::BindFlag>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_bind_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // bind(const QHostAddress & address, quint16 port, QFlags<QAbstractSocket::BindFlag> mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_port = Shiboken::String::createStaticString("port");
                if (PyDict_Contains(kwds, key_port)) {
                    value = PyDict_GetItem(kwds, key_port);
                    if (value && pyArgs[1]) {
                        errInfo = key_port;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractSocketFunc_bind_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1]))))
                            goto Sbk_QAbstractSocketFunc_bind_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_port);
                }
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractSocketFunc_bind_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QAbstractSocketFunc_bind_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QAbstractSocketFunc_bind_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QHostAddress cppArg0_local;
            ::QHostAddress *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            quint16 cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QAbstractSocket::BindFlag> cppArg2 = QAbstractSocket::DefaultForPlatform;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // bind(QHostAddress,quint16,QFlags<QAbstractSocket::BindFlag>)
                bool cppResult = cppSelf->bind(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // bind(quint16 port, QFlags<QAbstractSocket::BindFlag> mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_port = Shiboken::String::createStaticString("port");
                if (PyDict_Contains(kwds, key_port)) {
                    value = PyDict_GetItem(kwds, key_port);
                    if (value && pyArgs[0]) {
                        errInfo = key_port;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractSocketFunc_bind_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[0]))))
                            goto Sbk_QAbstractSocketFunc_bind_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_port);
                }
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractSocketFunc_bind_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QAbstractSocketFunc_bind_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QAbstractSocketFunc_bind_TypeError;
                }
            }
            quint16 cppArg0 = 0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QAbstractSocket::BindFlag> cppArg1 = QAbstractSocket::DefaultForPlatform;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bind(quint16,QFlags<QAbstractSocket::BindFlag>)
                bool cppResult = cppSelf->bind(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_bind_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_bytesAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.bytesAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesAvailable()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSocket *>(cppSelf)->::QAbstractSocket::bytesAvailable()
                : const_cast<const ::QAbstractSocket *>(cppSelf)->bytesAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_bytesToWrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.bytesToWrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesToWrite()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSocket *>(cppSelf)->::QAbstractSocket::bytesToWrite()
                : const_cast<const ::QAbstractSocket *>(cppSelf)->bytesToWrite();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_canReadLine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.canReadLine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canReadLine()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSocket *>(cppSelf)->::QAbstractSocket::canReadLine()
                : const_cast<const ::QAbstractSocket *>(cppSelf)->canReadLine();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::close()
                : cppSelf->close();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractSocketFunc_connectToHost(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.connectToHost";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:connectToHost", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractSocket::connectToHost(QString,quint16,QFlags<QIODevice::OpenModeFlag>,QAbstractSocket::NetworkLayerProtocol)
    // 1: QAbstractSocket::connectToHost(QHostAddress,quint16,QFlags<QIODevice::OpenModeFlag>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // connectToHost(QHostAddress,quint16,QFlags<QIODevice::OpenModeFlag>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[2])))) {
            overloadId = 1; // connectToHost(QHostAddress,quint16,QFlags<QIODevice::OpenModeFlag>)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // connectToHost(QString,quint16,QFlags<QIODevice::OpenModeFlag>,QAbstractSocket::NetworkLayerProtocol)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // connectToHost(QString,quint16,QFlags<QIODevice::OpenModeFlag>,QAbstractSocket::NetworkLayerProtocol)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX])->converter, (pyArgs[3])))) {
                overloadId = 0; // connectToHost(QString,quint16,QFlags<QIODevice::OpenModeFlag>,QAbstractSocket::NetworkLayerProtocol)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // connectToHost(const QString & hostName, quint16 port, QFlags<QIODevice::OpenModeFlag> mode, QAbstractSocket::NetworkLayerProtocol protocol)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                static PyObject *const key_protocol = Shiboken::String::createStaticString("protocol");
                if (PyDict_Contains(kwds, key_protocol)) {
                    value = PyDict_GetItem(kwds, key_protocol);
                    if (value && pyArgs[3]) {
                        errInfo = key_protocol;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_protocol);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            quint16 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QIODevice::OpenModeFlag> cppArg2 = QIODevice::ReadWrite;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QAbstractSocket::NetworkLayerProtocol cppArg3 = QAbstractSocket::NetworkLayerProtocol::AnyIPProtocol;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // connectToHost(QString,quint16,QFlags<QIODevice::OpenModeFlag>,QAbstractSocket::NetworkLayerProtocol)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QAbstractSocket::connectToHost(cppArg0, cppArg1, cppArg2, cppArg3)
                    : cppSelf->connectToHost(cppArg0, cppArg1, cppArg2, cppArg3);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            }
            break;
        }
        case 1: // connectToHost(const QHostAddress & address, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[2]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QAbstractSocketFunc_connectToHost_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QHostAddress cppArg0_local;
            ::QHostAddress *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            quint16 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QIODevice::OpenModeFlag> cppArg2 = QIODevice::ReadWrite;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // connectToHost(QHostAddress,quint16,QFlags<QIODevice::OpenModeFlag>)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QAbstractSocket::connectToHost(*cppArg0, cppArg1, cppArg2)
                    : cppSelf->connectToHost(*cppArg0, cppArg1, cppArg2);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_connectToHost_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_disconnectFromHost(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.disconnectFromHost";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // disconnectFromHost()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::disconnectFromHost()
                : cppSelf->disconnectFromHost();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractSocketFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QAbstractSocket::SocketError cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_flush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.flush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flush()
            bool cppResult = cppSelf->flush();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_isSequential(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.isSequential";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSequential()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSocket *>(cppSelf)->::QAbstractSocket::isSequential()
                : const_cast<const ::QAbstractSocket *>(cppSelf)->isSequential();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_localAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.localAddress";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localAddress()const
            QHostAddress cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->localAddress();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_localPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.localPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localPort()const
            quint16 cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->localPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_pauseMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.pauseMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pauseMode()const
            QFlags<QAbstractSocket::PauseMode> cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->pauseMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_peerAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.peerAddress";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerAddress()const
            QHostAddress cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->peerAddress();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_peerName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.peerName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerName()const
            QString cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->peerName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_peerPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.peerPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerPort()const
            quint16 cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->peerPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_protocolTag(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.protocolTag";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // protocolTag()const
            QString cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->protocolTag();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_proxy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.proxy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // proxy()const
            QNetworkProxy cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->proxy();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_readBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.readBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readBufferSize()const
            qint64 cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->readBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_readData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.readData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::readData(char*,qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // readData(char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_readData_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readData(char*,qint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            QByteArray ba(1 + int(cppArg0), char(0));
            Py_BEGIN_ALLOW_THREADS
            (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::QAbstractSocket::readData(ba.data(), int(cppArg0)) : cppSelf->readData(ba.data(), int(cppArg0)));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::String::fromCString(ba.constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_readData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_readLineData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.readLineData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::readLineData(char*,qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // readLineData(char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_readLineData_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readLineData(char*,qint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            QByteArray ba(1 + int(cppArg0), char(0));
            Py_BEGIN_ALLOW_THREADS
            (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::QAbstractSocket::readLineData(ba.data(), int(cppArg0)) : cppSelf->readLineData(ba.data(), int(cppArg0)));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::String::fromCString(ba.constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_readLineData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.resume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resume()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::resume()
                : cppSelf->resume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractSocketFunc_setLocalAddress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setLocalAddress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setLocalAddress(QHostAddress)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArg)))) {
        overloadId = 0; // setLocalAddress(QHostAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setLocalAddress_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLocalAddress(QHostAddress)
            cppSelf->setLocalAddress(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setLocalAddress_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setLocalPort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setLocalPort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setLocalPort(quint16)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArg)))) {
        overloadId = 0; // setLocalPort(quint16)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setLocalPort_TypeError;

    // Call function/method
    {
        quint16 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLocalPort(quint16)
            cppSelf->setLocalPort(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setLocalPort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setPauseMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setPauseMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setPauseMode(QFlags<QAbstractSocket::PauseMode>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPauseMode(QFlags<QAbstractSocket::PauseMode>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setPauseMode_TypeError;

    // Call function/method
    {
        ::QFlags<QAbstractSocket::PauseMode> cppArg0 = QFlags<QAbstractSocket::PauseMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPauseMode(QFlags<QAbstractSocket::PauseMode>)
            cppSelf->setPauseMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setPauseMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setPeerAddress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setPeerAddress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setPeerAddress(QHostAddress)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArg)))) {
        overloadId = 0; // setPeerAddress(QHostAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setPeerAddress_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPeerAddress(QHostAddress)
            cppSelf->setPeerAddress(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setPeerAddress_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setPeerName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setPeerName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setPeerName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPeerName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setPeerName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPeerName(QString)
            cppSelf->setPeerName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setPeerName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setPeerPort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setPeerPort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setPeerPort(quint16)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArg)))) {
        overloadId = 0; // setPeerPort(quint16)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setPeerPort_TypeError;

    // Call function/method
    {
        quint16 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPeerPort(quint16)
            cppSelf->setPeerPort(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setPeerPort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setProtocolTag(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setProtocolTag";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setProtocolTag(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setProtocolTag(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setProtocolTag_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProtocolTag(QString)
            cppSelf->setProtocolTag(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setProtocolTag_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setProxy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setProxy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setProxy(QNetworkProxy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), (pyArg)))) {
        overloadId = 0; // setProxy(QNetworkProxy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setProxy_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxy cppArg0_local;
        ::QNetworkProxy *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setProxy(QNetworkProxy)
            cppSelf->setProxy(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setProxy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setReadBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setReadBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setReadBufferSize(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setReadBufferSize(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setReadBufferSize_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setReadBufferSize(qint64)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::setReadBufferSize(cppArg0)
                : cppSelf->setReadBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setReadBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setSocketDescriptor(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setSocketDescriptor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractSocketFunc_setSocketDescriptor_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractSocketFunc_setSocketDescriptor_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setSocketDescriptor", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractSocket::setSocketDescriptor(qintptr,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setSocketDescriptor(qintptr,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setSocketDescriptor(qintptr,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // setSocketDescriptor(qintptr,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setSocketDescriptor_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_state = Shiboken::String::createStaticString("state");
            if (PyDict_Contains(kwds, key_state)) {
                value = PyDict_GetItem(kwds, key_state);
                if (value && pyArgs[1]) {
                    errInfo = key_state;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractSocketFunc_setSocketDescriptor_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QAbstractSocketFunc_setSocketDescriptor_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_state);
            }
            static PyObject *const key_openMode = Shiboken::String::createStaticString("openMode");
            if (PyDict_Contains(kwds, key_openMode)) {
                value = PyDict_GetItem(kwds, key_openMode);
                if (value && pyArgs[2]) {
                    errInfo = key_openMode;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractSocketFunc_setSocketDescriptor_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QAbstractSocketFunc_setSocketDescriptor_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_openMode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractSocketFunc_setSocketDescriptor_TypeError;
            }
        }
        ::qintptr cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QAbstractSocket::SocketState cppArg1 = QAbstractSocket::SocketState::ConnectedState;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<QIODevice::OpenModeFlag> cppArg2 = QIODevice::ReadWrite;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setSocketDescriptor(qintptr,QAbstractSocket::SocketState,QFlags<QIODevice::OpenModeFlag>)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::setSocketDescriptor(cppArg0, cppArg1, cppArg2)
                : cppSelf->setSocketDescriptor(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_setSocketDescriptor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setSocketError(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setSocketError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setSocketError(QAbstractSocket::SocketError)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSocketError(QAbstractSocket::SocketError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setSocketError_TypeError;

    // Call function/method
    {
        ::QAbstractSocket::SocketError cppArg0{QAbstractSocket::ConnectionRefusedError};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSocketError(QAbstractSocket::SocketError)
            cppSelf->setSocketError(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setSocketError_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setSocketOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setSocketOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSocketOption", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractSocket::setSocketOption(QAbstractSocket::SocketOption,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setSocketOption(QAbstractSocket::SocketOption,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setSocketOption_TypeError;

    // Call function/method
    {
        ::QAbstractSocket::SocketOption cppArg0{QAbstractSocket::LowDelayOption};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setSocketOption(QAbstractSocket::SocketOption,QVariant)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::setSocketOption(cppArg0, cppArg1)
                : cppSelf->setSocketOption(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setSocketOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_setSocketState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.setSocketState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::setSocketState(QAbstractSocket::SocketState)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSocketState(QAbstractSocket::SocketState)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_setSocketState_TypeError;

    // Call function/method
    {
        ::QAbstractSocket::SocketState cppArg0{QAbstractSocket::UnconnectedState};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSocketState(QAbstractSocket::SocketState)
            cppSelf->setSocketState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSocketFunc_setSocketState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_socketDescriptor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.socketDescriptor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // socketDescriptor()const
            qintptr cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSocket *>(cppSelf)->::QAbstractSocket::socketDescriptor()
                : const_cast<const ::QAbstractSocket *>(cppSelf)->socketDescriptor();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_socketOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.socketOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSocket::socketOption(QAbstractSocket::SocketOption)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // socketOption(QAbstractSocket::SocketOption)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_socketOption_TypeError;

    // Call function/method
    {
        ::QAbstractSocket::SocketOption cppArg0{QAbstractSocket::LowDelayOption};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // socketOption(QAbstractSocket::SocketOption)
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::socketOption(cppArg0)
                : cppSelf->socketOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_socketOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_socketType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.socketType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // socketType()const
            QAbstractSocket::SocketType cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->socketType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QAbstractSocket::SocketState cppResult = const_cast<const ::QAbstractSocket *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSocketFunc_waitForBytesWritten(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.waitForBytesWritten";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractSocketFunc_waitForBytesWritten_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForBytesWritten", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::waitForBytesWritten(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForBytesWritten(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForBytesWritten(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_waitForBytesWritten_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractSocketFunc_waitForBytesWritten_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QAbstractSocketFunc_waitForBytesWritten_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractSocketFunc_waitForBytesWritten_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForBytesWritten(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::waitForBytesWritten(cppArg0)
                : cppSelf->waitForBytesWritten(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_waitForBytesWritten_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_waitForConnected(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.waitForConnected";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractSocketFunc_waitForConnected_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForConnected", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractSocket::waitForConnected(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForConnected(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForConnected(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_waitForConnected_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractSocketFunc_waitForConnected_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QAbstractSocketFunc_waitForConnected_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractSocketFunc_waitForConnected_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForConnected(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::waitForConnected(cppArg0)
                : cppSelf->waitForConnected(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_waitForConnected_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_waitForDisconnected(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.waitForDisconnected";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractSocketFunc_waitForDisconnected_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForDisconnected", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractSocket::waitForDisconnected(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForDisconnected(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForDisconnected(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_waitForDisconnected_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractSocketFunc_waitForDisconnected_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QAbstractSocketFunc_waitForDisconnected_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractSocketFunc_waitForDisconnected_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForDisconnected(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::waitForDisconnected(cppArg0)
                : cppSelf->waitForDisconnected(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_waitForDisconnected_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_waitForReadyRead(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.waitForReadyRead";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractSocketFunc_waitForReadyRead_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForReadyRead", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::waitForReadyRead(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForReadyRead(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForReadyRead(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_waitForReadyRead_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractSocketFunc_waitForReadyRead_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QAbstractSocketFunc_waitForReadyRead_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QAbstractSocketFunc_waitForReadyRead_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForReadyRead(int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::waitForReadyRead(cppArg0)
                : cppSelf->waitForReadyRead(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_waitForReadyRead_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSocketFunc_writeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAbstractSocket.writeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::writeData(const char*,qint64)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 0; // writeData(const char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSocketFunc_writeData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // writeData(const char*,qint64)
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSocket::writeData(cppArg0, cppArg1)
                : cppSelf->writeData(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSocketFunc_writeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QAbstractSocket_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractSocket_methods[] = {
    {"abort", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_abort), METH_NOARGS},
    {"atEnd", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_atEnd), METH_NOARGS},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_bind), METH_VARARGS|METH_KEYWORDS},
    {"bytesAvailable", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_bytesAvailable), METH_NOARGS},
    {"bytesToWrite", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_bytesToWrite), METH_NOARGS},
    {"canReadLine", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_canReadLine), METH_NOARGS},
    {"close", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_close), METH_NOARGS},
    {"connectToHost", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_connectToHost), METH_VARARGS|METH_KEYWORDS},
    {"disconnectFromHost", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_disconnectFromHost), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_error), METH_NOARGS},
    {"flush", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_flush), METH_NOARGS},
    {"isSequential", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_isSequential), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_isValid), METH_NOARGS},
    {"localAddress", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_localAddress), METH_NOARGS},
    {"localPort", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_localPort), METH_NOARGS},
    {"pauseMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_pauseMode), METH_NOARGS},
    {"peerAddress", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_peerAddress), METH_NOARGS},
    {"peerName", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_peerName), METH_NOARGS},
    {"peerPort", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_peerPort), METH_NOARGS},
    {"protocolTag", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_protocolTag), METH_NOARGS},
    {"proxy", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_proxy), METH_NOARGS},
    {"readBufferSize", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_readBufferSize), METH_NOARGS},
    {"readData", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_readData), METH_O},
    {"readLineData", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_readLineData), METH_O},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_resume), METH_NOARGS},
    {"setLocalAddress", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setLocalAddress), METH_O},
    {"setLocalPort", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setLocalPort), METH_O},
    {"setPauseMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setPauseMode), METH_O},
    {"setPeerAddress", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setPeerAddress), METH_O},
    {"setPeerName", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setPeerName), METH_O},
    {"setPeerPort", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setPeerPort), METH_O},
    {"setProtocolTag", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setProtocolTag), METH_O},
    {"setProxy", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setProxy), METH_O},
    {"setReadBufferSize", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setReadBufferSize), METH_O},
    {"setSocketDescriptor", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setSocketDescriptor), METH_VARARGS|METH_KEYWORDS},
    {"setSocketError", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setSocketError), METH_O},
    {"setSocketOption", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setSocketOption), METH_VARARGS},
    {"setSocketState", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_setSocketState), METH_O},
    {"socketDescriptor", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_socketDescriptor), METH_NOARGS},
    {"socketOption", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_socketOption), METH_O},
    {"socketType", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_socketType), METH_NOARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_state), METH_NOARGS},
    {"waitForBytesWritten", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_waitForBytesWritten), METH_VARARGS|METH_KEYWORDS},
    {"waitForConnected", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_waitForConnected), METH_VARARGS|METH_KEYWORDS},
    {"waitForDisconnected", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_waitForDisconnected), METH_VARARGS|METH_KEYWORDS},
    {"waitForReadyRead", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_waitForReadyRead), METH_VARARGS|METH_KEYWORDS},
    {"writeData", reinterpret_cast<PyCFunction>(Sbk_QAbstractSocketFunc_writeData), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractSocket_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractSocketWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAbstractSocket_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractSocket_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractSocket_Type = nullptr;
static SbkObjectType *Sbk_QAbstractSocket_TypeF(void)
{
    return _Sbk_QAbstractSocket_Type;
}

static PyType_Slot Sbk_QAbstractSocket_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractSocket_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractSocket_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractSocket_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractSocket_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractSocket_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractSocket_spec = {
    "2:PySide2.QtNetwork.QAbstractSocket",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractSocket_slots
};

} //extern "C"

static void *Sbk_QAbstractSocket_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QAbstractSocket *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtNetwork_QAbstractSocket_BindFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSocket::BindMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractSocket::BindMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::BindMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractSocket::BindMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::BindMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QAbstractSocket_BindFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSocket::BindMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractSocket::BindMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::BindMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractSocket::BindMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::BindMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QAbstractSocket_BindFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSocket::BindMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractSocket::BindMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::BindMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractSocket::BindMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::BindMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QAbstractSocket_BindFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSocket::BindMode cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, self, &cppSelf);
    ::QAbstractSocket::BindMode cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QAbstractSocket_BindFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QAbstractSocket_BindFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QAbstractSocket_BindFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_BindFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtNetwork_QAbstractSocket_PauseMode___and__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSocket::PauseModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractSocket::PauseModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::PauseModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractSocket::PauseModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::PauseModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QAbstractSocket_PauseMode___or__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSocket::PauseModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractSocket::PauseModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::PauseModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractSocket::PauseModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::PauseModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QAbstractSocket_PauseMode___xor__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSocket::PauseModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractSocket::PauseModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::PauseModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractSocket::PauseModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractSocket::PauseModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QAbstractSocket_PauseMode___invert__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSocket::PauseModes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, self, &cppSelf);
    ::QAbstractSocket::PauseModes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QAbstractSocket_PauseMode_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QAbstractSocket_PauseMode__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QAbstractSocket_PauseMode_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QAbstractSocket_PauseMode_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QAbstractSocket_SocketType_PythonToCpp_QAbstractSocket_SocketType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSocket::SocketType *>(cppOut) =
        static_cast<::QAbstractSocket::SocketType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSocket_SocketType_PythonToCpp_QAbstractSocket_SocketType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX]))
        return QAbstractSocket_SocketType_PythonToCpp_QAbstractSocket_SocketType;
    return {};
}
static PyObject *QAbstractSocket_SocketType_CppToPython_QAbstractSocket_SocketType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSocket::SocketType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX], castCppIn);

}

static void QAbstractSocket_NetworkLayerProtocol_PythonToCpp_QAbstractSocket_NetworkLayerProtocol(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSocket::NetworkLayerProtocol *>(cppOut) =
        static_cast<::QAbstractSocket::NetworkLayerProtocol>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSocket_NetworkLayerProtocol_PythonToCpp_QAbstractSocket_NetworkLayerProtocol_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX]))
        return QAbstractSocket_NetworkLayerProtocol_PythonToCpp_QAbstractSocket_NetworkLayerProtocol;
    return {};
}
static PyObject *QAbstractSocket_NetworkLayerProtocol_CppToPython_QAbstractSocket_NetworkLayerProtocol(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSocket::NetworkLayerProtocol *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX], castCppIn);

}

static void QAbstractSocket_SocketError_PythonToCpp_QAbstractSocket_SocketError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSocket::SocketError *>(cppOut) =
        static_cast<::QAbstractSocket::SocketError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSocket_SocketError_PythonToCpp_QAbstractSocket_SocketError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX]))
        return QAbstractSocket_SocketError_PythonToCpp_QAbstractSocket_SocketError;
    return {};
}
static PyObject *QAbstractSocket_SocketError_CppToPython_QAbstractSocket_SocketError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSocket::SocketError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX], castCppIn);

}

static void QAbstractSocket_SocketState_PythonToCpp_QAbstractSocket_SocketState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSocket::SocketState *>(cppOut) =
        static_cast<::QAbstractSocket::SocketState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSocket_SocketState_PythonToCpp_QAbstractSocket_SocketState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX]))
        return QAbstractSocket_SocketState_PythonToCpp_QAbstractSocket_SocketState;
    return {};
}
static PyObject *QAbstractSocket_SocketState_CppToPython_QAbstractSocket_SocketState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSocket::SocketState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX], castCppIn);

}

static void QAbstractSocket_SocketOption_PythonToCpp_QAbstractSocket_SocketOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSocket::SocketOption *>(cppOut) =
        static_cast<::QAbstractSocket::SocketOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSocket_SocketOption_PythonToCpp_QAbstractSocket_SocketOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX]))
        return QAbstractSocket_SocketOption_PythonToCpp_QAbstractSocket_SocketOption;
    return {};
}
static PyObject *QAbstractSocket_SocketOption_CppToPython_QAbstractSocket_SocketOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSocket::SocketOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX], castCppIn);

}

static void QAbstractSocket_BindFlag_PythonToCpp_QAbstractSocket_BindFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSocket::BindFlag *>(cppOut) =
        static_cast<::QAbstractSocket::BindFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSocket_BindFlag_PythonToCpp_QAbstractSocket_BindFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX]))
        return QAbstractSocket_BindFlag_PythonToCpp_QAbstractSocket_BindFlag;
    return {};
}
static PyObject *QAbstractSocket_BindFlag_CppToPython_QAbstractSocket_BindFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSocket::BindFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX], castCppIn);

}

static void QFlags_QAbstractSocket_BindFlag__PythonToCpp_QFlags_QAbstractSocket_BindFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractSocket::BindFlag> *>(cppOut) =
        ::QFlags<QAbstractSocket::BindFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QAbstractSocket_BindFlag__PythonToCpp_QFlags_QAbstractSocket_BindFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX]))
        return QFlags_QAbstractSocket_BindFlag__PythonToCpp_QFlags_QAbstractSocket_BindFlag_;
    return {};
}
static PyObject *QFlags_QAbstractSocket_BindFlag__CppToPython_QFlags_QAbstractSocket_BindFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QAbstractSocket::BindFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX]));

}

static void QAbstractSocket_BindFlag_PythonToCpp_QFlags_QAbstractSocket_BindFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractSocket::BindFlag> *>(cppOut) =
        ::QFlags<QAbstractSocket::BindFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QAbstractSocket_BindFlag_PythonToCpp_QFlags_QAbstractSocket_BindFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX]))
        return QAbstractSocket_BindFlag_PythonToCpp_QFlags_QAbstractSocket_BindFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QAbstractSocket_BindFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QAbstractSocket::BindFlag> *>(cppOut) =
        ::QFlags<QAbstractSocket::BindFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QAbstractSocket_BindFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX]))
        return number_PythonToCpp_QFlags_QAbstractSocket_BindFlag_;
    return {};
}
static void QAbstractSocket_PauseMode_PythonToCpp_QAbstractSocket_PauseMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSocket::PauseMode *>(cppOut) =
        static_cast<::QAbstractSocket::PauseMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSocket_PauseMode_PythonToCpp_QAbstractSocket_PauseMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX]))
        return QAbstractSocket_PauseMode_PythonToCpp_QAbstractSocket_PauseMode;
    return {};
}
static PyObject *QAbstractSocket_PauseMode_CppToPython_QAbstractSocket_PauseMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSocket::PauseMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX], castCppIn);

}

static void QFlags_QAbstractSocket_PauseMode__PythonToCpp_QFlags_QAbstractSocket_PauseMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractSocket::PauseMode> *>(cppOut) =
        ::QFlags<QAbstractSocket::PauseMode>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QAbstractSocket_PauseMode__PythonToCpp_QFlags_QAbstractSocket_PauseMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX]))
        return QFlags_QAbstractSocket_PauseMode__PythonToCpp_QFlags_QAbstractSocket_PauseMode_;
    return {};
}
static PyObject *QFlags_QAbstractSocket_PauseMode__CppToPython_QFlags_QAbstractSocket_PauseMode_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QAbstractSocket::PauseMode> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX]));

}

static void QAbstractSocket_PauseMode_PythonToCpp_QFlags_QAbstractSocket_PauseMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractSocket::PauseMode> *>(cppOut) =
        ::QFlags<QAbstractSocket::PauseMode>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QAbstractSocket_PauseMode_PythonToCpp_QFlags_QAbstractSocket_PauseMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX]))
        return QAbstractSocket_PauseMode_PythonToCpp_QFlags_QAbstractSocket_PauseMode_;
    return {};
}
static void number_PythonToCpp_QFlags_QAbstractSocket_PauseMode_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QAbstractSocket::PauseMode> *>(cppOut) =
        ::QFlags<QAbstractSocket::PauseMode>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QAbstractSocket_PauseMode__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX]))
        return number_PythonToCpp_QFlags_QAbstractSocket_PauseMode_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractSocket_PythonToCpp_QAbstractSocket_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractSocket_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractSocket_PythonToCpp_QAbstractSocket_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractSocket_TypeF())))
        return QAbstractSocket_PythonToCpp_QAbstractSocket_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractSocket_PTR_CppToPython_QAbstractSocket(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAbstractSocket *>(const_cast<void *>(cppIn)), Sbk_QAbstractSocket_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractSocket_SignatureStrings[] = {
    "PySide2.QtNetwork.QAbstractSocket(self,socketType:PySide2.QtNetwork.QAbstractSocket.SocketType,parent:PySide2.QtCore.QObject)",
    "PySide2.QtNetwork.QAbstractSocket.abort(self)",
    "PySide2.QtNetwork.QAbstractSocket.atEnd(self)->bool",
    "1:PySide2.QtNetwork.QAbstractSocket.bind(self,address:PySide2.QtNetwork.QHostAddress,port:quint16=0,mode:PySide2.QtNetwork.QAbstractSocket.BindMode=QAbstractSocket.DefaultForPlatform)->bool",
    "0:PySide2.QtNetwork.QAbstractSocket.bind(self,port:quint16=0,mode:PySide2.QtNetwork.QAbstractSocket.BindMode=QAbstractSocket.DefaultForPlatform)->bool",
    "PySide2.QtNetwork.QAbstractSocket.bytesAvailable(self)->qint64",
    "PySide2.QtNetwork.QAbstractSocket.bytesToWrite(self)->qint64",
    "PySide2.QtNetwork.QAbstractSocket.canReadLine(self)->bool",
    "PySide2.QtNetwork.QAbstractSocket.close(self)",
    "1:PySide2.QtNetwork.QAbstractSocket.connectToHost(self,hostName:QString,port:quint16,mode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.ReadWrite,protocol:PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol=AnyIPProtocol)",
    "0:PySide2.QtNetwork.QAbstractSocket.connectToHost(self,address:PySide2.QtNetwork.QHostAddress,port:quint16,mode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.ReadWrite)",
    "PySide2.QtNetwork.QAbstractSocket.disconnectFromHost(self)",
    "PySide2.QtNetwork.QAbstractSocket.error(self)->PySide2.QtNetwork.QAbstractSocket.SocketError",
    "PySide2.QtNetwork.QAbstractSocket.flush(self)->bool",
    "PySide2.QtNetwork.QAbstractSocket.isSequential(self)->bool",
    "PySide2.QtNetwork.QAbstractSocket.isValid(self)->bool",
    "PySide2.QtNetwork.QAbstractSocket.localAddress(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QAbstractSocket.localPort(self)->quint16",
    "PySide2.QtNetwork.QAbstractSocket.pauseMode(self)->PySide2.QtNetwork.QAbstractSocket.PauseModes",
    "PySide2.QtNetwork.QAbstractSocket.peerAddress(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QAbstractSocket.peerName(self)->QString",
    "PySide2.QtNetwork.QAbstractSocket.peerPort(self)->quint16",
    "PySide2.QtNetwork.QAbstractSocket.protocolTag(self)->QString",
    "PySide2.QtNetwork.QAbstractSocket.proxy(self)->PySide2.QtNetwork.QNetworkProxy",
    "PySide2.QtNetwork.QAbstractSocket.readBufferSize(self)->qint64",
    "PySide2.QtNetwork.QAbstractSocket.readData(self,data:char*,maxlen:qint64)->qint64",
    "PySide2.QtNetwork.QAbstractSocket.readLineData(self,data:char*,maxlen:qint64)->qint64",
    "PySide2.QtNetwork.QAbstractSocket.resume(self)",
    "PySide2.QtNetwork.QAbstractSocket.setLocalAddress(self,address:PySide2.QtNetwork.QHostAddress)",
    "PySide2.QtNetwork.QAbstractSocket.setLocalPort(self,port:quint16)",
    "PySide2.QtNetwork.QAbstractSocket.setPauseMode(self,pauseMode:PySide2.QtNetwork.QAbstractSocket.PauseModes)",
    "PySide2.QtNetwork.QAbstractSocket.setPeerAddress(self,address:PySide2.QtNetwork.QHostAddress)",
    "PySide2.QtNetwork.QAbstractSocket.setPeerName(self,name:QString)",
    "PySide2.QtNetwork.QAbstractSocket.setPeerPort(self,port:quint16)",
    "PySide2.QtNetwork.QAbstractSocket.setProtocolTag(self,tag:QString)",
    "PySide2.QtNetwork.QAbstractSocket.setProxy(self,networkProxy:PySide2.QtNetwork.QNetworkProxy)",
    "PySide2.QtNetwork.QAbstractSocket.setReadBufferSize(self,size:qint64)",
    "PySide2.QtNetwork.QAbstractSocket.setSocketDescriptor(self,socketDescriptor:qintptr,state:PySide2.QtNetwork.QAbstractSocket.SocketState=ConnectedState,openMode:PySide2.QtCore.QIODevice.OpenMode=QIODevice.ReadWrite)->bool",
    "PySide2.QtNetwork.QAbstractSocket.setSocketError(self,socketError:PySide2.QtNetwork.QAbstractSocket.SocketError)",
    "PySide2.QtNetwork.QAbstractSocket.setSocketOption(self,option:PySide2.QtNetwork.QAbstractSocket.SocketOption,value:QVariant)",
    "PySide2.QtNetwork.QAbstractSocket.setSocketState(self,state:PySide2.QtNetwork.QAbstractSocket.SocketState)",
    "PySide2.QtNetwork.QAbstractSocket.socketDescriptor(self)->qintptr",
    "PySide2.QtNetwork.QAbstractSocket.socketOption(self,option:PySide2.QtNetwork.QAbstractSocket.SocketOption)->QVariant",
    "PySide2.QtNetwork.QAbstractSocket.socketType(self)->PySide2.QtNetwork.QAbstractSocket.SocketType",
    "PySide2.QtNetwork.QAbstractSocket.state(self)->PySide2.QtNetwork.QAbstractSocket.SocketState",
    "PySide2.QtNetwork.QAbstractSocket.waitForBytesWritten(self,msecs:int=30000)->bool",
    "PySide2.QtNetwork.QAbstractSocket.waitForConnected(self,msecs:int=30000)->bool",
    "PySide2.QtNetwork.QAbstractSocket.waitForDisconnected(self,msecs:int=30000)->bool",
    "PySide2.QtNetwork.QAbstractSocket.waitForReadyRead(self,msecs:int=30000)->bool",
    "PySide2.QtNetwork.QAbstractSocket.writeData(self,data:char*,len:qint64)->qint64",
    nullptr}; // Sentinel

void init_QAbstractSocket(PyObject *module)
{
    _Sbk_QAbstractSocket_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractSocket",
        "QAbstractSocket*",
        &Sbk_QAbstractSocket_spec,
        &Shiboken::callCppDestructor< ::QAbstractSocket >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractSocket_Type);
    InitSignatureStrings(pyType, QAbstractSocket_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractSocket_Type), Sbk_QAbstractSocket_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractSocket_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractSocket_TypeF(),
        QAbstractSocket_PythonToCpp_QAbstractSocket_PTR,
        is_QAbstractSocket_PythonToCpp_QAbstractSocket_PTR_Convertible,
        QAbstractSocket_PTR_CppToPython_QAbstractSocket);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractSocket).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractSocketWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAbstractSocket_TypeF(), &Sbk_QAbstractSocket_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'SocketType'.
    SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSocket_TypeF(),
        "SocketType",
        "2:PySide2.QtNetwork.QAbstractSocket.SocketType",
        "QAbstractSocket::SocketType");
    if (!SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX],
        Sbk_QAbstractSocket_TypeF(), "TcpSocket", (long) QAbstractSocket::SocketType::TcpSocket))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX],
        Sbk_QAbstractSocket_TypeF(), "UdpSocket", (long) QAbstractSocket::SocketType::UdpSocket))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX],
        Sbk_QAbstractSocket_TypeF(), "SctpSocket", (long) QAbstractSocket::SocketType::SctpSocket))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX],
        Sbk_QAbstractSocket_TypeF(), "UnknownSocketType", (long) QAbstractSocket::SocketType::UnknownSocketType))
        return;
    // Register converter for enum 'QAbstractSocket::SocketType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX],
            QAbstractSocket_SocketType_CppToPython_QAbstractSocket_SocketType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSocket_SocketType_PythonToCpp_QAbstractSocket_SocketType,
            is_QAbstractSocket_SocketType_PythonToCpp_QAbstractSocket_SocketType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket::SocketType");
        Shiboken::Conversions::registerConverterName(converter, "SocketType");
    }
    // End of 'SocketType' enum.

    // Initialization of enum 'NetworkLayerProtocol'.
    SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSocket_TypeF(),
        "NetworkLayerProtocol",
        "2:PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol",
        "QAbstractSocket::NetworkLayerProtocol");
    if (!SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX],
        Sbk_QAbstractSocket_TypeF(), "IPv4Protocol", (long) QAbstractSocket::NetworkLayerProtocol::IPv4Protocol))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX],
        Sbk_QAbstractSocket_TypeF(), "IPv6Protocol", (long) QAbstractSocket::NetworkLayerProtocol::IPv6Protocol))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX],
        Sbk_QAbstractSocket_TypeF(), "AnyIPProtocol", (long) QAbstractSocket::NetworkLayerProtocol::AnyIPProtocol))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX],
        Sbk_QAbstractSocket_TypeF(), "UnknownNetworkLayerProtocol", (long) QAbstractSocket::NetworkLayerProtocol::UnknownNetworkLayerProtocol))
        return;
    // Register converter for enum 'QAbstractSocket::NetworkLayerProtocol'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX],
            QAbstractSocket_NetworkLayerProtocol_CppToPython_QAbstractSocket_NetworkLayerProtocol);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSocket_NetworkLayerProtocol_PythonToCpp_QAbstractSocket_NetworkLayerProtocol,
            is_QAbstractSocket_NetworkLayerProtocol_PythonToCpp_QAbstractSocket_NetworkLayerProtocol_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket::NetworkLayerProtocol");
        Shiboken::Conversions::registerConverterName(converter, "NetworkLayerProtocol");
    }
    // End of 'NetworkLayerProtocol' enum.

    // Initialization of enum 'SocketError'.
    SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSocket_TypeF(),
        "SocketError",
        "2:PySide2.QtNetwork.QAbstractSocket.SocketError",
        "QAbstractSocket::SocketError");
    if (!SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "ConnectionRefusedError", (long) QAbstractSocket::SocketError::ConnectionRefusedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "RemoteHostClosedError", (long) QAbstractSocket::SocketError::RemoteHostClosedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "HostNotFoundError", (long) QAbstractSocket::SocketError::HostNotFoundError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "SocketAccessError", (long) QAbstractSocket::SocketError::SocketAccessError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "SocketResourceError", (long) QAbstractSocket::SocketError::SocketResourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "SocketTimeoutError", (long) QAbstractSocket::SocketError::SocketTimeoutError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "DatagramTooLargeError", (long) QAbstractSocket::SocketError::DatagramTooLargeError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "NetworkError", (long) QAbstractSocket::SocketError::NetworkError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "AddressInUseError", (long) QAbstractSocket::SocketError::AddressInUseError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "SocketAddressNotAvailableError", (long) QAbstractSocket::SocketError::SocketAddressNotAvailableError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "UnsupportedSocketOperationError", (long) QAbstractSocket::SocketError::UnsupportedSocketOperationError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "UnfinishedSocketOperationError", (long) QAbstractSocket::SocketError::UnfinishedSocketOperationError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "ProxyAuthenticationRequiredError", (long) QAbstractSocket::SocketError::ProxyAuthenticationRequiredError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "SslHandshakeFailedError", (long) QAbstractSocket::SocketError::SslHandshakeFailedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "ProxyConnectionRefusedError", (long) QAbstractSocket::SocketError::ProxyConnectionRefusedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "ProxyConnectionClosedError", (long) QAbstractSocket::SocketError::ProxyConnectionClosedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "ProxyConnectionTimeoutError", (long) QAbstractSocket::SocketError::ProxyConnectionTimeoutError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "ProxyNotFoundError", (long) QAbstractSocket::SocketError::ProxyNotFoundError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "ProxyProtocolError", (long) QAbstractSocket::SocketError::ProxyProtocolError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "OperationError", (long) QAbstractSocket::SocketError::OperationError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "SslInternalError", (long) QAbstractSocket::SocketError::SslInternalError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "SslInvalidUserDataError", (long) QAbstractSocket::SocketError::SslInvalidUserDataError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "TemporaryError", (long) QAbstractSocket::SocketError::TemporaryError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
        Sbk_QAbstractSocket_TypeF(), "UnknownSocketError", (long) QAbstractSocket::SocketError::UnknownSocketError))
        return;
    // Register converter for enum 'QAbstractSocket::SocketError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX],
            QAbstractSocket_SocketError_CppToPython_QAbstractSocket_SocketError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSocket_SocketError_PythonToCpp_QAbstractSocket_SocketError,
            is_QAbstractSocket_SocketError_PythonToCpp_QAbstractSocket_SocketError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket::SocketError");
        Shiboken::Conversions::registerConverterName(converter, "SocketError");
    }
    // End of 'SocketError' enum.

    // Initialization of enum 'SocketState'.
    SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSocket_TypeF(),
        "SocketState",
        "2:PySide2.QtNetwork.QAbstractSocket.SocketState",
        "QAbstractSocket::SocketState");
    if (!SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX],
        Sbk_QAbstractSocket_TypeF(), "UnconnectedState", (long) QAbstractSocket::SocketState::UnconnectedState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX],
        Sbk_QAbstractSocket_TypeF(), "HostLookupState", (long) QAbstractSocket::SocketState::HostLookupState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX],
        Sbk_QAbstractSocket_TypeF(), "ConnectingState", (long) QAbstractSocket::SocketState::ConnectingState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX],
        Sbk_QAbstractSocket_TypeF(), "ConnectedState", (long) QAbstractSocket::SocketState::ConnectedState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX],
        Sbk_QAbstractSocket_TypeF(), "BoundState", (long) QAbstractSocket::SocketState::BoundState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX],
        Sbk_QAbstractSocket_TypeF(), "ListeningState", (long) QAbstractSocket::SocketState::ListeningState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX],
        Sbk_QAbstractSocket_TypeF(), "ClosingState", (long) QAbstractSocket::SocketState::ClosingState))
        return;
    // Register converter for enum 'QAbstractSocket::SocketState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX],
            QAbstractSocket_SocketState_CppToPython_QAbstractSocket_SocketState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSocket_SocketState_PythonToCpp_QAbstractSocket_SocketState,
            is_QAbstractSocket_SocketState_PythonToCpp_QAbstractSocket_SocketState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket::SocketState");
        Shiboken::Conversions::registerConverterName(converter, "SocketState");
    }
    // End of 'SocketState' enum.

    // Initialization of enum 'SocketOption'.
    SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSocket_TypeF(),
        "SocketOption",
        "2:PySide2.QtNetwork.QAbstractSocket.SocketOption",
        "QAbstractSocket::SocketOption");
    if (!SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX],
        Sbk_QAbstractSocket_TypeF(), "LowDelayOption", (long) QAbstractSocket::SocketOption::LowDelayOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX],
        Sbk_QAbstractSocket_TypeF(), "KeepAliveOption", (long) QAbstractSocket::SocketOption::KeepAliveOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX],
        Sbk_QAbstractSocket_TypeF(), "MulticastTtlOption", (long) QAbstractSocket::SocketOption::MulticastTtlOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX],
        Sbk_QAbstractSocket_TypeF(), "MulticastLoopbackOption", (long) QAbstractSocket::SocketOption::MulticastLoopbackOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX],
        Sbk_QAbstractSocket_TypeF(), "TypeOfServiceOption", (long) QAbstractSocket::SocketOption::TypeOfServiceOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX],
        Sbk_QAbstractSocket_TypeF(), "SendBufferSizeSocketOption", (long) QAbstractSocket::SocketOption::SendBufferSizeSocketOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX],
        Sbk_QAbstractSocket_TypeF(), "ReceiveBufferSizeSocketOption", (long) QAbstractSocket::SocketOption::ReceiveBufferSizeSocketOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX],
        Sbk_QAbstractSocket_TypeF(), "PathMtuSocketOption", (long) QAbstractSocket::SocketOption::PathMtuSocketOption))
        return;
    // Register converter for enum 'QAbstractSocket::SocketOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX],
            QAbstractSocket_SocketOption_CppToPython_QAbstractSocket_SocketOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSocket_SocketOption_PythonToCpp_QAbstractSocket_SocketOption,
            is_QAbstractSocket_SocketOption_PythonToCpp_QAbstractSocket_SocketOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket::SocketOption");
        Shiboken::Conversions::registerConverterName(converter, "SocketOption");
    }
    // End of 'SocketOption' enum.

    // Initialization of enum 'BindFlag'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QAbstractSocket.BindMode", SbkPySide2_QtNetwork_QAbstractSocket_BindFlag_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSocket_TypeF(),
        "BindFlag",
        "2:PySide2.QtNetwork.QAbstractSocket.BindFlag",
        "QAbstractSocket::BindFlag",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX],
        Sbk_QAbstractSocket_TypeF(), "DefaultForPlatform", (long) QAbstractSocket::BindFlag::DefaultForPlatform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX],
        Sbk_QAbstractSocket_TypeF(), "ShareAddress", (long) QAbstractSocket::BindFlag::ShareAddress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX],
        Sbk_QAbstractSocket_TypeF(), "DontShareAddress", (long) QAbstractSocket::BindFlag::DontShareAddress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX],
        Sbk_QAbstractSocket_TypeF(), "ReuseAddressHint", (long) QAbstractSocket::BindFlag::ReuseAddressHint))
        return;
    // Register converter for enum 'QAbstractSocket::BindFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX],
            QAbstractSocket_BindFlag_CppToPython_QAbstractSocket_BindFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSocket_BindFlag_PythonToCpp_QAbstractSocket_BindFlag,
            is_QAbstractSocket_BindFlag_PythonToCpp_QAbstractSocket_BindFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_BINDFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket::BindFlag");
        Shiboken::Conversions::registerConverterName(converter, "BindFlag");
    }
    // Register converter for flag 'QFlags<QAbstractSocket::BindFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX],
            QFlags_QAbstractSocket_BindFlag__CppToPython_QFlags_QAbstractSocket_BindFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSocket_BindFlag_PythonToCpp_QFlags_QAbstractSocket_BindFlag_,
            is_QAbstractSocket_BindFlag_PythonToCpp_QFlags_QAbstractSocket_BindFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QAbstractSocket_BindFlag__PythonToCpp_QFlags_QAbstractSocket_BindFlag_,
            is_QFlags_QAbstractSocket_BindFlag__PythonToCpp_QFlags_QAbstractSocket_BindFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QAbstractSocket_BindFlag_,
            is_number_PythonToCpp_QFlags_QAbstractSocket_BindFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_BINDFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket::BindMode");
        Shiboken::Conversions::registerConverterName(converter, "BindMode");
    }
    // End of 'BindFlag' enum/flags.

    // Initialization of enum 'PauseMode'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QAbstractSocket.PauseModes", SbkPySide2_QtNetwork_QAbstractSocket_PauseMode_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSocket_TypeF(),
        "PauseMode",
        "2:PySide2.QtNetwork.QAbstractSocket.PauseMode",
        "QAbstractSocket::PauseMode",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX],
        Sbk_QAbstractSocket_TypeF(), "PauseNever", (long) QAbstractSocket::PauseMode::PauseNever))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX],
        Sbk_QAbstractSocket_TypeF(), "PauseOnSslErrors", (long) QAbstractSocket::PauseMode::PauseOnSslErrors))
        return;
    // Register converter for enum 'QAbstractSocket::PauseMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX],
            QAbstractSocket_PauseMode_CppToPython_QAbstractSocket_PauseMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSocket_PauseMode_PythonToCpp_QAbstractSocket_PauseMode,
            is_QAbstractSocket_PauseMode_PythonToCpp_QAbstractSocket_PauseMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_PAUSEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket::PauseMode");
        Shiboken::Conversions::registerConverterName(converter, "PauseMode");
    }
    // Register converter for flag 'QFlags<QAbstractSocket::PauseMode>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX],
            QFlags_QAbstractSocket_PauseMode__CppToPython_QFlags_QAbstractSocket_PauseMode_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSocket_PauseMode_PythonToCpp_QFlags_QAbstractSocket_PauseMode_,
            is_QAbstractSocket_PauseMode_PythonToCpp_QFlags_QAbstractSocket_PauseMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QAbstractSocket_PauseMode__PythonToCpp_QFlags_QAbstractSocket_PauseMode_,
            is_QFlags_QAbstractSocket_PauseMode__PythonToCpp_QFlags_QAbstractSocket_PauseMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QAbstractSocket_PauseMode_,
            is_number_PythonToCpp_QFlags_QAbstractSocket_PauseMode__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSocket::PauseModes");
        Shiboken::Conversions::registerConverterName(converter, "PauseModes");
    }
    // End of 'PauseMode' enum/flags.

    PySide::Signal::registerSignals(Sbk_QAbstractSocket_TypeF(), &::QAbstractSocket::staticMetaObject);
    qRegisterMetaType< ::QAbstractSocket::SocketType >("QAbstractSocket::SocketType");
    qRegisterMetaType< ::QAbstractSocket::NetworkLayerProtocol >("QAbstractSocket::NetworkLayerProtocol");
    qRegisterMetaType< ::QAbstractSocket::SocketError >("QAbstractSocket::SocketError");
    qRegisterMetaType< ::QAbstractSocket::SocketState >("QAbstractSocket::SocketState");
    qRegisterMetaType< ::QAbstractSocket::SocketOption >("QAbstractSocket::SocketOption");
    qRegisterMetaType< ::QAbstractSocket::BindFlag >("QAbstractSocket::BindFlag");
    qRegisterMetaType< ::QAbstractSocket::BindMode >("QAbstractSocket::BindMode");
    qRegisterMetaType< ::QAbstractSocket::PauseMode >("QAbstractSocket::PauseMode");
    qRegisterMetaType< ::QAbstractSocket::PauseModes >("QAbstractSocket::PauseModes");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAbstractSocket_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAbstractSocket_TypeF(), &::QAbstractSocket::staticMetaObject, sizeof(QAbstractSocketWrapper));
}
