/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qdnshostaddressrecord_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qdnslookup.h>
#include <QtNetwork/qhostaddress.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDnsHostAddressRecord_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDnsHostAddressRecord >()))
        return -1;

    ::QDnsHostAddressRecord *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsHostAddressRecord.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDnsHostAddressRecord", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QDnsHostAddressRecord::QDnsHostAddressRecord()
    // 1: QDnsHostAddressRecord::QDnsHostAddressRecord(QDnsHostAddressRecord)
    if (numArgs == 0) {
        overloadId = 0; // QDnsHostAddressRecord()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QDnsHostAddressRecord(QDnsHostAddressRecord)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDnsHostAddressRecord_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDnsHostAddressRecord()
        {

            if (!PyErr_Occurred()) {
                // QDnsHostAddressRecord()
                cptr = new ::QDnsHostAddressRecord();
            }
            break;
        }
        case 1: // QDnsHostAddressRecord(const QDnsHostAddressRecord & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDnsHostAddressRecord cppArg0_local;
            ::QDnsHostAddressRecord *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDnsHostAddressRecord(QDnsHostAddressRecord)
                cptr = new ::QDnsHostAddressRecord(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDnsHostAddressRecord >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDnsHostAddressRecord_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDnsHostAddressRecord_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDnsHostAddressRecordFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsHostAddressRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsHostAddressRecord.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QDnsHostAddressRecord *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsHostAddressRecordFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsHostAddressRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsHostAddressRecord.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDnsHostAddressRecord::swap(QDnsHostAddressRecord&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QDnsHostAddressRecord&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDnsHostAddressRecordFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDnsHostAddressRecord cppArg0_local;
        ::QDnsHostAddressRecord *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QDnsHostAddressRecord&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDnsHostAddressRecordFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDnsHostAddressRecordFunc_timeToLive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsHostAddressRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsHostAddressRecord.timeToLive";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timeToLive()const
            quint32 cppResult = const_cast<const ::QDnsHostAddressRecord *>(cppSelf)->timeToLive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsHostAddressRecordFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsHostAddressRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsHostAddressRecord.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()const
            QHostAddress cppResult = const_cast<const ::QDnsHostAddressRecord *>(cppSelf)->value();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsHostAddressRecord___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDnsHostAddressRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDnsHostAddressRecord_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDnsHostAddressRecord_methods[] = {
    {"name", reinterpret_cast<PyCFunction>(Sbk_QDnsHostAddressRecordFunc_name), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QDnsHostAddressRecordFunc_swap), METH_O},
    {"timeToLive", reinterpret_cast<PyCFunction>(Sbk_QDnsHostAddressRecordFunc_timeToLive), METH_NOARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QDnsHostAddressRecordFunc_value), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDnsHostAddressRecord___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QDnsHostAddressRecord_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDnsHostAddressRecord_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDnsHostAddressRecord_Type = nullptr;
static SbkObjectType *Sbk_QDnsHostAddressRecord_TypeF(void)
{
    return _Sbk_QDnsHostAddressRecord_Type;
}

static PyType_Slot Sbk_QDnsHostAddressRecord_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDnsHostAddressRecord_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDnsHostAddressRecord_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDnsHostAddressRecord_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDnsHostAddressRecord_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QDnsHostAddressRecord_spec = {
    "2:PySide2.QtNetwork.QDnsHostAddressRecord",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDnsHostAddressRecord_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDnsHostAddressRecord_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDnsHostAddressRecord_TypeF())))
        return QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDnsHostAddressRecord_PTR_CppToPython_QDnsHostAddressRecord(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDnsHostAddressRecord *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDnsHostAddressRecord_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDnsHostAddressRecord_COPY_CppToPython_QDnsHostAddressRecord(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDnsHostAddressRecord_TypeF(), new ::QDnsHostAddressRecord(*reinterpret_cast<const ::QDnsHostAddressRecord *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDnsHostAddressRecord *>(cppOut) = *reinterpret_cast< ::QDnsHostAddressRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDnsHostAddressRecord_TypeF())))
        return QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDnsHostAddressRecord_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QDnsHostAddressRecord(self)",
    "0:PySide2.QtNetwork.QDnsHostAddressRecord(self,other:PySide2.QtNetwork.QDnsHostAddressRecord)",
    "PySide2.QtNetwork.QDnsHostAddressRecord.name(self)->QString",
    "PySide2.QtNetwork.QDnsHostAddressRecord.swap(self,other:PySide2.QtNetwork.QDnsHostAddressRecord)",
    "PySide2.QtNetwork.QDnsHostAddressRecord.timeToLive(self)->quint32",
    "PySide2.QtNetwork.QDnsHostAddressRecord.value(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QDnsHostAddressRecord.__copy__()",
    nullptr}; // Sentinel

void init_QDnsHostAddressRecord(PyObject *module)
{
    _Sbk_QDnsHostAddressRecord_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDnsHostAddressRecord",
        "QDnsHostAddressRecord",
        &Sbk_QDnsHostAddressRecord_spec,
        &Shiboken::callCppDestructor< ::QDnsHostAddressRecord >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDnsHostAddressRecord_Type);
    InitSignatureStrings(pyType, QDnsHostAddressRecord_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDnsHostAddressRecord_Type), Sbk_QDnsHostAddressRecord_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDnsHostAddressRecord_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDnsHostAddressRecord_TypeF(),
        QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_PTR,
        is_QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_PTR_Convertible,
        QDnsHostAddressRecord_PTR_CppToPython_QDnsHostAddressRecord,
        QDnsHostAddressRecord_COPY_CppToPython_QDnsHostAddressRecord);

    Shiboken::Conversions::registerConverterName(converter, "QDnsHostAddressRecord");
    Shiboken::Conversions::registerConverterName(converter, "QDnsHostAddressRecord*");
    Shiboken::Conversions::registerConverterName(converter, "QDnsHostAddressRecord&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDnsHostAddressRecord).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_COPY,
        is_QDnsHostAddressRecord_PythonToCpp_QDnsHostAddressRecord_COPY_Convertible);

    qRegisterMetaType< ::QDnsHostAddressRecord >("QDnsHostAddressRecord");
}
