/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkaddressentry_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qhostaddress.h>
#include <QtNetwork/qnetworkinterface.h>
#include <qdeadlinetimer.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkAddressEntry_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkAddressEntry >()))
        return -1;

    ::QNetworkAddressEntry *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QNetworkAddressEntry", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkAddressEntry::QNetworkAddressEntry()
    // 1: QNetworkAddressEntry::QNetworkAddressEntry(QNetworkAddressEntry)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkAddressEntry()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QNetworkAddressEntry(QNetworkAddressEntry)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAddressEntry_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QNetworkAddressEntry()
        {

            if (!PyErr_Occurred()) {
                // QNetworkAddressEntry()
                cptr = new ::QNetworkAddressEntry();
            }
            break;
        }
        case 1: // QNetworkAddressEntry(const QNetworkAddressEntry & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkAddressEntry cppArg0_local;
            ::QNetworkAddressEntry *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QNetworkAddressEntry(QNetworkAddressEntry)
                cptr = new ::QNetworkAddressEntry(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkAddressEntry >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkAddressEntry_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QNetworkAddressEntry_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_broadcast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.broadcast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // broadcast()const
            QHostAddress cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->broadcast();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_clearAddressLifetime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.clearAddressLifetime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearAddressLifetime()
            cppSelf->clearAddressLifetime();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_dnsEligibility(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.dnsEligibility";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dnsEligibility()const
            QNetworkAddressEntry::DnsEligibilityStatus cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->dnsEligibility();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_ip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.ip";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ip()const
            QHostAddress cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->ip();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_isLifetimeKnown(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.isLifetimeKnown";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLifetimeKnown()const
            bool cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->isLifetimeKnown();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_isPermanent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.isPermanent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPermanent()const
            bool cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->isPermanent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_isTemporary(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.isTemporary";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTemporary()const
            bool cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->isTemporary();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_netmask(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.netmask";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // netmask()const
            QHostAddress cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->netmask();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_preferredLifetime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.preferredLifetime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preferredLifetime()const
            QDeadlineTimer cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->preferredLifetime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_prefixLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.prefixLength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // prefixLength()const
            int cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->prefixLength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntryFunc_setAddressLifetime(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.setAddressLifetime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAddressLifetime", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAddressEntry::setAddressLifetime(QDeadlineTimer,QDeadlineTimer)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setAddressLifetime(QDeadlineTimer,QDeadlineTimer)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAddressEntryFunc_setAddressLifetime_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDeadlineTimer cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDeadlineTimer cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setAddressLifetime(QDeadlineTimer,QDeadlineTimer)
            cppSelf->setAddressLifetime(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAddressEntryFunc_setAddressLifetime_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAddressEntryFunc_setBroadcast(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.setBroadcast";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAddressEntry::setBroadcast(QHostAddress)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArg)))) {
        overloadId = 0; // setBroadcast(QHostAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAddressEntryFunc_setBroadcast_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBroadcast(QHostAddress)
            cppSelf->setBroadcast(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAddressEntryFunc_setBroadcast_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAddressEntryFunc_setDnsEligibility(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.setDnsEligibility";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAddressEntry::setDnsEligibility(QNetworkAddressEntry::DnsEligibilityStatus)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDnsEligibility(QNetworkAddressEntry::DnsEligibilityStatus)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAddressEntryFunc_setDnsEligibility_TypeError;

    // Call function/method
    {
        ::QNetworkAddressEntry::DnsEligibilityStatus cppArg0{QNetworkAddressEntry::DnsIneligible};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDnsEligibility(QNetworkAddressEntry::DnsEligibilityStatus)
            cppSelf->setDnsEligibility(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAddressEntryFunc_setDnsEligibility_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAddressEntryFunc_setIp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.setIp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAddressEntry::setIp(QHostAddress)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArg)))) {
        overloadId = 0; // setIp(QHostAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAddressEntryFunc_setIp_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setIp(QHostAddress)
            cppSelf->setIp(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAddressEntryFunc_setIp_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAddressEntryFunc_setNetmask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.setNetmask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAddressEntry::setNetmask(QHostAddress)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArg)))) {
        overloadId = 0; // setNetmask(QHostAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAddressEntryFunc_setNetmask_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setNetmask(QHostAddress)
            cppSelf->setNetmask(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAddressEntryFunc_setNetmask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAddressEntryFunc_setPrefixLength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.setPrefixLength";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAddressEntry::setPrefixLength(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPrefixLength(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAddressEntryFunc_setPrefixLength_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPrefixLength(int)
            cppSelf->setPrefixLength(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAddressEntryFunc_setPrefixLength_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAddressEntryFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAddressEntry::swap(QNetworkAddressEntry&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QNetworkAddressEntry&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAddressEntryFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkAddressEntry cppArg0_local;
        ::QNetworkAddressEntry *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QNetworkAddressEntry&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAddressEntryFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAddressEntryFunc_validityLifetime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAddressEntry.validityLifetime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // validityLifetime()const
            QDeadlineTimer cppResult = const_cast<const ::QNetworkAddressEntry *>(cppSelf)->validityLifetime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDEADLINETIMER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAddressEntry___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNetworkAddressEntry_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkAddressEntry_methods[] = {
    {"broadcast", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_broadcast), METH_NOARGS},
    {"clearAddressLifetime", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_clearAddressLifetime), METH_NOARGS},
    {"dnsEligibility", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_dnsEligibility), METH_NOARGS},
    {"ip", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_ip), METH_NOARGS},
    {"isLifetimeKnown", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_isLifetimeKnown), METH_NOARGS},
    {"isPermanent", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_isPermanent), METH_NOARGS},
    {"isTemporary", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_isTemporary), METH_NOARGS},
    {"netmask", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_netmask), METH_NOARGS},
    {"preferredLifetime", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_preferredLifetime), METH_NOARGS},
    {"prefixLength", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_prefixLength), METH_NOARGS},
    {"setAddressLifetime", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_setAddressLifetime), METH_VARARGS},
    {"setBroadcast", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_setBroadcast), METH_O},
    {"setDnsEligibility", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_setDnsEligibility), METH_O},
    {"setIp", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_setIp), METH_O},
    {"setNetmask", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_setNetmask), METH_O},
    {"setPrefixLength", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_setPrefixLength), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_swap), METH_O},
    {"validityLifetime", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntryFunc_validityLifetime), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QNetworkAddressEntry___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QNetworkAddressEntry_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), (pyArg)))) {
                // operator!=(const QNetworkAddressEntry & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkAddressEntry cppArg0_local;
                ::QNetworkAddressEntry *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), (pyArg)))) {
                // operator==(const QNetworkAddressEntry & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkAddressEntry cppArg0_local;
                ::QNetworkAddressEntry *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QNetworkAddressEntry_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QNetworkAddressEntry_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QNetworkAddressEntry_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkAddressEntry_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkAddressEntry_Type = nullptr;
static SbkObjectType *Sbk_QNetworkAddressEntry_TypeF(void)
{
    return _Sbk_QNetworkAddressEntry_Type;
}

static PyType_Slot Sbk_QNetworkAddressEntry_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkAddressEntry_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkAddressEntry_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QNetworkAddressEntry_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkAddressEntry_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkAddressEntry_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkAddressEntry_spec = {
    "2:PySide2.QtNetwork.QNetworkAddressEntry",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkAddressEntry_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QNetworkAddressEntry_DnsEligibilityStatus_PythonToCpp_QNetworkAddressEntry_DnsEligibilityStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkAddressEntry::DnsEligibilityStatus *>(cppOut) =
        static_cast<::QNetworkAddressEntry::DnsEligibilityStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkAddressEntry_DnsEligibilityStatus_PythonToCpp_QNetworkAddressEntry_DnsEligibilityStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX]))
        return QNetworkAddressEntry_DnsEligibilityStatus_PythonToCpp_QNetworkAddressEntry_DnsEligibilityStatus;
    return {};
}
static PyObject *QNetworkAddressEntry_DnsEligibilityStatus_CppToPython_QNetworkAddressEntry_DnsEligibilityStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkAddressEntry::DnsEligibilityStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkAddressEntry_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkAddressEntry_TypeF())))
        return QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkAddressEntry_PTR_CppToPython_QNetworkAddressEntry(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QNetworkAddressEntry *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QNetworkAddressEntry_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QNetworkAddressEntry_COPY_CppToPython_QNetworkAddressEntry(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QNetworkAddressEntry_TypeF(), new ::QNetworkAddressEntry(*reinterpret_cast<const ::QNetworkAddressEntry *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkAddressEntry *>(cppOut) = *reinterpret_cast< ::QNetworkAddressEntry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkAddressEntry_TypeF())))
        return QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkAddressEntry_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QNetworkAddressEntry(self)",
    "0:PySide2.QtNetwork.QNetworkAddressEntry(self,other:PySide2.QtNetwork.QNetworkAddressEntry)",
    "PySide2.QtNetwork.QNetworkAddressEntry.broadcast(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QNetworkAddressEntry.clearAddressLifetime(self)",
    "PySide2.QtNetwork.QNetworkAddressEntry.dnsEligibility(self)->PySide2.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus",
    "PySide2.QtNetwork.QNetworkAddressEntry.ip(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QNetworkAddressEntry.isLifetimeKnown(self)->bool",
    "PySide2.QtNetwork.QNetworkAddressEntry.isPermanent(self)->bool",
    "PySide2.QtNetwork.QNetworkAddressEntry.isTemporary(self)->bool",
    "PySide2.QtNetwork.QNetworkAddressEntry.netmask(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QNetworkAddressEntry.preferredLifetime(self)->PySide2.QtCore.QDeadlineTimer",
    "PySide2.QtNetwork.QNetworkAddressEntry.prefixLength(self)->int",
    "PySide2.QtNetwork.QNetworkAddressEntry.setAddressLifetime(self,preferred:PySide2.QtCore.QDeadlineTimer,validity:PySide2.QtCore.QDeadlineTimer)",
    "PySide2.QtNetwork.QNetworkAddressEntry.setBroadcast(self,newBroadcast:PySide2.QtNetwork.QHostAddress)",
    "PySide2.QtNetwork.QNetworkAddressEntry.setDnsEligibility(self,status:PySide2.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus)",
    "PySide2.QtNetwork.QNetworkAddressEntry.setIp(self,newIp:PySide2.QtNetwork.QHostAddress)",
    "PySide2.QtNetwork.QNetworkAddressEntry.setNetmask(self,newNetmask:PySide2.QtNetwork.QHostAddress)",
    "PySide2.QtNetwork.QNetworkAddressEntry.setPrefixLength(self,length:int)",
    "PySide2.QtNetwork.QNetworkAddressEntry.swap(self,other:PySide2.QtNetwork.QNetworkAddressEntry)",
    "PySide2.QtNetwork.QNetworkAddressEntry.validityLifetime(self)->PySide2.QtCore.QDeadlineTimer",
    "PySide2.QtNetwork.QNetworkAddressEntry.__copy__()",
    nullptr}; // Sentinel

void init_QNetworkAddressEntry(PyObject *module)
{
    _Sbk_QNetworkAddressEntry_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkAddressEntry",
        "QNetworkAddressEntry",
        &Sbk_QNetworkAddressEntry_spec,
        &Shiboken::callCppDestructor< ::QNetworkAddressEntry >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkAddressEntry_Type);
    InitSignatureStrings(pyType, QNetworkAddressEntry_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkAddressEntry_Type), Sbk_QNetworkAddressEntry_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkAddressEntry_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkAddressEntry_TypeF(),
        QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_PTR,
        is_QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_PTR_Convertible,
        QNetworkAddressEntry_PTR_CppToPython_QNetworkAddressEntry,
        QNetworkAddressEntry_COPY_CppToPython_QNetworkAddressEntry);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkAddressEntry");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkAddressEntry*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkAddressEntry&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkAddressEntry).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_COPY,
        is_QNetworkAddressEntry_PythonToCpp_QNetworkAddressEntry_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'DnsEligibilityStatus'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkAddressEntry_TypeF(),
        "DnsEligibilityStatus",
        "2:PySide2.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus",
        "QNetworkAddressEntry::DnsEligibilityStatus");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX],
        Sbk_QNetworkAddressEntry_TypeF(), "DnsEligibilityUnknown", (long) QNetworkAddressEntry::DnsEligibilityStatus::DnsEligibilityUnknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX],
        Sbk_QNetworkAddressEntry_TypeF(), "DnsIneligible", (long) QNetworkAddressEntry::DnsEligibilityStatus::DnsIneligible))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX],
        Sbk_QNetworkAddressEntry_TypeF(), "DnsEligible", (long) QNetworkAddressEntry::DnsEligibilityStatus::DnsEligible))
        return;
    // Register converter for enum 'QNetworkAddressEntry::DnsEligibilityStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX],
            QNetworkAddressEntry_DnsEligibilityStatus_CppToPython_QNetworkAddressEntry_DnsEligibilityStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkAddressEntry_DnsEligibilityStatus_PythonToCpp_QNetworkAddressEntry_DnsEligibilityStatus,
            is_QNetworkAddressEntry_DnsEligibilityStatus_PythonToCpp_QNetworkAddressEntry_DnsEligibilityStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_DNSELIGIBILITYSTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkAddressEntry::DnsEligibilityStatus");
        Shiboken::Conversions::registerConverterName(converter, "DnsEligibilityStatus");
    }
    // End of 'DnsEligibilityStatus' enum.

    qRegisterMetaType< ::QNetworkAddressEntry >("QNetworkAddressEntry");
    qRegisterMetaType< ::QNetworkAddressEntry::DnsEligibilityStatus >("QNetworkAddressEntry::DnsEligibilityStatus");
}
