/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkdatagram_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qhostaddress.h>
#include <QtNetwork/qnetworkdatagram.h>
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkDatagram_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkDatagram >()))
        return -1;

    ::QNetworkDatagram *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkDatagram_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QNetworkDatagram", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkDatagram::QNetworkDatagram()
    // 1: QNetworkDatagram::QNetworkDatagram(QByteArray,QHostAddress,quint16)
    // 2: QNetworkDatagram::QNetworkDatagram(QNetworkDatagram)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkDatagram()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QNetworkDatagram(QByteArray,QHostAddress,quint16)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // QNetworkDatagram(QByteArray,QHostAddress,quint16)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[2])))) {
                overloadId = 1; // QNetworkDatagram(QByteArray,QHostAddress,quint16)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QNetworkDatagram(QNetworkDatagram)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkDatagram_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QNetworkDatagram()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QNetworkDatagram_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QNetworkDatagram()
                cptr = new ::QNetworkDatagram();
            }
            break;
        }
        case 1: // QNetworkDatagram(const QByteArray & data, const QHostAddress & destinationAddress, quint16 port)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_destinationAddress = Shiboken::String::createStaticString("destinationAddress");
                if (PyDict_Contains(kwds, key_destinationAddress)) {
                    value = PyDict_GetItem(kwds, key_destinationAddress);
                    if (value && pyArgs[1]) {
                        errInfo = key_destinationAddress;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkDatagram_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[1]))))
                            goto Sbk_QNetworkDatagram_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_destinationAddress);
                }
                static PyObject *const key_port = Shiboken::String::createStaticString("port");
                if (PyDict_Contains(kwds, key_port)) {
                    value = PyDict_GetItem(kwds, key_port);
                    if (value && pyArgs[2]) {
                        errInfo = key_port;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkDatagram_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[2]))))
                            goto Sbk_QNetworkDatagram_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_port);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkDatagram_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QHostAddress cppArg1_local = QHostAddress();
            ::QHostAddress *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }
            quint16 cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QNetworkDatagram(QByteArray,QHostAddress,quint16)
                cptr = new ::QNetworkDatagram(*cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 2: // QNetworkDatagram(const QNetworkDatagram & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QNetworkDatagram_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkDatagram cppArg0_local;
            ::QNetworkDatagram *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QNetworkDatagram(QNetworkDatagram)
                cptr = new ::QNetworkDatagram(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkDatagram >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkDatagram_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QNetworkDatagram_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkDatagramFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkDatagramFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            QByteArray cppResult = const_cast<const ::QNetworkDatagram *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkDatagramFunc_destinationAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.destinationAddress";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destinationAddress()const
            QHostAddress cppResult = const_cast<const ::QNetworkDatagram *>(cppSelf)->destinationAddress();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkDatagramFunc_destinationPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.destinationPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destinationPort()const
            int cppResult = const_cast<const ::QNetworkDatagram *>(cppSelf)->destinationPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkDatagramFunc_hopLimit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.hopLimit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hopLimit()const
            int cppResult = const_cast<const ::QNetworkDatagram *>(cppSelf)->hopLimit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkDatagramFunc_interfaceIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.interfaceIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // interfaceIndex()const
            uint cppResult = const_cast<const ::QNetworkDatagram *>(cppSelf)->interfaceIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkDatagramFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QNetworkDatagram *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkDatagramFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QNetworkDatagram *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkDatagramFunc_makeReply(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.makeReply";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkDatagram::makeReply(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // makeReply(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkDatagramFunc_makeReply_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // makeReply(QByteArray)
            QNetworkDatagram cppResult = cppSelf->makeReply(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkDatagramFunc_makeReply_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkDatagramFunc_senderAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.senderAddress";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // senderAddress()const
            QHostAddress cppResult = const_cast<const ::QNetworkDatagram *>(cppSelf)->senderAddress();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkDatagramFunc_senderPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.senderPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // senderPort()const
            int cppResult = const_cast<const ::QNetworkDatagram *>(cppSelf)->senderPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkDatagramFunc_setData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkDatagram::setData(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setData(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkDatagramFunc_setData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setData(QByteArray)
            cppSelf->setData(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkDatagramFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkDatagramFunc_setDestination(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.setDestination";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setDestination", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkDatagram::setDestination(QHostAddress,quint16)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
        overloadId = 0; // setDestination(QHostAddress,quint16)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkDatagramFunc_setDestination_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        quint16 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setDestination(QHostAddress,quint16)
            cppSelf->setDestination(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkDatagramFunc_setDestination_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkDatagramFunc_setHopLimit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.setHopLimit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkDatagram::setHopLimit(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHopLimit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkDatagramFunc_setHopLimit_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHopLimit(int)
            cppSelf->setHopLimit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkDatagramFunc_setHopLimit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkDatagramFunc_setInterfaceIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.setInterfaceIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkDatagram::setInterfaceIndex(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // setInterfaceIndex(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkDatagramFunc_setInterfaceIndex_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInterfaceIndex(uint)
            cppSelf->setInterfaceIndex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkDatagramFunc_setInterfaceIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkDatagramFunc_setSender(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.setSender";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkDatagramFunc_setSender_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkDatagramFunc_setSender_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setSender", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkDatagram::setSender(QHostAddress,quint16)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setSender(QHostAddress,quint16)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
            overloadId = 0; // setSender(QHostAddress,quint16)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkDatagramFunc_setSender_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_port = Shiboken::String::createStaticString("port");
            if (PyDict_Contains(kwds, key_port)) {
                value = PyDict_GetItem(kwds, key_port);
                if (value && pyArgs[1]) {
                    errInfo = key_port;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkDatagramFunc_setSender_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1]))))
                        goto Sbk_QNetworkDatagramFunc_setSender_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_port);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkDatagramFunc_setSender_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        quint16 cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setSender(QHostAddress,quint16)
            cppSelf->setSender(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkDatagramFunc_setSender_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkDatagramFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkDatagram.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkDatagram::swap(QNetworkDatagram&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QNetworkDatagram&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkDatagramFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkDatagram cppArg0_local;
        ::QNetworkDatagram *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QNetworkDatagram&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkDatagramFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkDatagram___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNetworkDatagram_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkDatagram_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_clear), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_data), METH_NOARGS},
    {"destinationAddress", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_destinationAddress), METH_NOARGS},
    {"destinationPort", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_destinationPort), METH_NOARGS},
    {"hopLimit", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_hopLimit), METH_NOARGS},
    {"interfaceIndex", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_interfaceIndex), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_isNull), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_isValid), METH_NOARGS},
    {"makeReply", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_makeReply), METH_O},
    {"senderAddress", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_senderAddress), METH_NOARGS},
    {"senderPort", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_senderPort), METH_NOARGS},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_setData), METH_O},
    {"setDestination", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_setDestination), METH_VARARGS},
    {"setHopLimit", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_setHopLimit), METH_O},
    {"setInterfaceIndex", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_setInterfaceIndex), METH_O},
    {"setSender", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_setSender), METH_VARARGS|METH_KEYWORDS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagramFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QNetworkDatagram___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QNetworkDatagram___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QNetworkDatagram_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkDatagram_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkDatagram_Type = nullptr;
static SbkObjectType *Sbk_QNetworkDatagram_TypeF(void)
{
    return _Sbk_QNetworkDatagram_Type;
}

static PyType_Slot Sbk_QNetworkDatagram_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkDatagram_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkDatagram_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkDatagram_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkDatagram_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QNetworkDatagram___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QNetworkDatagram___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkDatagram_spec = {
    "2:PySide2.QtNetwork.QNetworkDatagram",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkDatagram_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkDatagram_PythonToCpp_QNetworkDatagram_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkDatagram_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkDatagram_PythonToCpp_QNetworkDatagram_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkDatagram_TypeF())))
        return QNetworkDatagram_PythonToCpp_QNetworkDatagram_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkDatagram_PTR_CppToPython_QNetworkDatagram(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QNetworkDatagram *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QNetworkDatagram_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QNetworkDatagram_COPY_CppToPython_QNetworkDatagram(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QNetworkDatagram_TypeF(), new ::QNetworkDatagram(*reinterpret_cast<const ::QNetworkDatagram *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QNetworkDatagram_PythonToCpp_QNetworkDatagram_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkDatagram *>(cppOut) = *reinterpret_cast< ::QNetworkDatagram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QNetworkDatagram_PythonToCpp_QNetworkDatagram_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkDatagram_TypeF())))
        return QNetworkDatagram_PythonToCpp_QNetworkDatagram_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_constQByteArrayREF_PythonToCpp_QNetworkDatagram(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkDatagram *>(cppOut) = ::QNetworkDatagram( *reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtCore_constQByteArrayREF_PythonToCpp_QNetworkDatagram_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], pyIn))
        return PySide2_QtCore_constQByteArrayREF_PythonToCpp_QNetworkDatagram;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkDatagram_SignatureStrings[] = {
    "2:PySide2.QtNetwork.QNetworkDatagram(self)",
    "1:PySide2.QtNetwork.QNetworkDatagram(self,data:PySide2.QtCore.QByteArray,destinationAddress:PySide2.QtNetwork.QHostAddress=QHostAddress(),port:quint16=0)",
    "0:PySide2.QtNetwork.QNetworkDatagram(self,other:PySide2.QtNetwork.QNetworkDatagram)",
    "PySide2.QtNetwork.QNetworkDatagram.clear(self)",
    "PySide2.QtNetwork.QNetworkDatagram.data(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QNetworkDatagram.destinationAddress(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QNetworkDatagram.destinationPort(self)->int",
    "PySide2.QtNetwork.QNetworkDatagram.hopLimit(self)->int",
    "PySide2.QtNetwork.QNetworkDatagram.interfaceIndex(self)->uint",
    "PySide2.QtNetwork.QNetworkDatagram.isNull(self)->bool",
    "PySide2.QtNetwork.QNetworkDatagram.isValid(self)->bool",
    "1:PySide2.QtNetwork.QNetworkDatagram.makeReply(self,payload:PySide2.QtCore.QByteArray)->PySide2.QtNetwork.QNetworkDatagram",
    "0:PySide2.QtNetwork.QNetworkDatagram.makeReply(self,payload:PySide2.QtCore.QByteArray)->PySide2.QtNetwork.QNetworkDatagram",
    "PySide2.QtNetwork.QNetworkDatagram.senderAddress(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QNetworkDatagram.senderPort(self)->int",
    "PySide2.QtNetwork.QNetworkDatagram.setData(self,data:PySide2.QtCore.QByteArray)",
    "PySide2.QtNetwork.QNetworkDatagram.setDestination(self,address:PySide2.QtNetwork.QHostAddress,port:quint16)",
    "PySide2.QtNetwork.QNetworkDatagram.setHopLimit(self,count:int)",
    "PySide2.QtNetwork.QNetworkDatagram.setInterfaceIndex(self,index:uint)",
    "PySide2.QtNetwork.QNetworkDatagram.setSender(self,address:PySide2.QtNetwork.QHostAddress,port:quint16=0)",
    "PySide2.QtNetwork.QNetworkDatagram.swap(self,other:PySide2.QtNetwork.QNetworkDatagram)",
    "PySide2.QtNetwork.QNetworkDatagram.__copy__()",
    nullptr}; // Sentinel

void init_QNetworkDatagram(PyObject *module)
{
    _Sbk_QNetworkDatagram_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkDatagram",
        "QNetworkDatagram",
        &Sbk_QNetworkDatagram_spec,
        &Shiboken::callCppDestructor< ::QNetworkDatagram >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkDatagram_Type);
    InitSignatureStrings(pyType, QNetworkDatagram_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkDatagram_Type), Sbk_QNetworkDatagram_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKDATAGRAM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkDatagram_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkDatagram_TypeF(),
        QNetworkDatagram_PythonToCpp_QNetworkDatagram_PTR,
        is_QNetworkDatagram_PythonToCpp_QNetworkDatagram_PTR_Convertible,
        QNetworkDatagram_PTR_CppToPython_QNetworkDatagram,
        QNetworkDatagram_COPY_CppToPython_QNetworkDatagram);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkDatagram");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkDatagram*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkDatagram&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkDatagram).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QNetworkDatagram_PythonToCpp_QNetworkDatagram_COPY,
        is_QNetworkDatagram_PythonToCpp_QNetworkDatagram_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQByteArrayREF_PythonToCpp_QNetworkDatagram,
        is_PySide2_QtCore_constQByteArrayREF_PythonToCpp_QNetworkDatagram_Convertible);

    qRegisterMetaType< ::QNetworkDatagram >("QNetworkDatagram");
}
