/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qssl_wrapper.h"

// inner classes

// Extra includes
#include <qssl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {

static const char *Sbk_QSsl_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSsl_methods[] = {

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSsl_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSsl_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSsl_Type = nullptr;
static SbkObjectType *Sbk_QSsl_TypeF(void)
{
    return _Sbk_QSsl_Type;
}

static PyType_Slot Sbk_QSsl_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSsl_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSsl_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSsl_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSsl_spec = {
    "2:PySide2.QtNetwork.QSsl",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSsl_slots
};

} //extern "C"

PyObject *SbkPySide2_QtNetwork_QSsl_SslOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QSsl::SslOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSsl::SslOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSsl::SslOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSsl::SslOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSsl::SslOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QSsl_SslOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QSsl::SslOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSsl::SslOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSsl::SslOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSsl::SslOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSsl::SslOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QSsl_SslOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSsl::SslOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSsl::SslOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSsl::SslOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSsl::SslOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSsl::SslOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QSsl_SslOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSsl::SslOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX])->converter, self, &cppSelf);
    ::QSsl::SslOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QSsl_SslOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QSsl_SslOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QSsl_SslOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QSsl_SslOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSsl_KeyType_PythonToCpp_QSsl_KeyType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSsl::KeyType *>(cppOut) =
        static_cast<::QSsl::KeyType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSsl_KeyType_PythonToCpp_QSsl_KeyType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX]))
        return QSsl_KeyType_PythonToCpp_QSsl_KeyType;
    return {};
}
static PyObject *QSsl_KeyType_CppToPython_QSsl_KeyType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSsl::KeyType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX], castCppIn);

}

static void QSsl_EncodingFormat_PythonToCpp_QSsl_EncodingFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSsl::EncodingFormat *>(cppOut) =
        static_cast<::QSsl::EncodingFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSsl_EncodingFormat_PythonToCpp_QSsl_EncodingFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX]))
        return QSsl_EncodingFormat_PythonToCpp_QSsl_EncodingFormat;
    return {};
}
static PyObject *QSsl_EncodingFormat_CppToPython_QSsl_EncodingFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSsl::EncodingFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX], castCppIn);

}

static void QSsl_KeyAlgorithm_PythonToCpp_QSsl_KeyAlgorithm(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSsl::KeyAlgorithm *>(cppOut) =
        static_cast<::QSsl::KeyAlgorithm>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSsl_KeyAlgorithm_PythonToCpp_QSsl_KeyAlgorithm_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX]))
        return QSsl_KeyAlgorithm_PythonToCpp_QSsl_KeyAlgorithm;
    return {};
}
static PyObject *QSsl_KeyAlgorithm_CppToPython_QSsl_KeyAlgorithm(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSsl::KeyAlgorithm *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX], castCppIn);

}

static void QSsl_AlternativeNameEntryType_PythonToCpp_QSsl_AlternativeNameEntryType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSsl::AlternativeNameEntryType *>(cppOut) =
        static_cast<::QSsl::AlternativeNameEntryType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSsl_AlternativeNameEntryType_PythonToCpp_QSsl_AlternativeNameEntryType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX]))
        return QSsl_AlternativeNameEntryType_PythonToCpp_QSsl_AlternativeNameEntryType;
    return {};
}
static PyObject *QSsl_AlternativeNameEntryType_CppToPython_QSsl_AlternativeNameEntryType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSsl::AlternativeNameEntryType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX], castCppIn);

}

static void QSsl_SslProtocol_PythonToCpp_QSsl_SslProtocol(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSsl::SslProtocol *>(cppOut) =
        static_cast<::QSsl::SslProtocol>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSsl_SslProtocol_PythonToCpp_QSsl_SslProtocol_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX]))
        return QSsl_SslProtocol_PythonToCpp_QSsl_SslProtocol;
    return {};
}
static PyObject *QSsl_SslProtocol_CppToPython_QSsl_SslProtocol(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSsl::SslProtocol *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX], castCppIn);

}

static void QSsl_SslOption_PythonToCpp_QSsl_SslOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSsl::SslOption *>(cppOut) =
        static_cast<::QSsl::SslOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSsl_SslOption_PythonToCpp_QSsl_SslOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX]))
        return QSsl_SslOption_PythonToCpp_QSsl_SslOption;
    return {};
}
static PyObject *QSsl_SslOption_CppToPython_QSsl_SslOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSsl::SslOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX], castCppIn);

}

static void QFlags_QSsl_SslOption__PythonToCpp_QFlags_QSsl_SslOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSsl::SslOption> *>(cppOut) =
        ::QFlags<QSsl::SslOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSsl_SslOption__PythonToCpp_QFlags_QSsl_SslOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX]))
        return QFlags_QSsl_SslOption__PythonToCpp_QFlags_QSsl_SslOption_;
    return {};
}
static PyObject *QFlags_QSsl_SslOption__CppToPython_QFlags_QSsl_SslOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSsl::SslOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX]));

}

static void QSsl_SslOption_PythonToCpp_QFlags_QSsl_SslOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSsl::SslOption> *>(cppOut) =
        ::QFlags<QSsl::SslOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSsl_SslOption_PythonToCpp_QFlags_QSsl_SslOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX]))
        return QSsl_SslOption_PythonToCpp_QFlags_QSsl_SslOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QSsl_SslOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSsl::SslOption> *>(cppOut) =
        ::QFlags<QSsl::SslOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSsl_SslOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX]))
        return number_PythonToCpp_QFlags_QSsl_SslOption_;
    return {};
}
// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtNetworkQSsl_SignatureStrings[] = {
    nullptr}; // Sentinel

void init_QtNetworkQSsl(PyObject *module)
{
    _Sbk_QSsl_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSsl",
        "QSsl",
        &Sbk_QSsl_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSsl_Type);
    InitSignatureStrings(pyType, QtNetworkQSsl_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSsl_Type), Sbk_QSsl_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QtNetworkQSSL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSsl_TypeF());


    // Initialization of enums.

    // Initialization of enum 'KeyType'.
    SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSsl_TypeF(),
        "KeyType",
        "2:PySide2.QtNetwork.QSsl.KeyType",
        "QSsl::KeyType");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX],
        Sbk_QSsl_TypeF(), "PrivateKey", (long) QSsl::KeyType::PrivateKey))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX],
        Sbk_QSsl_TypeF(), "PublicKey", (long) QSsl::KeyType::PublicKey))
        return;
    // Register converter for enum 'QSsl::KeyType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX],
            QSsl_KeyType_CppToPython_QSsl_KeyType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSsl_KeyType_PythonToCpp_QSsl_KeyType,
            is_QSsl_KeyType_PythonToCpp_QSsl_KeyType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSsl::KeyType");
        Shiboken::Conversions::registerConverterName(converter, "KeyType");
    }
    // End of 'KeyType' enum.

    // Initialization of enum 'EncodingFormat'.
    SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSsl_TypeF(),
        "EncodingFormat",
        "2:PySide2.QtNetwork.QSsl.EncodingFormat",
        "QSsl::EncodingFormat");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX],
        Sbk_QSsl_TypeF(), "Pem", (long) QSsl::EncodingFormat::Pem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX],
        Sbk_QSsl_TypeF(), "Der", (long) QSsl::EncodingFormat::Der))
        return;
    // Register converter for enum 'QSsl::EncodingFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX],
            QSsl_EncodingFormat_CppToPython_QSsl_EncodingFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSsl_EncodingFormat_PythonToCpp_QSsl_EncodingFormat,
            is_QSsl_EncodingFormat_PythonToCpp_QSsl_EncodingFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSsl::EncodingFormat");
        Shiboken::Conversions::registerConverterName(converter, "EncodingFormat");
    }
    // End of 'EncodingFormat' enum.

    // Initialization of enum 'KeyAlgorithm'.
    SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSsl_TypeF(),
        "KeyAlgorithm",
        "2:PySide2.QtNetwork.QSsl.KeyAlgorithm",
        "QSsl::KeyAlgorithm");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX],
        Sbk_QSsl_TypeF(), "Opaque", (long) QSsl::KeyAlgorithm::Opaque))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX],
        Sbk_QSsl_TypeF(), "Rsa", (long) QSsl::KeyAlgorithm::Rsa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX],
        Sbk_QSsl_TypeF(), "Dsa", (long) QSsl::KeyAlgorithm::Dsa))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX],
        Sbk_QSsl_TypeF(), "Ec", (long) QSsl::KeyAlgorithm::Ec))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX],
        Sbk_QSsl_TypeF(), "Dh", (long) QSsl::KeyAlgorithm::Dh))
        return;
    // Register converter for enum 'QSsl::KeyAlgorithm'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX],
            QSsl_KeyAlgorithm_CppToPython_QSsl_KeyAlgorithm);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSsl_KeyAlgorithm_PythonToCpp_QSsl_KeyAlgorithm,
            is_QSsl_KeyAlgorithm_PythonToCpp_QSsl_KeyAlgorithm_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_KEYALGORITHM_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSsl::KeyAlgorithm");
        Shiboken::Conversions::registerConverterName(converter, "KeyAlgorithm");
    }
    // End of 'KeyAlgorithm' enum.

    // Initialization of enum 'AlternativeNameEntryType'.
    SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSsl_TypeF(),
        "AlternativeNameEntryType",
        "2:PySide2.QtNetwork.QSsl.AlternativeNameEntryType",
        "QSsl::AlternativeNameEntryType");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX],
        Sbk_QSsl_TypeF(), "EmailEntry", (long) QSsl::AlternativeNameEntryType::EmailEntry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX],
        Sbk_QSsl_TypeF(), "DnsEntry", (long) QSsl::AlternativeNameEntryType::DnsEntry))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX],
        Sbk_QSsl_TypeF(), "IpAddressEntry", (long) QSsl::AlternativeNameEntryType::IpAddressEntry))
        return;
    // Register converter for enum 'QSsl::AlternativeNameEntryType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX],
            QSsl_AlternativeNameEntryType_CppToPython_QSsl_AlternativeNameEntryType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSsl_AlternativeNameEntryType_PythonToCpp_QSsl_AlternativeNameEntryType,
            is_QSsl_AlternativeNameEntryType_PythonToCpp_QSsl_AlternativeNameEntryType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSsl::AlternativeNameEntryType");
        Shiboken::Conversions::registerConverterName(converter, "AlternativeNameEntryType");
    }
    // End of 'AlternativeNameEntryType' enum.

    // Initialization of enum 'SslProtocol'.
    SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSsl_TypeF(),
        "SslProtocol",
        "2:PySide2.QtNetwork.QSsl.SslProtocol",
        "QSsl::SslProtocol");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "SslV3", (long) QSsl::SslProtocol::SslV3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "SslV2", (long) QSsl::SslProtocol::SslV2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "TlsV1_0", (long) QSsl::SslProtocol::TlsV1_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "TlsV1_1", (long) QSsl::SslProtocol::TlsV1_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "TlsV1_2", (long) QSsl::SslProtocol::TlsV1_2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "AnyProtocol", (long) QSsl::SslProtocol::AnyProtocol))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "TlsV1SslV3", (long) QSsl::SslProtocol::TlsV1SslV3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "SecureProtocols", (long) QSsl::SslProtocol::SecureProtocols))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "TlsV1_0OrLater", (long) QSsl::SslProtocol::TlsV1_0OrLater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "TlsV1_1OrLater", (long) QSsl::SslProtocol::TlsV1_1OrLater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "TlsV1_2OrLater", (long) QSsl::SslProtocol::TlsV1_2OrLater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "DtlsV1_0", (long) QSsl::SslProtocol::DtlsV1_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "DtlsV1_0OrLater", (long) QSsl::SslProtocol::DtlsV1_0OrLater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "DtlsV1_2", (long) QSsl::SslProtocol::DtlsV1_2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "DtlsV1_2OrLater", (long) QSsl::SslProtocol::DtlsV1_2OrLater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "TlsV1_3", (long) QSsl::SslProtocol::TlsV1_3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "TlsV1_3OrLater", (long) QSsl::SslProtocol::TlsV1_3OrLater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
        Sbk_QSsl_TypeF(), "UnknownProtocol", (long) QSsl::SslProtocol::UnknownProtocol))
        return;
    // Register converter for enum 'QSsl::SslProtocol'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX],
            QSsl_SslProtocol_CppToPython_QSsl_SslProtocol);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSsl_SslProtocol_PythonToCpp_QSsl_SslProtocol,
            is_QSsl_SslProtocol_PythonToCpp_QSsl_SslProtocol_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSsl::SslProtocol");
        Shiboken::Conversions::registerConverterName(converter, "SslProtocol");
    }
    // End of 'SslProtocol' enum.

    // Initialization of enum 'SslOption'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QSsl.SslOptions", SbkPySide2_QtNetwork_QSsl_SslOption_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSsl_TypeF(),
        "SslOption",
        "2:PySide2.QtNetwork.QSsl.SslOption",
        "QSsl::SslOption",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX],
        Sbk_QSsl_TypeF(), "SslOptionDisableEmptyFragments", (long) QSsl::SslOption::SslOptionDisableEmptyFragments))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX],
        Sbk_QSsl_TypeF(), "SslOptionDisableSessionTickets", (long) QSsl::SslOption::SslOptionDisableSessionTickets))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX],
        Sbk_QSsl_TypeF(), "SslOptionDisableCompression", (long) QSsl::SslOption::SslOptionDisableCompression))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX],
        Sbk_QSsl_TypeF(), "SslOptionDisableServerNameIndication", (long) QSsl::SslOption::SslOptionDisableServerNameIndication))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX],
        Sbk_QSsl_TypeF(), "SslOptionDisableLegacyRenegotiation", (long) QSsl::SslOption::SslOptionDisableLegacyRenegotiation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX],
        Sbk_QSsl_TypeF(), "SslOptionDisableSessionSharing", (long) QSsl::SslOption::SslOptionDisableSessionSharing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX],
        Sbk_QSsl_TypeF(), "SslOptionDisableSessionPersistence", (long) QSsl::SslOption::SslOptionDisableSessionPersistence))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX],
        Sbk_QSsl_TypeF(), "SslOptionDisableServerCipherPreference", (long) QSsl::SslOption::SslOptionDisableServerCipherPreference))
        return;
    // Register converter for enum 'QSsl::SslOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX],
            QSsl_SslOption_CppToPython_QSsl_SslOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSsl_SslOption_PythonToCpp_QSsl_SslOption,
            is_QSsl_SslOption_PythonToCpp_QSsl_SslOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSsl::SslOption");
        Shiboken::Conversions::registerConverterName(converter, "SslOption");
    }
    // Register converter for flag 'QFlags<QSsl::SslOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX],
            QFlags_QSsl_SslOption__CppToPython_QFlags_QSsl_SslOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSsl_SslOption_PythonToCpp_QFlags_QSsl_SslOption_,
            is_QSsl_SslOption_PythonToCpp_QFlags_QSsl_SslOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSsl_SslOption__PythonToCpp_QFlags_QSsl_SslOption_,
            is_QFlags_QSsl_SslOption__PythonToCpp_QFlags_QSsl_SslOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSsl_SslOption_,
            is_number_PythonToCpp_QFlags_QSsl_SslOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QSSL_SSLOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSsl::SslOptions");
        Shiboken::Conversions::registerConverterName(converter, "SslOptions");
    }
    // End of 'SslOption' enum/flags.

    qRegisterMetaType< ::QSsl::KeyType >("QSsl::KeyType");
    qRegisterMetaType< ::QSsl::EncodingFormat >("QSsl::EncodingFormat");
    qRegisterMetaType< ::QSsl::KeyAlgorithm >("QSsl::KeyAlgorithm");
    qRegisterMetaType< ::QSsl::AlternativeNameEntryType >("QSsl::AlternativeNameEntryType");
    qRegisterMetaType< ::QSsl::SslProtocol >("QSsl::SslProtocol");
    qRegisterMetaType< ::QSsl::SslOption >("QSsl::SslOption");
    qRegisterMetaType< ::QSsl::SslOptions >("QSsl::SslOptions");
}
