/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopengl_python.h"

// main header
#include "qgl_wrapper.h"

// inner classes

// Extra includes
#include <qgl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {

static const char *Sbk_QGL_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGL_methods[] = {

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QGL_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGL_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGL_Type = nullptr;
static SbkObjectType *Sbk_QGL_TypeF(void)
{
    return _Sbk_QGL_Type;
}

static PyType_Slot Sbk_QGL_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGL_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGL_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGL_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGL_spec = {
    "2:PySide2.QtOpenGL.QGL",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGL_slots
};

} //extern "C"

PyObject *SbkPySide2_QtOpenGL_QGL_FormatOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QGL::FormatOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGL::FormatOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGL::FormatOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGL::FormatOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGL::FormatOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtOpenGL_QGL_FormatOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QGL::FormatOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGL::FormatOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGL::FormatOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGL::FormatOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGL::FormatOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtOpenGL_QGL_FormatOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGL::FormatOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGL::FormatOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGL::FormatOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGL::FormatOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGL::FormatOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtOpenGL_QGL_FormatOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGL::FormatOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, self, &cppSelf);
    ::QGL::FormatOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtOpenGL_QGL_FormatOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtOpenGL_QGL_FormatOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtOpenGL_QGL_FormatOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGL_FormatOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGL_FormatOption_PythonToCpp_QGL_FormatOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGL::FormatOption *>(cppOut) =
        static_cast<::QGL::FormatOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGL_FormatOption_PythonToCpp_QGL_FormatOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX]))
        return QGL_FormatOption_PythonToCpp_QGL_FormatOption;
    return {};
}
static PyObject *QGL_FormatOption_CppToPython_QGL_FormatOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGL::FormatOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX], castCppIn);

}

static void QFlags_QGL_FormatOption__PythonToCpp_QFlags_QGL_FormatOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGL::FormatOption> *>(cppOut) =
        ::QFlags<QGL::FormatOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGL_FormatOption__PythonToCpp_QFlags_QGL_FormatOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX]))
        return QFlags_QGL_FormatOption__PythonToCpp_QFlags_QGL_FormatOption_;
    return {};
}
static PyObject *QFlags_QGL_FormatOption__CppToPython_QFlags_QGL_FormatOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGL::FormatOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX]));

}

static void QGL_FormatOption_PythonToCpp_QFlags_QGL_FormatOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGL::FormatOption> *>(cppOut) =
        ::QFlags<QGL::FormatOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGL_FormatOption_PythonToCpp_QFlags_QGL_FormatOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX]))
        return QGL_FormatOption_PythonToCpp_QFlags_QGL_FormatOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QGL_FormatOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGL::FormatOption> *>(cppOut) =
        ::QFlags<QGL::FormatOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGL_FormatOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX]))
        return number_PythonToCpp_QFlags_QGL_FormatOption_;
    return {};
}
// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtOpenGLQGL_SignatureStrings[] = {
    nullptr}; // Sentinel

void init_QtOpenGLQGL(PyObject *module)
{
    _Sbk_QGL_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGL",
        "QGL",
        &Sbk_QGL_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGL_Type);
    InitSignatureStrings(pyType, QtOpenGLQGL_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGL_Type), Sbk_QGL_PropertyStrings);
    SbkPySide2_QtOpenGLTypes[SBK_QtOpenGLQGL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGL_TypeF());


    // Initialization of enums.

    // Initialization of enum 'FormatOption'.
    SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtOpenGL.QGL.FormatOptions", SbkPySide2_QtOpenGL_QGL_FormatOption_number_slots);
    SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGL_TypeF(),
        "FormatOption",
        "2:PySide2.QtOpenGL.QGL.FormatOption",
        "QGL::FormatOption",
        SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX]);
    if (!SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "DoubleBuffer", (long) QGL::FormatOption::DoubleBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "DepthBuffer", (long) QGL::FormatOption::DepthBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "Rgba", (long) QGL::FormatOption::Rgba))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "AlphaChannel", (long) QGL::FormatOption::AlphaChannel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "AccumBuffer", (long) QGL::FormatOption::AccumBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "StencilBuffer", (long) QGL::FormatOption::StencilBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "StereoBuffers", (long) QGL::FormatOption::StereoBuffers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "DirectRendering", (long) QGL::FormatOption::DirectRendering))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "HasOverlay", (long) QGL::FormatOption::HasOverlay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "SampleBuffers", (long) QGL::FormatOption::SampleBuffers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "DeprecatedFunctions", (long) QGL::FormatOption::DeprecatedFunctions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "SingleBuffer", (long) QGL::FormatOption::SingleBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "NoDepthBuffer", (long) QGL::FormatOption::NoDepthBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "ColorIndex", (long) QGL::FormatOption::ColorIndex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "NoAlphaChannel", (long) QGL::FormatOption::NoAlphaChannel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "NoAccumBuffer", (long) QGL::FormatOption::NoAccumBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "NoStencilBuffer", (long) QGL::FormatOption::NoStencilBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "NoStereoBuffers", (long) QGL::FormatOption::NoStereoBuffers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "IndirectRendering", (long) QGL::FormatOption::IndirectRendering))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "NoOverlay", (long) QGL::FormatOption::NoOverlay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "NoSampleBuffers", (long) QGL::FormatOption::NoSampleBuffers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
        Sbk_QGL_TypeF(), "NoDeprecatedFunctions", (long) QGL::FormatOption::NoDeprecatedFunctions))
        return;
    // Register converter for enum 'QGL::FormatOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX],
            QGL_FormatOption_CppToPython_QGL_FormatOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGL_FormatOption_PythonToCpp_QGL_FormatOption,
            is_QGL_FormatOption_PythonToCpp_QGL_FormatOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QGL_FORMATOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGL::FormatOption");
        Shiboken::Conversions::registerConverterName(converter, "FormatOption");
    }
    // Register converter for flag 'QFlags<QGL::FormatOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX],
            QFlags_QGL_FormatOption__CppToPython_QFlags_QGL_FormatOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGL_FormatOption_PythonToCpp_QFlags_QGL_FormatOption_,
            is_QGL_FormatOption_PythonToCpp_QFlags_QGL_FormatOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGL_FormatOption__PythonToCpp_QFlags_QGL_FormatOption_,
            is_QFlags_QGL_FormatOption__PythonToCpp_QFlags_QGL_FormatOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGL_FormatOption_,
            is_number_PythonToCpp_QFlags_QGL_FormatOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGL::FormatOptions");
        Shiboken::Conversions::registerConverterName(converter, "FormatOptions");
    }
    // End of 'FormatOption' enum/flags.

    qRegisterMetaType< ::QGL::FormatOption >("QGL::FormatOption");
    qRegisterMetaType< ::QGL::FormatOptions >("QGL::FormatOptions");
}
