/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopengl_python.h"

// main header
#include "qglframebufferobject_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGLFramebufferObjectWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(const ::QSize & size, GLenum target) : QGLFramebufferObject(size, target)
{
    resetPyMethodCache();
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(const ::QSize & size, ::QGLFramebufferObject::Attachment attachment, GLenum target, GLenum internal_format) : QGLFramebufferObject(size, attachment, target, internal_format)
{
    resetPyMethodCache();
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(const ::QSize & size, const ::QGLFramebufferObjectFormat & format) : QGLFramebufferObject(size, format)
{
    resetPyMethodCache();
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(int width, int height, GLenum target) : QGLFramebufferObject(width, height, target)
{
    resetPyMethodCache();
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(int width, int height, ::QGLFramebufferObject::Attachment attachment, GLenum target, GLenum internal_format) : QGLFramebufferObject(width, height, attachment, target, internal_format)
{
    resetPyMethodCache();
    // ... middle
}

QGLFramebufferObjectWrapper::QGLFramebufferObjectWrapper(int width, int height, const ::QGLFramebufferObjectFormat & format) : QGLFramebufferObject(width, height, format)
{
    resetPyMethodCache();
    // ... middle
}

int QGLFramebufferObjectWrapper::devType() const
{
    if (m_PyMethodCache[0])
        return this->::QGLFramebufferObject::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGLFramebufferObject::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLFramebufferObject.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGLFramebufferObjectWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[1]) {
        return this->::QPaintDevice::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QPaintDevice::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

int QGLFramebufferObjectWrapper::metric(::QPaintDevice::PaintDeviceMetric metric) const
{
    if (m_PyMethodCache[2])
        return this->::QGLFramebufferObject::metric(metric);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QGLFramebufferObject::metric(metric);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &metric)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLFramebufferObject.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintEngine * QGLFramebufferObjectWrapper::paintEngine() const
{
    if (m_PyMethodCache[3])
        return this->::QGLFramebufferObject::paintEngine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QGLFramebufferObject::paintEngine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLFramebufferObject.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintDevice * QGLFramebufferObjectWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[4])
        return this->::QPaintDevice::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QPaintDevice::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLFramebufferObject.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPainter * QGLFramebufferObjectWrapper::sharedPainter() const
{
    if (m_PyMethodCache[5])
        return this->::QPaintDevice::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QPaintDevice::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLFramebufferObject.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QGLFramebufferObjectWrapper::~QGLFramebufferObjectWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGLFramebufferObject_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGLFramebufferObject >()))
        return -1;

    ::QGLFramebufferObjectWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLFramebufferObject_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLFramebufferObject_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:QGLFramebufferObject", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QGLFramebufferObject::QGLFramebufferObject(QSize,GLenum)
    // 1: QGLFramebufferObject::QGLFramebufferObject(QSize,QGLFramebufferObject::Attachment,GLenum,GLenum)
    // 2: QGLFramebufferObject::QGLFramebufferObject(QSize,QGLFramebufferObjectFormat)
    // 3: QGLFramebufferObject::QGLFramebufferObject(int,int,GLenum)
    // 4: QGLFramebufferObject::QGLFramebufferObject(int,int,QGLFramebufferObject::Attachment,GLenum,GLenum)
    // 5: QGLFramebufferObject::QGLFramebufferObject(int,int,QGLFramebufferObjectFormat)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 3; // QGLFramebufferObject(int,int,GLenum)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), (pyArgs[2])))) {
            overloadId = 5; // QGLFramebufferObject(int,int,QGLFramebufferObjectFormat)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 4; // QGLFramebufferObject(int,int,QGLFramebufferObject::Attachment,GLenum,GLenum)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 4; // QGLFramebufferObject(int,int,QGLFramebufferObject::Attachment,GLenum,GLenum)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[4])))) {
                    overloadId = 4; // QGLFramebufferObject(int,int,QGLFramebufferObject::Attachment,GLenum,GLenum)
                }
            }
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2])))) {
            overloadId = 3; // QGLFramebufferObject(int,int,GLenum)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QGLFramebufferObject(QSize,GLenum)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QGLFramebufferObject(QSize,QGLFramebufferObjectFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // QGLFramebufferObject(QSize,QGLFramebufferObject::Attachment,GLenum,GLenum)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // QGLFramebufferObject(QSize,QGLFramebufferObject::Attachment,GLenum,GLenum)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[3])))) {
                    overloadId = 1; // QGLFramebufferObject(QSize,QGLFramebufferObject::Attachment,GLenum,GLenum)
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1])))) {
            overloadId = 0; // QGLFramebufferObject(QSize,GLenum)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObject_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGLFramebufferObject(const QSize & size, GLenum target)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[1]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1]))))
                            goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLFramebufferObject_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLenum cppArg1 = GL_TEXTURE_2D;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QGLFramebufferObject(QSize,GLenum)
                cptr = new ::QGLFramebufferObjectWrapper(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // QGLFramebufferObject(const QSize & size, QGLFramebufferObject::Attachment attachment, GLenum target, GLenum internal_format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[2]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2]))))
                            goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                static PyObject *const key_internal_format = Shiboken::String::createStaticString("internal_format");
                if (PyDict_Contains(kwds, key_internal_format)) {
                    value = PyDict_GetItem(kwds, key_internal_format);
                    if (value && pyArgs[3]) {
                        errInfo = key_internal_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[3]))))
                            goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_internal_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLFramebufferObject_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QGLFramebufferObject::Attachment cppArg1{QGLFramebufferObject::NoAttachment};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLenum cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            GLenum cppArg3 = 0;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QGLFramebufferObject(QSize,QGLFramebufferObject::Attachment,GLenum,GLenum)
                cptr = new ::QGLFramebufferObjectWrapper(*cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // QGLFramebufferObject(const QSize & size, const QGLFramebufferObjectFormat & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGLFramebufferObject_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QGLFramebufferObjectFormat cppArg1_local;
            ::QGLFramebufferObjectFormat *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QGLFramebufferObject(QSize,QGLFramebufferObjectFormat)
                cptr = new ::QGLFramebufferObjectWrapper(*cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // QGLFramebufferObject(int width, int height, GLenum target)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[2]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2]))))
                            goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLFramebufferObject_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLenum cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QGLFramebufferObject(int,int,GLenum)
                cptr = new ::QGLFramebufferObjectWrapper(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 4: // QGLFramebufferObject(int width, int height, QGLFramebufferObject::Attachment attachment, GLenum target, GLenum internal_format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[3]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[3]))))
                            goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                static PyObject *const key_internal_format = Shiboken::String::createStaticString("internal_format");
                if (PyDict_Contains(kwds, key_internal_format)) {
                    value = PyDict_GetItem(kwds, key_internal_format);
                    if (value && pyArgs[4]) {
                        errInfo = key_internal_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[4]))))
                            goto Sbk_QGLFramebufferObject_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_internal_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLFramebufferObject_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QGLFramebufferObject::Attachment cppArg2{QGLFramebufferObject::NoAttachment};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            GLenum cppArg3 = GL_TEXTURE_2D;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            GLenum cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QGLFramebufferObject(int,int,QGLFramebufferObject::Attachment,GLenum,GLenum)
                cptr = new ::QGLFramebufferObjectWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 5: // QGLFramebufferObject(int width, int height, const QGLFramebufferObjectFormat & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGLFramebufferObject_Init_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QGLFramebufferObjectFormat cppArg2_local;
            ::QGLFramebufferObjectFormat *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // QGLFramebufferObject(int,int,QGLFramebufferObjectFormat)
                cptr = new ::QGLFramebufferObjectWrapper(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGLFramebufferObject >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGLFramebufferObject_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGLFramebufferObject_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_attachment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.attachment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // attachment()const
            QGLFramebufferObject::Attachment cppResult = const_cast<const ::QGLFramebufferObject *>(cppSelf)->attachment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_bind(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.bind";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bind()
            bool cppResult = cppSelf->bind();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_bindDefault(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.bindDefault";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bindDefault()
            bool cppResult = ::QGLFramebufferObject::bindDefault();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_blitFramebuffer(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.blitFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLFramebufferObjectFunc_blitFramebuffer_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLFramebufferObjectFunc_blitFramebuffer_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:blitFramebuffer", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: static QGLFramebufferObject::blitFramebuffer(QGLFramebufferObject*,QRect,QGLFramebufferObject*,QRect,GLbitfield,GLenum)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // blitFramebuffer(QGLFramebufferObject*,QRect,QGLFramebufferObject*,QRect,GLbitfield,GLenum)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLbitfield>(), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 0; // blitFramebuffer(QGLFramebufferObject*,QRect,QGLFramebufferObject*,QRect,GLbitfield,GLenum)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[5])))) {
                overloadId = 0; // blitFramebuffer(QGLFramebufferObject*,QRect,QGLFramebufferObject*,QRect,GLbitfield,GLenum)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObjectFunc_blitFramebuffer_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_buffers = Shiboken::String::createStaticString("buffers");
            if (PyDict_Contains(kwds, key_buffers)) {
                value = PyDict_GetItem(kwds, key_buffers);
                if (value && pyArgs[4]) {
                    errInfo = key_buffers;
                    Py_INCREF(errInfo);
                    goto Sbk_QGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLbitfield>(), (pyArgs[4]))))
                        goto Sbk_QGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_buffers);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[5]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[5]))))
                        goto Sbk_QGLFramebufferObjectFunc_blitFramebuffer_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGLFramebufferObjectFunc_blitFramebuffer_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGLFramebufferObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QGLFramebufferObject *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QRect cppArg3_local;
        ::QRect *cppArg3 = &cppArg3_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[3]))
            pythonToCpp[3](pyArgs[3], &cppArg3_local);
        else
            pythonToCpp[3](pyArgs[3], &cppArg3);

        GLbitfield cppArg4 = GL_COLOR_BUFFER_BIT;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        GLenum cppArg5 = GL_NEAREST;
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // blitFramebuffer(QGLFramebufferObject*,QRect,QGLFramebufferObject*,QRect,GLbitfield,GLenum)
            ::QGLFramebufferObject::blitFramebuffer(cppArg0, *cppArg1, cppArg2, *cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFramebufferObjectFunc_blitFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFramebufferObjectFunc_devType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.devType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devType()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGLFramebufferObject *>(cppSelf)->::QGLFramebufferObject::devType()
                : const_cast<const ::QGLFramebufferObject *>(cppSelf)->devType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_drawTexture(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.drawTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:drawTexture", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGLFramebufferObject::drawTexture(QPointF,GLuint,GLenum)
    // 1: QGLFramebufferObject::drawTexture(QRectF,GLuint,GLenum)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // drawTexture(QRectF,GLuint,GLenum)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2])))) {
            overloadId = 1; // drawTexture(QRectF,GLuint,GLenum)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // drawTexture(QPointF,GLuint,GLenum)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2])))) {
            overloadId = 0; // drawTexture(QPointF,GLuint,GLenum)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawTexture(const QPointF & point, GLuint textureId, GLenum textureTarget)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_textureTarget = Shiboken::String::createStaticString("textureTarget");
                if (PyDict_Contains(kwds, key_textureTarget)) {
                    value = PyDict_GetItem(kwds, key_textureTarget);
                    if (value && pyArgs[2]) {
                        errInfo = key_textureTarget;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2]))))
                            goto Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_textureTarget);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLuint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLenum cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawTexture(QPointF,GLuint,GLenum)
                cppSelf->drawTexture(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // drawTexture(const QRectF & target, GLuint textureId, GLenum textureTarget)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_textureTarget = Shiboken::String::createStaticString("textureTarget");
                if (PyDict_Contains(kwds, key_textureTarget)) {
                    value = PyDict_GetItem(kwds, key_textureTarget);
                    if (value && pyArgs[2]) {
                        errInfo = key_textureTarget;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2]))))
                            goto Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_textureTarget);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLuint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLenum cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawTexture(QRectF,GLuint,GLenum)
                cppSelf->drawTexture(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFramebufferObjectFunc_drawTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFramebufferObjectFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QGLFramebufferObjectFormat cppResult = const_cast<const ::QGLFramebufferObject *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()const
            GLuint cppResult = const_cast<const ::QGLFramebufferObject *>(cppSelf)->handle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_hasOpenGLFramebufferBlit(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.hasOpenGLFramebufferBlit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasOpenGLFramebufferBlit()
            bool cppResult = ::QGLFramebufferObject::hasOpenGLFramebufferBlit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_hasOpenGLFramebufferObjects(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.hasOpenGLFramebufferObjects";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasOpenGLFramebufferObjects()
            bool cppResult = ::QGLFramebufferObject::hasOpenGLFramebufferObjects();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_isBound(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.isBound";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBound()const
            bool cppResult = const_cast<const ::QGLFramebufferObject *>(cppSelf)->isBound();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QGLFramebufferObject *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_metric(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.metric";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // metric(QPaintDevice::PaintDeviceMetric)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObjectFunc_metric_TypeError;

    // Call function/method
    {
        ::QPaintDevice::PaintDeviceMetric cppArg0 = static_cast< ::QPaintDevice::PaintDeviceMetric>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // metric(QPaintDevice::PaintDeviceMetric)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGLFramebufferObject *>(cppSelf)->::QGLFramebufferObject::metric(cppArg0)
                : const_cast<const ::QGLFramebufferObject *>(cppSelf)->metric(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLFramebufferObjectFunc_metric_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFramebufferObjectFunc_paintEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.paintEngine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paintEngine()const
            QPaintEngine * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGLFramebufferObject *>(cppSelf)->::QGLFramebufferObject::paintEngine()
                : const_cast<const ::QGLFramebufferObject *>(cppSelf)->paintEngine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_release(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.release";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // release()
            bool cppResult = cppSelf->release();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSize cppResult = const_cast<const ::QGLFramebufferObject *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_texture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.texture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // texture()const
            GLuint cppResult = const_cast<const ::QGLFramebufferObject *>(cppSelf)->texture();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFunc_toImage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObject.toImage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toImage()const
            QImage cppResult = const_cast<const ::QGLFramebufferObject *>(cppSelf)->toImage();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGLFramebufferObject_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGLFramebufferObject_methods[] = {
    {"attachment", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_attachment), METH_NOARGS},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_bind), METH_NOARGS},
    {"bindDefault", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_bindDefault), METH_NOARGS|METH_STATIC},
    {"blitFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_blitFramebuffer), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"devType", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_devType), METH_NOARGS},
    {"drawTexture", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_drawTexture), METH_VARARGS|METH_KEYWORDS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_format), METH_NOARGS},
    {"handle", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_handle), METH_NOARGS},
    {"hasOpenGLFramebufferBlit", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_hasOpenGLFramebufferBlit), METH_NOARGS|METH_STATIC},
    {"hasOpenGLFramebufferObjects", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_hasOpenGLFramebufferObjects), METH_NOARGS|METH_STATIC},
    {"isBound", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_isBound), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_isValid), METH_NOARGS},
    {"metric", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_metric), METH_O},
    {"paintEngine", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_paintEngine), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_release), METH_NOARGS},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_size), METH_NOARGS},
    {"texture", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_texture), METH_NOARGS},
    {"toImage", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFunc_toImage), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGLFramebufferObject_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGLFramebufferObject *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGLFramebufferObjectWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGLFramebufferObject_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGLFramebufferObject_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGLFramebufferObject_Type = nullptr;
static SbkObjectType *Sbk_QGLFramebufferObject_TypeF(void)
{
    return _Sbk_QGLFramebufferObject_Type;
}

static PyType_Slot Sbk_QGLFramebufferObject_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGLFramebufferObject_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGLFramebufferObject_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGLFramebufferObject_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGLFramebufferObject_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGLFramebufferObject_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGLFramebufferObject_spec = {
    "2:PySide2.QtOpenGL.QGLFramebufferObject",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGLFramebufferObject_slots
};

} //extern "C"

static void *Sbk_QGLFramebufferObject_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QGLFramebufferObject *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QGLFramebufferObject_Attachment_PythonToCpp_QGLFramebufferObject_Attachment(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLFramebufferObject::Attachment *>(cppOut) =
        static_cast<::QGLFramebufferObject::Attachment>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGLFramebufferObject_Attachment_PythonToCpp_QGLFramebufferObject_Attachment_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX]))
        return QGLFramebufferObject_Attachment_PythonToCpp_QGLFramebufferObject_Attachment;
    return {};
}
static PyObject *QGLFramebufferObject_Attachment_CppToPython_QGLFramebufferObject_Attachment(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGLFramebufferObject::Attachment *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGLFramebufferObject_PythonToCpp_QGLFramebufferObject_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGLFramebufferObject_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGLFramebufferObject_PythonToCpp_QGLFramebufferObject_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLFramebufferObject_TypeF())))
        return QGLFramebufferObject_PythonToCpp_QGLFramebufferObject_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGLFramebufferObject_PTR_CppToPython_QGLFramebufferObject(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGLFramebufferObject *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGLFramebufferObject_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGLFramebufferObject_SignatureStrings[] = {
    "5:PySide2.QtOpenGL.QGLFramebufferObject(self,size:PySide2.QtCore.QSize,target:GLenum=GL_TEXTURE_2D)",
    "4:PySide2.QtOpenGL.QGLFramebufferObject(self,size:PySide2.QtCore.QSize,attachment:PySide2.QtOpenGL.QGLFramebufferObject.Attachment,target:GLenum=GL_TEXTURE_2D,internal_format:GLenum=0)",
    "3:PySide2.QtOpenGL.QGLFramebufferObject(self,size:PySide2.QtCore.QSize,format:PySide2.QtOpenGL.QGLFramebufferObjectFormat)",
    "2:PySide2.QtOpenGL.QGLFramebufferObject(self,width:int,height:int,target:GLenum=GL_TEXTURE_2D)",
    "1:PySide2.QtOpenGL.QGLFramebufferObject(self,width:int,height:int,attachment:PySide2.QtOpenGL.QGLFramebufferObject.Attachment,target:GLenum=GL_TEXTURE_2D,internal_format:GLenum=0)",
    "0:PySide2.QtOpenGL.QGLFramebufferObject(self,width:int,height:int,format:PySide2.QtOpenGL.QGLFramebufferObjectFormat)",
    "PySide2.QtOpenGL.QGLFramebufferObject.attachment(self)->PySide2.QtOpenGL.QGLFramebufferObject.Attachment",
    "PySide2.QtOpenGL.QGLFramebufferObject.bind(self)->bool",
    "PySide2.QtOpenGL.QGLFramebufferObject.bindDefault()->bool",
    "PySide2.QtOpenGL.QGLFramebufferObject.blitFramebuffer(target:PySide2.QtOpenGL.QGLFramebufferObject,targetRect:PySide2.QtCore.QRect,source:PySide2.QtOpenGL.QGLFramebufferObject,sourceRect:PySide2.QtCore.QRect,buffers:GLbitfield=GL_COLOR_BUFFER_BIT,filter:GLenum=GL_NEAREST)",
    "PySide2.QtOpenGL.QGLFramebufferObject.devType(self)->int",
    "1:PySide2.QtOpenGL.QGLFramebufferObject.drawTexture(self,point:PySide2.QtCore.QPointF,textureId:GLuint,textureTarget:GLenum=GL_TEXTURE_2D)",
    "0:PySide2.QtOpenGL.QGLFramebufferObject.drawTexture(self,target:PySide2.QtCore.QRectF,textureId:GLuint,textureTarget:GLenum=GL_TEXTURE_2D)",
    "PySide2.QtOpenGL.QGLFramebufferObject.format(self)->PySide2.QtOpenGL.QGLFramebufferObjectFormat",
    "PySide2.QtOpenGL.QGLFramebufferObject.handle(self)->GLuint",
    "PySide2.QtOpenGL.QGLFramebufferObject.hasOpenGLFramebufferBlit()->bool",
    "PySide2.QtOpenGL.QGLFramebufferObject.hasOpenGLFramebufferObjects()->bool",
    "PySide2.QtOpenGL.QGLFramebufferObject.isBound(self)->bool",
    "PySide2.QtOpenGL.QGLFramebufferObject.isValid(self)->bool",
    "PySide2.QtOpenGL.QGLFramebufferObject.metric(self,metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric)->int",
    "PySide2.QtOpenGL.QGLFramebufferObject.paintEngine(self)->PySide2.QtGui.QPaintEngine",
    "PySide2.QtOpenGL.QGLFramebufferObject.release(self)->bool",
    "PySide2.QtOpenGL.QGLFramebufferObject.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtOpenGL.QGLFramebufferObject.texture(self)->GLuint",
    "PySide2.QtOpenGL.QGLFramebufferObject.toImage(self)->PySide2.QtGui.QImage",
    nullptr}; // Sentinel

void init_QGLFramebufferObject(PyObject *module)
{
    _Sbk_QGLFramebufferObject_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGLFramebufferObject",
        "QGLFramebufferObject*",
        &Sbk_QGLFramebufferObject_spec,
        &Shiboken::callCppDestructor< ::QGLFramebufferObject >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGLFramebufferObject_Type);
    InitSignatureStrings(pyType, QGLFramebufferObject_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGLFramebufferObject_Type), Sbk_QGLFramebufferObject_PropertyStrings);
    SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGLFramebufferObject_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGLFramebufferObject_TypeF(),
        QGLFramebufferObject_PythonToCpp_QGLFramebufferObject_PTR,
        is_QGLFramebufferObject_PythonToCpp_QGLFramebufferObject_PTR_Convertible,
        QGLFramebufferObject_PTR_CppToPython_QGLFramebufferObject);

    Shiboken::Conversions::registerConverterName(converter, "QGLFramebufferObject");
    Shiboken::Conversions::registerConverterName(converter, "QGLFramebufferObject*");
    Shiboken::Conversions::registerConverterName(converter, "QGLFramebufferObject&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLFramebufferObject).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLFramebufferObjectWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGLFramebufferObject_TypeF(), &Sbk_QGLFramebufferObject_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Attachment'.
    SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGLFramebufferObject_TypeF(),
        "Attachment",
        "2:PySide2.QtOpenGL.QGLFramebufferObject.Attachment",
        "QGLFramebufferObject::Attachment");
    if (!SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX],
        Sbk_QGLFramebufferObject_TypeF(), "NoAttachment", (long) QGLFramebufferObject::Attachment::NoAttachment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX],
        Sbk_QGLFramebufferObject_TypeF(), "CombinedDepthStencil", (long) QGLFramebufferObject::Attachment::CombinedDepthStencil))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX],
        Sbk_QGLFramebufferObject_TypeF(), "Depth", (long) QGLFramebufferObject::Attachment::Depth))
        return;
    // Register converter for enum 'QGLFramebufferObject::Attachment'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX],
            QGLFramebufferObject_Attachment_CppToPython_QGLFramebufferObject_Attachment);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGLFramebufferObject_Attachment_PythonToCpp_QGLFramebufferObject_Attachment,
            is_QGLFramebufferObject_Attachment_PythonToCpp_QGLFramebufferObject_Attachment_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGLFramebufferObject::Attachment");
        Shiboken::Conversions::registerConverterName(converter, "Attachment");
    }
    // End of 'Attachment' enum.

    qRegisterMetaType< ::QGLFramebufferObject::Attachment >("QGLFramebufferObject::Attachment");
}
