/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopengl_python.h"

// main header
#include "qglpixelbuffer_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGLPixelBufferWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGLPixelBufferWrapper::QGLPixelBufferWrapper(const ::QSize & size, const ::QGLFormat & format, ::QGLWidget * shareWidget) : QGLPixelBuffer(size, format, shareWidget)
{
    resetPyMethodCache();
    // ... middle
}

QGLPixelBufferWrapper::QGLPixelBufferWrapper(int width, int height, const ::QGLFormat & format, ::QGLWidget * shareWidget) : QGLPixelBuffer(width, height, format, shareWidget)
{
    resetPyMethodCache();
    // ... middle
}

int QGLPixelBufferWrapper::devType() const
{
    if (m_PyMethodCache[0])
        return this->::QGLPixelBuffer::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGLPixelBuffer::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLPixelBuffer.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGLPixelBufferWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[1]) {
        return this->::QPaintDevice::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QPaintDevice::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

int QGLPixelBufferWrapper::metric(::QPaintDevice::PaintDeviceMetric metric) const
{
    if (m_PyMethodCache[2])
        return this->::QGLPixelBuffer::metric(metric);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QGLPixelBuffer::metric(metric);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &metric)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLPixelBuffer.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintEngine * QGLPixelBufferWrapper::paintEngine() const
{
    if (m_PyMethodCache[3])
        return this->::QGLPixelBuffer::paintEngine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QGLPixelBuffer::paintEngine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLPixelBuffer.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintDevice * QGLPixelBufferWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[4])
        return this->::QPaintDevice::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QPaintDevice::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLPixelBuffer.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPainter * QGLPixelBufferWrapper::sharedPainter() const
{
    if (m_PyMethodCache[5])
        return this->::QPaintDevice::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QPaintDevice::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLPixelBuffer.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QGLPixelBufferWrapper::~QGLPixelBufferWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGLPixelBuffer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGLPixelBuffer >()))
        return -1;

    ::QGLPixelBufferWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLPixelBuffer_Init_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLPixelBuffer_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QGLPixelBuffer", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QGLPixelBuffer::QGLPixelBuffer(QSize,QGLFormat,QGLWidget*)
    // 1: QGLPixelBuffer::QGLPixelBuffer(int,int,QGLFormat,QGLWidget*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // QGLPixelBuffer(int,int,QGLFormat,QGLWidget*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // QGLPixelBuffer(int,int,QGLFormat,QGLWidget*)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLWIDGET_IDX]), (pyArgs[3])))) {
                overloadId = 1; // QGLPixelBuffer(int,int,QGLFormat,QGLWidget*)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QGLPixelBuffer(QSize,QGLFormat,QGLWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // QGLPixelBuffer(QSize,QGLFormat,QGLWidget*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLWIDGET_IDX]), (pyArgs[2])))) {
                overloadId = 0; // QGLPixelBuffer(QSize,QGLFormat,QGLWidget*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLPixelBuffer_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGLPixelBuffer(const QSize & size, const QGLFormat & format, QGLWidget * shareWidget)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLPixelBuffer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArgs[1]))))
                            goto Sbk_QGLPixelBuffer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_shareWidget = Shiboken::String::createStaticString("shareWidget");
                if (PyDict_Contains(kwds, key_shareWidget)) {
                    value = PyDict_GetItem(kwds, key_shareWidget);
                    if (value && pyArgs[2]) {
                        errInfo = key_shareWidget;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLPixelBuffer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLWIDGET_IDX]), (pyArgs[2]))))
                            goto Sbk_QGLPixelBuffer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_shareWidget);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLPixelBuffer_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QGLFormat cppArg1_local = QGLFormat::defaultFormat();
            ::QGLFormat *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QGLWidget *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QGLPixelBuffer(QSize,QGLFormat,QGLWidget*)
                cptr = new ::QGLPixelBufferWrapper(*cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 1: // QGLPixelBuffer(int width, int height, const QGLFormat & format, QGLWidget * shareWidget)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[2]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLPixelBuffer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArgs[2]))))
                            goto Sbk_QGLPixelBuffer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_shareWidget = Shiboken::String::createStaticString("shareWidget");
                if (PyDict_Contains(kwds, key_shareWidget)) {
                    value = PyDict_GetItem(kwds, key_shareWidget);
                    if (value && pyArgs[3]) {
                        errInfo = key_shareWidget;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLPixelBuffer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLWIDGET_IDX]), (pyArgs[3]))))
                            goto Sbk_QGLPixelBuffer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_shareWidget);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLPixelBuffer_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QGLFormat cppArg2_local = QGLFormat::defaultFormat();
            ::QGLFormat *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QGLWidget *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QGLPixelBuffer(int,int,QGLFormat,QGLWidget*)
                cptr = new ::QGLPixelBufferWrapper(cppArg0, cppArg1, *cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGLPixelBuffer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGLPixelBuffer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGLPixelBuffer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGLPixelBufferFunc_bindTexture(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.bindTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:bindTexture", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLPixelBuffer::bindTexture(QImage,GLenum)
    // 1: QGLPixelBuffer::bindTexture(QPixmap,GLenum)
    // 2: QGLPixelBuffer::bindTexture(QString)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 2; // bindTexture(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // bindTexture(QImage,GLenum)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1])))) {
            overloadId = 0; // bindTexture(QImage,GLenum)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // bindTexture(QPixmap,GLenum)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1])))) {
            overloadId = 1; // bindTexture(QPixmap,GLenum)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // bindTexture(const QImage & image, GLenum target)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[1]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1]))))
                            goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLenum cppArg1 = GL_TEXTURE_2D;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindTexture(QImage,GLenum)
                GLuint cppResult = cppSelf->bindTexture(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
            }
            break;
        }
        case 1: // bindTexture(const QPixmap & pixmap, GLenum target)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[1]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1]))))
                            goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLenum cppArg1 = GL_TEXTURE_2D;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindTexture(QPixmap,GLenum)
                GLuint cppResult = cppSelf->bindTexture(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
            }
            break;
        }
        case 2: // bindTexture(const QString & fileName)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGLPixelBufferFunc_bindTexture_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // bindTexture(QString)
                GLuint cppResult = cppSelf->bindTexture(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLPixelBufferFunc_bindTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLPixelBufferFunc_bindToDynamicTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.bindToDynamicTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLPixelBuffer::bindToDynamicTexture(GLuint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArg)))) {
        overloadId = 0; // bindToDynamicTexture(GLuint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLPixelBufferFunc_bindToDynamicTexture_TypeError;

    // Call function/method
    {
        GLuint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // bindToDynamicTexture(GLuint)
            bool cppResult = cppSelf->bindToDynamicTexture(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLPixelBufferFunc_bindToDynamicTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLPixelBufferFunc_context(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.context";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // context()const
            QGLContext * cppResult = const_cast<const ::QGLPixelBuffer *>(cppSelf)->context();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_deleteTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.deleteTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLPixelBuffer::deleteTexture(GLuint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArg)))) {
        overloadId = 0; // deleteTexture(GLuint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLPixelBufferFunc_deleteTexture_TypeError;

    // Call function/method
    {
        GLuint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // deleteTexture(GLuint)
            cppSelf->deleteTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLPixelBufferFunc_deleteTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLPixelBufferFunc_devType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.devType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devType()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGLPixelBuffer *>(cppSelf)->::QGLPixelBuffer::devType()
                : const_cast<const ::QGLPixelBuffer *>(cppSelf)->devType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_doneCurrent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.doneCurrent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // doneCurrent()
            bool cppResult = cppSelf->doneCurrent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_drawTexture(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.drawTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLPixelBufferFunc_drawTexture_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLPixelBufferFunc_drawTexture_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:drawTexture", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGLPixelBuffer::drawTexture(QPointF,GLuint,GLenum)
    // 1: QGLPixelBuffer::drawTexture(QRectF,GLuint,GLenum)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // drawTexture(QRectF,GLuint,GLenum)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2])))) {
            overloadId = 1; // drawTexture(QRectF,GLuint,GLenum)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // drawTexture(QPointF,GLuint,GLenum)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2])))) {
            overloadId = 0; // drawTexture(QPointF,GLuint,GLenum)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLPixelBufferFunc_drawTexture_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawTexture(const QPointF & point, GLuint textureId, GLenum textureTarget)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_textureTarget = Shiboken::String::createStaticString("textureTarget");
                if (PyDict_Contains(kwds, key_textureTarget)) {
                    value = PyDict_GetItem(kwds, key_textureTarget);
                    if (value && pyArgs[2]) {
                        errInfo = key_textureTarget;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLPixelBufferFunc_drawTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2]))))
                            goto Sbk_QGLPixelBufferFunc_drawTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_textureTarget);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLPixelBufferFunc_drawTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLuint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLenum cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawTexture(QPointF,GLuint,GLenum)
                cppSelf->drawTexture(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // drawTexture(const QRectF & target, GLuint textureId, GLenum textureTarget)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_textureTarget = Shiboken::String::createStaticString("textureTarget");
                if (PyDict_Contains(kwds, key_textureTarget)) {
                    value = PyDict_GetItem(kwds, key_textureTarget);
                    if (value && pyArgs[2]) {
                        errInfo = key_textureTarget;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLPixelBufferFunc_drawTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2]))))
                            goto Sbk_QGLPixelBufferFunc_drawTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_textureTarget);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLPixelBufferFunc_drawTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLuint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLenum cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawTexture(QRectF,GLuint,GLenum)
                cppSelf->drawTexture(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLPixelBufferFunc_drawTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLPixelBufferFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QGLFormat cppResult = const_cast<const ::QGLPixelBuffer *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_generateDynamicTexture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.generateDynamicTexture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // generateDynamicTexture()const
            GLuint cppResult = const_cast<const ::QGLPixelBuffer *>(cppSelf)->generateDynamicTexture();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()const
            Qt::HANDLE cppResult = const_cast<const ::QGLPixelBuffer *>(cppSelf)->handle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<Qt::HANDLE>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_hasOpenGLPbuffers(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.hasOpenGLPbuffers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasOpenGLPbuffers()
            bool cppResult = ::QGLPixelBuffer::hasOpenGLPbuffers();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QGLPixelBuffer *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_makeCurrent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.makeCurrent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // makeCurrent()
            bool cppResult = cppSelf->makeCurrent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_metric(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.metric";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // metric(QPaintDevice::PaintDeviceMetric)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLPixelBufferFunc_metric_TypeError;

    // Call function/method
    {
        ::QPaintDevice::PaintDeviceMetric cppArg0 = static_cast< ::QPaintDevice::PaintDeviceMetric>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // metric(QPaintDevice::PaintDeviceMetric)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGLPixelBuffer *>(cppSelf)->::QGLPixelBuffer::metric(cppArg0)
                : const_cast<const ::QGLPixelBuffer *>(cppSelf)->metric(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLPixelBufferFunc_metric_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLPixelBufferFunc_paintEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.paintEngine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paintEngine()const
            QPaintEngine * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGLPixelBuffer *>(cppSelf)->::QGLPixelBuffer::paintEngine()
                : const_cast<const ::QGLPixelBuffer *>(cppSelf)->paintEngine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_releaseFromDynamicTexture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.releaseFromDynamicTexture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // releaseFromDynamicTexture()
            cppSelf->releaseFromDynamicTexture();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGLPixelBufferFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSize cppResult = const_cast<const ::QGLPixelBuffer *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_toImage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.toImage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toImage()const
            QImage cppResult = const_cast<const ::QGLPixelBuffer *>(cppSelf)->toImage();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLPixelBufferFunc_updateDynamicTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLPixelBuffer.updateDynamicTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLPixelBuffer::updateDynamicTexture(GLuint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArg)))) {
        overloadId = 0; // updateDynamicTexture(GLuint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLPixelBufferFunc_updateDynamicTexture_TypeError;

    // Call function/method
    {
        GLuint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // updateDynamicTexture(GLuint)const
            const_cast<const ::QGLPixelBuffer *>(cppSelf)->updateDynamicTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLPixelBufferFunc_updateDynamicTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGLPixelBuffer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGLPixelBuffer_methods[] = {
    {"bindTexture", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_bindTexture), METH_VARARGS|METH_KEYWORDS},
    {"bindToDynamicTexture", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_bindToDynamicTexture), METH_O},
    {"context", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_context), METH_NOARGS},
    {"deleteTexture", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_deleteTexture), METH_O},
    {"devType", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_devType), METH_NOARGS},
    {"doneCurrent", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_doneCurrent), METH_NOARGS},
    {"drawTexture", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_drawTexture), METH_VARARGS|METH_KEYWORDS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_format), METH_NOARGS},
    {"generateDynamicTexture", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_generateDynamicTexture), METH_NOARGS},
    {"handle", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_handle), METH_NOARGS},
    {"hasOpenGLPbuffers", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_hasOpenGLPbuffers), METH_NOARGS|METH_STATIC},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_isValid), METH_NOARGS},
    {"makeCurrent", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_makeCurrent), METH_NOARGS},
    {"metric", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_metric), METH_O},
    {"paintEngine", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_paintEngine), METH_NOARGS},
    {"releaseFromDynamicTexture", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_releaseFromDynamicTexture), METH_NOARGS},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_size), METH_NOARGS},
    {"toImage", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_toImage), METH_NOARGS},
    {"updateDynamicTexture", reinterpret_cast<PyCFunction>(Sbk_QGLPixelBufferFunc_updateDynamicTexture), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGLPixelBuffer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGLPixelBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGLPixelBufferWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGLPixelBuffer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGLPixelBuffer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGLPixelBuffer_Type = nullptr;
static SbkObjectType *Sbk_QGLPixelBuffer_TypeF(void)
{
    return _Sbk_QGLPixelBuffer_Type;
}

static PyType_Slot Sbk_QGLPixelBuffer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGLPixelBuffer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGLPixelBuffer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGLPixelBuffer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGLPixelBuffer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGLPixelBuffer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGLPixelBuffer_spec = {
    "2:PySide2.QtOpenGL.QGLPixelBuffer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGLPixelBuffer_slots
};

} //extern "C"

static void *Sbk_QGLPixelBuffer_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QGLPixelBuffer *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGLPixelBuffer_PythonToCpp_QGLPixelBuffer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGLPixelBuffer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGLPixelBuffer_PythonToCpp_QGLPixelBuffer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLPixelBuffer_TypeF())))
        return QGLPixelBuffer_PythonToCpp_QGLPixelBuffer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGLPixelBuffer_PTR_CppToPython_QGLPixelBuffer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGLPixelBuffer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGLPixelBuffer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGLPixelBuffer_SignatureStrings[] = {
    "1:PySide2.QtOpenGL.QGLPixelBuffer(self,size:PySide2.QtCore.QSize,format:PySide2.QtOpenGL.QGLFormat=QGLFormat.defaultFormat(),shareWidget:PySide2.QtOpenGL.QGLWidget=nullptr)",
    "0:PySide2.QtOpenGL.QGLPixelBuffer(self,width:int,height:int,format:PySide2.QtOpenGL.QGLFormat=QGLFormat.defaultFormat(),shareWidget:PySide2.QtOpenGL.QGLWidget=nullptr)",
    "2:PySide2.QtOpenGL.QGLPixelBuffer.bindTexture(self,image:PySide2.QtGui.QImage,target:GLenum=GL_TEXTURE_2D)->GLuint",
    "1:PySide2.QtOpenGL.QGLPixelBuffer.bindTexture(self,pixmap:PySide2.QtGui.QPixmap,target:GLenum=GL_TEXTURE_2D)->GLuint",
    "0:PySide2.QtOpenGL.QGLPixelBuffer.bindTexture(self,fileName:QString)->GLuint",
    "PySide2.QtOpenGL.QGLPixelBuffer.bindToDynamicTexture(self,texture:GLuint)->bool",
    "PySide2.QtOpenGL.QGLPixelBuffer.context(self)->PySide2.QtOpenGL.QGLContext",
    "PySide2.QtOpenGL.QGLPixelBuffer.deleteTexture(self,texture_id:GLuint)",
    "PySide2.QtOpenGL.QGLPixelBuffer.devType(self)->int",
    "PySide2.QtOpenGL.QGLPixelBuffer.doneCurrent(self)->bool",
    "1:PySide2.QtOpenGL.QGLPixelBuffer.drawTexture(self,point:PySide2.QtCore.QPointF,textureId:GLuint,textureTarget:GLenum=GL_TEXTURE_2D)",
    "0:PySide2.QtOpenGL.QGLPixelBuffer.drawTexture(self,target:PySide2.QtCore.QRectF,textureId:GLuint,textureTarget:GLenum=GL_TEXTURE_2D)",
    "PySide2.QtOpenGL.QGLPixelBuffer.format(self)->PySide2.QtOpenGL.QGLFormat",
    "PySide2.QtOpenGL.QGLPixelBuffer.generateDynamicTexture(self)->GLuint",
    "PySide2.QtOpenGL.QGLPixelBuffer.handle(self)->Qt.HANDLE",
    "PySide2.QtOpenGL.QGLPixelBuffer.hasOpenGLPbuffers()->bool",
    "PySide2.QtOpenGL.QGLPixelBuffer.isValid(self)->bool",
    "PySide2.QtOpenGL.QGLPixelBuffer.makeCurrent(self)->bool",
    "PySide2.QtOpenGL.QGLPixelBuffer.metric(self,metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric)->int",
    "PySide2.QtOpenGL.QGLPixelBuffer.paintEngine(self)->PySide2.QtGui.QPaintEngine",
    "PySide2.QtOpenGL.QGLPixelBuffer.releaseFromDynamicTexture(self)",
    "PySide2.QtOpenGL.QGLPixelBuffer.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtOpenGL.QGLPixelBuffer.toImage(self)->PySide2.QtGui.QImage",
    "PySide2.QtOpenGL.QGLPixelBuffer.updateDynamicTexture(self,texture_id:GLuint)",
    nullptr}; // Sentinel

void init_QGLPixelBuffer(PyObject *module)
{
    _Sbk_QGLPixelBuffer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGLPixelBuffer",
        "QGLPixelBuffer*",
        &Sbk_QGLPixelBuffer_spec,
        &Shiboken::callCppDestructor< ::QGLPixelBuffer >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGLPixelBuffer_Type);
    InitSignatureStrings(pyType, QGLPixelBuffer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGLPixelBuffer_Type), Sbk_QGLPixelBuffer_PropertyStrings);
    SbkPySide2_QtOpenGLTypes[SBK_QGLPIXELBUFFER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGLPixelBuffer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGLPixelBuffer_TypeF(),
        QGLPixelBuffer_PythonToCpp_QGLPixelBuffer_PTR,
        is_QGLPixelBuffer_PythonToCpp_QGLPixelBuffer_PTR_Convertible,
        QGLPixelBuffer_PTR_CppToPython_QGLPixelBuffer);

    Shiboken::Conversions::registerConverterName(converter, "QGLPixelBuffer");
    Shiboken::Conversions::registerConverterName(converter, "QGLPixelBuffer*");
    Shiboken::Conversions::registerConverterName(converter, "QGLPixelBuffer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLPixelBuffer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLPixelBufferWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGLPixelBuffer_TypeF(), &Sbk_QGLPixelBuffer_typeDiscovery);

}
