/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopenglfunctions_python.h"

// main header
#include "qopenglfunctions_3_1_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QOpenGLFunctions_3_1Wrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QOpenGLFunctions_3_1Wrapper::QOpenGLFunctions_3_1Wrapper() : QOpenGLFunctions_3_1()
{
    resetPyMethodCache();
    // ... middle
}

bool QOpenGLFunctions_3_1Wrapper::initializeOpenGLFunctions()
{
    if (m_PyMethodCache[0])
        return this->::QOpenGLFunctions_3_1::initializeOpenGLFunctions();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initializeOpenGLFunctions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QOpenGLFunctions_3_1::initializeOpenGLFunctions();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLFunctions_3_1.initializeOpenGLFunctions", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QOpenGLFunctions_3_1Wrapper::~QOpenGLFunctions_3_1Wrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLFunctions_3_1_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLFunctions_3_1 >()))
        return -1;

    ::QOpenGLFunctions_3_1Wrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QOpenGLFunctions_3_1()
            cptr = new ::QOpenGLFunctions_3_1Wrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLFunctions_3_1 >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glActiveTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glActiveTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glActiveTexture(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glActiveTexture(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glActiveTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glActiveTexture(uint)
            cppSelf->glActiveTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glActiveTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glAttachShader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glAttachShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glAttachShader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glAttachShader(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glAttachShader(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glAttachShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glAttachShader(uint,uint)
            cppSelf->glAttachShader(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glAttachShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBeginConditionalRender(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBeginConditionalRender";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBeginConditionalRender", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBeginConditionalRender(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBeginConditionalRender(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBeginConditionalRender_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBeginConditionalRender(uint,uint)
            cppSelf->glBeginConditionalRender(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBeginConditionalRender_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBeginQuery(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBeginQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBeginQuery", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBeginQuery(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBeginQuery(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBeginQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBeginQuery(uint,uint)
            cppSelf->glBeginQuery(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBeginQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBeginTransformFeedback(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBeginTransformFeedback";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBeginTransformFeedback(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBeginTransformFeedback(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBeginTransformFeedback_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBeginTransformFeedback(uint)
            cppSelf->glBeginTransformFeedback(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBeginTransformFeedback_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBindAttribLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindAttribLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindAttribLocation", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBindAttribLocation(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glBindAttribLocation(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBindAttribLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindAttribLocation(uint,uint,const char*)
            cppSelf->glBindAttribLocation(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBindAttribLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBindBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindBuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBindBuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindBuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBindBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindBuffer(uint,uint)
            cppSelf->glBindBuffer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBindBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBindBufferBase(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindBufferBase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindBufferBase", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBindBufferBase(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glBindBufferBase(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBindBufferBase_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindBufferBase(uint,uint,uint)
            cppSelf->glBindBufferBase(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBindBufferBase_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBindFragDataLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindFragDataLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindFragDataLocation", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBindFragDataLocation(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glBindFragDataLocation(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBindFragDataLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindFragDataLocation(uint,uint,const char*)
            cppSelf->glBindFragDataLocation(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBindFragDataLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBindFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindFramebuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBindFramebuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindFramebuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBindFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindFramebuffer(uint,uint)
            cppSelf->glBindFramebuffer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBindFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBindRenderbuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindRenderbuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindRenderbuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBindRenderbuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindRenderbuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBindRenderbuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindRenderbuffer(uint,uint)
            cppSelf->glBindRenderbuffer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBindRenderbuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBindTexture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindTexture", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBindTexture(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindTexture(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBindTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindTexture(uint,uint)
            cppSelf->glBindTexture(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBindTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBindVertexArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindVertexArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBindVertexArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBindVertexArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBindVertexArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBindVertexArray(uint)
            cppSelf->glBindVertexArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBindVertexArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBlendColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendColor", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBlendColor(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glBlendColor(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBlendColor_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glBlendColor(float,float,float,float)
            cppSelf->glBlendColor(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBlendColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBlendEquation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendEquation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBlendEquation(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBlendEquation(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBlendEquation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBlendEquation(uint)
            cppSelf->glBlendEquation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBlendEquation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBlendEquationSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendEquationSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendEquationSeparate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBlendEquationSeparate(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBlendEquationSeparate(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBlendEquationSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBlendEquationSeparate(uint,uint)
            cppSelf->glBlendEquationSeparate(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBlendEquationSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBlendFunc(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFunc", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBlendFunc(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBlendFunc(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBlendFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBlendFunc(uint,uint)
            cppSelf->glBlendFunc(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBlendFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBlendFuncSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendFuncSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFuncSeparate", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBlendFuncSeparate(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glBlendFuncSeparate(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBlendFuncSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glBlendFuncSeparate(uint,uint,uint,uint)
            cppSelf->glBlendFuncSeparate(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBlendFuncSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glBlitFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlitFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlitFramebuffer", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[9])))) {
        overloadId = 0; // glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glBlitFramebuffer_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        unsigned int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
            cppSelf->glBlitFramebuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glBlitFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCheckFramebufferStatus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCheckFramebufferStatus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCheckFramebufferStatus(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCheckFramebufferStatus(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCheckFramebufferStatus_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCheckFramebufferStatus(uint)
            unsigned int cppResult = cppSelf->glCheckFramebufferStatus(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glCheckFramebufferStatus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glClampColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClampColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClampColor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glClampColor(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glClampColor(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glClampColor_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glClampColor(uint,uint)
            cppSelf->glClampColor(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glClampColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glClear(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glClear(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glClear(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glClear_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClear(uint)
            cppSelf->glClear(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glClear_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glClearBufferfi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearBufferfi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferfi", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glClearBufferfi(uint,int,float,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glClearBufferfi(uint,int,float,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glClearBufferfi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glClearBufferfi(uint,int,float,int)
            cppSelf->glClearBufferfi(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glClearBufferfi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glClearBufferfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearBufferfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glClearBufferfv(uint,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferfv(uint,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glClearBufferfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferfv(uint,int,const float*)
            cppSelf->glClearBufferfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glClearBufferfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glClearBufferiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearBufferiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glClearBufferiv(uint,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferiv(uint,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glClearBufferiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferiv(uint,int,const int*)
            cppSelf->glClearBufferiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glClearBufferiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glClearBufferuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearBufferuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glClearBufferuiv(uint,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferuiv(uint,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glClearBufferuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferuiv(uint,int,const uint*)
            cppSelf->glClearBufferuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glClearBufferuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glClearColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearColor", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glClearColor(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glClearColor(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glClearColor_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glClearColor(float,float,float,float)
            cppSelf->glClearColor(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glClearColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glClearDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glClearDepth(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // glClearDepth(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glClearDepth_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClearDepth(double)
            cppSelf->glClearDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glClearDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glClearStencil(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearStencil";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glClearStencil(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // glClearStencil(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glClearStencil_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClearStencil(int)
            cppSelf->glClearStencil(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glClearStencil_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glColorMask(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glColorMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorMask", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glColorMask(unsigned char,unsigned char,unsigned char,unsigned char)
    if (numArgs == 4
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))) {
        overloadId = 0; // glColorMask(unsigned char,unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glColorMask_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColorMask(unsigned char,unsigned char,unsigned char,unsigned char)
            cppSelf->glColorMask(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glColorMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glColorMaski(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glColorMaski";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorMaski", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && SbkChar_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[4])))) {
        overloadId = 0; // glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glColorMaski_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned char cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
            cppSelf->glColorMaski(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glColorMaski_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCompileShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompileShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCompileShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCompileShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCompileShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCompileShader(uint)
            cppSelf->glCompileShader(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCompileShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCompressedTexImage1D(uint,int,uint,int,int,int,const void*)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
        overloadId = 0; // glCompressedTexImage1D(uint,int,uint,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage1D(uint,int,uint,int,int,int,const void*)
            cppSelf->glCompressedTexImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCompressedTexImage2D(uint,int,uint,int,int,int,int,const void*)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[7])))) {
        overloadId = 0; // glCompressedTexImage2D(uint,int,uint,int,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        void* cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage2D(uint,int,uint,int,int,int,int,const void*)
            cppSelf->glCompressedTexImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage3D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
            cppSelf->glCompressedTexImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexSubImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCompressedTexSubImage1D(uint,int,int,int,uint,int,const void*)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
        overloadId = 0; // glCompressedTexSubImage1D(uint,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage1D(uint,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexSubImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage2D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCompressedTexSubImage2D(uint,int,int,int,int,int,uint,int,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glCompressedTexSubImage2D(uint,int,int,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage2D(uint,int,int,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage3D", 11, 11, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
    if (numArgs == 11
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[10])))) {
        overloadId = 0; // glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);
        void* cppArg10;
        pythonToCpp[10](pyArgs[10], &cppArg10);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCopyTexImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCopyTexImage1D(uint,int,uint,int,int,int,int)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
        overloadId = 0; // glCopyTexImage1D(uint,int,uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCopyTexImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glCopyTexImage1D(uint,int,uint,int,int,int,int)
            cppSelf->glCopyTexImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCopyTexImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCopyTexImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexImage2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCopyTexImage2D(uint,int,uint,int,int,int,int,int)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
        overloadId = 0; // glCopyTexImage2D(uint,int,uint,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCopyTexImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glCopyTexImage2D(uint,int,uint,int,int,int,int,int)
            cppSelf->glCopyTexImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCopyTexImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexSubImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage1D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCopyTexSubImage1D(uint,int,int,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glCopyTexSubImage1D(uint,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage1D(uint,int,int,int,int,int)
            cppSelf->glCopyTexSubImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexSubImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCopyTexSubImage2D(uint,int,int,int,int,int,int,int)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
        overloadId = 0; // glCopyTexSubImage2D(uint,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage2D(uint,int,int,int,int,int,int,int)
            cppSelf->glCopyTexSubImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage3D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[8])))) {
        overloadId = 0; // glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
            cppSelf->glCopyTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCreateProgram(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCreateProgram";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glCreateProgram()
            unsigned int cppResult = cppSelf->glCreateProgram();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCreateShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCreateShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCreateShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCreateShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCreateShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCreateShader(uint)
            unsigned int cppResult = cppSelf->glCreateShader(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glCreateShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glCullFace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCullFace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glCullFace(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCullFace(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glCullFace_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCullFace(uint)
            cppSelf->glCullFace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glCullFace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDeleteBuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteBuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDeleteBuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteBuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDeleteBuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteBuffers(int,const uint*)
            cppSelf->glDeleteBuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDeleteBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDeleteFramebuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteFramebuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteFramebuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDeleteFramebuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteFramebuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDeleteFramebuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteFramebuffers(int,const uint*)
            cppSelf->glDeleteFramebuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDeleteFramebuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDeleteProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDeleteProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDeleteProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDeleteProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDeleteProgram(uint)
            cppSelf->glDeleteProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDeleteProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDeleteQueries(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteQueries";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteQueries", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDeleteQueries(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteQueries(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDeleteQueries_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteQueries(int,const uint*)
            cppSelf->glDeleteQueries(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDeleteQueries_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDeleteRenderbuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteRenderbuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteRenderbuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDeleteRenderbuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteRenderbuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDeleteRenderbuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteRenderbuffers(int,const uint*)
            cppSelf->glDeleteRenderbuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDeleteRenderbuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDeleteShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDeleteShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDeleteShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDeleteShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDeleteShader(uint)
            cppSelf->glDeleteShader(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDeleteShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDeleteTextures(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteTextures";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteTextures", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDeleteTextures(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteTextures(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDeleteTextures_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteTextures(int,const uint*)
            cppSelf->glDeleteTextures(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDeleteTextures_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDeleteVertexArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteVertexArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteVertexArrays", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDeleteVertexArrays(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteVertexArrays(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDeleteVertexArrays_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteVertexArrays(int,const uint*)
            cppSelf->glDeleteVertexArrays(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDeleteVertexArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDepthFunc(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDepthFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDepthFunc(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDepthFunc(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDepthFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDepthFunc(uint)
            cppSelf->glDepthFunc(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDepthFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDepthMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDepthMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDepthMask(unsigned char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glDepthMask(unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDepthMask_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDepthMask(unsigned char)
            cppSelf->glDepthMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDepthMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDepthRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDepthRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDepthRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDepthRange(double,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // glDepthRange(double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDepthRange_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDepthRange(double,double)
            cppSelf->glDepthRange(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDepthRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDetachShader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDetachShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDetachShader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDetachShader(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glDetachShader(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDetachShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDetachShader(uint,uint)
            cppSelf->glDetachShader(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDetachShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDisable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDisable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDisable(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDisable(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDisable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDisable(uint)
            cppSelf->glDisable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDisable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDisableVertexAttribArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDisableVertexAttribArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDisableVertexAttribArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDisableVertexAttribArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDisableVertexAttribArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDisableVertexAttribArray(uint)
            cppSelf->glDisableVertexAttribArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDisableVertexAttribArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDisablei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDisablei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDisablei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDisablei(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glDisablei(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDisablei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDisablei(uint,uint)
            cppSelf->glDisablei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDisablei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDrawArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArrays", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDrawArrays(uint,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glDrawArrays(uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDrawArrays_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDrawArrays(uint,int,int)
            cppSelf->glDrawArrays(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDrawArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDrawArraysInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawArraysInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArraysInstanced", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDrawArraysInstanced(uint,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glDrawArraysInstanced(uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDrawArraysInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glDrawArraysInstanced(uint,int,int,int)
            cppSelf->glDrawArraysInstanced(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDrawArraysInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDrawBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDrawBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDrawBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDrawBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDrawBuffer(uint)
            cppSelf->glDrawBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDrawBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDrawBuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawBuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDrawBuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDrawBuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDrawBuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDrawBuffers(int,const uint*)
            cppSelf->glDrawBuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDrawBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDrawElements(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawElements";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElements", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDrawElements(uint,int,uint,const void*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))) {
        overloadId = 0; // glDrawElements(uint,int,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDrawElements_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glDrawElements(uint,int,uint,const void*)
            cppSelf->glDrawElements(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDrawElements_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDrawElementsInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawElementsInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsInstanced", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDrawElementsInstanced(uint,int,uint,const void*,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glDrawElementsInstanced(uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDrawElementsInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glDrawElementsInstanced(uint,int,uint,const void*,int)
            cppSelf->glDrawElementsInstanced(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDrawElementsInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glDrawRangeElements(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawRangeElements";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawRangeElements", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glDrawRangeElements(uint,uint,uint,int,uint,const void*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
        overloadId = 0; // glDrawRangeElements(uint,uint,uint,int,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glDrawRangeElements_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDrawRangeElements(uint,uint,uint,int,uint,const void*)
            cppSelf->glDrawRangeElements(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glDrawRangeElements_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glEnable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEnable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glEnable(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEnable(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glEnable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEnable(uint)
            cppSelf->glEnable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glEnable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glEnableVertexAttribArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEnableVertexAttribArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glEnableVertexAttribArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEnableVertexAttribArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glEnableVertexAttribArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEnableVertexAttribArray(uint)
            cppSelf->glEnableVertexAttribArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glEnableVertexAttribArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glEnablei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEnablei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEnablei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glEnablei(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glEnablei(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glEnablei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glEnablei(uint,uint)
            cppSelf->glEnablei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glEnablei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glEndConditionalRender(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEndConditionalRender";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glEndConditionalRender()
            cppSelf->glEndConditionalRender();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glEndQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEndQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glEndQuery(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEndQuery(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glEndQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEndQuery(uint)
            cppSelf->glEndQuery(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glEndQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glEndTransformFeedback(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEndTransformFeedback";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glEndTransformFeedback()
            cppSelf->glEndTransformFeedback();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glFinish(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFinish";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glFinish()
            cppSelf->glFinish();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glFlush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFlush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glFlush()
            cppSelf->glFlush();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glFramebufferRenderbuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferRenderbuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferRenderbuffer", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glFramebufferRenderbuffer(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glFramebufferRenderbuffer(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glFramebufferRenderbuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glFramebufferRenderbuffer(uint,uint,uint,uint)
            cppSelf->glFramebufferRenderbuffer(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glFramebufferRenderbuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferTexture1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture1D", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glFramebufferTexture1D(uint,uint,uint,uint,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTexture1D(uint,uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture1D(uint,uint,uint,uint,int)
            cppSelf->glFramebufferTexture1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferTexture2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture2D", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glFramebufferTexture2D(uint,uint,uint,uint,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTexture2D(uint,uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture2D(uint,uint,uint,uint,int)
            cppSelf->glFramebufferTexture2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferTexture3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture3D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glFramebufferTexture3D(uint,uint,uint,uint,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glFramebufferTexture3D(uint,uint,uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture3D(uint,uint,uint,uint,int,int)
            cppSelf->glFramebufferTexture3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glFramebufferTextureLayer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferTextureLayer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTextureLayer", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glFramebufferTextureLayer(uint,uint,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTextureLayer(uint,uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glFramebufferTextureLayer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTextureLayer(uint,uint,uint,int,int)
            cppSelf->glFramebufferTextureLayer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glFramebufferTextureLayer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glFrontFace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFrontFace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glFrontFace(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glFrontFace(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glFrontFace_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glFrontFace(uint)
            cppSelf->glFrontFace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glFrontFace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glGenerateMipmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGenerateMipmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glGenerateMipmap(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glGenerateMipmap(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glGenerateMipmap_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glGenerateMipmap(uint)
            cppSelf->glGenerateMipmap(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glGenerateMipmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glGetAttribLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetAttribLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetAttribLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glGetAttribLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetAttribLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glGetAttribLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetAttribLocation(uint,const char*)
            int cppResult = cppSelf->glGetAttribLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glGetAttribLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glGetError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glGetError()
            unsigned int cppResult = cppSelf->glGetError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glGetFragDataLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetFragDataLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetFragDataLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glGetFragDataLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetFragDataLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glGetFragDataLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetFragDataLocation(uint,const char*)
            int cppResult = cppSelf->glGetFragDataLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glGetFragDataLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glGetString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glGetString(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glGetString(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glGetString_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glGetString(uint)
            // Begin code injection
            // TEMPLATE - glGetString_return_QString - START
            const GLubyte *us = cppSelf->glGetString(cppArg0);
            const QString s = QString::fromLocal8Bit(reinterpret_cast<const char *>(us));
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &s);
            // TEMPLATE - glGetString_return_QString - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glGetString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glGetStringi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetStringi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetStringi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glGetStringi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glGetStringi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glGetStringi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetStringi(uint,uint)
            // Begin code injection
            // TEMPLATE - glGetString_return_QString - START
            const GLubyte *us = cppSelf->glGetStringi(cppArg0, cppArg1);
            const QString s = QString::fromLocal8Bit(reinterpret_cast<const char *>(us));
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &s);
            // TEMPLATE - glGetString_return_QString - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glGetStringi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glGetUniformBlockIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetUniformBlockIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetUniformBlockIndex", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glGetUniformBlockIndex(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetUniformBlockIndex(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glGetUniformBlockIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetUniformBlockIndex(uint,const char*)
            unsigned int cppResult = cppSelf->glGetUniformBlockIndex(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glGetUniformBlockIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glGetUniformLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetUniformLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetUniformLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glGetUniformLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetUniformLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glGetUniformLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetUniformLocation(uint,const char*)
            int cppResult = cppSelf->glGetUniformLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glGetUniformLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glHint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glHint", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glHint(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glHint(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glHint_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glHint(uint,uint)
            cppSelf->glHint(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIndexub(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIndexub";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIndexub(unsigned char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glIndexub(unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIndexub_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexub(unsigned char)
            cppSelf->glIndexub(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glIndexub_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIndexubv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIndexubv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIndexubv(const unsigned char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glIndexubv(const unsigned char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIndexubv_TypeError;

    // Call function/method
    {
        unsigned char *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexubv(const unsigned char*)
            cppSelf->glIndexubv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glIndexubv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsBuffer(uint)
            unsigned char cppResult = cppSelf->glIsBuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsEnabled(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsEnabled(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsEnabled_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsEnabled(uint)
            unsigned char cppResult = cppSelf->glIsEnabled(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsEnabledi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsEnabledi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glIsEnabledi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsEnabledi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glIsEnabledi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsEnabledi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glIsEnabledi(uint,uint)
            unsigned char cppResult = cppSelf->glIsEnabledi(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsEnabledi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsFramebuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsFramebuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsFramebuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsFramebuffer(uint)
            unsigned char cppResult = cppSelf->glIsFramebuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsProgram(uint)
            unsigned char cppResult = cppSelf->glIsProgram(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsQuery(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsQuery(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsQuery(uint)
            unsigned char cppResult = cppSelf->glIsQuery(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsRenderbuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsRenderbuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsRenderbuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsRenderbuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsRenderbuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsRenderbuffer(uint)
            unsigned char cppResult = cppSelf->glIsRenderbuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsRenderbuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsShader(uint)
            unsigned char cppResult = cppSelf->glIsShader(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsTexture(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsTexture(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsTexture(uint)
            unsigned char cppResult = cppSelf->glIsTexture(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glIsVertexArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsVertexArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glIsVertexArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsVertexArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glIsVertexArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsVertexArray(uint)
            unsigned char cppResult = cppSelf->glIsVertexArray(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glIsVertexArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glLineWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glLineWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glLineWidth(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glLineWidth(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glLineWidth_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLineWidth(float)
            cppSelf->glLineWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glLineWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glLinkProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glLinkProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glLinkProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glLinkProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glLinkProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLinkProgram(uint)
            cppSelf->glLinkProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glLinkProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glLogicOp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glLogicOp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glLogicOp(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glLogicOp(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glLogicOp_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLogicOp(uint)
            cppSelf->glLogicOp(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glLogicOp_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glMapBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glMapBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMapBuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glMapBuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glMapBuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glMapBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMapBuffer(uint,uint)
            void * cppResult = cppSelf->glMapBuffer(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glMapBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glMultiDrawArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glMultiDrawArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiDrawArrays", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glMultiDrawArrays(uint,const int*,const int*,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glMultiDrawArrays(uint,const int*,const int*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glMultiDrawArrays_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glMultiDrawArrays(uint,const int*,const int*,int)
            cppSelf->glMultiDrawArrays(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glMultiDrawArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPixelStoref(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPixelStoref";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelStoref", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPixelStoref(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPixelStoref(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPixelStoref_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPixelStoref(uint,float)
            cppSelf->glPixelStoref(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPixelStoref_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPixelStorei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPixelStorei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelStorei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPixelStorei(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glPixelStorei(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPixelStorei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPixelStorei(uint,int)
            cppSelf->glPixelStorei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPixelStorei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPointParameterf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointParameterf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameterf", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPointParameterf(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPointParameterf(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPointParameterf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameterf(uint,float)
            cppSelf->glPointParameterf(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPointParameterf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPointParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameterfv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPointParameterfv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glPointParameterfv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPointParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameterfv(uint,const float*)
            cppSelf->glPointParameterfv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPointParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPointParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameteri", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPointParameteri(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glPointParameteri(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPointParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameteri(uint,int)
            cppSelf->glPointParameteri(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPointParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPointParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameteriv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPointParameteriv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glPointParameteriv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPointParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameteriv(uint,const int*)
            cppSelf->glPointParameteriv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPointParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPointSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPointSize(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glPointSize(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPointSize_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPointSize(float)
            cppSelf->glPointSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPointSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPolygonMode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPolygonMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPolygonMode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPolygonMode(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glPolygonMode(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPolygonMode_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPolygonMode(uint,uint)
            cppSelf->glPolygonMode(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPolygonMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPolygonOffset(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPolygonOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPolygonOffset", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPolygonOffset(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPolygonOffset(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPolygonOffset_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPolygonOffset(float,float)
            cppSelf->glPolygonOffset(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPolygonOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glPrimitiveRestartIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPrimitiveRestartIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glPrimitiveRestartIndex(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glPrimitiveRestartIndex(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glPrimitiveRestartIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPrimitiveRestartIndex(uint)
            cppSelf->glPrimitiveRestartIndex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glPrimitiveRestartIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glReadBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glReadBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glReadBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glReadBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glReadBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glReadBuffer(uint)
            cppSelf->glReadBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glReadBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glRenderbufferStorage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glRenderbufferStorage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRenderbufferStorage", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glRenderbufferStorage(uint,uint,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glRenderbufferStorage(uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glRenderbufferStorage_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRenderbufferStorage(uint,uint,int,int)
            cppSelf->glRenderbufferStorage(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glRenderbufferStorage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glRenderbufferStorageMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glRenderbufferStorageMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRenderbufferStorageMultisample", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glRenderbufferStorageMultisample(uint,int,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glRenderbufferStorageMultisample(uint,int,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glRenderbufferStorageMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glRenderbufferStorageMultisample(uint,int,uint,int,int)
            cppSelf->glRenderbufferStorageMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glRenderbufferStorageMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glSampleCoverage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glSampleCoverage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSampleCoverage", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glSampleCoverage(float,unsigned char)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))) {
        overloadId = 0; // glSampleCoverage(float,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glSampleCoverage_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSampleCoverage(float,unsigned char)
            cppSelf->glSampleCoverage(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glSampleCoverage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glScissor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glScissor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glScissor", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glScissor(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glScissor(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glScissor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glScissor(int,int,int,int)
            cppSelf->glScissor(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glScissor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glStencilFunc(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilFunc", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glStencilFunc(uint,int,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glStencilFunc(uint,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glStencilFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glStencilFunc(uint,int,uint)
            cppSelf->glStencilFunc(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glStencilFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glStencilFuncSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilFuncSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilFuncSeparate", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glStencilFuncSeparate(uint,uint,int,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glStencilFuncSeparate(uint,uint,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glStencilFuncSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glStencilFuncSeparate(uint,uint,int,uint)
            cppSelf->glStencilFuncSeparate(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glStencilFuncSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glStencilMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glStencilMask(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glStencilMask(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glStencilMask_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glStencilMask(uint)
            cppSelf->glStencilMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glStencilMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glStencilMaskSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilMaskSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilMaskSeparate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glStencilMaskSeparate(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glStencilMaskSeparate(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glStencilMaskSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glStencilMaskSeparate(uint,uint)
            cppSelf->glStencilMaskSeparate(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glStencilMaskSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glStencilOp(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilOp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilOp", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glStencilOp(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glStencilOp(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glStencilOp_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glStencilOp(uint,uint,uint)
            cppSelf->glStencilOp(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glStencilOp_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glStencilOpSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilOpSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilOpSeparate", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glStencilOpSeparate(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glStencilOpSeparate(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glStencilOpSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glStencilOpSeparate(uint,uint,uint,uint)
            cppSelf->glStencilOpSeparate(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glStencilOpSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexBuffer", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexBuffer(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glTexBuffer(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexBuffer(uint,uint,uint)
            cppSelf->glTexBuffer(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexImage1D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexImage1D(uint,int,int,int,int,uint,uint,const void*)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[7])))) {
        overloadId = 0; // glTexImage1D(uint,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        void* cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glTexImage1D(uint,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexImage2D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexImage2D(uint,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glTexImage2D(uint,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glTexImage2D(uint,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexImage3D", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexImage3D(uint,int,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[9])))) {
        overloadId = 0; // glTexImage3D(uint,int,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        void* cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // glTexImage3D(uint,int,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexParameterIiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameterIiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterIiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexParameterIiv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameterIiv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexParameterIiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterIiv(uint,uint,const int*)
            cppSelf->glTexParameterIiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexParameterIiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexParameterIuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameterIuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterIuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexParameterIuiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameterIuiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexParameterIuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterIuiv(uint,uint,const uint*)
            cppSelf->glTexParameterIuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexParameterIuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexParameterf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameterf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterf", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexParameterf(uint,uint,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glTexParameterf(uint,uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexParameterf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterf(uint,uint,float)
            cppSelf->glTexParameterf(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexParameterf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexParameterfv(uint,uint,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameterfv(uint,uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterfv(uint,uint,const float*)
            cppSelf->glTexParameterfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glTexParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameteri(uint,uint,int)
            cppSelf->glTexParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameteriv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexParameteriv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameteriv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameteriv(uint,uint,const int*)
            cppSelf->glTexParameteriv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexSubImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexSubImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexSubImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexSubImage1D(uint,int,int,int,uint,uint,const void*)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
        overloadId = 0; // glTexSubImage1D(uint,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexSubImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glTexSubImage1D(uint,int,int,int,uint,uint,const void*)
            cppSelf->glTexSubImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexSubImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexSubImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexSubImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexSubImage2D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexSubImage2D(uint,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glTexSubImage2D(uint,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexSubImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glTexSubImage2D(uint,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexSubImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexSubImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexSubImage3D", 11, 11, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glTexSubImage3D(uint,int,int,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 11
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[10])))) {
        overloadId = 0; // glTexSubImage3D(uint,int,int,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        unsigned int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);
        void* cppArg10;
        pythonToCpp[10](pyArgs[10], &cppArg10);

        if (!PyErr_Occurred()) {
            // glTexSubImage3D(uint,int,int,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform1f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1f", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform1f(int,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glUniform1f(int,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform1f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glUniform1f(int,float)
            cppSelf->glUniform1f(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform1fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1fv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform1fv(int,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform1fv(int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform1fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform1fv(int,int,const float*)
            cppSelf->glUniform1fv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform1fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform1i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1i", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform1i(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glUniform1i(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform1i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glUniform1i(int,int)
            cppSelf->glUniform1i(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform1i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform1iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1iv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform1iv(int,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform1iv(int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform1iv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform1iv(int,int,const int*)
            cppSelf->glUniform1iv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform1iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform1ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform1ui(int,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glUniform1ui(int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform1ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glUniform1ui(int,uint)
            cppSelf->glUniform1ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform1ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform1uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform1uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform1uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform1uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform1uiv(int,int,const uint*)
            cppSelf->glUniform1uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform1uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform2f(int,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glUniform2f(int,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform2f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2f(int,float,float)
            cppSelf->glUniform2f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2fv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform2fv(int,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform2fv(int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2fv(int,int,const float*)
            cppSelf->glUniform2fv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform2i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform2i(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glUniform2i(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform2i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2i(int,int,int)
            cppSelf->glUniform2i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform2i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform2iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2iv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform2iv(int,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform2iv(int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform2iv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2iv(int,int,const int*)
            cppSelf->glUniform2iv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform2iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform2ui(int,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glUniform2ui(int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform2ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2ui(int,uint,uint)
            cppSelf->glUniform2ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform2uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform2uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform2uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2uiv(int,int,const uint*)
            cppSelf->glUniform2uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3f", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform3f(int,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glUniform3f(int,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform3f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniform3f(int,float,float,float)
            cppSelf->glUniform3f(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3fv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform3fv(int,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform3fv(int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform3fv(int,int,const float*)
            cppSelf->glUniform3fv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3i", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform3i(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glUniform3i(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform3i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniform3i(int,int,int,int)
            cppSelf->glUniform3i(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform3iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3iv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform3iv(int,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform3iv(int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform3iv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform3iv(int,int,const int*)
            cppSelf->glUniform3iv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform3iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform3ui(int,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glUniform3ui(int,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform3ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniform3ui(int,uint,uint,uint)
            cppSelf->glUniform3ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform3uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform3uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform3uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform3uiv(int,int,const uint*)
            cppSelf->glUniform3uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform4f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4f", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform4f(int,float,float,float,float)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
        overloadId = 0; // glUniform4f(int,float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform4f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glUniform4f(int,float,float,float,float)
            cppSelf->glUniform4f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform4f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4fv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform4fv(int,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform4fv(int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform4fv(int,int,const float*)
            cppSelf->glUniform4fv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform4i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4i", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform4i(int,int,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glUniform4i(int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform4i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glUniform4i(int,int,int,int,int)
            cppSelf->glUniform4i(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform4i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform4iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4iv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform4iv(int,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform4iv(int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform4iv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform4iv(int,int,const int*)
            cppSelf->glUniform4iv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform4iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4ui", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform4ui(int,uint,uint,uint,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glUniform4ui(int,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform4ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glUniform4ui(int,uint,uint,uint,uint)
            cppSelf->glUniform4ui(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniform4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniform4uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform4uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniform4uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform4uiv(int,int,const uint*)
            cppSelf->glUniform4uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniform4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformBlockBinding(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformBlockBinding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformBlockBinding", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformBlockBinding(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glUniformBlockBinding(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformBlockBinding_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniformBlockBinding(uint,uint,uint)
            cppSelf->glUniformBlockBinding(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformBlockBinding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformMatrix2fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix2x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2x3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformMatrix2x3fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2x3fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2x3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2x3fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix2x3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix2x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2x4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformMatrix2x4fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2x4fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2x4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2x4fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix2x4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformMatrix3fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix3x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3x2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformMatrix3x2fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3x2fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3x2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3x2fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix3x2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix3x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3x4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformMatrix3x4fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3x4fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3x4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3x4fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix3x4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformMatrix4fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix4x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4x2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformMatrix4x2fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4x2fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4x2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4x2fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix4x2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix4x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4x3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUniformMatrix4x3fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4x3fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4x3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4x3fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix4x3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUnmapBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUnmapBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUnmapBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glUnmapBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUnmapBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glUnmapBuffer(uint)
            unsigned char cppResult = cppSelf->glUnmapBuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_1Func_glUnmapBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glUseProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUseProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glUseProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glUseProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glUseProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glUseProgram(uint)
            cppSelf->glUseProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glUseProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glValidateProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glValidateProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glValidateProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glValidateProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glValidateProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glValidateProgram(uint)
            cppSelf->glValidateProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glValidateProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glVertexAttribIPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glVertexAttribIPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribIPointer", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glVertexAttribIPointer(uint,int,uint,int,const void*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[4])))) {
        overloadId = 0; // glVertexAttribIPointer(uint,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glVertexAttribIPointer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        void* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glVertexAttribIPointer(uint,int,uint,int,const void*)
            cppSelf->glVertexAttribIPointer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glVertexAttribIPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glVertexAttribPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glVertexAttribPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribPointer", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glVertexAttribPointer(uint,int,uint,unsigned char,int,const void*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
        overloadId = 0; // glVertexAttribPointer(uint,int,uint,unsigned char,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glVertexAttribPointer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glVertexAttribPointer(uint,int,uint,unsigned char,int,const void*)
            cppSelf->glVertexAttribPointer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glVertexAttribPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_glViewport(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glViewport";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glViewport", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_1::glViewport(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glViewport(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_1Func_glViewport_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glViewport(int,int,int,int)
            cppSelf->glViewport(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_1Func_glViewport_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_1Func_initializeOpenGLFunctions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.initializeOpenGLFunctions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initializeOpenGLFunctions()
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QOpenGLFunctions_3_1::initializeOpenGLFunctions()
                : cppSelf->initializeOpenGLFunctions();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QOpenGLFunctions_3_1_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLFunctions_3_1_methods[] = {
    {"glActiveTexture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glActiveTexture), METH_O},
    {"glAttachShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glAttachShader), METH_VARARGS},
    {"glBeginConditionalRender", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBeginConditionalRender), METH_VARARGS},
    {"glBeginQuery", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBeginQuery), METH_VARARGS},
    {"glBeginTransformFeedback", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBeginTransformFeedback), METH_O},
    {"glBindAttribLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBindAttribLocation), METH_VARARGS},
    {"glBindBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBindBuffer), METH_VARARGS},
    {"glBindBufferBase", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBindBufferBase), METH_VARARGS},
    {"glBindFragDataLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBindFragDataLocation), METH_VARARGS},
    {"glBindFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBindFramebuffer), METH_VARARGS},
    {"glBindRenderbuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBindRenderbuffer), METH_VARARGS},
    {"glBindTexture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBindTexture), METH_VARARGS},
    {"glBindVertexArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBindVertexArray), METH_O},
    {"glBlendColor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBlendColor), METH_VARARGS},
    {"glBlendEquation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBlendEquation), METH_O},
    {"glBlendEquationSeparate", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBlendEquationSeparate), METH_VARARGS},
    {"glBlendFunc", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBlendFunc), METH_VARARGS},
    {"glBlendFuncSeparate", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBlendFuncSeparate), METH_VARARGS},
    {"glBlitFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glBlitFramebuffer), METH_VARARGS},
    {"glCheckFramebufferStatus", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCheckFramebufferStatus), METH_O},
    {"glClampColor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glClampColor), METH_VARARGS},
    {"glClear", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glClear), METH_O},
    {"glClearBufferfi", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glClearBufferfi), METH_VARARGS},
    {"glClearBufferfv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glClearBufferfv), METH_VARARGS},
    {"glClearBufferiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glClearBufferiv), METH_VARARGS},
    {"glClearBufferuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glClearBufferuiv), METH_VARARGS},
    {"glClearColor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glClearColor), METH_VARARGS},
    {"glClearDepth", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glClearDepth), METH_O},
    {"glClearStencil", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glClearStencil), METH_O},
    {"glColorMask", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glColorMask), METH_VARARGS},
    {"glColorMaski", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glColorMaski), METH_VARARGS},
    {"glCompileShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCompileShader), METH_O},
    {"glCompressedTexImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage1D), METH_VARARGS},
    {"glCompressedTexImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage2D), METH_VARARGS},
    {"glCompressedTexImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCompressedTexImage3D), METH_VARARGS},
    {"glCompressedTexSubImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage1D), METH_VARARGS},
    {"glCompressedTexSubImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage2D), METH_VARARGS},
    {"glCompressedTexSubImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCompressedTexSubImage3D), METH_VARARGS},
    {"glCopyTexImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCopyTexImage1D), METH_VARARGS},
    {"glCopyTexImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCopyTexImage2D), METH_VARARGS},
    {"glCopyTexSubImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage1D), METH_VARARGS},
    {"glCopyTexSubImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage2D), METH_VARARGS},
    {"glCopyTexSubImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCopyTexSubImage3D), METH_VARARGS},
    {"glCreateProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCreateProgram), METH_NOARGS},
    {"glCreateShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCreateShader), METH_O},
    {"glCullFace", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glCullFace), METH_O},
    {"glDeleteBuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDeleteBuffers), METH_VARARGS},
    {"glDeleteFramebuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDeleteFramebuffers), METH_VARARGS},
    {"glDeleteProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDeleteProgram), METH_O},
    {"glDeleteQueries", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDeleteQueries), METH_VARARGS},
    {"glDeleteRenderbuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDeleteRenderbuffers), METH_VARARGS},
    {"glDeleteShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDeleteShader), METH_O},
    {"glDeleteTextures", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDeleteTextures), METH_VARARGS},
    {"glDeleteVertexArrays", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDeleteVertexArrays), METH_VARARGS},
    {"glDepthFunc", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDepthFunc), METH_O},
    {"glDepthMask", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDepthMask), METH_O},
    {"glDepthRange", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDepthRange), METH_VARARGS},
    {"glDetachShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDetachShader), METH_VARARGS},
    {"glDisable", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDisable), METH_O},
    {"glDisableVertexAttribArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDisableVertexAttribArray), METH_O},
    {"glDisablei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDisablei), METH_VARARGS},
    {"glDrawArrays", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDrawArrays), METH_VARARGS},
    {"glDrawArraysInstanced", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDrawArraysInstanced), METH_VARARGS},
    {"glDrawBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDrawBuffer), METH_O},
    {"glDrawBuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDrawBuffers), METH_VARARGS},
    {"glDrawElements", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDrawElements), METH_VARARGS},
    {"glDrawElementsInstanced", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDrawElementsInstanced), METH_VARARGS},
    {"glDrawRangeElements", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glDrawRangeElements), METH_VARARGS},
    {"glEnable", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glEnable), METH_O},
    {"glEnableVertexAttribArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glEnableVertexAttribArray), METH_O},
    {"glEnablei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glEnablei), METH_VARARGS},
    {"glEndConditionalRender", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glEndConditionalRender), METH_NOARGS},
    {"glEndQuery", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glEndQuery), METH_O},
    {"glEndTransformFeedback", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glEndTransformFeedback), METH_NOARGS},
    {"glFinish", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glFinish), METH_NOARGS},
    {"glFlush", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glFlush), METH_NOARGS},
    {"glFramebufferRenderbuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glFramebufferRenderbuffer), METH_VARARGS},
    {"glFramebufferTexture1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture1D), METH_VARARGS},
    {"glFramebufferTexture2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture2D), METH_VARARGS},
    {"glFramebufferTexture3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glFramebufferTexture3D), METH_VARARGS},
    {"glFramebufferTextureLayer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glFramebufferTextureLayer), METH_VARARGS},
    {"glFrontFace", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glFrontFace), METH_O},
    {"glGenerateMipmap", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glGenerateMipmap), METH_O},
    {"glGetAttribLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glGetAttribLocation), METH_VARARGS},
    {"glGetError", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glGetError), METH_NOARGS},
    {"glGetFragDataLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glGetFragDataLocation), METH_VARARGS},
    {"glGetString", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glGetString), METH_O},
    {"glGetStringi", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glGetStringi), METH_VARARGS},
    {"glGetUniformBlockIndex", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glGetUniformBlockIndex), METH_VARARGS},
    {"glGetUniformLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glGetUniformLocation), METH_VARARGS},
    {"glHint", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glHint), METH_VARARGS},
    {"glIndexub", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIndexub), METH_O},
    {"glIndexubv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIndexubv), METH_O},
    {"glIsBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsBuffer), METH_O},
    {"glIsEnabled", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsEnabled), METH_O},
    {"glIsEnabledi", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsEnabledi), METH_VARARGS},
    {"glIsFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsFramebuffer), METH_O},
    {"glIsProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsProgram), METH_O},
    {"glIsQuery", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsQuery), METH_O},
    {"glIsRenderbuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsRenderbuffer), METH_O},
    {"glIsShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsShader), METH_O},
    {"glIsTexture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsTexture), METH_O},
    {"glIsVertexArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glIsVertexArray), METH_O},
    {"glLineWidth", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glLineWidth), METH_O},
    {"glLinkProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glLinkProgram), METH_O},
    {"glLogicOp", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glLogicOp), METH_O},
    {"glMapBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glMapBuffer), METH_VARARGS},
    {"glMultiDrawArrays", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glMultiDrawArrays), METH_VARARGS},
    {"glPixelStoref", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPixelStoref), METH_VARARGS},
    {"glPixelStorei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPixelStorei), METH_VARARGS},
    {"glPointParameterf", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPointParameterf), METH_VARARGS},
    {"glPointParameterfv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPointParameterfv), METH_VARARGS},
    {"glPointParameteri", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPointParameteri), METH_VARARGS},
    {"glPointParameteriv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPointParameteriv), METH_VARARGS},
    {"glPointSize", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPointSize), METH_O},
    {"glPolygonMode", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPolygonMode), METH_VARARGS},
    {"glPolygonOffset", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPolygonOffset), METH_VARARGS},
    {"glPrimitiveRestartIndex", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glPrimitiveRestartIndex), METH_O},
    {"glReadBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glReadBuffer), METH_O},
    {"glRenderbufferStorage", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glRenderbufferStorage), METH_VARARGS},
    {"glRenderbufferStorageMultisample", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glRenderbufferStorageMultisample), METH_VARARGS},
    {"glSampleCoverage", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glSampleCoverage), METH_VARARGS},
    {"glScissor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glScissor), METH_VARARGS},
    {"glStencilFunc", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glStencilFunc), METH_VARARGS},
    {"glStencilFuncSeparate", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glStencilFuncSeparate), METH_VARARGS},
    {"glStencilMask", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glStencilMask), METH_O},
    {"glStencilMaskSeparate", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glStencilMaskSeparate), METH_VARARGS},
    {"glStencilOp", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glStencilOp), METH_VARARGS},
    {"glStencilOpSeparate", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glStencilOpSeparate), METH_VARARGS},
    {"glTexBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexBuffer), METH_VARARGS},
    {"glTexImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexImage1D), METH_VARARGS},
    {"glTexImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexImage2D), METH_VARARGS},
    {"glTexImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexImage3D), METH_VARARGS},
    {"glTexParameterIiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexParameterIiv), METH_VARARGS},
    {"glTexParameterIuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexParameterIuiv), METH_VARARGS},
    {"glTexParameterf", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexParameterf), METH_VARARGS},
    {"glTexParameterfv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexParameterfv), METH_VARARGS},
    {"glTexParameteri", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexParameteri), METH_VARARGS},
    {"glTexParameteriv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexParameteriv), METH_VARARGS},
    {"glTexSubImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexSubImage1D), METH_VARARGS},
    {"glTexSubImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexSubImage2D), METH_VARARGS},
    {"glTexSubImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glTexSubImage3D), METH_VARARGS},
    {"glUniform1f", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform1f), METH_VARARGS},
    {"glUniform1fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform1fv), METH_VARARGS},
    {"glUniform1i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform1i), METH_VARARGS},
    {"glUniform1iv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform1iv), METH_VARARGS},
    {"glUniform1ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform1ui), METH_VARARGS},
    {"glUniform1uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform1uiv), METH_VARARGS},
    {"glUniform2f", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform2f), METH_VARARGS},
    {"glUniform2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform2fv), METH_VARARGS},
    {"glUniform2i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform2i), METH_VARARGS},
    {"glUniform2iv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform2iv), METH_VARARGS},
    {"glUniform2ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform2ui), METH_VARARGS},
    {"glUniform2uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform2uiv), METH_VARARGS},
    {"glUniform3f", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform3f), METH_VARARGS},
    {"glUniform3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform3fv), METH_VARARGS},
    {"glUniform3i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform3i), METH_VARARGS},
    {"glUniform3iv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform3iv), METH_VARARGS},
    {"glUniform3ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform3ui), METH_VARARGS},
    {"glUniform3uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform3uiv), METH_VARARGS},
    {"glUniform4f", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform4f), METH_VARARGS},
    {"glUniform4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform4fv), METH_VARARGS},
    {"glUniform4i", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform4i), METH_VARARGS},
    {"glUniform4iv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform4iv), METH_VARARGS},
    {"glUniform4ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform4ui), METH_VARARGS},
    {"glUniform4uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniform4uiv), METH_VARARGS},
    {"glUniformBlockBinding", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformBlockBinding), METH_VARARGS},
    {"glUniformMatrix2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2fv), METH_VARARGS},
    {"glUniformMatrix2x3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2x3fv), METH_VARARGS},
    {"glUniformMatrix2x4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix2x4fv), METH_VARARGS},
    {"glUniformMatrix3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3fv), METH_VARARGS},
    {"glUniformMatrix3x2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3x2fv), METH_VARARGS},
    {"glUniformMatrix3x4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix3x4fv), METH_VARARGS},
    {"glUniformMatrix4fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4fv), METH_VARARGS},
    {"glUniformMatrix4x2fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4x2fv), METH_VARARGS},
    {"glUniformMatrix4x3fv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUniformMatrix4x3fv), METH_VARARGS},
    {"glUnmapBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUnmapBuffer), METH_O},
    {"glUseProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glUseProgram), METH_O},
    {"glValidateProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glValidateProgram), METH_O},
    {"glVertexAttribIPointer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glVertexAttribIPointer), METH_VARARGS},
    {"glVertexAttribPointer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glVertexAttribPointer), METH_VARARGS},
    {"glViewport", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_glViewport), METH_VARARGS},
    {"initializeOpenGLFunctions", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_3_1Func_initializeOpenGLFunctions), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QOpenGLFunctions_3_1_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QOpenGLFunctions_3_1 *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QOpenGLFunctions_3_1Wrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QOpenGLFunctions_3_1_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLFunctions_3_1_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLFunctions_3_1_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLFunctions_3_1_TypeF(void)
{
    return _Sbk_QOpenGLFunctions_3_1_Type;
}

static PyType_Slot Sbk_QOpenGLFunctions_3_1_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QOpenGLFunctions_3_1_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLFunctions_3_1_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLFunctions_3_1_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLFunctions_3_1_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLFunctions_3_1_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLFunctions_3_1_spec = {
    "2:PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLFunctions_3_1_slots
};

} //extern "C"

static void *Sbk_QOpenGLFunctions_3_1_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QAbstractOpenGLFunctions >()))
        return dynamic_cast< ::QOpenGLFunctions_3_1 *>(reinterpret_cast< ::QAbstractOpenGLFunctions *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLFunctions_3_1_PythonToCpp_QOpenGLFunctions_3_1_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLFunctions_3_1_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLFunctions_3_1_PythonToCpp_QOpenGLFunctions_3_1_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLFunctions_3_1_TypeF())))
        return QOpenGLFunctions_3_1_PythonToCpp_QOpenGLFunctions_3_1_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLFunctions_3_1_PTR_CppToPython_QOpenGLFunctions_3_1(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLFunctions_3_1 *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLFunctions_3_1_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLFunctions_3_1_SignatureStrings[] = {
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1(self)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glActiveTexture(self,texture:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glAttachShader(self,program:unsigned int,shader:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBeginConditionalRender(self,id:unsigned int,mode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBeginQuery(self,target:unsigned int,id:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBeginTransformFeedback(self,primitiveMode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindAttribLocation(self,program:unsigned int,index:unsigned int,name:char*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindBuffer(self,target:unsigned int,buffer:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindBufferBase(self,target:unsigned int,index:unsigned int,buffer:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindFragDataLocation(self,program:unsigned int,color:unsigned int,name:char*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindFramebuffer(self,target:unsigned int,framebuffer:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindRenderbuffer(self,target:unsigned int,renderbuffer:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindTexture(self,target:unsigned int,texture:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBindVertexArray(self,array:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendColor(self,red:float,green:float,blue:float,alpha:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendEquation(self,mode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendEquationSeparate(self,modeRGB:unsigned int,modeAlpha:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendFunc(self,sfactor:unsigned int,dfactor:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlendFuncSeparate(self,sfactorRGB:unsigned int,dfactorRGB:unsigned int,sfactorAlpha:unsigned int,dfactorAlpha:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glBlitFramebuffer(self,srcX0:int,srcY0:int,srcX1:int,srcY1:int,dstX0:int,dstY0:int,dstX1:int,dstY1:int,mask:unsigned int,filter:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCheckFramebufferStatus(self,target:unsigned int)->unsigned int",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClampColor(self,target:unsigned int,clamp:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClear(self,mask:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearBufferfi(self,buffer:unsigned int,drawbuffer:int,depth:float,stencil:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearBufferfv(self,buffer:unsigned int,drawbuffer:int,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearBufferiv(self,buffer:unsigned int,drawbuffer:int,value:array int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearBufferuiv(self,buffer:unsigned int,drawbuffer:int,value:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearColor(self,red:float,green:float,blue:float,alpha:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearDepth(self,depth:double)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glClearStencil(self,s:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glColorMask(self,red:unsigned char,green:unsigned char,blue:unsigned char,alpha:unsigned char)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glColorMaski(self,index:unsigned int,r:unsigned char,g:unsigned char,b:unsigned char,a:unsigned char)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompileShader(self,shader:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexImage1D(self,target:unsigned int,level:int,internalformat:unsigned int,width:int,border:int,imageSize:int,data:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexImage2D(self,target:unsigned int,level:int,internalformat:unsigned int,width:int,height:int,border:int,imageSize:int,data:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexImage3D(self,target:unsigned int,level:int,internalformat:unsigned int,width:int,height:int,depth:int,border:int,imageSize:int,data:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexSubImage1D(self,target:unsigned int,level:int,xoffset:int,width:int,format:unsigned int,imageSize:int,data:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexSubImage2D(self,target:unsigned int,level:int,xoffset:int,yoffset:int,width:int,height:int,format:unsigned int,imageSize:int,data:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCompressedTexSubImage3D(self,target:unsigned int,level:int,xoffset:int,yoffset:int,zoffset:int,width:int,height:int,depth:int,format:unsigned int,imageSize:int,data:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexImage1D(self,target:unsigned int,level:int,internalformat:unsigned int,x:int,y:int,width:int,border:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexImage2D(self,target:unsigned int,level:int,internalformat:unsigned int,x:int,y:int,width:int,height:int,border:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexSubImage1D(self,target:unsigned int,level:int,xoffset:int,x:int,y:int,width:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexSubImage2D(self,target:unsigned int,level:int,xoffset:int,yoffset:int,x:int,y:int,width:int,height:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCopyTexSubImage3D(self,target:unsigned int,level:int,xoffset:int,yoffset:int,zoffset:int,x:int,y:int,width:int,height:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCreateProgram(self)->unsigned int",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCreateShader(self,type:unsigned int)->unsigned int",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glCullFace(self,mode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteBuffers(self,n:int,buffers:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteFramebuffers(self,n:int,framebuffers:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteProgram(self,program:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteQueries(self,n:int,ids:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteRenderbuffers(self,n:int,renderbuffers:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteShader(self,shader:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteTextures(self,n:int,textures:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDeleteVertexArrays(self,n:int,arrays:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDepthFunc(self,func:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDepthMask(self,flag:unsigned char)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDepthRange(self,nearVal:double,farVal:double)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDetachShader(self,program:unsigned int,shader:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDisable(self,cap:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDisableVertexAttribArray(self,index:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDisablei(self,target:unsigned int,index:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawArrays(self,mode:unsigned int,first:int,count:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawArraysInstanced(self,mode:unsigned int,first:int,count:int,instancecount:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawBuffer(self,mode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawBuffers(self,n:int,bufs:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawElements(self,mode:unsigned int,count:int,type:unsigned int,indices:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawElementsInstanced(self,mode:unsigned int,count:int,type:unsigned int,indices:void,instancecount:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glDrawRangeElements(self,mode:unsigned int,start:unsigned int,end:unsigned int,count:int,type:unsigned int,indices:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEnable(self,cap:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEnableVertexAttribArray(self,index:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEnablei(self,target:unsigned int,index:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEndConditionalRender(self)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEndQuery(self,target:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glEndTransformFeedback(self)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFinish(self)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFlush(self)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferRenderbuffer(self,target:unsigned int,attachment:unsigned int,renderbuffertarget:unsigned int,renderbuffer:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferTexture1D(self,target:unsigned int,attachment:unsigned int,textarget:unsigned int,texture:unsigned int,level:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferTexture2D(self,target:unsigned int,attachment:unsigned int,textarget:unsigned int,texture:unsigned int,level:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferTexture3D(self,target:unsigned int,attachment:unsigned int,textarget:unsigned int,texture:unsigned int,level:int,zoffset:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFramebufferTextureLayer(self,target:unsigned int,attachment:unsigned int,texture:unsigned int,level:int,layer:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glFrontFace(self,mode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGenerateMipmap(self,target:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetAttribLocation(self,program:unsigned int,name:char*)->int",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetError(self)->unsigned int",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetFragDataLocation(self,program:unsigned int,name:char*)->int",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetString(self,name:unsigned int)->unsigned char*",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetStringi(self,name:unsigned int,index:unsigned int)->unsigned char*",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetUniformBlockIndex(self,program:unsigned int,uniformBlockName:char*)->unsigned int",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glGetUniformLocation(self,program:unsigned int,name:char*)->int",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glHint(self,target:unsigned int,mode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIndexub(self,c:unsigned char)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIndexubv(self,c:unsigned char*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsBuffer(self,buffer:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsEnabled(self,cap:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsEnabledi(self,target:unsigned int,index:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsFramebuffer(self,framebuffer:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsProgram(self,program:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsQuery(self,id:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsRenderbuffer(self,renderbuffer:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsShader(self,shader:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsTexture(self,texture:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glIsVertexArray(self,array:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glLineWidth(self,width:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glLinkProgram(self,program:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glLogicOp(self,opcode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glMapBuffer(self,target:unsigned int,access:unsigned int)->void",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glMultiDrawArrays(self,mode:unsigned int,first:array int*,count:array int*,drawcount:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPixelStoref(self,pname:unsigned int,param:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPixelStorei(self,pname:unsigned int,param:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointParameterf(self,pname:unsigned int,param:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointParameterfv(self,pname:unsigned int,params:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointParameteri(self,pname:unsigned int,param:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointParameteriv(self,pname:unsigned int,params:array int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPointSize(self,size:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPolygonMode(self,face:unsigned int,mode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPolygonOffset(self,factor:float,units:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glPrimitiveRestartIndex(self,index:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glReadBuffer(self,mode:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glRenderbufferStorage(self,target:unsigned int,internalformat:unsigned int,width:int,height:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glRenderbufferStorageMultisample(self,target:unsigned int,samples:int,internalformat:unsigned int,width:int,height:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glSampleCoverage(self,value:float,invert:unsigned char)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glScissor(self,x:int,y:int,width:int,height:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilFunc(self,func:unsigned int,ref:int,mask:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilFuncSeparate(self,face:unsigned int,func:unsigned int,ref:int,mask:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilMask(self,mask:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilMaskSeparate(self,face:unsigned int,mask:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilOp(self,fail:unsigned int,zfail:unsigned int,zpass:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glStencilOpSeparate(self,face:unsigned int,sfail:unsigned int,dpfail:unsigned int,dppass:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexBuffer(self,target:unsigned int,internalformat:unsigned int,buffer:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexImage1D(self,target:unsigned int,level:int,internalformat:int,width:int,border:int,format:unsigned int,type:unsigned int,pixels:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexImage2D(self,target:unsigned int,level:int,internalformat:int,width:int,height:int,border:int,format:unsigned int,type:unsigned int,pixels:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexImage3D(self,target:unsigned int,level:int,internalformat:int,width:int,height:int,depth:int,border:int,format:unsigned int,type:unsigned int,pixels:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameterIiv(self,target:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameterIuiv(self,target:unsigned int,pname:unsigned int,params:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameterf(self,target:unsigned int,pname:unsigned int,param:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameterfv(self,target:unsigned int,pname:unsigned int,params:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameteri(self,target:unsigned int,pname:unsigned int,param:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexParameteriv(self,target:unsigned int,pname:unsigned int,params:array int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexSubImage1D(self,target:unsigned int,level:int,xoffset:int,width:int,format:unsigned int,type:unsigned int,pixels:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexSubImage2D(self,target:unsigned int,level:int,xoffset:int,yoffset:int,width:int,height:int,format:unsigned int,type:unsigned int,pixels:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glTexSubImage3D(self,target:unsigned int,level:int,xoffset:int,yoffset:int,zoffset:int,width:int,height:int,depth:int,format:unsigned int,type:unsigned int,pixels:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1f(self,location:int,v0:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1fv(self,location:int,count:int,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1i(self,location:int,v0:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1iv(self,location:int,count:int,value:array int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1ui(self,location:int,v0:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform1uiv(self,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2f(self,location:int,v0:float,v1:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2fv(self,location:int,count:int,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2i(self,location:int,v0:int,v1:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2iv(self,location:int,count:int,value:array int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2ui(self,location:int,v0:unsigned int,v1:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform2uiv(self,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3f(self,location:int,v0:float,v1:float,v2:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3fv(self,location:int,count:int,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3i(self,location:int,v0:int,v1:int,v2:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3iv(self,location:int,count:int,value:array int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3ui(self,location:int,v0:unsigned int,v1:unsigned int,v2:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform3uiv(self,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4f(self,location:int,v0:float,v1:float,v2:float,v3:float)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4fv(self,location:int,count:int,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4i(self,location:int,v0:int,v1:int,v2:int,v3:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4iv(self,location:int,count:int,value:array int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4ui(self,location:int,v0:unsigned int,v1:unsigned int,v2:unsigned int,v3:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniform4uiv(self,location:int,count:int,value:array unsigned int*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformBlockBinding(self,program:unsigned int,uniformBlockIndex:unsigned int,uniformBlockBinding:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix2fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix2x3fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix2x4fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix3fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix3x2fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix3x4fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix4fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix4x2fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUniformMatrix4x3fv(self,location:int,count:int,transpose:unsigned char,value:array float*)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUnmapBuffer(self,target:unsigned int)->unsigned char",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glUseProgram(self,program:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glValidateProgram(self,program:unsigned int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glVertexAttribIPointer(self,index:unsigned int,size:int,type:unsigned int,stride:int,pointer:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glVertexAttribPointer(self,index:unsigned int,size:int,type:unsigned int,normalized:unsigned char,stride:int,pointer:void)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.glViewport(self,x:int,y:int,width:int,height:int)",
    "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_1.initializeOpenGLFunctions(self)->bool",
    nullptr}; // Sentinel

void init_QOpenGLFunctions_3_1(PyObject *module)
{
    _Sbk_QOpenGLFunctions_3_1_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLFunctions_3_1",
        "QOpenGLFunctions_3_1*",
        &Sbk_QOpenGLFunctions_3_1_spec,
        &Shiboken::callCppDestructor< ::QOpenGLFunctions_3_1 >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QABSTRACTOPENGLFUNCTIONS_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLFunctions_3_1_Type);
    InitSignatureStrings(pyType, QOpenGLFunctions_3_1_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLFunctions_3_1_Type), Sbk_QOpenGLFunctions_3_1_PropertyStrings);
    SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLFunctions_3_1_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLFunctions_3_1_TypeF(),
        QOpenGLFunctions_3_1_PythonToCpp_QOpenGLFunctions_3_1_PTR,
        is_QOpenGLFunctions_3_1_PythonToCpp_QOpenGLFunctions_3_1_PTR_Convertible,
        QOpenGLFunctions_3_1_PTR_CppToPython_QOpenGLFunctions_3_1);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLFunctions_3_1");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLFunctions_3_1*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLFunctions_3_1&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLFunctions_3_1).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLFunctions_3_1Wrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QOpenGLFunctions_3_1_TypeF(), &Sbk_QOpenGLFunctions_3_1_typeDiscovery);

}
