/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeoareamonitorsource_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoAreaMonitorSourceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoAreaMonitorSourceWrapper::QGeoAreaMonitorSourceWrapper(::QObject * parent) : QGeoAreaMonitorSource(parent)
{
    resetPyMethodCache();
    // ... middle
}

::QList<QGeoAreaMonitorInfo > QGeoAreaMonitorSourceWrapper::activeMonitors() const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.activeMonitors()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "activeMonitors";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.activeMonitors()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOAREAMONITORINFO_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.activeMonitors", "list", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QList<QGeoAreaMonitorInfo > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QList<QGeoAreaMonitorInfo > QGeoAreaMonitorSourceWrapper::activeMonitors(const ::QGeoShape & lookupArea) const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.activeMonitors()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "activeMonitors";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.activeMonitors()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), &lookupArea)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOAREAMONITORINFO_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.activeMonitors", "list", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QList<QGeoAreaMonitorInfo > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGeoAreaMonitorSourceWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoAreaMonitorSourceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoAreaMonitorSourceWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoAreaMonitorSourceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QGeoAreaMonitorSource::Error QGeoAreaMonitorSourceWrapper::error() const
{
    if (m_PyMethodCache[6]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.error()' not implemented.");
        return QGeoAreaMonitorSource::AccessError;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QGeoAreaMonitorSource::AccessError;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "error";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.error()' not implemented.");
        return QGeoAreaMonitorSource::AccessError;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QGeoAreaMonitorSource::AccessError;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.error", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoAreaMonitorSource::Error >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QGeoAreaMonitorSource::AccessError;
    }
    ::QGeoAreaMonitorSource::Error cppResult{QGeoAreaMonitorSource::AccessError};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QGeoAreaMonitorSourceWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGeoAreaMonitorSourceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[8])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QGeoPositionInfoSource * QGeoAreaMonitorSourceWrapper::positionInfoSource() const
{
    if (m_PyMethodCache[10])
        return this->::QGeoAreaMonitorSource::positionInfoSource();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "positionInfoSource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QGeoAreaMonitorSource::positionInfoSource();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.positionInfoSource", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoPositionInfoSource >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoPositionInfoSource *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QGeoAreaMonitorSourceWrapper::requestUpdate(const ::QGeoAreaMonitorInfo & monitor, const char * signal)
{
    if (m_PyMethodCache[11]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.requestUpdate()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "requestUpdate";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.requestUpdate()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), &monitor),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.requestUpdate", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGeoAreaMonitorSourceWrapper::setPositionInfoSource(::QGeoPositionInfoSource * source)
{
    if (m_PyMethodCache[12]) {
        return this->::QGeoAreaMonitorSource::setPositionInfoSource(source);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setPositionInfoSource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QGeoAreaMonitorSource::setPositionInfoSource(source);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), source)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGeoAreaMonitorSourceWrapper::startMonitoring(const ::QGeoAreaMonitorInfo & monitor)
{
    if (m_PyMethodCache[13]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.startMonitoring()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "startMonitoring";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.startMonitoring()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), &monitor)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.startMonitoring", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QGeoAreaMonitorSourceWrapper::stopMonitoring(const ::QGeoAreaMonitorInfo & monitor)
{
    if (m_PyMethodCache[14]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.stopMonitoring()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stopMonitoring";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.stopMonitoring()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), &monitor)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.stopMonitoring", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature> QGeoAreaMonitorSourceWrapper::supportedAreaMonitorFeatures() const
{
    if (m_PyMethodCache[15]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.supportedAreaMonitorFeatures()' not implemented.");
        return QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>(0);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportedAreaMonitorFeatures";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.supportedAreaMonitorFeatures()' not implemented.");
        return QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>(0);
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitorSource.supportedAreaMonitorFeatures", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QGeoAreaMonitorSource::AreaMonitorFeature> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>(0);
    }
    ::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature> cppResult = QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGeoAreaMonitorSourceWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[16]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGeoAreaMonitorSourceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGeoAreaMonitorSource::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGeoAreaMonitorSourceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGeoAreaMonitorSource::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGeoAreaMonitorSourceWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGeoAreaMonitorSourceWrapper *>(this));
        return QGeoAreaMonitorSource::qt_metacast(_clname);
}

QGeoAreaMonitorSourceWrapper::~QGeoAreaMonitorSourceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoAreaMonitorSource_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGeoAreaMonitorSource' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoAreaMonitorSource >()))
        return -1;

    ::QGeoAreaMonitorSourceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoAreaMonitorSource", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoAreaMonitorSource::QGeoAreaMonitorSource(QObject*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGeoAreaMonitorSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorSource_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QGeoAreaMonitorSource(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QGeoAreaMonitorSourceWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QGeoAreaMonitorSourceWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoAreaMonitorSource >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoAreaMonitorSource_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGeoAreaMonitorSource_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGeoAreaMonitorSource_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_activeMonitors(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.activeMonitors";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "activeMonitors", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGeoAreaMonitorSource::activeMonitors(QGeoShape)const
    // 1: QGeoAreaMonitorSource::activeMonitors()const
    if (numArgs == 0) {
        overloadId = 1; // activeMonitors()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // activeMonitors(QGeoShape)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorSourceFunc_activeMonitors_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // activeMonitors(const QGeoShape & lookupArea) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QGeoShape cppArg0_local;
            ::QGeoShape *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // activeMonitors(QGeoShape)const
                if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.activeMonitors()' not implemented.");
                    return {};
                }
                QList<QGeoAreaMonitorInfo > cppResult = const_cast<const ::QGeoAreaMonitorSource *>(cppSelf)->activeMonitors(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOAREAMONITORINFO_IDX], &cppResult);
            }
            break;
        }
        case 1: // activeMonitors() const
        {

            if (!PyErr_Occurred()) {
                // activeMonitors()const
                if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.activeMonitors()' not implemented.");
                    return {};
                }
                QList<QGeoAreaMonitorInfo > cppResult = const_cast<const ::QGeoAreaMonitorSource *>(cppSelf)->activeMonitors();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOAREAMONITORINFO_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoAreaMonitorSourceFunc_activeMonitors_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_availableSources(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.availableSources";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableSources()
            QStringList cppResult = ::QGeoAreaMonitorSource::availableSources();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_createDefaultSource(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.createDefaultSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGeoAreaMonitorSource::createDefaultSource(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // createDefaultSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorSourceFunc_createDefaultSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createDefaultSource(QObject*)
            QGeoAreaMonitorSource * cppResult = ::QGeoAreaMonitorSource::createDefaultSource(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoAreaMonitorSourceFunc_createDefaultSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_createSource(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.createSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createSource", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QGeoAreaMonitorSource::createSource(QString,QObject*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // createSource(QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorSourceFunc_createSource_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // createSource(QString,QObject*)
            QGeoAreaMonitorSource * cppResult = ::QGeoAreaMonitorSource::createSource(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoAreaMonitorSourceFunc_createSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.error()' not implemented.");
                return {};
            }
            QGeoAreaMonitorSource::Error cppResult = const_cast<const ::QGeoAreaMonitorSource *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_positionInfoSource(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.positionInfoSource";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // positionInfoSource()const
            QGeoPositionInfoSource * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGeoAreaMonitorSource *>(cppSelf)->::QGeoAreaMonitorSource::positionInfoSource()
                : const_cast<const ::QGeoAreaMonitorSource *>(cppSelf)->positionInfoSource();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_requestUpdate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.requestUpdate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "requestUpdate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoAreaMonitorSource::requestUpdate(QGeoAreaMonitorInfo,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // requestUpdate(QGeoAreaMonitorInfo,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorSourceFunc_requestUpdate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGeoAreaMonitorInfo cppArg0_local;
        ::QGeoAreaMonitorInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // requestUpdate(QGeoAreaMonitorInfo,const char*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.requestUpdate()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->requestUpdate(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoAreaMonitorSourceFunc_requestUpdate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_setPositionInfoSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.setPositionInfoSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAreaMonitorSource::setPositionInfoSource(QGeoPositionInfoSource*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), (pyArg)))) {
        overloadId = 0; // setPositionInfoSource(QGeoPositionInfoSource*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorSourceFunc_setPositionInfoSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoPositionInfoSource *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPositionInfoSource(QGeoPositionInfoSource*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGeoAreaMonitorSource::setPositionInfoSource(cppArg0)
                : cppSelf->setPositionInfoSource(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAreaMonitorSourceFunc_setPositionInfoSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_sourceName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.sourceName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceName()const
            QString cppResult = const_cast<const ::QGeoAreaMonitorSource *>(cppSelf)->sourceName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_startMonitoring(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.startMonitoring";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAreaMonitorSource::startMonitoring(QGeoAreaMonitorInfo)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), (pyArg)))) {
        overloadId = 0; // startMonitoring(QGeoAreaMonitorInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorSourceFunc_startMonitoring_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoAreaMonitorInfo cppArg0_local;
        ::QGeoAreaMonitorInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // startMonitoring(QGeoAreaMonitorInfo)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.startMonitoring()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->startMonitoring(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoAreaMonitorSourceFunc_startMonitoring_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_stopMonitoring(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.stopMonitoring";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAreaMonitorSource::stopMonitoring(QGeoAreaMonitorInfo)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), (pyArg)))) {
        overloadId = 0; // stopMonitoring(QGeoAreaMonitorInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorSourceFunc_stopMonitoring_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoAreaMonitorInfo cppArg0_local;
        ::QGeoAreaMonitorInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // stopMonitoring(QGeoAreaMonitorInfo)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.stopMonitoring()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->stopMonitoring(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoAreaMonitorSourceFunc_stopMonitoring_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorSourceFunc_supportedAreaMonitorFeatures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorSource.supportedAreaMonitorFeatures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedAreaMonitorFeatures()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoAreaMonitorSource.supportedAreaMonitorFeatures()' not implemented.");
                return {};
            }
            QFlags<QGeoAreaMonitorSource::AreaMonitorFeature> cppResult = const_cast<const ::QGeoAreaMonitorSource *>(cppSelf)->supportedAreaMonitorFeatures();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoAreaMonitorSource_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoAreaMonitorSource_methods[] = {
    {"activeMonitors", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_activeMonitors), METH_VARARGS},
    {"availableSources", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_availableSources), METH_NOARGS|METH_STATIC},
    {"createDefaultSource", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_createDefaultSource), METH_O|METH_STATIC},
    {"createSource", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_createSource), METH_VARARGS|METH_STATIC},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_error), METH_NOARGS},
    {"positionInfoSource", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_positionInfoSource), METH_NOARGS},
    {"requestUpdate", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_requestUpdate), METH_VARARGS},
    {"setPositionInfoSource", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_setPositionInfoSource), METH_O},
    {"sourceName", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_sourceName), METH_NOARGS},
    {"startMonitoring", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_startMonitoring), METH_O},
    {"stopMonitoring", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_stopMonitoring), METH_O},
    {"supportedAreaMonitorFeatures", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorSourceFunc_supportedAreaMonitorFeatures), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoAreaMonitorSource_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoAreaMonitorSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoAreaMonitorSourceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoAreaMonitorSource_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoAreaMonitorSource_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoAreaMonitorSource_Type = nullptr;
static SbkObjectType *Sbk_QGeoAreaMonitorSource_TypeF(void)
{
    return _Sbk_QGeoAreaMonitorSource_Type;
}

static PyType_Slot Sbk_QGeoAreaMonitorSource_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoAreaMonitorSource_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoAreaMonitorSource_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoAreaMonitorSource_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoAreaMonitorSource_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoAreaMonitorSource_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoAreaMonitorSource_spec = {
    "2:PySide2.QtPositioning.QGeoAreaMonitorSource",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoAreaMonitorSource_slots
};

} //extern "C"

static void *Sbk_QGeoAreaMonitorSource_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGeoAreaMonitorSource *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoAreaMonitorSource::AreaMonitorFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoAreaMonitorSource::AreaMonitorFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoAreaMonitorSource::AreaMonitorFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoAreaMonitorSource::AreaMonitorFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoAreaMonitorSource::AreaMonitorFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])->converter, self, &cppSelf);
    ::QGeoAreaMonitorSource::AreaMonitorFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoAreaMonitorSource_Error_PythonToCpp_QGeoAreaMonitorSource_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoAreaMonitorSource::Error *>(cppOut) =
        static_cast<::QGeoAreaMonitorSource::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoAreaMonitorSource_Error_PythonToCpp_QGeoAreaMonitorSource_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX]))
        return QGeoAreaMonitorSource_Error_PythonToCpp_QGeoAreaMonitorSource_Error;
    return {};
}
static PyObject *QGeoAreaMonitorSource_Error_CppToPython_QGeoAreaMonitorSource_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoAreaMonitorSource::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX], castCppIn);

}

static void QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QGeoAreaMonitorSource_AreaMonitorFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoAreaMonitorSource::AreaMonitorFeature *>(cppOut) =
        static_cast<::QGeoAreaMonitorSource::AreaMonitorFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QGeoAreaMonitorSource_AreaMonitorFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX]))
        return QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QGeoAreaMonitorSource_AreaMonitorFeature;
    return {};
}
static PyObject *QGeoAreaMonitorSource_AreaMonitorFeature_CppToPython_QGeoAreaMonitorSource_AreaMonitorFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoAreaMonitorSource::AreaMonitorFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX], castCppIn);

}

static void QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature> *>(cppOut) =
        ::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX]))
        return QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_;
    return {};
}
static PyObject *QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__CppToPython_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX]));

}

static void QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature> *>(cppOut) =
        ::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX]))
        return QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature> *>(cppOut) =
        ::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoAreaMonitorSource_PythonToCpp_QGeoAreaMonitorSource_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoAreaMonitorSource_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoAreaMonitorSource_PythonToCpp_QGeoAreaMonitorSource_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoAreaMonitorSource_TypeF())))
        return QGeoAreaMonitorSource_PythonToCpp_QGeoAreaMonitorSource_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoAreaMonitorSource_PTR_CppToPython_QGeoAreaMonitorSource(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGeoAreaMonitorSource *>(const_cast<void *>(cppIn)), Sbk_QGeoAreaMonitorSource_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoAreaMonitorSource_SignatureStrings[] = {
    "PySide2.QtPositioning.QGeoAreaMonitorSource(self,parent:PySide2.QtCore.QObject)",
    "1:PySide2.QtPositioning.QGeoAreaMonitorSource.activeMonitors(self,lookupArea:PySide2.QtPositioning.QGeoShape)->QList[PySide2.QtPositioning.QGeoAreaMonitorInfo]",
    "0:PySide2.QtPositioning.QGeoAreaMonitorSource.activeMonitors(self)->QList[PySide2.QtPositioning.QGeoAreaMonitorInfo]",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.availableSources()->QStringList",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.createDefaultSource(parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoAreaMonitorSource",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.createSource(sourceName:QString,parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoAreaMonitorSource",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.error(self)->PySide2.QtPositioning.QGeoAreaMonitorSource.Error",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.positionInfoSource(self)->PySide2.QtPositioning.QGeoPositionInfoSource",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.requestUpdate(self,monitor:PySide2.QtPositioning.QGeoAreaMonitorInfo,signal:char*)->bool",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.setPositionInfoSource(self,source:PySide2.QtPositioning.QGeoPositionInfoSource)",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.sourceName(self)->QString",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.startMonitoring(self,monitor:PySide2.QtPositioning.QGeoAreaMonitorInfo)->bool",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.stopMonitoring(self,monitor:PySide2.QtPositioning.QGeoAreaMonitorInfo)->bool",
    "PySide2.QtPositioning.QGeoAreaMonitorSource.supportedAreaMonitorFeatures(self)->PySide2.QtPositioning.QGeoAreaMonitorSource.AreaMonitorFeatures",
    nullptr}; // Sentinel

void init_QGeoAreaMonitorSource(PyObject *module)
{
    _Sbk_QGeoAreaMonitorSource_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoAreaMonitorSource",
        "QGeoAreaMonitorSource*",
        &Sbk_QGeoAreaMonitorSource_spec,
        &Shiboken::callCppDestructor< ::QGeoAreaMonitorSource >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoAreaMonitorSource_Type);
    InitSignatureStrings(pyType, QGeoAreaMonitorSource_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoAreaMonitorSource_Type), Sbk_QGeoAreaMonitorSource_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoAreaMonitorSource_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoAreaMonitorSource_TypeF(),
        QGeoAreaMonitorSource_PythonToCpp_QGeoAreaMonitorSource_PTR,
        is_QGeoAreaMonitorSource_PythonToCpp_QGeoAreaMonitorSource_PTR_Convertible,
        QGeoAreaMonitorSource_PTR_CppToPython_QGeoAreaMonitorSource);

    Shiboken::Conversions::registerConverterName(converter, "QGeoAreaMonitorSource");
    Shiboken::Conversions::registerConverterName(converter, "QGeoAreaMonitorSource*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoAreaMonitorSource&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoAreaMonitorSource).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoAreaMonitorSourceWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGeoAreaMonitorSource_TypeF(), &Sbk_QGeoAreaMonitorSource_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoAreaMonitorSource_TypeF(),
        "Error",
        "2:PySide2.QtPositioning.QGeoAreaMonitorSource.Error",
        "QGeoAreaMonitorSource::Error");
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX],
        Sbk_QGeoAreaMonitorSource_TypeF(), "AccessError", (long) QGeoAreaMonitorSource::Error::AccessError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX],
        Sbk_QGeoAreaMonitorSource_TypeF(), "InsufficientPositionInfo", (long) QGeoAreaMonitorSource::Error::InsufficientPositionInfo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX],
        Sbk_QGeoAreaMonitorSource_TypeF(), "UnknownSourceError", (long) QGeoAreaMonitorSource::Error::UnknownSourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX],
        Sbk_QGeoAreaMonitorSource_TypeF(), "NoError", (long) QGeoAreaMonitorSource::Error::NoError))
        return;
    // Register converter for enum 'QGeoAreaMonitorSource::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX],
            QGeoAreaMonitorSource_Error_CppToPython_QGeoAreaMonitorSource_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoAreaMonitorSource_Error_PythonToCpp_QGeoAreaMonitorSource_Error,
            is_QGeoAreaMonitorSource_Error_PythonToCpp_QGeoAreaMonitorSource_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoAreaMonitorSource::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    // Initialization of enum 'AreaMonitorFeature'.
    SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtPositioning.QGeoAreaMonitorSource.AreaMonitorFeatures", SbkPySide2_QtPositioning_QGeoAreaMonitorSource_AreaMonitorFeature_number_slots);
    SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoAreaMonitorSource_TypeF(),
        "AreaMonitorFeature",
        "2:PySide2.QtPositioning.QGeoAreaMonitorSource.AreaMonitorFeature",
        "QGeoAreaMonitorSource::AreaMonitorFeature",
        SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX]);
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX],
        Sbk_QGeoAreaMonitorSource_TypeF(), "PersistentAreaMonitorFeature", (long) QGeoAreaMonitorSource::AreaMonitorFeature::PersistentAreaMonitorFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX],
        Sbk_QGeoAreaMonitorSource_TypeF(), "AnyAreaMonitorFeature", (long) QGeoAreaMonitorSource::AreaMonitorFeature::AnyAreaMonitorFeature))
        return;
    // Register converter for enum 'QGeoAreaMonitorSource::AreaMonitorFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX],
            QGeoAreaMonitorSource_AreaMonitorFeature_CppToPython_QGeoAreaMonitorSource_AreaMonitorFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QGeoAreaMonitorSource_AreaMonitorFeature,
            is_QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QGeoAreaMonitorSource_AreaMonitorFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoAreaMonitorSource::AreaMonitorFeature");
        Shiboken::Conversions::registerConverterName(converter, "AreaMonitorFeature");
    }
    // Register converter for flag 'QFlags<QGeoAreaMonitorSource::AreaMonitorFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX],
            QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__CppToPython_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_,
            is_QGeoAreaMonitorSource_AreaMonitorFeature_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_,
            is_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature_,
            is_number_PythonToCpp_QFlags_QGeoAreaMonitorSource_AreaMonitorFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOAREAMONITORSOURCE_AREAMONITORFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoAreaMonitorSource::AreaMonitorFeatures");
        Shiboken::Conversions::registerConverterName(converter, "AreaMonitorFeatures");
    }
    // End of 'AreaMonitorFeature' enum/flags.

    PySide::Signal::registerSignals(Sbk_QGeoAreaMonitorSource_TypeF(), &::QGeoAreaMonitorSource::staticMetaObject);
    qRegisterMetaType< ::QGeoAreaMonitorSource::Error >("QGeoAreaMonitorSource::Error");
    qRegisterMetaType< ::QGeoAreaMonitorSource::AreaMonitorFeature >("QGeoAreaMonitorSource::AreaMonitorFeature");
    qRegisterMetaType< ::QGeoAreaMonitorSource::AreaMonitorFeatures >("QGeoAreaMonitorSource::AreaMonitorFeatures");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGeoAreaMonitorSource_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGeoAreaMonitorSource_TypeF(), &::QGeoAreaMonitorSource::staticMetaObject, sizeof(QGeoAreaMonitorSourceWrapper));
}
