/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeocoordinate_wrapper.h"

// inner classes

// Extra includes
#include <QtPositioning/qgeocoordinate.h>
#include <qdatastream.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoCoordinate_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoCoordinate >()))
        return -1;

    ::QGeoCoordinate *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoCoordinate", 0, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoCoordinate::QGeoCoordinate()
    // 1: QGeoCoordinate::QGeoCoordinate(QGeoCoordinate)
    // 2: QGeoCoordinate::QGeoCoordinate(double,double)
    // 3: QGeoCoordinate::QGeoCoordinate(double,double,double)
    if (numArgs == 0) {
        overloadId = 0; // QGeoCoordinate()
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // QGeoCoordinate(double,double)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
            overloadId = 3; // QGeoCoordinate(double,double,double)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGeoCoordinate(QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCoordinate_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoCoordinate()
        {

            if (!PyErr_Occurred()) {
                // QGeoCoordinate()
                cptr = new ::QGeoCoordinate();
            }
            break;
        }
        case 1: // QGeoCoordinate(const QGeoCoordinate & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoCoordinate cppArg0_local;
            ::QGeoCoordinate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGeoCoordinate(QGeoCoordinate)
                cptr = new ::QGeoCoordinate(*cppArg0);
            }
            break;
        }
        case 2: // QGeoCoordinate(double latitude, double longitude)
        {
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            double cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QGeoCoordinate(double,double)
                cptr = new ::QGeoCoordinate(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // QGeoCoordinate(double latitude, double longitude, double altitude)
        {
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            double cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            double cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QGeoCoordinate(double,double,double)
                cptr = new ::QGeoCoordinate(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoCoordinate >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoCoordinate_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGeoCoordinate_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoCoordinateFunc_altitude(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.altitude";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // altitude()const
            double cppResult = const_cast<const ::QGeoCoordinate *>(cppSelf)->altitude();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCoordinateFunc_atDistanceAndAzimuth(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.atDistanceAndAzimuth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGeoCoordinateFunc_atDistanceAndAzimuth_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGeoCoordinateFunc_atDistanceAndAzimuth_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:atDistanceAndAzimuth", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGeoCoordinate::atDistanceAndAzimuth(qreal,qreal,qreal)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // atDistanceAndAzimuth(qreal,qreal,qreal)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
            overloadId = 0; // atDistanceAndAzimuth(qreal,qreal,qreal)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCoordinateFunc_atDistanceAndAzimuth_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_distanceUp = Shiboken::String::createStaticString("distanceUp");
            if (PyDict_Contains(kwds, key_distanceUp)) {
                value = PyDict_GetItem(kwds, key_distanceUp);
                if (value && pyArgs[2]) {
                    errInfo = key_distanceUp;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoCoordinateFunc_atDistanceAndAzimuth_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2]))))
                        goto Sbk_QGeoCoordinateFunc_atDistanceAndAzimuth_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_distanceUp);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGeoCoordinateFunc_atDistanceAndAzimuth_TypeError;
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2 = 0.0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // atDistanceAndAzimuth(qreal,qreal,qreal)const
            QGeoCoordinate cppResult = const_cast<const ::QGeoCoordinate *>(cppSelf)->atDistanceAndAzimuth(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoCoordinateFunc_atDistanceAndAzimuth_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCoordinateFunc_azimuthTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.azimuthTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCoordinate::azimuthTo(QGeoCoordinate)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
        overloadId = 0; // azimuthTo(QGeoCoordinate)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCoordinateFunc_azimuthTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoCoordinate cppArg0_local;
        ::QGeoCoordinate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // azimuthTo(QGeoCoordinate)const
            qreal cppResult = const_cast<const ::QGeoCoordinate *>(cppSelf)->azimuthTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoCoordinateFunc_azimuthTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCoordinateFunc_distanceTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.distanceTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCoordinate::distanceTo(QGeoCoordinate)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
        overloadId = 0; // distanceTo(QGeoCoordinate)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCoordinateFunc_distanceTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoCoordinate cppArg0_local;
        ::QGeoCoordinate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // distanceTo(QGeoCoordinate)const
            qreal cppResult = const_cast<const ::QGeoCoordinate *>(cppSelf)->distanceTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoCoordinateFunc_distanceTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCoordinateFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QGeoCoordinate *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCoordinateFunc_latitude(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.latitude";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // latitude()const
            double cppResult = const_cast<const ::QGeoCoordinate *>(cppSelf)->latitude();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCoordinateFunc_longitude(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.longitude";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // longitude()const
            double cppResult = const_cast<const ::QGeoCoordinate *>(cppSelf)->longitude();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCoordinateFunc_setAltitude(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.setAltitude";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCoordinate::setAltitude(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // setAltitude(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCoordinateFunc_setAltitude_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAltitude(double)
            cppSelf->setAltitude(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCoordinateFunc_setAltitude_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCoordinateFunc_setLatitude(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.setLatitude";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCoordinate::setLatitude(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // setLatitude(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCoordinateFunc_setLatitude_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLatitude(double)
            cppSelf->setLatitude(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCoordinateFunc_setLatitude_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCoordinateFunc_setLongitude(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.setLongitude";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoCoordinate::setLongitude(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // setLongitude(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCoordinateFunc_setLongitude_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLongitude(double)
            cppSelf->setLongitude(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoCoordinateFunc_setLongitude_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCoordinateFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.toString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGeoCoordinateFunc_toString_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toString", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGeoCoordinate::toString(QGeoCoordinate::CoordinateFormat)const
    if (numArgs == 0) {
        overloadId = 0; // toString(QGeoCoordinate::CoordinateFormat)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toString(QGeoCoordinate::CoordinateFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoCoordinateFunc_toString_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[0]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoCoordinateFunc_toString_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QGeoCoordinateFunc_toString_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGeoCoordinateFunc_toString_TypeError;
            }
        }
        ::QGeoCoordinate::CoordinateFormat cppArg0 = QGeoCoordinate::CoordinateFormat::DegreesMinutesSecondsWithHemisphere;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toString(QGeoCoordinate::CoordinateFormat)const
            QString cppResult = const_cast<const ::QGeoCoordinate *>(cppSelf)->toString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoCoordinateFunc_toString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCoordinateFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QGeoCoordinate::CoordinateType cppResult = const_cast<const ::QGeoCoordinate *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoCoordinate___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoCoordinate_PropertyStrings[] = {
    "altitude::",
    "isValid:",
    "latitude::",
    "longitude::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoCoordinate_methods[] = {
    {"altitude", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_altitude), METH_NOARGS},
    {"atDistanceAndAzimuth", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_atDistanceAndAzimuth), METH_VARARGS|METH_KEYWORDS},
    {"azimuthTo", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_azimuthTo), METH_O},
    {"distanceTo", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_distanceTo), METH_O},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_isValid), METH_NOARGS},
    {"latitude", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_latitude), METH_NOARGS},
    {"longitude", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_longitude), METH_NOARGS},
    {"setAltitude", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_setAltitude), METH_O},
    {"setLatitude", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_setLatitude), METH_O},
    {"setLongitude", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_setLongitude), METH_O},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_toString), METH_VARARGS|METH_KEYWORDS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinateFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGeoCoordinate___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QGeoCoordinateFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QGeoCoordinate::operator<<(QDataStream&,QGeoCoordinate)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QGeoCoordinate)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QGeoCoordinateFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QGeoCoordinate) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoCoordinateFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoCoordinateFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoCoordinate.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QGeoCoordinate::operator>>(QDataStream&,QGeoCoordinate&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QGeoCoordinate&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QGeoCoordinateFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QGeoCoordinate&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoCoordinateFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QGeoCoordinate_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
                // operator!=(const QGeoCoordinate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoCoordinate cppArg0_local;
                ::QGeoCoordinate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
                // operator==(const QGeoCoordinate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoCoordinate cppArg0_local;
                ::QGeoCoordinate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGeoCoordinate_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGeoCoordinate_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGeoCoordinate_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoCoordinate_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QGeoCoordinate__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoCoordinate_Type = nullptr;
static SbkObjectType *Sbk_QGeoCoordinate_TypeF(void)
{
    return _Sbk_QGeoCoordinate_Type;
}

static PyType_Slot Sbk_QGeoCoordinate_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QGeoCoordinate__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoCoordinate_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoCoordinate_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGeoCoordinate_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoCoordinate_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoCoordinate_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QGeoCoordinateFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QGeoCoordinateFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoCoordinate_spec = {
    "2:PySide2.QtPositioning.QGeoCoordinate",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoCoordinate_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoCoordinate_CoordinateType_PythonToCpp_QGeoCoordinate_CoordinateType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoCoordinate::CoordinateType *>(cppOut) =
        static_cast<::QGeoCoordinate::CoordinateType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoCoordinate_CoordinateType_PythonToCpp_QGeoCoordinate_CoordinateType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX]))
        return QGeoCoordinate_CoordinateType_PythonToCpp_QGeoCoordinate_CoordinateType;
    return {};
}
static PyObject *QGeoCoordinate_CoordinateType_CppToPython_QGeoCoordinate_CoordinateType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoCoordinate::CoordinateType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX], castCppIn);

}

static void QGeoCoordinate_CoordinateFormat_PythonToCpp_QGeoCoordinate_CoordinateFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoCoordinate::CoordinateFormat *>(cppOut) =
        static_cast<::QGeoCoordinate::CoordinateFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoCoordinate_CoordinateFormat_PythonToCpp_QGeoCoordinate_CoordinateFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX]))
        return QGeoCoordinate_CoordinateFormat_PythonToCpp_QGeoCoordinate_CoordinateFormat;
    return {};
}
static PyObject *QGeoCoordinate_CoordinateFormat_CppToPython_QGeoCoordinate_CoordinateFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoCoordinate::CoordinateFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoCoordinate_PythonToCpp_QGeoCoordinate_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoCoordinate_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoCoordinate_PythonToCpp_QGeoCoordinate_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoCoordinate_TypeF())))
        return QGeoCoordinate_PythonToCpp_QGeoCoordinate_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoCoordinate_PTR_CppToPython_QGeoCoordinate(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoCoordinate *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoCoordinate_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGeoCoordinate_COPY_CppToPython_QGeoCoordinate(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGeoCoordinate_TypeF(), new ::QGeoCoordinate(*reinterpret_cast<const ::QGeoCoordinate *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGeoCoordinate_PythonToCpp_QGeoCoordinate_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoCoordinate *>(cppOut) = *reinterpret_cast< ::QGeoCoordinate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGeoCoordinate_PythonToCpp_QGeoCoordinate_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoCoordinate_TypeF())))
        return QGeoCoordinate_PythonToCpp_QGeoCoordinate_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoCoordinate_SignatureStrings[] = {
    "3:PySide2.QtPositioning.QGeoCoordinate(self)",
    "2:PySide2.QtPositioning.QGeoCoordinate(self,other:PySide2.QtPositioning.QGeoCoordinate)",
    "1:PySide2.QtPositioning.QGeoCoordinate(self,latitude:double,longitude:double)",
    "0:PySide2.QtPositioning.QGeoCoordinate(self,latitude:double,longitude:double,altitude:double)",
    "PySide2.QtPositioning.QGeoCoordinate.altitude(self)->double",
    "PySide2.QtPositioning.QGeoCoordinate.atDistanceAndAzimuth(self,distance:qreal,azimuth:qreal,distanceUp:qreal=0.0)->PySide2.QtPositioning.QGeoCoordinate",
    "PySide2.QtPositioning.QGeoCoordinate.azimuthTo(self,other:PySide2.QtPositioning.QGeoCoordinate)->qreal",
    "PySide2.QtPositioning.QGeoCoordinate.distanceTo(self,other:PySide2.QtPositioning.QGeoCoordinate)->qreal",
    "PySide2.QtPositioning.QGeoCoordinate.isValid(self)->bool",
    "PySide2.QtPositioning.QGeoCoordinate.latitude(self)->double",
    "PySide2.QtPositioning.QGeoCoordinate.longitude(self)->double",
    "PySide2.QtPositioning.QGeoCoordinate.setAltitude(self,altitude:double)",
    "PySide2.QtPositioning.QGeoCoordinate.setLatitude(self,latitude:double)",
    "PySide2.QtPositioning.QGeoCoordinate.setLongitude(self,longitude:double)",
    "PySide2.QtPositioning.QGeoCoordinate.toString(self,format:PySide2.QtPositioning.QGeoCoordinate.CoordinateFormat=DegreesMinutesSecondsWithHemisphere)->QString",
    "PySide2.QtPositioning.QGeoCoordinate.type(self)->PySide2.QtPositioning.QGeoCoordinate.CoordinateType",
    "PySide2.QtPositioning.QGeoCoordinate.__copy__()",
    "PySide2.QtPositioning.QGeoCoordinate.__lshift__(self,stream:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtPositioning.QGeoCoordinate.__rshift__(self,stream:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QGeoCoordinate(PyObject *module)
{
    _Sbk_QGeoCoordinate_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoCoordinate",
        "QGeoCoordinate",
        &Sbk_QGeoCoordinate_spec,
        &Shiboken::callCppDestructor< ::QGeoCoordinate >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoCoordinate_Type);
    InitSignatureStrings(pyType, QGeoCoordinate_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoCoordinate_Type), Sbk_QGeoCoordinate_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoCoordinate_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoCoordinate_TypeF(),
        QGeoCoordinate_PythonToCpp_QGeoCoordinate_PTR,
        is_QGeoCoordinate_PythonToCpp_QGeoCoordinate_PTR_Convertible,
        QGeoCoordinate_PTR_CppToPython_QGeoCoordinate,
        QGeoCoordinate_COPY_CppToPython_QGeoCoordinate);

    Shiboken::Conversions::registerConverterName(converter, "QGeoCoordinate");
    Shiboken::Conversions::registerConverterName(converter, "QGeoCoordinate*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoCoordinate&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoCoordinate).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGeoCoordinate_PythonToCpp_QGeoCoordinate_COPY,
        is_QGeoCoordinate_PythonToCpp_QGeoCoordinate_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'CoordinateType'.
    SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoCoordinate_TypeF(),
        "CoordinateType",
        "2:PySide2.QtPositioning.QGeoCoordinate.CoordinateType",
        "QGeoCoordinate::CoordinateType");
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX],
        Sbk_QGeoCoordinate_TypeF(), "InvalidCoordinate", (long) QGeoCoordinate::CoordinateType::InvalidCoordinate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX],
        Sbk_QGeoCoordinate_TypeF(), "Coordinate2D", (long) QGeoCoordinate::CoordinateType::Coordinate2D))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX],
        Sbk_QGeoCoordinate_TypeF(), "Coordinate3D", (long) QGeoCoordinate::CoordinateType::Coordinate3D))
        return;
    // Register converter for enum 'QGeoCoordinate::CoordinateType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX],
            QGeoCoordinate_CoordinateType_CppToPython_QGeoCoordinate_CoordinateType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoCoordinate_CoordinateType_PythonToCpp_QGeoCoordinate_CoordinateType,
            is_QGeoCoordinate_CoordinateType_PythonToCpp_QGeoCoordinate_CoordinateType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoCoordinate::CoordinateType");
        Shiboken::Conversions::registerConverterName(converter, "CoordinateType");
    }
    // End of 'CoordinateType' enum.

    // Initialization of enum 'CoordinateFormat'.
    SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoCoordinate_TypeF(),
        "CoordinateFormat",
        "2:PySide2.QtPositioning.QGeoCoordinate.CoordinateFormat",
        "QGeoCoordinate::CoordinateFormat");
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX],
        Sbk_QGeoCoordinate_TypeF(), "Degrees", (long) QGeoCoordinate::CoordinateFormat::Degrees))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX],
        Sbk_QGeoCoordinate_TypeF(), "DegreesWithHemisphere", (long) QGeoCoordinate::CoordinateFormat::DegreesWithHemisphere))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX],
        Sbk_QGeoCoordinate_TypeF(), "DegreesMinutes", (long) QGeoCoordinate::CoordinateFormat::DegreesMinutes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX],
        Sbk_QGeoCoordinate_TypeF(), "DegreesMinutesWithHemisphere", (long) QGeoCoordinate::CoordinateFormat::DegreesMinutesWithHemisphere))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX],
        Sbk_QGeoCoordinate_TypeF(), "DegreesMinutesSeconds", (long) QGeoCoordinate::CoordinateFormat::DegreesMinutesSeconds))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX],
        Sbk_QGeoCoordinate_TypeF(), "DegreesMinutesSecondsWithHemisphere", (long) QGeoCoordinate::CoordinateFormat::DegreesMinutesSecondsWithHemisphere))
        return;
    // Register converter for enum 'QGeoCoordinate::CoordinateFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX],
            QGeoCoordinate_CoordinateFormat_CppToPython_QGeoCoordinate_CoordinateFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoCoordinate_CoordinateFormat_PythonToCpp_QGeoCoordinate_CoordinateFormat,
            is_QGeoCoordinate_CoordinateFormat_PythonToCpp_QGeoCoordinate_CoordinateFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_COORDINATEFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoCoordinate::CoordinateFormat");
        Shiboken::Conversions::registerConverterName(converter, "CoordinateFormat");
    }
    // End of 'CoordinateFormat' enum.

    qRegisterMetaType< ::QGeoCoordinate >("QGeoCoordinate");
    qRegisterMetaType< ::QGeoCoordinate::CoordinateType >("QGeoCoordinate::CoordinateType");
    qRegisterMetaType< ::QGeoCoordinate::CoordinateFormat >("QGeoCoordinate::CoordinateFormat");
}
