/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeolocation_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QtPositioning/qgeoaddress.h>
#include <QtPositioning/qgeocoordinate.h>
#include <QtPositioning/qgeolocation.h>
#include <QtPositioning/qgeorectangle.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoLocation_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoLocation >()))
        return -1;

    ::QGeoLocation *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoLocation", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoLocation::QGeoLocation()
    // 1: QGeoLocation::QGeoLocation(QGeoLocation)
    if (numArgs == 0) {
        overloadId = 0; // QGeoLocation()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGeoLocation(QGeoLocation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoLocation_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoLocation()
        {

            if (!PyErr_Occurred()) {
                // QGeoLocation()
                cptr = new ::QGeoLocation();
            }
            break;
        }
        case 1: // QGeoLocation(const QGeoLocation & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoLocation cppArg0_local;
            ::QGeoLocation *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGeoLocation(QGeoLocation)
                cptr = new ::QGeoLocation(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoLocation >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoLocation_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGeoLocation_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoLocationFunc_address(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.address";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // address()const
            QGeoAddress cppResult = const_cast<const ::QGeoLocation *>(cppSelf)->address();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoLocationFunc_boundingBox(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.boundingBox";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boundingBox()const
            QGeoRectangle cppResult = const_cast<const ::QGeoLocation *>(cppSelf)->boundingBox();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEORECTANGLE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoLocationFunc_coordinate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.coordinate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // coordinate()const
            QGeoCoordinate cppResult = const_cast<const ::QGeoLocation *>(cppSelf)->coordinate();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoLocationFunc_extendedAttributes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.extendedAttributes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // extendedAttributes()const
            QMap<QString,QVariant > cppResult = const_cast<const ::QGeoLocation *>(cppSelf)->extendedAttributes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QMAP_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoLocationFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QGeoLocation *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoLocationFunc_setAddress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.setAddress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoLocation::setAddress(QGeoAddress)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), (pyArg)))) {
        overloadId = 0; // setAddress(QGeoAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoLocationFunc_setAddress_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoAddress cppArg0_local;
        ::QGeoAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setAddress(QGeoAddress)
            cppSelf->setAddress(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoLocationFunc_setAddress_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoLocationFunc_setBoundingBox(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.setBoundingBox";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoLocation::setBoundingBox(QGeoRectangle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEORECTANGLE_IDX]), (pyArg)))) {
        overloadId = 0; // setBoundingBox(QGeoRectangle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoLocationFunc_setBoundingBox_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoRectangle cppArg0_local;
        ::QGeoRectangle *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEORECTANGLE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBoundingBox(QGeoRectangle)
            cppSelf->setBoundingBox(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoLocationFunc_setBoundingBox_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoLocationFunc_setCoordinate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.setCoordinate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoLocation::setCoordinate(QGeoCoordinate)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
        overloadId = 0; // setCoordinate(QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoLocationFunc_setCoordinate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoCoordinate cppArg0_local;
        ::QGeoCoordinate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setCoordinate(QGeoCoordinate)
            cppSelf->setCoordinate(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoLocationFunc_setCoordinate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoLocationFunc_setExtendedAttributes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoLocation.setExtendedAttributes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoLocation::setExtendedAttributes(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setExtendedAttributes(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoLocationFunc_setExtendedAttributes_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExtendedAttributes(QMap<QString,QVariant>)
            cppSelf->setExtendedAttributes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoLocationFunc_setExtendedAttributes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoLocation___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoLocation_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoLocation_methods[] = {
    {"address", reinterpret_cast<PyCFunction>(Sbk_QGeoLocationFunc_address), METH_NOARGS},
    {"boundingBox", reinterpret_cast<PyCFunction>(Sbk_QGeoLocationFunc_boundingBox), METH_NOARGS},
    {"coordinate", reinterpret_cast<PyCFunction>(Sbk_QGeoLocationFunc_coordinate), METH_NOARGS},
    {"extendedAttributes", reinterpret_cast<PyCFunction>(Sbk_QGeoLocationFunc_extendedAttributes), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QGeoLocationFunc_isEmpty), METH_NOARGS},
    {"setAddress", reinterpret_cast<PyCFunction>(Sbk_QGeoLocationFunc_setAddress), METH_O},
    {"setBoundingBox", reinterpret_cast<PyCFunction>(Sbk_QGeoLocationFunc_setBoundingBox), METH_O},
    {"setCoordinate", reinterpret_cast<PyCFunction>(Sbk_QGeoLocationFunc_setCoordinate), METH_O},
    {"setExtendedAttributes", reinterpret_cast<PyCFunction>(Sbk_QGeoLocationFunc_setExtendedAttributes), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGeoLocation___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QGeoLocation_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), (pyArg)))) {
                // operator!=(const QGeoLocation & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoLocation cppArg0_local;
                ::QGeoLocation *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), (pyArg)))) {
                // operator==(const QGeoLocation & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoLocation cppArg0_local;
                ::QGeoLocation *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGeoLocation_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGeoLocation_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGeoLocation_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoLocation_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoLocation_Type = nullptr;
static SbkObjectType *Sbk_QGeoLocation_TypeF(void)
{
    return _Sbk_QGeoLocation_Type;
}

static PyType_Slot Sbk_QGeoLocation_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoLocation_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoLocation_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGeoLocation_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoLocation_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoLocation_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoLocation_spec = {
    "2:PySide2.QtPositioning.QGeoLocation",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoLocation_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoLocation_PythonToCpp_QGeoLocation_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoLocation_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoLocation_PythonToCpp_QGeoLocation_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoLocation_TypeF())))
        return QGeoLocation_PythonToCpp_QGeoLocation_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoLocation_PTR_CppToPython_QGeoLocation(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoLocation *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoLocation_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGeoLocation_COPY_CppToPython_QGeoLocation(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGeoLocation_TypeF(), new ::QGeoLocation(*reinterpret_cast<const ::QGeoLocation *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGeoLocation_PythonToCpp_QGeoLocation_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoLocation *>(cppOut) = *reinterpret_cast< ::QGeoLocation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGeoLocation_PythonToCpp_QGeoLocation_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoLocation_TypeF())))
        return QGeoLocation_PythonToCpp_QGeoLocation_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoLocation_SignatureStrings[] = {
    "1:PySide2.QtPositioning.QGeoLocation(self)",
    "0:PySide2.QtPositioning.QGeoLocation(self,other:PySide2.QtPositioning.QGeoLocation)",
    "PySide2.QtPositioning.QGeoLocation.address(self)->PySide2.QtPositioning.QGeoAddress",
    "PySide2.QtPositioning.QGeoLocation.boundingBox(self)->PySide2.QtPositioning.QGeoRectangle",
    "PySide2.QtPositioning.QGeoLocation.coordinate(self)->PySide2.QtPositioning.QGeoCoordinate",
    "PySide2.QtPositioning.QGeoLocation.extendedAttributes(self)->QMap[QString, QVariant]",
    "PySide2.QtPositioning.QGeoLocation.isEmpty(self)->bool",
    "PySide2.QtPositioning.QGeoLocation.setAddress(self,address:PySide2.QtPositioning.QGeoAddress)",
    "PySide2.QtPositioning.QGeoLocation.setBoundingBox(self,box:PySide2.QtPositioning.QGeoRectangle)",
    "PySide2.QtPositioning.QGeoLocation.setCoordinate(self,position:PySide2.QtPositioning.QGeoCoordinate)",
    "PySide2.QtPositioning.QGeoLocation.setExtendedAttributes(self,data:QMap[QString, QVariant])",
    "PySide2.QtPositioning.QGeoLocation.__copy__()",
    nullptr}; // Sentinel

void init_QGeoLocation(PyObject *module)
{
    _Sbk_QGeoLocation_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoLocation",
        "QGeoLocation",
        &Sbk_QGeoLocation_spec,
        &Shiboken::callCppDestructor< ::QGeoLocation >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoLocation_Type);
    InitSignatureStrings(pyType, QGeoLocation_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoLocation_Type), Sbk_QGeoLocation_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOLOCATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoLocation_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoLocation_TypeF(),
        QGeoLocation_PythonToCpp_QGeoLocation_PTR,
        is_QGeoLocation_PythonToCpp_QGeoLocation_PTR_Convertible,
        QGeoLocation_PTR_CppToPython_QGeoLocation,
        QGeoLocation_COPY_CppToPython_QGeoLocation);

    Shiboken::Conversions::registerConverterName(converter, "QGeoLocation");
    Shiboken::Conversions::registerConverterName(converter, "QGeoLocation*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoLocation&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoLocation).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGeoLocation_PythonToCpp_QGeoLocation_COPY,
        is_QGeoLocation_PythonToCpp_QGeoLocation_COPY_Convertible);

    qRegisterMetaType< ::QGeoLocation >("QGeoLocation");
}
