/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeopolygon_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtPositioning/qgeocoordinate.h>
#include <QtPositioning/qgeopolygon.h>
#include <QtPositioning/qgeorectangle.h>
#include <QtPositioning/qgeoshape.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoPolygon_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoPolygon >()))
        return -1;

    ::QGeoPolygon *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoPolygon", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoPolygon::QGeoPolygon()
    // 1: QGeoPolygon::QGeoPolygon(QGeoPolygon)
    // 2: QGeoPolygon::QGeoPolygon(QGeoShape)
    // 3: QGeoPolygon::QGeoPolygon(QList<QGeoCoordinate>)
    if (numArgs == 0) {
        overloadId = 0; // QGeoPolygon()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOCOORDINATE_IDX], (pyArgs[0])))) {
        overloadId = 3; // QGeoPolygon(QList<QGeoCoordinate>)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGeoPolygon(QGeoPolygon)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QGeoPolygon(QGeoShape)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygon_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoPolygon()
        {

            if (!PyErr_Occurred()) {
                // QGeoPolygon()
                cptr = new ::QGeoPolygon();
            }
            break;
        }
        case 1: // QGeoPolygon(const QGeoPolygon & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoPolygon cppArg0_local;
            ::QGeoPolygon *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGeoPolygon(QGeoPolygon)
                cptr = new ::QGeoPolygon(*cppArg0);
            }
            break;
        }
        case 2: // QGeoPolygon(const QGeoShape & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoShape cppArg0_local;
            ::QGeoShape *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGeoPolygon(QGeoShape)
                cptr = new ::QGeoPolygon(*cppArg0);
            }
            break;
        }
        case 3: // QGeoPolygon(const QList<QGeoCoordinate > & path)
        {
            ::QList<QGeoCoordinate > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGeoPolygon(QList<QGeoCoordinate>)
                cptr = new ::QGeoPolygon(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoPolygon >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoPolygon_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGeoPolygon_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoPolygonFunc_addCoordinate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.addCoordinate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::addCoordinate(QGeoCoordinate)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
        overloadId = 0; // addCoordinate(QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_addCoordinate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoCoordinate cppArg0_local;
        ::QGeoCoordinate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addCoordinate(QGeoCoordinate)
            cppSelf->addCoordinate(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPolygonFunc_addCoordinate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_addHole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.addHole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::addHole(QList<QGeoCoordinate>)
    // 1: QGeoPolygon::addHole(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOCOORDINATE_IDX], (pyArg)))) {
        overloadId = 0; // addHole(QList<QGeoCoordinate>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 1; // addHole(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_addHole_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addHole(const QList<QGeoCoordinate > & holePath)
        {
            ::QList<QGeoCoordinate > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // addHole(QList<QGeoCoordinate>)
                cppSelf->addHole(cppArg0);
            }
            break;
        }
        case 1: // addHole(const QVariant & holePath)
        {
            ::QVariant cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // addHole(QVariant)
                cppSelf->addHole(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPolygonFunc_addHole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_containsCoordinate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.containsCoordinate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::containsCoordinate(QGeoCoordinate)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
        overloadId = 0; // containsCoordinate(QGeoCoordinate)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_containsCoordinate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoCoordinate cppArg0_local;
        ::QGeoCoordinate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // containsCoordinate(QGeoCoordinate)const
            bool cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->containsCoordinate(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPolygonFunc_containsCoordinate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_coordinateAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.coordinateAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::coordinateAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // coordinateAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_coordinateAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // coordinateAt(int)const
            QGeoCoordinate cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->coordinateAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPolygonFunc_coordinateAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_hole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.hole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::hole(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // hole(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_hole_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hole(int)const
            const QList<QVariant > cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->hole(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPolygonFunc_hole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_holePath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.holePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::holePath(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // holePath(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_holePath_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // holePath(int)const
            const QList<QGeoCoordinate > cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->holePath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOCOORDINATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPolygonFunc_holePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_holesCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.holesCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // holesCount()const
            int cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->holesCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPolygonFunc_insertCoordinate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.insertCoordinate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertCoordinate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPolygon::insertCoordinate(int,QGeoCoordinate)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertCoordinate(int,QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_insertCoordinate_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QGeoCoordinate cppArg1_local;
        ::QGeoCoordinate *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // insertCoordinate(int,QGeoCoordinate)
            cppSelf->insertCoordinate(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPolygonFunc_insertCoordinate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_length(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.length";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGeoPolygonFunc_length_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:length", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPolygon::length(int,int)const
    if (numArgs == 0) {
        overloadId = 0; // length(int,int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // length(int,int)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // length(int,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_length_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_indexFrom = Shiboken::String::createStaticString("indexFrom");
            if (PyDict_Contains(kwds, key_indexFrom)) {
                value = PyDict_GetItem(kwds, key_indexFrom);
                if (value && pyArgs[0]) {
                    errInfo = key_indexFrom;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoPolygonFunc_length_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QGeoPolygonFunc_length_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_indexFrom);
            }
            static PyObject *const key_indexTo = Shiboken::String::createStaticString("indexTo");
            if (PyDict_Contains(kwds, key_indexTo)) {
                value = PyDict_GetItem(kwds, key_indexTo);
                if (value && pyArgs[1]) {
                    errInfo = key_indexTo;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoPolygonFunc_length_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QGeoPolygonFunc_length_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_indexTo);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGeoPolygonFunc_length_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // length(int,int)const
            double cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->length(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPolygonFunc_length_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_path(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.path";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // path()const
            const QList<QGeoCoordinate > & cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->path();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOCOORDINATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPolygonFunc_perimeter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.perimeter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // perimeter()const
            QList<QVariant > cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->perimeter();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPolygonFunc_removeCoordinate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.removeCoordinate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::removeCoordinate(QGeoCoordinate)
    // 1: QGeoPolygon::removeCoordinate(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // removeCoordinate(int)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
        overloadId = 0; // removeCoordinate(QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_removeCoordinate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // removeCoordinate(const QGeoCoordinate & coordinate)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QGeoCoordinate cppArg0_local;
            ::QGeoCoordinate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // removeCoordinate(QGeoCoordinate)
                cppSelf->removeCoordinate(*cppArg0);
            }
            break;
        }
        case 1: // removeCoordinate(int index)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // removeCoordinate(int)
                cppSelf->removeCoordinate(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPolygonFunc_removeCoordinate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_removeHole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.removeHole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::removeHole(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // removeHole(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_removeHole_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeHole(int)
            cppSelf->removeHole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPolygonFunc_removeHole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_replaceCoordinate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.replaceCoordinate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "replaceCoordinate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPolygon::replaceCoordinate(int,QGeoCoordinate)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // replaceCoordinate(int,QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_replaceCoordinate_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QGeoCoordinate cppArg1_local;
        ::QGeoCoordinate *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // replaceCoordinate(int,QGeoCoordinate)
            cppSelf->replaceCoordinate(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPolygonFunc_replaceCoordinate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_setPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.setPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::setPath(QList<QGeoCoordinate>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOCOORDINATE_IDX], (pyArg)))) {
        overloadId = 0; // setPath(QList<QGeoCoordinate>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_setPath_TypeError;

    // Call function/method
    {
        ::QList<QGeoCoordinate > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPath(QList<QGeoCoordinate>)
            cppSelf->setPath(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPolygonFunc_setPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_setPerimeter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.setPerimeter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPolygon::setPerimeter(QList<QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setPerimeter(QList<QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_setPerimeter_TypeError;

    // Call function/method
    {
        ::QList<QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPerimeter(QList<QVariant>)
            cppSelf->setPerimeter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPolygonFunc_setPerimeter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPolygonFunc_toString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.toString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toString()const
            QString cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->toString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPolygonFunc_translate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.translate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "translate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPolygon::translate(double,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // translate(double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_translate_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // translate(double,double)
            cppSelf->translate(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPolygonFunc_translate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygonFunc_translated(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPolygon.translated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "translated", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPolygon::translated(double,double)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // translated(double,double)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPolygonFunc_translated_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // translated(double,double)const
            QGeoPolygon cppResult = const_cast<const ::QGeoPolygon *>(cppSelf)->translated(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPolygonFunc_translated_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPolygon___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoPolygon_PropertyStrings[] = {
    "perimeter::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoPolygon_methods[] = {
    {"addCoordinate", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_addCoordinate), METH_O},
    {"addHole", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_addHole), METH_O},
    {"containsCoordinate", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_containsCoordinate), METH_O},
    {"coordinateAt", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_coordinateAt), METH_O},
    {"hole", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_hole), METH_O},
    {"holePath", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_holePath), METH_O},
    {"holesCount", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_holesCount), METH_NOARGS},
    {"insertCoordinate", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_insertCoordinate), METH_VARARGS},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_length), METH_VARARGS|METH_KEYWORDS},
    {"path", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_path), METH_NOARGS},
    {"perimeter", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_perimeter), METH_NOARGS},
    {"removeCoordinate", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_removeCoordinate), METH_O},
    {"removeHole", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_removeHole), METH_O},
    {"replaceCoordinate", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_replaceCoordinate), METH_VARARGS},
    {"setPath", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_setPath), METH_O},
    {"setPerimeter", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_setPerimeter), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_size), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_toString), METH_NOARGS},
    {"translate", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_translate), METH_VARARGS},
    {"translated", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygonFunc_translated), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGeoPolygon___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QGeoPolygon_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX]), (pyArg)))) {
                // operator!=(const QGeoPolygon & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoPolygon cppArg0_local;
                ::QGeoPolygon *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX]), (pyArg)))) {
                // operator==(const QGeoPolygon & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoPolygon cppArg0_local;
                ::QGeoPolygon *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGeoPolygon_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGeoPolygon_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGeoPolygon_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoPolygon_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoPolygon_Type = nullptr;
static SbkObjectType *Sbk_QGeoPolygon_TypeF(void)
{
    return _Sbk_QGeoPolygon_Type;
}

static PyType_Slot Sbk_QGeoPolygon_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoPolygon_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoPolygon_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGeoPolygon_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoPolygon_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoPolygon_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoPolygon_spec = {
    "2:PySide2.QtPositioning.QGeoPolygon",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoPolygon_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoPolygon_PythonToCpp_QGeoPolygon_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoPolygon_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoPolygon_PythonToCpp_QGeoPolygon_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoPolygon_TypeF())))
        return QGeoPolygon_PythonToCpp_QGeoPolygon_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoPolygon_PTR_CppToPython_QGeoPolygon(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoPolygon *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoPolygon_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGeoPolygon_COPY_CppToPython_QGeoPolygon(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGeoPolygon_TypeF(), new ::QGeoPolygon(*reinterpret_cast<const ::QGeoPolygon *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGeoPolygon_PythonToCpp_QGeoPolygon_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoPolygon *>(cppOut) = *reinterpret_cast< ::QGeoPolygon *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGeoPolygon_PythonToCpp_QGeoPolygon_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoPolygon_TypeF())))
        return QGeoPolygon_PythonToCpp_QGeoPolygon_COPY;
    return {};
}

// Implicit conversions.
static void constQGeoShapeREF_PythonToCpp_QGeoPolygon(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoPolygon *>(cppOut) = ::QGeoPolygon( *reinterpret_cast< ::QGeoShape *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQGeoShapeREF_PythonToCpp_QGeoPolygon_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX], pyIn))
        return constQGeoShapeREF_PythonToCpp_QGeoPolygon;
    return {};
}

static void _constQList_QGeoCoordinate_REF_PythonToCpp_QGeoPolygon(PyObject *pyIn, void *cppOut) {
    ::QList<QGeoCoordinate > cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QLIST_QGEOCOORDINATE_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QGeoPolygon *>(cppOut) = ::QGeoPolygon(cppIn);
}
static PythonToCppFunc is__constQList_QGeoCoordinate_REF_PythonToCpp_QGeoPolygon_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pyIn))
        return _constQList_QGeoCoordinate_REF_PythonToCpp_QGeoPolygon;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoPolygon_SignatureStrings[] = {
    "3:PySide2.QtPositioning.QGeoPolygon(self)",
    "2:PySide2.QtPositioning.QGeoPolygon(self,other:PySide2.QtPositioning.QGeoPolygon)",
    "1:PySide2.QtPositioning.QGeoPolygon(self,other:PySide2.QtPositioning.QGeoShape)",
    "0:PySide2.QtPositioning.QGeoPolygon(self,path:QList[PySide2.QtPositioning.QGeoCoordinate])",
    "PySide2.QtPositioning.QGeoPolygon.addCoordinate(self,coordinate:PySide2.QtPositioning.QGeoCoordinate)",
    "1:PySide2.QtPositioning.QGeoPolygon.addHole(self,holePath:QList[PySide2.QtPositioning.QGeoCoordinate])",
    "0:PySide2.QtPositioning.QGeoPolygon.addHole(self,holePath:QVariant)",
    "PySide2.QtPositioning.QGeoPolygon.containsCoordinate(self,coordinate:PySide2.QtPositioning.QGeoCoordinate)->bool",
    "PySide2.QtPositioning.QGeoPolygon.coordinateAt(self,index:int)->PySide2.QtPositioning.QGeoCoordinate",
    "PySide2.QtPositioning.QGeoPolygon.hole(self,index:int)->QList[QVariant]",
    "PySide2.QtPositioning.QGeoPolygon.holePath(self,index:int)->QList[PySide2.QtPositioning.QGeoCoordinate]",
    "PySide2.QtPositioning.QGeoPolygon.holesCount(self)->int",
    "PySide2.QtPositioning.QGeoPolygon.insertCoordinate(self,index:int,coordinate:PySide2.QtPositioning.QGeoCoordinate)",
    "PySide2.QtPositioning.QGeoPolygon.length(self,indexFrom:int=0,indexTo:int=-1)->double",
    "PySide2.QtPositioning.QGeoPolygon.path(self)->QList[PySide2.QtPositioning.QGeoCoordinate]",
    "PySide2.QtPositioning.QGeoPolygon.perimeter(self)->QList[QVariant]",
    "1:PySide2.QtPositioning.QGeoPolygon.removeCoordinate(self,coordinate:PySide2.QtPositioning.QGeoCoordinate)",
    "0:PySide2.QtPositioning.QGeoPolygon.removeCoordinate(self,index:int)",
    "PySide2.QtPositioning.QGeoPolygon.removeHole(self,index:int)",
    "PySide2.QtPositioning.QGeoPolygon.replaceCoordinate(self,index:int,coordinate:PySide2.QtPositioning.QGeoCoordinate)",
    "PySide2.QtPositioning.QGeoPolygon.setPath(self,path:QList[PySide2.QtPositioning.QGeoCoordinate])",
    "PySide2.QtPositioning.QGeoPolygon.setPerimeter(self,path:QList[QVariant])",
    "PySide2.QtPositioning.QGeoPolygon.size(self)->int",
    "PySide2.QtPositioning.QGeoPolygon.toString(self)->QString",
    "PySide2.QtPositioning.QGeoPolygon.translate(self,degreesLatitude:double,degreesLongitude:double)",
    "PySide2.QtPositioning.QGeoPolygon.translated(self,degreesLatitude:double,degreesLongitude:double)->PySide2.QtPositioning.QGeoPolygon",
    "PySide2.QtPositioning.QGeoPolygon.__copy__()",
    nullptr}; // Sentinel

void init_QGeoPolygon(PyObject *module)
{
    _Sbk_QGeoPolygon_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoPolygon",
        "QGeoPolygon",
        &Sbk_QGeoPolygon_spec,
        &Shiboken::callCppDestructor< ::QGeoPolygon >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoPolygon_Type);
    InitSignatureStrings(pyType, QGeoPolygon_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoPolygon_Type), Sbk_QGeoPolygon_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOPOLYGON_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoPolygon_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoPolygon_TypeF(),
        QGeoPolygon_PythonToCpp_QGeoPolygon_PTR,
        is_QGeoPolygon_PythonToCpp_QGeoPolygon_PTR_Convertible,
        QGeoPolygon_PTR_CppToPython_QGeoPolygon,
        QGeoPolygon_COPY_CppToPython_QGeoPolygon);

    Shiboken::Conversions::registerConverterName(converter, "QGeoPolygon");
    Shiboken::Conversions::registerConverterName(converter, "QGeoPolygon*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoPolygon&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoPolygon).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGeoPolygon_PythonToCpp_QGeoPolygon_COPY,
        is_QGeoPolygon_PythonToCpp_QGeoPolygon_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQGeoShapeREF_PythonToCpp_QGeoPolygon,
        is_constQGeoShapeREF_PythonToCpp_QGeoPolygon_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        _constQList_QGeoCoordinate_REF_PythonToCpp_QGeoPolygon,
        is__constQList_QGeoCoordinate_REF_PythonToCpp_QGeoPolygon_Convertible);

    qRegisterMetaType< ::QGeoPolygon >("QGeoPolygon");
}
