/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeopositioninfosource_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoPositionInfoSourceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoPositionInfoSourceWrapper::QGeoPositionInfoSourceWrapper(::QObject * parent) : QGeoPositionInfoSource(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QGeoPositionInfoSourceWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoPositionInfoSourceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoPositionInfoSourceWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoPositionInfoSourceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QGeoPositionInfoSource::Error QGeoPositionInfoSourceWrapper::error() const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.error()' not implemented.");
        return QGeoPositionInfoSource::AccessError;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QGeoPositionInfoSource::AccessError;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "error";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.error()' not implemented.");
        return QGeoPositionInfoSource::AccessError;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QGeoPositionInfoSource::AccessError;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.error", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoPositionInfoSource::Error >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QGeoPositionInfoSource::AccessError;
    }
    ::QGeoPositionInfoSource::Error cppResult{QGeoPositionInfoSource::AccessError};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QGeoPositionInfoSourceWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGeoPositionInfoSourceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QGeoPositionInfo QGeoPositionInfoSourceWrapper::lastKnownPosition(bool fromSatellitePositioningMethodsOnly) const
{
    if (m_PyMethodCache[7]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.lastKnownPosition()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "lastKnownPosition";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.lastKnownPosition()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &fromSatellitePositioningMethodsOnly)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.lastKnownPosition", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoPositionInfo >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QGeoPositionInfo cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QGeoPositionInfoSourceWrapper::minimumUpdateInterval() const
{
    if (m_PyMethodCache[9]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.minimumUpdateInterval()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "1:minimumUpdateInterval";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.minimumUpdateInterval()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.minimumUpdateInterval", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGeoPositionInfoSourceWrapper::requestUpdate(int timeout)
{
    if (m_PyMethodCache[10]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.requestUpdate()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "requestUpdate";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.requestUpdate()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    timeout
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoPositionInfoSourceWrapper::setPreferredPositioningMethods(::QFlags<QGeoPositionInfoSource::PositioningMethod> methods)
{
    if (m_PyMethodCache[11]) {
        return this->::QGeoPositionInfoSource::setPreferredPositioningMethods(methods);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setPreferredPositioningMethods";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QGeoPositionInfoSource::setPreferredPositioningMethods(methods);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, &methods)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoPositionInfoSourceWrapper::setUpdateInterval(int msec)
{
    if (m_PyMethodCache[12]) {
        return this->::QGeoPositionInfoSource::setUpdateInterval(msec);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "2:setUpdateInterval";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QGeoPositionInfoSource::setUpdateInterval(msec);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msec
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoPositionInfoSourceWrapper::startUpdates()
{
    if (m_PyMethodCache[13]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.startUpdates()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "startUpdates";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.startUpdates()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoPositionInfoSourceWrapper::stopUpdates()
{
    if (m_PyMethodCache[14]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.stopUpdates()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stopUpdates";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.stopUpdates()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QFlags<QGeoPositionInfoSource::PositioningMethod> QGeoPositionInfoSourceWrapper::supportedPositioningMethods() const
{
    if (m_PyMethodCache[15]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.supportedPositioningMethods()' not implemented.");
        return QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportedPositioningMethods";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.supportedPositioningMethods()' not implemented.");
        return QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.supportedPositioningMethods", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QGeoPositionInfoSource::PositioningMethod> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    }
    ::QFlags<QGeoPositionInfoSource::PositioningMethod> cppResult = QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGeoPositionInfoSourceWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[16]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGeoPositionInfoSourceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGeoPositionInfoSource::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGeoPositionInfoSourceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGeoPositionInfoSource::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGeoPositionInfoSourceWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGeoPositionInfoSourceWrapper *>(this));
        return QGeoPositionInfoSource::qt_metacast(_clname);
}

QGeoPositionInfoSourceWrapper::~QGeoPositionInfoSourceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoPositionInfoSource_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGeoPositionInfoSource' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoPositionInfoSource >()))
        return -1;

    ::QGeoPositionInfoSourceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoPositionInfoSource", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::QGeoPositionInfoSource(QObject*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGeoPositionInfoSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSource_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QGeoPositionInfoSource(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QGeoPositionInfoSourceWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QGeoPositionInfoSourceWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoPositionInfoSource >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoPositionInfoSource_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGeoPositionInfoSource_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGeoPositionInfoSource_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_availableSources(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.availableSources";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableSources()
            QStringList cppResult = ::QGeoPositionInfoSource::availableSources();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_backendProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.backendProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::backendProperty(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // backendProperty(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFunc_backendProperty_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // backendProperty(QString)const
            QVariant cppResult = const_cast<const ::QGeoPositionInfoSource *>(cppSelf)->backendProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoSourceFunc_backendProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_createDefaultSource(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.createDefaultSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createDefaultSource", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QGeoPositionInfoSource::createDefaultSource(QObject*)
    // 1: static QGeoPositionInfoSource::createDefaultSource(QMap<QString,QVariant>,QObject*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
        overloadId = 1; // createDefaultSource(QMap<QString,QVariant>,QObject*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // createDefaultSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFunc_createDefaultSource_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createDefaultSource(QObject * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // createDefaultSource(QObject*)
                QGeoPositionInfoSource * cppResult = ::QGeoPositionInfoSource::createDefaultSource(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), cppResult);
            }
            break;
        }
        case 1: // createDefaultSource(const QMap<QString,QVariant > & parameters, QObject * parent)
        {
            ::QMap<QString,QVariant > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // createDefaultSource(QMap<QString,QVariant>,QObject*)
                QGeoPositionInfoSource * cppResult = ::QGeoPositionInfoSource::createDefaultSource(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoSourceFunc_createDefaultSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_createSource(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.createSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createSource", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QGeoPositionInfoSource::createSource(QString,QObject*)
    // 1: static QGeoPositionInfoSource::createSource(QString,QMap<QString,QVariant>,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
            overloadId = 1; // createSource(QString,QMap<QString,QVariant>,QObject*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // createSource(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFunc_createSource_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createSource(const QString & sourceName, QObject * parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // createSource(QString,QObject*)
                QGeoPositionInfoSource * cppResult = ::QGeoPositionInfoSource::createSource(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), cppResult);
            }
            break;
        }
        case 1: // createSource(const QString & sourceName, const QMap<QString,QVariant > & parameters, QObject * parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QMap<QString,QVariant > cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // createSource(QString,QMap<QString,QVariant>,QObject*)
                QGeoPositionInfoSource * cppResult = ::QGeoPositionInfoSource::createSource(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoSourceFunc_createSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.error()' not implemented.");
                return {};
            }
            QGeoPositionInfoSource::Error cppResult = const_cast<const ::QGeoPositionInfoSource *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_lastKnownPosition(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.lastKnownPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGeoPositionInfoSourceFunc_lastKnownPosition_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:lastKnownPosition", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::lastKnownPosition(bool)const
    if (numArgs == 0) {
        overloadId = 0; // lastKnownPosition(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // lastKnownPosition(bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFunc_lastKnownPosition_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_fromSatellitePositioningMethodsOnly = Shiboken::String::createStaticString("fromSatellitePositioningMethodsOnly");
            if (PyDict_Contains(kwds, key_fromSatellitePositioningMethodsOnly)) {
                value = PyDict_GetItem(kwds, key_fromSatellitePositioningMethodsOnly);
                if (value && pyArgs[0]) {
                    errInfo = key_fromSatellitePositioningMethodsOnly;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoPositionInfoSourceFunc_lastKnownPosition_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QGeoPositionInfoSourceFunc_lastKnownPosition_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_fromSatellitePositioningMethodsOnly);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGeoPositionInfoSourceFunc_lastKnownPosition_TypeError;
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // lastKnownPosition(bool)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.lastKnownPosition()' not implemented.");
                return {};
            }
            QGeoPositionInfo cppResult = const_cast<const ::QGeoPositionInfoSource *>(cppSelf)->lastKnownPosition(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoSourceFunc_lastKnownPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_minimumUpdateInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.minimumUpdateInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumUpdateInterval()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.minimumUpdateInterval()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QGeoPositionInfoSource *>(cppSelf)->minimumUpdateInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_preferredPositioningMethods(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.preferredPositioningMethods";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preferredPositioningMethods()const
            QFlags<QGeoPositionInfoSource::PositioningMethod> cppResult = const_cast<const ::QGeoPositionInfoSource *>(cppSelf)->preferredPositioningMethods();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_requestUpdate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.requestUpdate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGeoPositionInfoSourceFunc_requestUpdate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:requestUpdate", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::requestUpdate(int)
    if (numArgs == 0) {
        overloadId = 0; // requestUpdate(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // requestUpdate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFunc_requestUpdate_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[0]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoPositionInfoSourceFunc_requestUpdate_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QGeoPositionInfoSourceFunc_requestUpdate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGeoPositionInfoSourceFunc_requestUpdate_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // requestUpdate(int)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.requestUpdate()' not implemented.");
                return {};
            }
            cppSelf->requestUpdate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPositionInfoSourceFunc_requestUpdate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_setBackendProperty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.setBackendProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setBackendProperty", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::setBackendProperty(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setBackendProperty(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFunc_setBackendProperty_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setBackendProperty(QString,QVariant)
            bool cppResult = cppSelf->setBackendProperty(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoSourceFunc_setBackendProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_setPreferredPositioningMethods(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.setPreferredPositioningMethods";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::setPreferredPositioningMethods(QFlags<QGeoPositionInfoSource::PositioningMethod>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPreferredPositioningMethods(QFlags<QGeoPositionInfoSource::PositioningMethod>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFunc_setPreferredPositioningMethods_TypeError;

    // Call function/method
    {
        ::QFlags<QGeoPositionInfoSource::PositioningMethod> cppArg0 = QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPreferredPositioningMethods(QFlags<QGeoPositionInfoSource::PositioningMethod>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGeoPositionInfoSource::setPreferredPositioningMethods(cppArg0)
                : cppSelf->setPreferredPositioningMethods(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPositionInfoSourceFunc_setPreferredPositioningMethods_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_setUpdateInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.setUpdateInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::setUpdateInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setUpdateInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFunc_setUpdateInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUpdateInterval(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGeoPositionInfoSource::setUpdateInterval(cppArg0)
                : cppSelf->setUpdateInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPositionInfoSourceFunc_setUpdateInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_sourceName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.sourceName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceName()const
            QString cppResult = const_cast<const ::QGeoPositionInfoSource *>(cppSelf)->sourceName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_startUpdates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.startUpdates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startUpdates()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.startUpdates()' not implemented.");
                return {};
            }
            cppSelf->startUpdates();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_stopUpdates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.stopUpdates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stopUpdates()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.stopUpdates()' not implemented.");
                return {};
            }
            cppSelf->stopUpdates();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_supportedPositioningMethods(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.supportedPositioningMethods";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedPositioningMethods()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.supportedPositioningMethods()' not implemented.");
                return {};
            }
            QFlags<QGeoPositionInfoSource::PositioningMethod> cppResult = const_cast<const ::QGeoPositionInfoSource *>(cppSelf)->supportedPositioningMethods();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPositionInfoSourceFunc_updateInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSource.updateInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateInterval()const
            int cppResult = const_cast<const ::QGeoPositionInfoSource *>(cppSelf)->updateInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoPositionInfoSource_PropertyStrings[] = {
    "minimumUpdateInterval:",
    "sourceName:",
    "updateInterval::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoPositionInfoSource_methods[] = {
    {"availableSources", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_availableSources), METH_NOARGS|METH_STATIC},
    {"backendProperty", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_backendProperty), METH_O},
    {"createDefaultSource", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_createDefaultSource), METH_VARARGS|METH_STATIC},
    {"createSource", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_createSource), METH_VARARGS|METH_STATIC},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_error), METH_NOARGS},
    {"lastKnownPosition", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_lastKnownPosition), METH_VARARGS|METH_KEYWORDS},
    {"minimumUpdateInterval", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_minimumUpdateInterval), METH_NOARGS},
    {"preferredPositioningMethods", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_preferredPositioningMethods), METH_NOARGS},
    {"requestUpdate", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_requestUpdate), METH_VARARGS|METH_KEYWORDS},
    {"setBackendProperty", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_setBackendProperty), METH_VARARGS},
    {"setPreferredPositioningMethods", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_setPreferredPositioningMethods), METH_O},
    {"setUpdateInterval", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_setUpdateInterval), METH_O},
    {"sourceName", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_sourceName), METH_NOARGS},
    {"startUpdates", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_startUpdates), METH_NOARGS},
    {"stopUpdates", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_stopUpdates), METH_NOARGS},
    {"supportedPositioningMethods", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_supportedPositioningMethods), METH_NOARGS},
    {"updateInterval", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFunc_updateInterval), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoPositionInfoSource_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoPositionInfoSourceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoPositionInfoSource_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoPositionInfoSource_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoPositionInfoSource_Type = nullptr;
static SbkObjectType *Sbk_QGeoPositionInfoSource_TypeF(void)
{
    return _Sbk_QGeoPositionInfoSource_Type;
}

static PyType_Slot Sbk_QGeoPositionInfoSource_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoPositionInfoSource_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoPositionInfoSource_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoPositionInfoSource_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoPositionInfoSource_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoPositionInfoSource_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoPositionInfoSource_spec = {
    "2:PySide2.QtPositioning.QGeoPositionInfoSource",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoPositionInfoSource_slots
};

} //extern "C"

static void *Sbk_QGeoPositionInfoSource_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGeoPositionInfoSource *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoPositionInfoSource::PositioningMethods cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoPositionInfoSource::PositioningMethods>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoPositionInfoSource::PositioningMethods>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoPositionInfoSource::PositioningMethods>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoPositionInfoSource::PositioningMethods>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoPositionInfoSource::PositioningMethods cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoPositionInfoSource::PositioningMethods>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoPositionInfoSource::PositioningMethods>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoPositionInfoSource::PositioningMethods>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoPositionInfoSource::PositioningMethods>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoPositionInfoSource::PositioningMethods cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoPositionInfoSource::PositioningMethods>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoPositionInfoSource::PositioningMethods>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoPositionInfoSource::PositioningMethods>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoPositionInfoSource::PositioningMethods>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoPositionInfoSource::PositioningMethods cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, self, &cppSelf);
    ::QGeoPositionInfoSource::PositioningMethods cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoPositionInfoSource_Error_PythonToCpp_QGeoPositionInfoSource_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoPositionInfoSource::Error *>(cppOut) =
        static_cast<::QGeoPositionInfoSource::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoPositionInfoSource_Error_PythonToCpp_QGeoPositionInfoSource_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX]))
        return QGeoPositionInfoSource_Error_PythonToCpp_QGeoPositionInfoSource_Error;
    return {};
}
static PyObject *QGeoPositionInfoSource_Error_CppToPython_QGeoPositionInfoSource_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoPositionInfoSource::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX], castCppIn);

}

static void QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QGeoPositionInfoSource_PositioningMethod(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoPositionInfoSource::PositioningMethod *>(cppOut) =
        static_cast<::QGeoPositionInfoSource::PositioningMethod>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QGeoPositionInfoSource_PositioningMethod_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX]))
        return QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QGeoPositionInfoSource_PositioningMethod;
    return {};
}
static PyObject *QGeoPositionInfoSource_PositioningMethod_CppToPython_QGeoPositionInfoSource_PositioningMethod(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoPositionInfoSource::PositioningMethod *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX], castCppIn);

}

static void QFlags_QGeoPositionInfoSource_PositioningMethod__PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoPositionInfoSource::PositioningMethod> *>(cppOut) =
        ::QFlags<QGeoPositionInfoSource::PositioningMethod>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoPositionInfoSource_PositioningMethod__PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX]))
        return QFlags_QGeoPositionInfoSource_PositioningMethod__PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod_;
    return {};
}
static PyObject *QFlags_QGeoPositionInfoSource_PositioningMethod__CppToPython_QFlags_QGeoPositionInfoSource_PositioningMethod_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoPositionInfoSource::PositioningMethod> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX]));

}

static void QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoPositionInfoSource::PositioningMethod> *>(cppOut) =
        ::QFlags<QGeoPositionInfoSource::PositioningMethod>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX]))
        return QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoPositionInfoSource::PositioningMethod> *>(cppOut) =
        ::QFlags<QGeoPositionInfoSource::PositioningMethod>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX]))
        return number_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoPositionInfoSource_PythonToCpp_QGeoPositionInfoSource_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoPositionInfoSource_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoPositionInfoSource_PythonToCpp_QGeoPositionInfoSource_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoPositionInfoSource_TypeF())))
        return QGeoPositionInfoSource_PythonToCpp_QGeoPositionInfoSource_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoPositionInfoSource_PTR_CppToPython_QGeoPositionInfoSource(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGeoPositionInfoSource *>(const_cast<void *>(cppIn)), Sbk_QGeoPositionInfoSource_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoPositionInfoSource_SignatureStrings[] = {
    "PySide2.QtPositioning.QGeoPositionInfoSource(self,parent:PySide2.QtCore.QObject)",
    "PySide2.QtPositioning.QGeoPositionInfoSource.availableSources()->QStringList",
    "PySide2.QtPositioning.QGeoPositionInfoSource.backendProperty(self,name:QString)->QVariant",
    "1:PySide2.QtPositioning.QGeoPositionInfoSource.createDefaultSource(parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoPositionInfoSource",
    "0:PySide2.QtPositioning.QGeoPositionInfoSource.createDefaultSource(parameters:QMap[QString, QVariant],parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoPositionInfoSource",
    "1:PySide2.QtPositioning.QGeoPositionInfoSource.createSource(sourceName:QString,parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoPositionInfoSource",
    "0:PySide2.QtPositioning.QGeoPositionInfoSource.createSource(sourceName:QString,parameters:QMap[QString, QVariant],parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoPositionInfoSource",
    "PySide2.QtPositioning.QGeoPositionInfoSource.error(self)->PySide2.QtPositioning.QGeoPositionInfoSource.Error",
    "PySide2.QtPositioning.QGeoPositionInfoSource.lastKnownPosition(self,fromSatellitePositioningMethodsOnly:bool=false)->PySide2.QtPositioning.QGeoPositionInfo",
    "PySide2.QtPositioning.QGeoPositionInfoSource.minimumUpdateInterval(self)->int",
    "PySide2.QtPositioning.QGeoPositionInfoSource.preferredPositioningMethods(self)->PySide2.QtPositioning.QGeoPositionInfoSource.PositioningMethods",
    "PySide2.QtPositioning.QGeoPositionInfoSource.requestUpdate(self,timeout:int=0)",
    "PySide2.QtPositioning.QGeoPositionInfoSource.setBackendProperty(self,name:QString,value:QVariant)->bool",
    "PySide2.QtPositioning.QGeoPositionInfoSource.setPreferredPositioningMethods(self,methods:PySide2.QtPositioning.QGeoPositionInfoSource.PositioningMethods)",
    "PySide2.QtPositioning.QGeoPositionInfoSource.setUpdateInterval(self,msec:int)",
    "PySide2.QtPositioning.QGeoPositionInfoSource.sourceName(self)->QString",
    "PySide2.QtPositioning.QGeoPositionInfoSource.startUpdates(self)",
    "PySide2.QtPositioning.QGeoPositionInfoSource.stopUpdates(self)",
    "PySide2.QtPositioning.QGeoPositionInfoSource.supportedPositioningMethods(self)->PySide2.QtPositioning.QGeoPositionInfoSource.PositioningMethods",
    "PySide2.QtPositioning.QGeoPositionInfoSource.updateInterval(self)->int",
    nullptr}; // Sentinel

void init_QGeoPositionInfoSource(PyObject *module)
{
    _Sbk_QGeoPositionInfoSource_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoPositionInfoSource",
        "QGeoPositionInfoSource*",
        &Sbk_QGeoPositionInfoSource_spec,
        &Shiboken::callCppDestructor< ::QGeoPositionInfoSource >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoPositionInfoSource_Type);
    InitSignatureStrings(pyType, QGeoPositionInfoSource_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoPositionInfoSource_Type), Sbk_QGeoPositionInfoSource_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoPositionInfoSource_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoPositionInfoSource_TypeF(),
        QGeoPositionInfoSource_PythonToCpp_QGeoPositionInfoSource_PTR,
        is_QGeoPositionInfoSource_PythonToCpp_QGeoPositionInfoSource_PTR_Convertible,
        QGeoPositionInfoSource_PTR_CppToPython_QGeoPositionInfoSource);

    Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfoSource");
    Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfoSource*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfoSource&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoPositionInfoSource).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoPositionInfoSourceWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGeoPositionInfoSource_TypeF(), &Sbk_QGeoPositionInfoSource_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoPositionInfoSource_TypeF(),
        "Error",
        "2:PySide2.QtPositioning.QGeoPositionInfoSource.Error",
        "QGeoPositionInfoSource::Error");
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX],
        Sbk_QGeoPositionInfoSource_TypeF(), "AccessError", (long) QGeoPositionInfoSource::Error::AccessError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX],
        Sbk_QGeoPositionInfoSource_TypeF(), "ClosedError", (long) QGeoPositionInfoSource::Error::ClosedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX],
        Sbk_QGeoPositionInfoSource_TypeF(), "UnknownSourceError", (long) QGeoPositionInfoSource::Error::UnknownSourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX],
        Sbk_QGeoPositionInfoSource_TypeF(), "NoError", (long) QGeoPositionInfoSource::Error::NoError))
        return;
    // Register converter for enum 'QGeoPositionInfoSource::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX],
            QGeoPositionInfoSource_Error_CppToPython_QGeoPositionInfoSource_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoPositionInfoSource_Error_PythonToCpp_QGeoPositionInfoSource_Error,
            is_QGeoPositionInfoSource_Error_PythonToCpp_QGeoPositionInfoSource_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfoSource::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    // Initialization of enum 'PositioningMethod'.
    SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX] = PySide::QFlags::create("2:PySide2.QtPositioning.QGeoPositionInfoSource.PositioningMethods", SbkPySide2_QtPositioning_QGeoPositionInfoSource_PositioningMethod_number_slots);
    SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoPositionInfoSource_TypeF(),
        "PositioningMethod",
        "2:PySide2.QtPositioning.QGeoPositionInfoSource.PositioningMethod",
        "QGeoPositionInfoSource::PositioningMethod",
        SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX]);
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX],
        Sbk_QGeoPositionInfoSource_TypeF(), "NoPositioningMethods", (long) QGeoPositionInfoSource::PositioningMethod::NoPositioningMethods))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX],
        Sbk_QGeoPositionInfoSource_TypeF(), "SatellitePositioningMethods", (long) QGeoPositionInfoSource::PositioningMethod::SatellitePositioningMethods))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX],
        Sbk_QGeoPositionInfoSource_TypeF(), "NonSatellitePositioningMethods", (long) QGeoPositionInfoSource::PositioningMethod::NonSatellitePositioningMethods))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX],
        Sbk_QGeoPositionInfoSource_TypeF(), "AllPositioningMethods", (long) QGeoPositionInfoSource::PositioningMethod::AllPositioningMethods))
        return;
    // Register converter for enum 'QGeoPositionInfoSource::PositioningMethod'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX],
            QGeoPositionInfoSource_PositioningMethod_CppToPython_QGeoPositionInfoSource_PositioningMethod);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QGeoPositionInfoSource_PositioningMethod,
            is_QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QGeoPositionInfoSource_PositioningMethod_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfoSource::PositioningMethod");
        Shiboken::Conversions::registerConverterName(converter, "PositioningMethod");
    }
    // Register converter for flag 'QFlags<QGeoPositionInfoSource::PositioningMethod>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX],
            QFlags_QGeoPositionInfoSource_PositioningMethod__CppToPython_QFlags_QGeoPositionInfoSource_PositioningMethod_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod_,
            is_QGeoPositionInfoSource_PositioningMethod_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoPositionInfoSource_PositioningMethod__PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod_,
            is_QFlags_QGeoPositionInfoSource_PositioningMethod__PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod_,
            is_number_PythonToCpp_QFlags_QGeoPositionInfoSource_PositioningMethod__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfoSource::PositioningMethods");
        Shiboken::Conversions::registerConverterName(converter, "PositioningMethods");
    }
    // End of 'PositioningMethod' enum/flags.

    PySide::Signal::registerSignals(Sbk_QGeoPositionInfoSource_TypeF(), &::QGeoPositionInfoSource::staticMetaObject);
    qRegisterMetaType< ::QGeoPositionInfoSource::Error >("QGeoPositionInfoSource::Error");
    qRegisterMetaType< ::QGeoPositionInfoSource::PositioningMethod >("QGeoPositionInfoSource::PositioningMethod");
    qRegisterMetaType< ::QGeoPositionInfoSource::PositioningMethods >("QGeoPositionInfoSource::PositioningMethods");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGeoPositionInfoSource_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGeoPositionInfoSource_TypeF(), &::QGeoPositionInfoSource::staticMetaObject, sizeof(QGeoPositionInfoSourceWrapper));
}
