/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtprintsupport_python.h"

// main header
#include "qprinterinfo_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QPair>
#include <QtGui/qpagesize.h>
#include <QtPrintSupport/qprinter.h>
#include <QtPrintSupport/qprinterinfo.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPrinterInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPrinterInfo >()))
        return -1;

    ::QPrinterInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPrinterInfo", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPrinterInfo::QPrinterInfo()
    // 1: QPrinterInfo::QPrinterInfo(QPrinter)
    // 2: QPrinterInfo::QPrinterInfo(QPrinterInfo)
    if (numArgs == 0) {
        overloadId = 0; // QPrinterInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QPrinterInfo(QPrinterInfo)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPrinterInfo(QPrinter)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPrinterInfo()
        {

            if (!PyErr_Occurred()) {
                // QPrinterInfo()
                cptr = new ::QPrinterInfo();
            }
            break;
        }
        case 1: // QPrinterInfo(const QPrinter & printer)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPrinter *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QPrinterInfo(QPrinter)
                cptr = new ::QPrinterInfo(*cppArg0);
            }
            break;
        }
        case 2: // QPrinterInfo(const QPrinterInfo & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPrinterInfo cppArg0_local;
            ::QPrinterInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPrinterInfo(QPrinterInfo)
                cptr = new ::QPrinterInfo(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPrinterInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPrinterInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPrinterInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPrinterInfoFunc_availablePrinterNames(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.availablePrinterNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availablePrinterNames()
            QStringList cppResult = ::QPrinterInfo::availablePrinterNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_availablePrinters(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.availablePrinters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availablePrinters()
            QList<QPrinterInfo > cppResult = ::QPrinterInfo::availablePrinters();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTERINFO_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_defaultColorMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.defaultColorMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultColorMode()const
            QPrinter::ColorMode cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->defaultColorMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_defaultDuplexMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.defaultDuplexMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultDuplexMode()const
            QPrinter::DuplexMode cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->defaultDuplexMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_defaultPageSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.defaultPageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultPageSize()const
            QPageSize cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->defaultPageSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_defaultPrinter(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.defaultPrinter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultPrinter()
            QPrinterInfo cppResult = ::QPrinterInfo::defaultPrinter();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_defaultPrinterName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.defaultPrinterName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultPrinterName()
            QString cppResult = ::QPrinterInfo::defaultPrinterName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.description";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // description()const
            QString cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->description();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_isDefault(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.isDefault";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDefault()const
            bool cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->isDefault();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_isRemote(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.isRemote";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRemote()const
            bool cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->isRemote();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_location(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.location";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // location()const
            QString cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->location();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_makeAndModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.makeAndModel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // makeAndModel()const
            QString cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->makeAndModel();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_maximumPhysicalPageSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.maximumPhysicalPageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumPhysicalPageSize()const
            QPageSize cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->maximumPhysicalPageSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_minimumPhysicalPageSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.minimumPhysicalPageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumPhysicalPageSize()const
            QPageSize cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->minimumPhysicalPageSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_printerInfo(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.printerInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QPrinterInfo::printerInfo(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // printerInfo(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterInfoFunc_printerInfo_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // printerInfo(QString)
            QPrinterInfo cppResult = ::QPrinterInfo::printerInfo(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrinterInfoFunc_printerInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterInfoFunc_printerName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.printerName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // printerName()const
            QString cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->printerName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QPrinter::PrinterState cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_supportedColorModes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.supportedColorModes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedColorModes()const
            QList<QPrinter::ColorMode > cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->supportedColorModes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTER_COLORMODE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_supportedDuplexModes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.supportedDuplexModes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedDuplexModes()const
            QList<QPrinter::DuplexMode > cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->supportedDuplexModes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTER_DUPLEXMODE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_supportedPageSizes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.supportedPageSizes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedPageSizes()const
            QList<QPageSize > cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->supportedPageSizes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAGESIZE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_supportedPaperSizes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.supportedPaperSizes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedPaperSizes()const
            QList<QPagedPaintDevice::PageSize > cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->supportedPaperSizes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAGEDPAINTDEVICE_PAGESIZE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_supportedResolutions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.supportedResolutions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedResolutions()const
            QList<int > cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->supportedResolutions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_supportedSizesWithNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.supportedSizesWithNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSizesWithNames()const
            QList<QPair< QString,QSizeF > > cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->supportedSizesWithNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAIR_QSTRING_QSIZEF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfoFunc_supportsCustomPageSizes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinterInfo.supportsCustomPageSizes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsCustomPageSizes()const
            bool cppResult = const_cast<const ::QPrinterInfo *>(cppSelf)->supportsCustomPageSizes();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPrinterInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPrinterInfo_methods[] = {
    {"availablePrinterNames", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_availablePrinterNames), METH_NOARGS|METH_STATIC},
    {"availablePrinters", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_availablePrinters), METH_NOARGS|METH_STATIC},
    {"defaultColorMode", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_defaultColorMode), METH_NOARGS},
    {"defaultDuplexMode", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_defaultDuplexMode), METH_NOARGS},
    {"defaultPageSize", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_defaultPageSize), METH_NOARGS},
    {"defaultPrinter", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_defaultPrinter), METH_NOARGS|METH_STATIC},
    {"defaultPrinterName", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_defaultPrinterName), METH_NOARGS|METH_STATIC},
    {"description", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_description), METH_NOARGS},
    {"isDefault", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_isDefault), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_isNull), METH_NOARGS},
    {"isRemote", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_isRemote), METH_NOARGS},
    {"location", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_location), METH_NOARGS},
    {"makeAndModel", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_makeAndModel), METH_NOARGS},
    {"maximumPhysicalPageSize", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_maximumPhysicalPageSize), METH_NOARGS},
    {"minimumPhysicalPageSize", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_minimumPhysicalPageSize), METH_NOARGS},
    {"printerInfo", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_printerInfo), METH_O|METH_STATIC},
    {"printerName", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_printerName), METH_NOARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_state), METH_NOARGS},
    {"supportedColorModes", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_supportedColorModes), METH_NOARGS},
    {"supportedDuplexModes", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_supportedDuplexModes), METH_NOARGS},
    {"supportedPageSizes", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_supportedPageSizes), METH_NOARGS},
    {"supportedPaperSizes", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_supportedPaperSizes), METH_NOARGS},
    {"supportedResolutions", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_supportedResolutions), METH_NOARGS},
    {"supportedSizesWithNames", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_supportedSizesWithNames), METH_NOARGS},
    {"supportsCustomPageSizes", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfoFunc_supportsCustomPageSizes), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPrinterInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPrinterInfo___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QPrinterInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPrinterInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPrinterInfo_Type = nullptr;
static SbkObjectType *Sbk_QPrinterInfo_TypeF(void)
{
    return _Sbk_QPrinterInfo_Type;
}

static PyType_Slot Sbk_QPrinterInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPrinterInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPrinterInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPrinterInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPrinterInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QPrinterInfo___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QPrinterInfo___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QPrinterInfo_spec = {
    "2:PySide2.QtPrintSupport.QPrinterInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPrinterInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPrinterInfo_PythonToCpp_QPrinterInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPrinterInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPrinterInfo_PythonToCpp_QPrinterInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPrinterInfo_TypeF())))
        return QPrinterInfo_PythonToCpp_QPrinterInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPrinterInfo_PTR_CppToPython_QPrinterInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPrinterInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPrinterInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPrinterInfo_COPY_CppToPython_QPrinterInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPrinterInfo_TypeF(), new ::QPrinterInfo(*reinterpret_cast<const ::QPrinterInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPrinterInfo_PythonToCpp_QPrinterInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinterInfo *>(cppOut) = *reinterpret_cast< ::QPrinterInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPrinterInfo_PythonToCpp_QPrinterInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPrinterInfo_TypeF())))
        return QPrinterInfo_PythonToCpp_QPrinterInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPrinterInfo_SignatureStrings[] = {
    "2:PySide2.QtPrintSupport.QPrinterInfo(self)",
    "1:PySide2.QtPrintSupport.QPrinterInfo(self,printer:PySide2.QtPrintSupport.QPrinter)",
    "0:PySide2.QtPrintSupport.QPrinterInfo(self,other:PySide2.QtPrintSupport.QPrinterInfo)",
    "PySide2.QtPrintSupport.QPrinterInfo.availablePrinterNames()->QStringList",
    "PySide2.QtPrintSupport.QPrinterInfo.availablePrinters()->QList[PySide2.QtPrintSupport.QPrinterInfo]",
    "PySide2.QtPrintSupport.QPrinterInfo.defaultColorMode(self)->PySide2.QtPrintSupport.QPrinter.ColorMode",
    "PySide2.QtPrintSupport.QPrinterInfo.defaultDuplexMode(self)->PySide2.QtPrintSupport.QPrinter.DuplexMode",
    "PySide2.QtPrintSupport.QPrinterInfo.defaultPageSize(self)->PySide2.QtGui.QPageSize",
    "PySide2.QtPrintSupport.QPrinterInfo.defaultPrinter()->PySide2.QtPrintSupport.QPrinterInfo",
    "PySide2.QtPrintSupport.QPrinterInfo.defaultPrinterName()->QString",
    "PySide2.QtPrintSupport.QPrinterInfo.description(self)->QString",
    "PySide2.QtPrintSupport.QPrinterInfo.isDefault(self)->bool",
    "PySide2.QtPrintSupport.QPrinterInfo.isNull(self)->bool",
    "PySide2.QtPrintSupport.QPrinterInfo.isRemote(self)->bool",
    "PySide2.QtPrintSupport.QPrinterInfo.location(self)->QString",
    "PySide2.QtPrintSupport.QPrinterInfo.makeAndModel(self)->QString",
    "PySide2.QtPrintSupport.QPrinterInfo.maximumPhysicalPageSize(self)->PySide2.QtGui.QPageSize",
    "PySide2.QtPrintSupport.QPrinterInfo.minimumPhysicalPageSize(self)->PySide2.QtGui.QPageSize",
    "PySide2.QtPrintSupport.QPrinterInfo.printerInfo(printerName:QString)->PySide2.QtPrintSupport.QPrinterInfo",
    "PySide2.QtPrintSupport.QPrinterInfo.printerName(self)->QString",
    "PySide2.QtPrintSupport.QPrinterInfo.state(self)->PySide2.QtPrintSupport.QPrinter.PrinterState",
    "PySide2.QtPrintSupport.QPrinterInfo.supportedColorModes(self)->QList[PySide2.QtPrintSupport.QPrinter.ColorMode]",
    "PySide2.QtPrintSupport.QPrinterInfo.supportedDuplexModes(self)->QList[PySide2.QtPrintSupport.QPrinter.DuplexMode]",
    "PySide2.QtPrintSupport.QPrinterInfo.supportedPageSizes(self)->QList[PySide2.QtGui.QPageSize]",
    "PySide2.QtPrintSupport.QPrinterInfo.supportedPaperSizes(self)->QList[PySide2.QtGui.QPagedPaintDevice.PageSize]",
    "PySide2.QtPrintSupport.QPrinterInfo.supportedResolutions(self)->QList[int]",
    "PySide2.QtPrintSupport.QPrinterInfo.supportedSizesWithNames(self)->QList[QPair[QString, PySide2.QtCore.QSizeF]]",
    "PySide2.QtPrintSupport.QPrinterInfo.supportsCustomPageSizes(self)->bool",
    "PySide2.QtPrintSupport.QPrinterInfo.__copy__()",
    nullptr}; // Sentinel

void init_QPrinterInfo(PyObject *module)
{
    _Sbk_QPrinterInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPrinterInfo",
        "QPrinterInfo",
        &Sbk_QPrinterInfo_spec,
        &Shiboken::callCppDestructor< ::QPrinterInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPrinterInfo_Type);
    InitSignatureStrings(pyType, QPrinterInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPrinterInfo_Type), Sbk_QPrinterInfo_PropertyStrings);
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPrinterInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPrinterInfo_TypeF(),
        QPrinterInfo_PythonToCpp_QPrinterInfo_PTR,
        is_QPrinterInfo_PythonToCpp_QPrinterInfo_PTR_Convertible,
        QPrinterInfo_PTR_CppToPython_QPrinterInfo,
        QPrinterInfo_COPY_CppToPython_QPrinterInfo);

    Shiboken::Conversions::registerConverterName(converter, "QPrinterInfo");
    Shiboken::Conversions::registerConverterName(converter, "QPrinterInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QPrinterInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPrinterInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPrinterInfo_PythonToCpp_QPrinterInfo_COPY,
        is_QPrinterInfo_PythonToCpp_QPrinterInfo_COPY_Convertible);

    qRegisterMetaType< ::QPrinterInfo >("QPrinterInfo");
}
