/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmlfile_wrapper.h"

// inner classes

// Extra includes
#include <QtQml/qqmlengine.h>
#include <qbytearray.h>
#include <qobject.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQmlFile_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQmlFile >()))
        return -1;

    ::QQmlFile *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto Sbk_QQmlFile_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QQmlFile", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QQmlFile::QQmlFile()
    // 1: QQmlFile::QQmlFile(QQmlEngine*,QString)
    // 2: QQmlFile::QQmlFile(QQmlEngine*,QUrl)
    if (numArgs == 0) {
        overloadId = 0; // QQmlFile()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // QQmlFile(QQmlEngine*,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QQmlFile(QQmlEngine*,QUrl)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlFile_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QQmlFile()
        {

            if (!PyErr_Occurred()) {
                // QQmlFile()
                cptr = new ::QQmlFile();
            }
            break;
        }
        case 1: // QQmlFile(QQmlEngine * arg__1, const QString & arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QQmlEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QQmlFile(QQmlEngine*,QString)
                cptr = new ::QQmlFile(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QQmlFile(QQmlEngine * arg__1, const QUrl & arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QQmlEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QQmlFile(QQmlEngine*,QUrl)
                cptr = new ::QQmlFile(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQmlFile >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QQmlFile_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QQmlFile_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QQmlFileFunc_clear(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.clear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "clear", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QQmlFile::clear()
    // 1: QQmlFile::clear(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // clear()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // clear(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlFileFunc_clear_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // clear()
        {

            if (!PyErr_Occurred()) {
                // clear()
                cppSelf->clear();
            }
            break;
        }
        case 1: // clear(QObject * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // clear(QObject*)
                cppSelf->clear(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlFileFunc_clear_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlFileFunc_connectDownloadProgress(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.connectDownloadProgress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "connectDownloadProgress", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQmlFile::connectDownloadProgress(QObject*,const char*)
    // 1: QQmlFile::connectDownloadProgress(QObject*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // connectDownloadProgress(QObject*,int)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 0; // connectDownloadProgress(QObject*,const char*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlFileFunc_connectDownloadProgress_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // connectDownloadProgress(QObject * arg__1, const char * arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // connectDownloadProgress(QObject*,const char*)
                bool cppResult = cppSelf->connectDownloadProgress(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // connectDownloadProgress(QObject * arg__1, int arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // connectDownloadProgress(QObject*,int)
                bool cppResult = cppSelf->connectDownloadProgress(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlFileFunc_connectDownloadProgress_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlFileFunc_connectFinished(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.connectFinished";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "connectFinished", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQmlFile::connectFinished(QObject*,const char*)
    // 1: QQmlFile::connectFinished(QObject*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // connectFinished(QObject*,int)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 0; // connectFinished(QObject*,const char*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlFileFunc_connectFinished_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // connectFinished(QObject * arg__1, const char * arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // connectFinished(QObject*,const char*)
                bool cppResult = cppSelf->connectFinished(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // connectFinished(QObject * arg__1, int arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // connectFinished(QObject*,int)
                bool cppResult = cppSelf->connectFinished(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlFileFunc_connectFinished_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlFileFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            const char * cppResult = const_cast<const ::QQmlFile *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_dataByteArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.dataByteArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dataByteArray()const
            QByteArray cppResult = const_cast<const ::QQmlFile *>(cppSelf)->dataByteArray();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QString cppResult = const_cast<const ::QQmlFile *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_isError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.isError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isError()const
            bool cppResult = const_cast<const ::QQmlFile *>(cppSelf)->isError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_isLoading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.isLoading";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLoading()const
            bool cppResult = const_cast<const ::QQmlFile *>(cppSelf)->isLoading();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_isLocalFile(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.isLocalFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QQmlFile::isLocalFile(QString)
    // 1: static QQmlFile::isLocalFile(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // isLocalFile(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 1; // isLocalFile(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlFileFunc_isLocalFile_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isLocalFile(const QString & url)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // isLocalFile(QString)
                bool cppResult = ::QQmlFile::isLocalFile(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isLocalFile(const QUrl & url)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // isLocalFile(QUrl)
                bool cppResult = ::QQmlFile::isLocalFile(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlFileFunc_isLocalFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlFileFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QQmlFile *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_isReady(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.isReady";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReady()const
            bool cppResult = const_cast<const ::QQmlFile *>(cppSelf)->isReady();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_isSynchronous(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.isSynchronous";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QQmlFile::isSynchronous(QString)
    // 1: static QQmlFile::isSynchronous(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // isSynchronous(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 1; // isSynchronous(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlFileFunc_isSynchronous_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isSynchronous(const QString & url)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // isSynchronous(QString)
                bool cppResult = ::QQmlFile::isSynchronous(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isSynchronous(const QUrl & url)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // isSynchronous(QUrl)
                bool cppResult = ::QQmlFile::isSynchronous(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlFileFunc_isSynchronous_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlFileFunc_load(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.load";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "load", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQmlFile::load(QQmlEngine*,QString)
    // 1: QQmlFile::load(QQmlEngine*,QUrl)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // load(QQmlEngine*,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 1; // load(QQmlEngine*,QUrl)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlFileFunc_load_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // load(QQmlEngine * arg__1, const QString & arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QQmlEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // load(QQmlEngine*,QString)
                cppSelf->load(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // load(QQmlEngine * arg__1, const QUrl & arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QQmlEngine *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // load(QQmlEngine*,QUrl)
                cppSelf->load(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlFileFunc_load_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlFileFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            qint64 cppResult = const_cast<const ::QQmlFile *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            QQmlFile::Status cppResult = const_cast<const ::QQmlFile *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::QQmlFile *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlFileFunc_urlToLocalFileOrQrc(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlFile.urlToLocalFileOrQrc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QQmlFile::urlToLocalFileOrQrc(QString)
    // 1: static QQmlFile::urlToLocalFileOrQrc(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // urlToLocalFileOrQrc(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 1; // urlToLocalFileOrQrc(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlFileFunc_urlToLocalFileOrQrc_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // urlToLocalFileOrQrc(const QString & arg__1)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // urlToLocalFileOrQrc(QString)
                QString cppResult = ::QQmlFile::urlToLocalFileOrQrc(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // urlToLocalFileOrQrc(const QUrl & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // urlToLocalFileOrQrc(QUrl)
                QString cppResult = ::QQmlFile::urlToLocalFileOrQrc(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlFileFunc_urlToLocalFileOrQrc_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQmlFile_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlFile_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_clear), METH_VARARGS},
    {"connectDownloadProgress", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_connectDownloadProgress), METH_VARARGS},
    {"connectFinished", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_connectFinished), METH_VARARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_data), METH_NOARGS},
    {"dataByteArray", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_dataByteArray), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_error), METH_NOARGS},
    {"isError", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_isError), METH_NOARGS},
    {"isLoading", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_isLoading), METH_NOARGS},
    {"isLocalFile", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_isLocalFile), METH_O|METH_STATIC},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_isNull), METH_NOARGS},
    {"isReady", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_isReady), METH_NOARGS},
    {"isSynchronous", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_isSynchronous), METH_O|METH_STATIC},
    {"load", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_load), METH_VARARGS},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_size), METH_NOARGS},
    {"status", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_status), METH_NOARGS},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_url), METH_NOARGS},
    {"urlToLocalFileOrQrc", reinterpret_cast<PyCFunction>(Sbk_QQmlFileFunc_urlToLocalFileOrQrc), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQmlFile___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QQmlFile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QQmlFile_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlFile_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlFile_Type = nullptr;
static SbkObjectType *Sbk_QQmlFile_TypeF(void)
{
    return _Sbk_QQmlFile_Type;
}

static PyType_Slot Sbk_QQmlFile_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlFile_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlFile_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlFile_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQmlFile_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QQmlFile___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QQmlFile___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlFile_spec = {
    "2:PySide2.QtQml.QQmlFile",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlFile_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QQmlFile_Status_PythonToCpp_QQmlFile_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlFile::Status *>(cppOut) =
        static_cast<::QQmlFile::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQmlFile_Status_PythonToCpp_QQmlFile_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX]))
        return QQmlFile_Status_PythonToCpp_QQmlFile_Status;
    return {};
}
static PyObject *QQmlFile_Status_CppToPython_QQmlFile_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQmlFile::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlFile_PythonToCpp_QQmlFile_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlFile_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlFile_PythonToCpp_QQmlFile_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlFile_TypeF())))
        return QQmlFile_PythonToCpp_QQmlFile_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlFile_PTR_CppToPython_QQmlFile(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlFile *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlFile_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlFile_SignatureStrings[] = {
    "2:PySide2.QtQml.QQmlFile(self)",
    "1:PySide2.QtQml.QQmlFile(self,arg__1:PySide2.QtQml.QQmlEngine,arg__2:QString)",
    "0:PySide2.QtQml.QQmlFile(self,arg__1:PySide2.QtQml.QQmlEngine,arg__2:PySide2.QtCore.QUrl)",
    "1:PySide2.QtQml.QQmlFile.clear(self)",
    "0:PySide2.QtQml.QQmlFile.clear(self,arg__1:PySide2.QtCore.QObject)",
    "1:PySide2.QtQml.QQmlFile.connectDownloadProgress(self,arg__1:PySide2.QtCore.QObject,arg__2:char*)->bool",
    "0:PySide2.QtQml.QQmlFile.connectDownloadProgress(self,arg__1:PySide2.QtCore.QObject,arg__2:int)->bool",
    "1:PySide2.QtQml.QQmlFile.connectFinished(self,arg__1:PySide2.QtCore.QObject,arg__2:char*)->bool",
    "0:PySide2.QtQml.QQmlFile.connectFinished(self,arg__1:PySide2.QtCore.QObject,arg__2:int)->bool",
    "PySide2.QtQml.QQmlFile.data(self)->char*",
    "PySide2.QtQml.QQmlFile.dataByteArray(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtQml.QQmlFile.error(self)->QString",
    "PySide2.QtQml.QQmlFile.isError(self)->bool",
    "PySide2.QtQml.QQmlFile.isLoading(self)->bool",
    "1:PySide2.QtQml.QQmlFile.isLocalFile(url:QString)->bool",
    "0:PySide2.QtQml.QQmlFile.isLocalFile(url:PySide2.QtCore.QUrl)->bool",
    "PySide2.QtQml.QQmlFile.isNull(self)->bool",
    "PySide2.QtQml.QQmlFile.isReady(self)->bool",
    "1:PySide2.QtQml.QQmlFile.isSynchronous(url:QString)->bool",
    "0:PySide2.QtQml.QQmlFile.isSynchronous(url:PySide2.QtCore.QUrl)->bool",
    "1:PySide2.QtQml.QQmlFile.load(self,arg__1:PySide2.QtQml.QQmlEngine,arg__2:QString)",
    "0:PySide2.QtQml.QQmlFile.load(self,arg__1:PySide2.QtQml.QQmlEngine,arg__2:PySide2.QtCore.QUrl)",
    "PySide2.QtQml.QQmlFile.size(self)->qint64",
    "PySide2.QtQml.QQmlFile.status(self)->PySide2.QtQml.QQmlFile.Status",
    "PySide2.QtQml.QQmlFile.url(self)->PySide2.QtCore.QUrl",
    "1:PySide2.QtQml.QQmlFile.urlToLocalFileOrQrc(arg__1:QString)->QString",
    "0:PySide2.QtQml.QQmlFile.urlToLocalFileOrQrc(arg__1:PySide2.QtCore.QUrl)->QString",
    nullptr}; // Sentinel

void init_QQmlFile(PyObject *module)
{
    _Sbk_QQmlFile_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlFile",
        "QQmlFile*",
        &Sbk_QQmlFile_spec,
        &Shiboken::callCppDestructor< ::QQmlFile >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlFile_Type);
    InitSignatureStrings(pyType, QQmlFile_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlFile_Type), Sbk_QQmlFile_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLFILE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlFile_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlFile_TypeF(),
        QQmlFile_PythonToCpp_QQmlFile_PTR,
        is_QQmlFile_PythonToCpp_QQmlFile_PTR_Convertible,
        QQmlFile_PTR_CppToPython_QQmlFile);

    Shiboken::Conversions::registerConverterName(converter, "QQmlFile");
    Shiboken::Conversions::registerConverterName(converter, "QQmlFile*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlFile&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlFile).name());


    // Initialization of enums.

    // Initialization of enum 'Status'.
    SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQmlFile_TypeF(),
        "Status",
        "2:PySide2.QtQml.QQmlFile.Status",
        "QQmlFile::Status");
    if (!SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX],
        Sbk_QQmlFile_TypeF(), "Null", (long) QQmlFile::Status::Null))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX],
        Sbk_QQmlFile_TypeF(), "Ready", (long) QQmlFile::Status::Ready))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX],
        Sbk_QQmlFile_TypeF(), "Error", (long) QQmlFile::Status::Error))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX],
        Sbk_QQmlFile_TypeF(), "Loading", (long) QQmlFile::Status::Loading))
        return;
    // Register converter for enum 'QQmlFile::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX],
            QQmlFile_Status_CppToPython_QQmlFile_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlFile_Status_PythonToCpp_QQmlFile_Status,
            is_QQmlFile_Status_PythonToCpp_QQmlFile_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QQMLFILE_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlFile::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    qRegisterMetaType< ::QQmlFile::Status >("QQmlFile::Status");
}
