/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmlimageproviderbase_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQmlImageProviderBaseWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

::QFlags<QQmlImageProviderBase::Flag> QQmlImageProviderBaseWrapper::flags() const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlImageProviderBase.flags()' not implemented.");
        return QFlags<QQmlImageProviderBase::Flag>(0);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QQmlImageProviderBase::Flag>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "flags";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlImageProviderBase.flags()' not implemented.");
        return QFlags<QQmlImageProviderBase::Flag>(0);
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QQmlImageProviderBase::Flag>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQmlImageProviderBase.flags", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QQmlImageProviderBase::Flag> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QQmlImageProviderBase::Flag>(0);
    }
    ::QFlags<QQmlImageProviderBase::Flag> cppResult = QFlags<QQmlImageProviderBase::Flag>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QQmlImageProviderBase::ImageType QQmlImageProviderBaseWrapper::imageType() const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlImageProviderBase.imageType()' not implemented.");
        return QQmlImageProviderBase::Image;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QQmlImageProviderBase::Image;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "imageType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlImageProviderBase.imageType()' not implemented.");
        return QQmlImageProviderBase::Image;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QQmlImageProviderBase::Image;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQmlImageProviderBase.imageType", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QQmlImageProviderBase::ImageType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QQmlImageProviderBase::Image;
    }
    ::QQmlImageProviderBase::ImageType cppResult{QQmlImageProviderBase::Image};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QQmlImageProviderBaseWrapper::~QQmlImageProviderBaseWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QQmlImageProviderBaseFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlImageProviderBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlImageProviderBase.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlImageProviderBase.flags()' not implemented.");
                return {};
            }
            QFlags<QQmlImageProviderBase::Flag> cppResult = const_cast<const ::QQmlImageProviderBase *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlImageProviderBaseFunc_imageType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlImageProviderBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlImageProviderBase.imageType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // imageType()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlImageProviderBase.imageType()' not implemented.");
                return {};
            }
            QQmlImageProviderBase::ImageType cppResult = const_cast<const ::QQmlImageProviderBase *>(cppSelf)->imageType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QQmlImageProviderBase_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlImageProviderBase_methods[] = {
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QQmlImageProviderBaseFunc_flags), METH_NOARGS},
    {"imageType", reinterpret_cast<PyCFunction>(Sbk_QQmlImageProviderBaseFunc_imageType), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQmlImageProviderBase_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQmlImageProviderBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQmlImageProviderBaseWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QQmlImageProviderBase_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlImageProviderBase_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlImageProviderBase_Type = nullptr;
static SbkObjectType *Sbk_QQmlImageProviderBase_TypeF(void)
{
    return _Sbk_QQmlImageProviderBase_Type;
}

static PyType_Slot Sbk_QQmlImageProviderBase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQmlImageProviderBase_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlImageProviderBase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlImageProviderBase_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlImageProviderBase_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlImageProviderBase_spec = {
    "2:PySide2.QtQml.QQmlImageProviderBase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlImageProviderBase_slots
};

} //extern "C"

PyObject *SbkPySide2_QtQml_QQmlImageProviderBase_Flag___and__(PyObject *self, PyObject *pyArg)
{
    ::QQmlImageProviderBase::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQmlImageProviderBase::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQmlImageProviderBase::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQmlImageProviderBase::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQmlImageProviderBase::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQml_QQmlImageProviderBase_Flag___or__(PyObject *self, PyObject *pyArg)
{
    ::QQmlImageProviderBase::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQmlImageProviderBase::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQmlImageProviderBase::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQmlImageProviderBase::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQmlImageProviderBase::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQml_QQmlImageProviderBase_Flag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QQmlImageProviderBase::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQmlImageProviderBase::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQmlImageProviderBase::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQmlImageProviderBase::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQmlImageProviderBase::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQml_QQmlImageProviderBase_Flag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QQmlImageProviderBase::Flags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, self, &cppSelf);
    ::QQmlImageProviderBase::Flags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQml_QQmlImageProviderBase_Flag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQml_QQmlImageProviderBase_Flag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQml_QQmlImageProviderBase_Flag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQml_QQmlImageProviderBase_Flag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QQmlImageProviderBase_ImageType_PythonToCpp_QQmlImageProviderBase_ImageType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlImageProviderBase::ImageType *>(cppOut) =
        static_cast<::QQmlImageProviderBase::ImageType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQmlImageProviderBase_ImageType_PythonToCpp_QQmlImageProviderBase_ImageType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX]))
        return QQmlImageProviderBase_ImageType_PythonToCpp_QQmlImageProviderBase_ImageType;
    return {};
}
static PyObject *QQmlImageProviderBase_ImageType_CppToPython_QQmlImageProviderBase_ImageType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQmlImageProviderBase::ImageType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX], castCppIn);

}

static void QQmlImageProviderBase_Flag_PythonToCpp_QQmlImageProviderBase_Flag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlImageProviderBase::Flag *>(cppOut) =
        static_cast<::QQmlImageProviderBase::Flag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQmlImageProviderBase_Flag_PythonToCpp_QQmlImageProviderBase_Flag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_FLAG_IDX]))
        return QQmlImageProviderBase_Flag_PythonToCpp_QQmlImageProviderBase_Flag;
    return {};
}
static PyObject *QQmlImageProviderBase_Flag_CppToPython_QQmlImageProviderBase_Flag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQmlImageProviderBase::Flag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_FLAG_IDX], castCppIn);

}

static void QFlags_QQmlImageProviderBase_Flag__PythonToCpp_QFlags_QQmlImageProviderBase_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QQmlImageProviderBase::Flag> *>(cppOut) =
        ::QFlags<QQmlImageProviderBase::Flag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QQmlImageProviderBase_Flag__PythonToCpp_QFlags_QQmlImageProviderBase_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX]))
        return QFlags_QQmlImageProviderBase_Flag__PythonToCpp_QFlags_QQmlImageProviderBase_Flag_;
    return {};
}
static PyObject *QFlags_QQmlImageProviderBase_Flag__CppToPython_QFlags_QQmlImageProviderBase_Flag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QQmlImageProviderBase::Flag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX]));

}

static void QQmlImageProviderBase_Flag_PythonToCpp_QFlags_QQmlImageProviderBase_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QQmlImageProviderBase::Flag> *>(cppOut) =
        ::QFlags<QQmlImageProviderBase::Flag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QQmlImageProviderBase_Flag_PythonToCpp_QFlags_QQmlImageProviderBase_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_FLAG_IDX]))
        return QQmlImageProviderBase_Flag_PythonToCpp_QFlags_QQmlImageProviderBase_Flag_;
    return {};
}
static void number_PythonToCpp_QFlags_QQmlImageProviderBase_Flag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QQmlImageProviderBase::Flag> *>(cppOut) =
        ::QFlags<QQmlImageProviderBase::Flag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QQmlImageProviderBase_Flag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_FLAG_IDX]))
        return number_PythonToCpp_QFlags_QQmlImageProviderBase_Flag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlImageProviderBase_PythonToCpp_QQmlImageProviderBase_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlImageProviderBase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlImageProviderBase_PythonToCpp_QQmlImageProviderBase_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlImageProviderBase_TypeF())))
        return QQmlImageProviderBase_PythonToCpp_QQmlImageProviderBase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlImageProviderBase_PTR_CppToPython_QQmlImageProviderBase(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlImageProviderBase *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlImageProviderBase_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlImageProviderBase_SignatureStrings[] = {
    "PySide2.QtQml.QQmlImageProviderBase.flags(self)->PySide2.QtQml.QQmlImageProviderBase.Flags",
    "PySide2.QtQml.QQmlImageProviderBase.imageType(self)->PySide2.QtQml.QQmlImageProviderBase.ImageType",
    nullptr}; // Sentinel

void init_QQmlImageProviderBase(PyObject *module)
{
    _Sbk_QQmlImageProviderBase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlImageProviderBase",
        "QQmlImageProviderBase*",
        &Sbk_QQmlImageProviderBase_spec,
        &Shiboken::callCppDestructor< ::QQmlImageProviderBase >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlImageProviderBase_Type);
    InitSignatureStrings(pyType, QQmlImageProviderBase_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlImageProviderBase_Type), Sbk_QQmlImageProviderBase_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlImageProviderBase_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlImageProviderBase_TypeF(),
        QQmlImageProviderBase_PythonToCpp_QQmlImageProviderBase_PTR,
        is_QQmlImageProviderBase_PythonToCpp_QQmlImageProviderBase_PTR_Convertible,
        QQmlImageProviderBase_PTR_CppToPython_QQmlImageProviderBase);

    Shiboken::Conversions::registerConverterName(converter, "QQmlImageProviderBase");
    Shiboken::Conversions::registerConverterName(converter, "QQmlImageProviderBase*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlImageProviderBase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlImageProviderBase).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlImageProviderBaseWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'ImageType'.
    SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQmlImageProviderBase_TypeF(),
        "ImageType",
        "2:PySide2.QtQml.QQmlImageProviderBase.ImageType",
        "QQmlImageProviderBase::ImageType");
    if (!SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX],
        Sbk_QQmlImageProviderBase_TypeF(), "Image", (long) QQmlImageProviderBase::ImageType::Image))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX],
        Sbk_QQmlImageProviderBase_TypeF(), "Pixmap", (long) QQmlImageProviderBase::ImageType::Pixmap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX],
        Sbk_QQmlImageProviderBase_TypeF(), "Texture", (long) QQmlImageProviderBase::ImageType::Texture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX],
        Sbk_QQmlImageProviderBase_TypeF(), "Invalid", (long) QQmlImageProviderBase::ImageType::Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX],
        Sbk_QQmlImageProviderBase_TypeF(), "ImageResponse", (long) QQmlImageProviderBase::ImageType::ImageResponse))
        return;
    // Register converter for enum 'QQmlImageProviderBase::ImageType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX],
            QQmlImageProviderBase_ImageType_CppToPython_QQmlImageProviderBase_ImageType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlImageProviderBase_ImageType_PythonToCpp_QQmlImageProviderBase_ImageType,
            is_QQmlImageProviderBase_ImageType_PythonToCpp_QQmlImageProviderBase_ImageType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_IMAGETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlImageProviderBase::ImageType");
        Shiboken::Conversions::registerConverterName(converter, "ImageType");
    }
    // End of 'ImageType' enum.

    // Initialization of enum 'Flag'.
    SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX] = PySide::QFlags::create("2:PySide2.QtQml.QQmlImageProviderBase.Flags", SbkPySide2_QtQml_QQmlImageProviderBase_Flag_number_slots);
    SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_FLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQmlImageProviderBase_TypeF(),
        "Flag",
        "2:PySide2.QtQml.QQmlImageProviderBase.Flag",
        "QQmlImageProviderBase::Flag",
        SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX]);
    if (!SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_FLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_FLAG_IDX],
        Sbk_QQmlImageProviderBase_TypeF(), "ForceAsynchronousImageLoading", (long) QQmlImageProviderBase::Flag::ForceAsynchronousImageLoading))
        return;
    // Register converter for enum 'QQmlImageProviderBase::Flag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_FLAG_IDX],
            QQmlImageProviderBase_Flag_CppToPython_QQmlImageProviderBase_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlImageProviderBase_Flag_PythonToCpp_QQmlImageProviderBase_Flag,
            is_QQmlImageProviderBase_Flag_PythonToCpp_QQmlImageProviderBase_Flag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QQMLIMAGEPROVIDERBASE_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlImageProviderBase::Flag");
        Shiboken::Conversions::registerConverterName(converter, "Flag");
    }
    // Register converter for flag 'QFlags<QQmlImageProviderBase::Flag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX],
            QFlags_QQmlImageProviderBase_Flag__CppToPython_QFlags_QQmlImageProviderBase_Flag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlImageProviderBase_Flag_PythonToCpp_QFlags_QQmlImageProviderBase_Flag_,
            is_QQmlImageProviderBase_Flag_PythonToCpp_QFlags_QQmlImageProviderBase_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QQmlImageProviderBase_Flag__PythonToCpp_QFlags_QQmlImageProviderBase_Flag_,
            is_QFlags_QQmlImageProviderBase_Flag__PythonToCpp_QFlags_QQmlImageProviderBase_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QQmlImageProviderBase_Flag_,
            is_number_PythonToCpp_QFlags_QQmlImageProviderBase_Flag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QQMLIMAGEPROVIDERBASE_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlImageProviderBase::Flags");
        Shiboken::Conversions::registerConverterName(converter, "Flags");
    }
    // End of 'Flag' enum/flags.

    qRegisterMetaType< ::QQmlImageProviderBase::ImageType >("QQmlImageProviderBase::ImageType");
    qRegisterMetaType< ::QQmlImageProviderBase::Flag >("QQmlImageProviderBase::Flag");
    qRegisterMetaType< ::QQmlImageProviderBase::Flags >("QQmlImageProviderBase::Flags");
}
