/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmlincubationcontroller_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQmlIncubationControllerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QQmlIncubationControllerWrapper::QQmlIncubationControllerWrapper() : QQmlIncubationController()
{
    resetPyMethodCache();
    // ... middle
}

void QQmlIncubationControllerWrapper::incubatingObjectCountChanged(int arg__1)
{
    if (m_PyMethodCache[0]) {
        return this->::QQmlIncubationController::incubatingObjectCountChanged(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "incubatingObjectCountChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QQmlIncubationController::incubatingObjectCountChanged(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QQmlIncubationControllerWrapper::~QQmlIncubationControllerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQmlIncubationController_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQmlIncubationController >()))
        return -1;

    ::QQmlIncubationControllerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubationController.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QQmlIncubationController()
            cptr = new ::QQmlIncubationControllerWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQmlIncubationController >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QQmlIncubationControllerFunc_engine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubationController *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATIONCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubationController.engine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // engine()const
            QQmlEngine * cppResult = const_cast<const ::QQmlIncubationController *>(cppSelf)->engine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubationControllerFunc_incubateFor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubationController *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATIONCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubationController.incubateFor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQmlIncubationController::incubateFor(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // incubateFor(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlIncubationControllerFunc_incubateFor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // incubateFor(int)
            cppSelf->incubateFor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlIncubationControllerFunc_incubateFor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlIncubationControllerFunc_incubateWhile(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubationController *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATIONCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubationController.incubateWhile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQmlIncubationControllerFunc_incubateWhile_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QQmlIncubationControllerFunc_incubateWhile_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:incubateWhile", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQmlIncubationController::incubateWhile(volatile bool*,int)
    if (numArgs >= 1
        && VolatileBool_Check(pyArgs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // incubateWhile(volatile bool*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // incubateWhile(volatile bool*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlIncubationControllerFunc_incubateWhile_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[1]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QQmlIncubationControllerFunc_incubateWhile_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QQmlIncubationControllerFunc_incubateWhile_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQmlIncubationControllerFunc_incubateWhile_TypeError;
            }
        }
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // incubateWhile(volatile bool*,int)
            // Begin code injection
            volatile bool * flag_out =
              &((reinterpret_cast<QtQml_VolatileBoolObject *>(pyArgs[1-1]))->flag);

            // End of code injection

            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->incubateWhile(flag_out, cppArg1);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlIncubationControllerFunc_incubateWhile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlIncubationControllerFunc_incubatingObjectCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubationController *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATIONCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubationController.incubatingObjectCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // incubatingObjectCount()const
            int cppResult = const_cast<const ::QQmlIncubationController *>(cppSelf)->incubatingObjectCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubationControllerFunc_incubatingObjectCountChanged(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubationController *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATIONCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubationController.incubatingObjectCountChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQmlIncubationController::incubatingObjectCountChanged(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // incubatingObjectCountChanged(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlIncubationControllerFunc_incubatingObjectCountChanged_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // incubatingObjectCountChanged(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQmlIncubationController::incubatingObjectCountChanged(cppArg0)
                : cppSelf->incubatingObjectCountChanged(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlIncubationControllerFunc_incubatingObjectCountChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQmlIncubationController_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlIncubationController_methods[] = {
    {"engine", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubationControllerFunc_engine), METH_NOARGS},
    {"incubateFor", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubationControllerFunc_incubateFor), METH_O},
    {"incubateWhile", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubationControllerFunc_incubateWhile), METH_VARARGS|METH_KEYWORDS},
    {"incubatingObjectCount", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubationControllerFunc_incubatingObjectCount), METH_NOARGS},
    {"incubatingObjectCountChanged", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubationControllerFunc_incubatingObjectCountChanged), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQmlIncubationController_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQmlIncubationController *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATIONCONTROLLER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQmlIncubationControllerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QQmlIncubationController_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlIncubationController_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlIncubationController_Type = nullptr;
static SbkObjectType *Sbk_QQmlIncubationController_TypeF(void)
{
    return _Sbk_QQmlIncubationController_Type;
}

static PyType_Slot Sbk_QQmlIncubationController_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQmlIncubationController_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlIncubationController_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlIncubationController_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlIncubationController_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQmlIncubationController_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlIncubationController_spec = {
    "2:PySide2.QtQml.QQmlIncubationController",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlIncubationController_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlIncubationController_PythonToCpp_QQmlIncubationController_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlIncubationController_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlIncubationController_PythonToCpp_QQmlIncubationController_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlIncubationController_TypeF())))
        return QQmlIncubationController_PythonToCpp_QQmlIncubationController_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlIncubationController_PTR_CppToPython_QQmlIncubationController(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlIncubationController *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlIncubationController_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlIncubationController_SignatureStrings[] = {
    "PySide2.QtQml.QQmlIncubationController(self)",
    "PySide2.QtQml.QQmlIncubationController.engine(self)->PySide2.QtQml.QQmlEngine",
    "PySide2.QtQml.QQmlIncubationController.incubateFor(self,msecs:int)",
    "PySide2.QtQml.QQmlIncubationController.incubateWhile(self,flag:bool*,msecs:int=0)",
    "PySide2.QtQml.QQmlIncubationController.incubatingObjectCount(self)->int",
    "PySide2.QtQml.QQmlIncubationController.incubatingObjectCountChanged(self,arg__1:int)",
    nullptr}; // Sentinel

void init_QQmlIncubationController(PyObject *module)
{
    _Sbk_QQmlIncubationController_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlIncubationController",
        "QQmlIncubationController*",
        &Sbk_QQmlIncubationController_spec,
        &Shiboken::callCppDestructor< ::QQmlIncubationController >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlIncubationController_Type);
    InitSignatureStrings(pyType, QQmlIncubationController_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlIncubationController_Type), Sbk_QQmlIncubationController_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATIONCONTROLLER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlIncubationController_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlIncubationController_TypeF(),
        QQmlIncubationController_PythonToCpp_QQmlIncubationController_PTR,
        is_QQmlIncubationController_PythonToCpp_QQmlIncubationController_PTR_Convertible,
        QQmlIncubationController_PTR_CppToPython_QQmlIncubationController);

    Shiboken::Conversions::registerConverterName(converter, "QQmlIncubationController");
    Shiboken::Conversions::registerConverterName(converter, "QQmlIncubationController*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlIncubationController&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlIncubationController).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlIncubationControllerWrapper).name());


}
