/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qquickitem_updatepaintnodedata_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QQuickItem_UpdatePaintNodeData___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QQuickItem::UpdatePaintNodeData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QQuickItem_UpdatePaintNodeData_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQuickItem_UpdatePaintNodeData_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QQuickItem_UpdatePaintNodeData___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QQuickItem_UpdatePaintNodeData_get_transformNode(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QQuickItem::UpdatePaintNodeData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTRANSFORMNODE_IDX]), cppSelf->transformNode);
    return pyOut;
}
static int Sbk_QQuickItem_UpdatePaintNodeData_set_transformNode(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QQuickItem::UpdatePaintNodeData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'transformNode' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTRANSFORMNODE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'transformNode', 'QSGTransformNode' or convertible type expected");
        return -1;
    }

    ::QSGTransformNode *& cppOut_ptr = cppSelf->transformNode;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "transformNode", pyIn);
    return 0;
}

// Getters and Setters for UpdatePaintNodeData
static PyGetSetDef Sbk_QQuickItem_UpdatePaintNodeData_getsetlist[] = {
    {const_cast<char *>("transformNode"), Sbk_QQuickItem_UpdatePaintNodeData_get_transformNode, Sbk_QQuickItem_UpdatePaintNodeData_set_transformNode},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QQuickItem_UpdatePaintNodeData_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQuickItem_UpdatePaintNodeData_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQuickItem_UpdatePaintNodeData_Type = nullptr;
static SbkObjectType *Sbk_QQuickItem_UpdatePaintNodeData_TypeF(void)
{
    return _Sbk_QQuickItem_UpdatePaintNodeData_Type;
}

static PyType_Slot Sbk_QQuickItem_UpdatePaintNodeData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQuickItem_UpdatePaintNodeData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQuickItem_UpdatePaintNodeData_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQuickItem_UpdatePaintNodeData_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QQuickItem_UpdatePaintNodeData_getsetlist)},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQuickItem_UpdatePaintNodeData_spec = {
    "2:PySide2.QtQuick.QQuickItem.UpdatePaintNodeData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQuickItem_UpdatePaintNodeData_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQuickItem_UpdatePaintNodeData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQuickItem_UpdatePaintNodeData_TypeF())))
        return UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *UpdatePaintNodeData_PTR_CppToPython_UpdatePaintNodeData(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQuickItem::UpdatePaintNodeData *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQuickItem_UpdatePaintNodeData_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *UpdatePaintNodeData_COPY_CppToPython_UpdatePaintNodeData(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QQuickItem_UpdatePaintNodeData_TypeF(), new ::QQuickItem::UpdatePaintNodeData(*reinterpret_cast<const ::QQuickItem::UpdatePaintNodeData *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickItem::UpdatePaintNodeData *>(cppOut) = *reinterpret_cast< ::QQuickItem::UpdatePaintNodeData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQuickItem_UpdatePaintNodeData_TypeF())))
        return UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQuickItem_UpdatePaintNodeData_SignatureStrings[] = {
    "PySide2.QtQuick.QQuickItem.UpdatePaintNodeData.__copy__()",
    nullptr}; // Sentinel

void init_QQuickItem_UpdatePaintNodeData(PyObject *enclosingClass)
{
    _Sbk_QQuickItem_UpdatePaintNodeData_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "UpdatePaintNodeData",
        "QQuickItem::UpdatePaintNodeData",
        &Sbk_QQuickItem_UpdatePaintNodeData_spec,
        &Shiboken::callCppDestructor< ::QQuickItem::UpdatePaintNodeData >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQuickItem_UpdatePaintNodeData_Type);
    InitSignatureStrings(pyType, QQuickItem_UpdatePaintNodeData_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQuickItem_UpdatePaintNodeData_Type), Sbk_QQuickItem_UpdatePaintNodeData_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQuickItem_UpdatePaintNodeData_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQuickItem_UpdatePaintNodeData_TypeF(),
        UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_PTR,
        is_UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_PTR_Convertible,
        UpdatePaintNodeData_PTR_CppToPython_UpdatePaintNodeData,
        UpdatePaintNodeData_COPY_CppToPython_UpdatePaintNodeData);

    Shiboken::Conversions::registerConverterName(converter, "QQuickItem::UpdatePaintNodeData");
    Shiboken::Conversions::registerConverterName(converter, "QQuickItem::UpdatePaintNodeData*");
    Shiboken::Conversions::registerConverterName(converter, "QQuickItem::UpdatePaintNodeData&");
    Shiboken::Conversions::registerConverterName(converter, "UpdatePaintNodeData");
    Shiboken::Conversions::registerConverterName(converter, "UpdatePaintNodeData*");
    Shiboken::Conversions::registerConverterName(converter, "UpdatePaintNodeData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQuickItem::UpdatePaintNodeData).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_COPY,
        is_UpdatePaintNodeData_PythonToCpp_UpdatePaintNodeData_COPY_Convertible);

}
