/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QQUICKPAINTEDITEMWRAPPER_H
#define SBK_QQUICKPAINTEDITEMWRAPPER_H

#define protected public

#include <QtQuick/qquickpainteditem.h>


// Extra includes
#include <qobject.h>
#include <QtQuick/qquickitem.h>
#include <qrect.h>
#include <qsize.h>
#include <QtGui/qcolor.h>
#include <QtGui/qpainter.h>
#include <QtQuick/qsgtextureprovider.h>
#include <QtQuick/qsgnode.h>
#include <QtQuick/qquickwindow.h>
#include <QtGui/qevent.h>
#include <qpoint.h>
#include <qcoreevent.h>
#include <QList>
#include <qobjectdefs.h>
#include <qmetaobject.h>
#include <QtGui/qtransform.h>
#include <qsharedpointer.h>
#include <QtQuick/qquickitemgrabresult.h>
#include <QVector>
#include <QtQml/qjsvalue.h>
#include <QtGui/qcursor.h>
namespace PySide { class DynamicQMetaObject; }

class QQuickPaintedItemWrapper : public QQuickPaintedItem
{
public:
    QQuickPaintedItemWrapper(::QQuickItem * parent = nullptr);
    ::QRectF boundingRect() const override;
    void childEvent(::QChildEvent * event) override;
    bool childMouseEventFilter(::QQuickItem * arg__1, ::QEvent * arg__2) override;
    void classBegin() override;
    ::QRectF clipRect() const override;
    void componentComplete() override;
    void connectNotify(const ::QMetaMethod & signal) override;
    bool contains(const ::QPointF & point) const override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * arg__1) override;
    void dragLeaveEvent(::QDragLeaveEvent * arg__1) override;
    void dragMoveEvent(::QDragMoveEvent * arg__1) override;
    void dropEvent(::QDropEvent * arg__1) override;
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * arg__1) override;
    void focusOutEvent(::QFocusEvent * arg__1) override;
    void geometryChanged(const ::QRectF & newGeometry, const ::QRectF & oldGeometry) override;
    void hoverEnterEvent(::QHoverEvent * event) override;
    void hoverLeaveEvent(::QHoverEvent * event) override;
    void hoverMoveEvent(::QHoverEvent * event) override;
    void inputMethodEvent(::QInputMethodEvent * arg__1) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery query) const override;
    bool isTextureProvider() const override;
    void keyPressEvent(::QKeyEvent * event) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    const ::QMetaObject * metaObject() const override;
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent(::QMouseEvent * event) override;
    void mousePressEvent(::QMouseEvent * event) override;
    void mouseReleaseEvent(::QMouseEvent * event) override;
    void mouseUngrabEvent() override;
    void paint(::QPainter * painter) override;
    void releaseResources() override;
    ::QSGTextureProvider * textureProvider() const override;
    void timerEvent(::QTimerEvent * event) override;
    void touchEvent(::QTouchEvent * event) override;
    void touchUngrabEvent() override;
    ::QSGNode * updatePaintNode(::QSGNode * arg__1, ::QQuickItem::UpdatePaintNodeData * arg__2) override;
    void updatePolish() override;
    void wheelEvent(::QWheelEvent * event) override;
    void windowDeactivateEvent() override;
    ~QQuickPaintedItemWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[43];
};

#endif // SBK_QQUICKPAINTEDITEMWRAPPER_H

