/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qquickwindow_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQuickWindowWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QQuickWindowWrapper::QQuickWindowWrapper(::QQuickRenderControl * renderControl) : QQuickWindow(renderControl)
{
    resetPyMethodCache();
    // ... middle
}

QQuickWindowWrapper::QQuickWindowWrapper(::QWindow * parent) : QQuickWindow(parent)
{
    resetPyMethodCache();
    // ... middle
}

::QAccessibleInterface * QQuickWindowWrapper::accessibleRoot() const
{
    if (m_PyMethodCache[0])
        return this->::QQuickWindow::accessibleRoot();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "accessibleRoot";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QQuickWindow::accessibleRoot();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickWindow.accessibleRoot", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAccessibleInterface >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QAccessibleInterface *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickWindowWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QQuickWindowWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QQuickWindowWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QQuickWindowWrapper::event(::QEvent * arg__1)
{
    if (m_PyMethodCache[5])
        return this->::QQuickWindow::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QQuickWindow::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickWindow.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QQuickWindowWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickWindow.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QQuickWindowWrapper::exposeEvent(::QExposeEvent * arg__1)
{
    if (m_PyMethodCache[7]) {
        return this->::QQuickWindow::exposeEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "exposeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QQuickWindow::exposeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QEXPOSEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::focusInEvent(::QFocusEvent * arg__1)
{
    if (m_PyMethodCache[8]) {
        return this->::QQuickWindow::focusInEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QQuickWindow::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QObject * QQuickWindowWrapper::focusObject() const
{
    if (m_PyMethodCache[9])
        return this->::QQuickWindow::focusObject();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QQuickWindow::focusObject();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickWindow.focusObject", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QObject >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QObject *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickWindowWrapper::focusOutEvent(::QFocusEvent * arg__1)
{
    if (m_PyMethodCache[10]) {
        return this->::QQuickWindow::focusOutEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QQuickWindow::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSurfaceFormat QQuickWindowWrapper::format() const
{
    if (m_PyMethodCache[11])
        return this->::QWindow::format();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "format";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QWindow::format();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickWindow.format", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSurfaceFormat >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSurfaceFormat cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickWindowWrapper::hideEvent(::QHideEvent * arg__1)
{
    if (m_PyMethodCache[12]) {
        return this->::QQuickWindow::hideEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hideEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QQuickWindow::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHIDEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    if (m_PyMethodCache[13]) {
        return this->::QQuickWindow::keyPressEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QQuickWindow::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::keyReleaseEvent(::QKeyEvent * arg__1)
{
    if (m_PyMethodCache[14]) {
        return this->::QQuickWindow::keyReleaseEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QQuickWindow::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::mouseDoubleClickEvent(::QMouseEvent * arg__1)
{
    if (m_PyMethodCache[16]) {
        return this->::QQuickWindow::mouseDoubleClickEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QQuickWindow::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    if (m_PyMethodCache[17]) {
        return this->::QQuickWindow::mouseMoveEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QQuickWindow::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::mousePressEvent(::QMouseEvent * arg__1)
{
    if (m_PyMethodCache[18]) {
        return this->::QQuickWindow::mousePressEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QQuickWindow::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::mouseReleaseEvent(::QMouseEvent * arg__1)
{
    if (m_PyMethodCache[19]) {
        return this->::QQuickWindow::mouseReleaseEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QQuickWindow::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::moveEvent(::QMoveEvent * arg__1)
{
    if (m_PyMethodCache[20]) {
        return this->::QWindow::moveEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QWindow::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOVEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QQuickWindowWrapper::nativeEvent(const ::QByteArray & eventType, void * message, long * result)
{
    if (m_PyMethodCache[21]) {
        return this->::QWindow::nativeEvent(eventType, message, result);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nativeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QWindow::nativeEvent(eventType, message, result);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &eventType),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), message)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Begin code injection
    // TEMPLATE - return_native_eventfilter_conversion - START
    bool cppResult = false;
    if (PySequence_Check(pyResult) && (PySequence_Size(pyResult) == 2)) {
        Shiboken::AutoDecRef pyItem(PySequence_GetItem(pyResult, 0));
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyItem, &(cppResult));
        if (result) {
            Shiboken::AutoDecRef pyResultItem(PySequence_GetItem(pyResult, 1));
            Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<long>(), pyResultItem, (result));
        }
    }
    // TEMPLATE - return_native_eventfilter_conversion - END

    // End of code injection


    return cppResult;
}

void QQuickWindowWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    if (m_PyMethodCache[22]) {
        return this->::QQuickWindow::resizeEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resizeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QQuickWindow::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::showEvent(::QShowEvent * arg__1)
{
    if (m_PyMethodCache[23]) {
        return this->::QQuickWindow::showEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "showEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QQuickWindow::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSHOWEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSize QQuickWindowWrapper::size() const
{
    if (m_PyMethodCache[24])
        return this->::QWindow::size();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QWindow::size();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickWindow.size", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSurface::SurfaceType QQuickWindowWrapper::surfaceType() const
{
    if (m_PyMethodCache[25])
        return this->::QWindow::surfaceType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QSurface::RasterSurface;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "surfaceType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QWindow::surfaceType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QSurface::RasterSurface;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACE_SURFACETYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickWindow.surfaceType", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSurface::SurfaceType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QSurface::RasterSurface;
    }
    ::QSurface::SurfaceType cppResult{QSurface::RasterSurface};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickWindowWrapper::tabletEvent(::QTabletEvent * arg__1)
{
    if (m_PyMethodCache[26]) {
        return this->::QQuickWindow::tabletEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "tabletEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QQuickWindow::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[27]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QQuickWindowWrapper::touchEvent(::QTouchEvent * arg__1)
{
    if (m_PyMethodCache[28]) {
        return this->::QWindow::touchEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "touchEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QWindow::touchEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickWindowWrapper::wheelEvent(::QWheelEvent * arg__1)
{
    if (m_PyMethodCache[29]) {
        return this->::QQuickWindow::wheelEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QQuickWindow::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QQuickWindowWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QQuickWindow::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QQuickWindowWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QQuickWindow::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QQuickWindowWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QQuickWindowWrapper *>(this));
        return QQuickWindow::qt_metacast(_clname);
}

QQuickWindowWrapper::~QQuickWindowWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQuickWindow_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQuickWindow >()))
        return -1;

    ::QQuickWindowWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QQuickWindow", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QQuickWindow::QQuickWindow(QQuickRenderControl*)
    // 1: QQuickWindow::QQuickWindow(QWindow*)
    if (numArgs == 0) {
        overloadId = 1; // QQuickWindow(QWindow*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QQuickWindow(QWindow*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKRENDERCONTROL_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QQuickWindow(QQuickRenderControl*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindow_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QQuickWindow(QQuickRenderControl * renderControl)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QQuickWindow_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QQuickRenderControl *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QQuickWindow(QQuickRenderControl*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QQuickWindowWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QQuickWindowWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // QQuickWindow(QWindow * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QQuickWindow_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0]))))
                            goto Sbk_QQuickWindow_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWindow *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QQuickWindow(QWindow*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QQuickWindowWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QQuickWindowWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQuickWindow >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QQuickWindow_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QQuickWindow_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QQuickWindow_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QQuickWindowFunc_accessibleRoot(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.accessibleRoot";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // accessibleRoot()const
            QAccessibleInterface * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickWindow *>(cppSelf)->::QQuickWindow::accessibleRoot()
                : const_cast<const ::QQuickWindow *>(cppSelf)->accessibleRoot();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_activeFocusItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.activeFocusItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeFocusItem()const
            QQuickItem * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->activeFocusItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_beginExternalCommands(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.beginExternalCommands";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // beginExternalCommands()
            cppSelf->beginExternalCommands();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickWindowFunc_clearBeforeRendering(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.clearBeforeRendering";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearBeforeRendering()const
            bool cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->clearBeforeRendering();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_color(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.color";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // color()const
            QColor cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->color();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_contentItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.contentItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentItem()const
            QQuickItem * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->contentItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_createTextureFromId(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.createTextureFromId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQuickWindowFunc_createTextureFromId_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QQuickWindowFunc_createTextureFromId_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:createTextureFromId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QQuickWindow::createTextureFromId(uint,QSize,QFlags<QQuickWindow::CreateTextureOption>)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // createTextureFromId(uint,QSize,QFlags<QQuickWindow::CreateTextureOption>)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // createTextureFromId(uint,QSize,QFlags<QQuickWindow::CreateTextureOption>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_createTextureFromId_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[2]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QQuickWindowFunc_createTextureFromId_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QQuickWindowFunc_createTextureFromId_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQuickWindowFunc_createTextureFromId_TypeError;
            }
        }
        uint cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSize cppArg1_local;
        ::QSize *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QFlags<QQuickWindow::CreateTextureOption> cppArg2 = QQuickWindow::CreateTextureOption();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // createTextureFromId(uint,QSize,QFlags<QQuickWindow::CreateTextureOption>)const
            QSGTexture * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->createTextureFromId(cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickWindowFunc_createTextureFromId_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_createTextureFromImage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.createTextureFromImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createTextureFromImage", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickWindow::createTextureFromImage(QImage)const
    // 1: QQuickWindow::createTextureFromImage(QImage,QFlags<QQuickWindow::CreateTextureOption>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createTextureFromImage(QImage)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // createTextureFromImage(QImage,QFlags<QQuickWindow::CreateTextureOption>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_createTextureFromImage_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createTextureFromImage(const QImage & image) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // createTextureFromImage(QImage)const
                QSGTexture * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->createTextureFromImage(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // createTextureFromImage(const QImage & image, QFlags<QQuickWindow::CreateTextureOption> options) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QFlags<QQuickWindow::CreateTextureOption> cppArg1 = QFlags<QQuickWindow::CreateTextureOption>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // createTextureFromImage(QImage,QFlags<QQuickWindow::CreateTextureOption>)const
                QSGTexture * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->createTextureFromImage(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickWindowFunc_createTextureFromImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_createTextureFromNativeObject(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.createTextureFromNativeObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQuickWindowFunc_createTextureFromNativeObject_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QQuickWindowFunc_createTextureFromNativeObject_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:createTextureFromNativeObject", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QQuickWindow::createTextureFromNativeObject(QQuickWindow::NativeObjectType,const void*,int,QSize,QFlags<QQuickWindow::CreateTextureOption>)const
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_NATIVEOBJECTTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // createTextureFromNativeObject(QQuickWindow::NativeObjectType,const void*,int,QSize,QFlags<QQuickWindow::CreateTextureOption>)const
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, (pyArgs[4])))) {
            overloadId = 0; // createTextureFromNativeObject(QQuickWindow::NativeObjectType,const void*,int,QSize,QFlags<QQuickWindow::CreateTextureOption>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_createTextureFromNativeObject_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[4]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QQuickWindowFunc_createTextureFromNativeObject_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, (pyArgs[4]))))
                        goto Sbk_QQuickWindowFunc_createTextureFromNativeObject_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQuickWindowFunc_createTextureFromNativeObject_TypeError;
            }
        }
        ::QQuickWindow::NativeObjectType cppArg0{QQuickWindow::NativeObjectTexture};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QSize cppArg3_local;
        ::QSize *cppArg3 = &cppArg3_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[3]))
            pythonToCpp[3](pyArgs[3], &cppArg3_local);
        else
            pythonToCpp[3](pyArgs[3], &cppArg3);

        ::QFlags<QQuickWindow::CreateTextureOption> cppArg4 = QQuickWindow::CreateTextureOption();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // createTextureFromNativeObject(QQuickWindow::NativeObjectType,const void*,int,QSize,QFlags<QQuickWindow::CreateTextureOption>)const
            QSGTexture * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->createTextureFromNativeObject(cppArg0, cppArg1, cppArg2, *cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickWindowFunc_createTextureFromNativeObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_effectiveDevicePixelRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.effectiveDevicePixelRatio";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // effectiveDevicePixelRatio()const
            qreal cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->effectiveDevicePixelRatio();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_endExternalCommands(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.endExternalCommands";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endExternalCommands()
            cppSelf->endExternalCommands();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickWindowFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickWindowFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_exposeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.exposeEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::exposeEvent(QExposeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QEXPOSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // exposeEvent(QExposeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_exposeEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QExposeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // exposeEvent(QExposeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::exposeEvent(cppArg0)
                : cppSelf->exposeEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_exposeEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.focusInEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_focusInEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusInEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::focusInEvent(cppArg0)
                : cppSelf->focusInEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_focusInEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_focusObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.focusObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focusObject()const
            QObject * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickWindow *>(cppSelf)->::QQuickWindow::focusObject()
                : const_cast<const ::QQuickWindow *>(cppSelf)->focusObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_focusOutEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.focusOutEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::focusOutEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusOutEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_focusOutEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusOutEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::focusOutEvent(cppArg0)
                : cppSelf->focusOutEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_focusOutEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_grabWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.grabWindow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // grabWindow()
            QImage cppResult = cppSelf->grabWindow();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_hasDefaultAlphaBuffer(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.hasDefaultAlphaBuffer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasDefaultAlphaBuffer()
            bool cppResult = ::QQuickWindow::hasDefaultAlphaBuffer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_hideEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.hideEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::hideEvent(QHideEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHIDEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // hideEvent(QHideEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_hideEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHideEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hideEvent(QHideEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::hideEvent(cppArg0)
                : cppSelf->hideEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_hideEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_incubationController(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.incubationController";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // incubationController()const
            QQmlIncubationController * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->incubationController();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATIONCONTROLLER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_isPersistentOpenGLContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.isPersistentOpenGLContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPersistentOpenGLContext()const
            bool cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->isPersistentOpenGLContext();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_isPersistentSceneGraph(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.isPersistentSceneGraph";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPersistentSceneGraph()const
            bool cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->isPersistentSceneGraph();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_isSceneGraphInitialized(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.isSceneGraphInitialized";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSceneGraphInitialized()const
            bool cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->isSceneGraphInitialized();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.keyPressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_keyPressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_keyPressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_keyReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.keyReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::keyReleaseEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // keyReleaseEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_keyReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyReleaseEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::keyReleaseEvent(cppArg0)
                : cppSelf->keyReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_keyReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_mouseDoubleClickEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.mouseDoubleClickEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::mouseDoubleClickEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseDoubleClickEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_mouseDoubleClickEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseDoubleClickEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::mouseDoubleClickEvent(cppArg0)
                : cppSelf->mouseDoubleClickEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_mouseDoubleClickEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_mouseGrabberItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.mouseGrabberItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mouseGrabberItem()const
            QQuickItem * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->mouseGrabberItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_mouseMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.mouseMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::mouseMoveEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseMoveEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_mouseMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseMoveEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::mouseMoveEvent(cppArg0)
                : cppSelf->mouseMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_mouseMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.mousePressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_mousePressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mousePressEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::mousePressEvent(cppArg0)
                : cppSelf->mousePressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_mousePressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.mouseReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_mouseReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseReleaseEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::mouseReleaseEvent(cppArg0)
                : cppSelf->mouseReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_mouseReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_openglContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.openglContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // openglContext()const
            QOpenGLContext * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->openglContext();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_releaseResources(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.releaseResources";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // releaseResources()
            cppSelf->releaseResources();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickWindowFunc_renderTarget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.renderTarget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderTarget()const
            QOpenGLFramebufferObject * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->renderTarget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_renderTargetId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.renderTargetId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderTargetId()const
            uint cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->renderTargetId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_renderTargetSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.renderTargetSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderTargetSize()const
            QSize cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->renderTargetSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_rendererInterface(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.rendererInterface";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rendererInterface()const
            QSGRendererInterface * cppResult = const_cast<const ::QQuickWindow *>(cppSelf)->rendererInterface();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_resetOpenGLState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.resetOpenGLState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetOpenGLState()
            cppSelf->resetOpenGLState();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickWindowFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.resizeEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_resizeEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_resizeEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_sceneGraphBackend(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.sceneGraphBackend";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sceneGraphBackend()
            QString cppResult = ::QQuickWindow::sceneGraphBackend();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_scheduleRenderJob(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.scheduleRenderJob";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "scheduleRenderJob", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickWindow::scheduleRenderJob(QRunnable*,QQuickWindow::RenderStage)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRUNNABLE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // scheduleRenderJob(QRunnable*,QQuickWindow::RenderStage)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_scheduleRenderJob_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRunnable *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QQuickWindow::RenderStage cppArg1{QQuickWindow::BeforeSynchronizingStage};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // scheduleRenderJob(QRunnable*,QQuickWindow::RenderStage)
            cppSelf->scheduleRenderJob(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_scheduleRenderJob_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_sendEvent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.sendEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sendEvent", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickWindow::sendEvent(QQuickItem*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // sendEvent(QQuickItem*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_sendEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // sendEvent(QQuickItem*,QEvent*)
            bool cppResult = cppSelf->sendEvent(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickWindowFunc_sendEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_setClearBeforeRendering(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.setClearBeforeRendering";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickWindow::setClearBeforeRendering(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setClearBeforeRendering(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_setClearBeforeRendering_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setClearBeforeRendering(bool)
            cppSelf->setClearBeforeRendering(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_setClearBeforeRendering_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_setColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.setColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickWindow::setColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_setColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setColor(QColor)
            cppSelf->setColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_setColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_setDefaultAlphaBuffer(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.setDefaultAlphaBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QQuickWindow::setDefaultAlphaBuffer(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDefaultAlphaBuffer(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_setDefaultAlphaBuffer_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultAlphaBuffer(bool)
            ::QQuickWindow::setDefaultAlphaBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_setDefaultAlphaBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_setPersistentOpenGLContext(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.setPersistentOpenGLContext";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickWindow::setPersistentOpenGLContext(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPersistentOpenGLContext(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_setPersistentOpenGLContext_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPersistentOpenGLContext(bool)
            cppSelf->setPersistentOpenGLContext(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_setPersistentOpenGLContext_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_setPersistentSceneGraph(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.setPersistentSceneGraph";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickWindow::setPersistentSceneGraph(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPersistentSceneGraph(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_setPersistentSceneGraph_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPersistentSceneGraph(bool)
            cppSelf->setPersistentSceneGraph(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_setPersistentSceneGraph_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_setRenderTarget(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.setRenderTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRenderTarget", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickWindow::setRenderTarget(QOpenGLFramebufferObject*)
    // 1: QQuickWindow::setRenderTarget(uint,QSize)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
        overloadId = 1; // setRenderTarget(uint,QSize)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLFRAMEBUFFEROBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setRenderTarget(QOpenGLFramebufferObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_setRenderTarget_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setRenderTarget(QOpenGLFramebufferObject * fbo)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QOpenGLFramebufferObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setRenderTarget(QOpenGLFramebufferObject*)
                cppSelf->setRenderTarget(cppArg0);
            }
            break;
        }
        case 1: // setRenderTarget(uint fboId, const QSize & size)
        {
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSize cppArg1_local;
            ::QSize *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setRenderTarget(uint,QSize)
                cppSelf->setRenderTarget(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_setRenderTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_setSceneGraphBackend(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.setSceneGraphBackend";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QQuickWindow::setSceneGraphBackend(QSGRendererInterface::GraphicsApi)
    // 1: static QQuickWindow::setSceneGraphBackend(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // setSceneGraphBackend(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSceneGraphBackend(QSGRendererInterface::GraphicsApi)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_setSceneGraphBackend_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setSceneGraphBackend(QSGRendererInterface::GraphicsApi api)
        {
            ::QSGRendererInterface::GraphicsApi cppArg0{QSGRendererInterface::Unknown};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setSceneGraphBackend(QSGRendererInterface::GraphicsApi)
                ::QQuickWindow::setSceneGraphBackend(cppArg0);
            }
            break;
        }
        case 1: // setSceneGraphBackend(const QString & backend)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setSceneGraphBackend(QString)
                ::QQuickWindow::setSceneGraphBackend(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_setSceneGraphBackend_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_setTextRenderType(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.setTextRenderType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QQuickWindow::setTextRenderType(QQuickWindow::TextRenderType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTextRenderType(QQuickWindow::TextRenderType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_setTextRenderType_TypeError;

    // Call function/method
    {
        ::QQuickWindow::TextRenderType cppArg0{QQuickWindow::QtTextRendering};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextRenderType(QQuickWindow::TextRenderType)
            ::QQuickWindow::setTextRenderType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_setTextRenderType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_showEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.showEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::showEvent(QShowEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSHOWEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // showEvent(QShowEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_showEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QShowEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // showEvent(QShowEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::showEvent(cppArg0)
                : cppSelf->showEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_showEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_tabletEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.tabletEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::tabletEvent(QTabletEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // tabletEvent(QTabletEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_tabletEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTabletEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // tabletEvent(QTabletEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::tabletEvent(cppArg0)
                : cppSelf->tabletEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_tabletEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickWindowFunc_textRenderType(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.textRenderType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textRenderType()
            QQuickWindow::TextRenderType cppResult = ::QQuickWindow::textRenderType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickWindowFunc_update(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.update";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // update()
            cppSelf->update();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickWindowFunc_wheelEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickWindow.wheelEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWindow::wheelEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // wheelEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickWindowFunc_wheelEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // wheelEvent(QWheelEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickWindow::wheelEvent(cppArg0)
                : cppSelf->wheelEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickWindowFunc_wheelEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQuickWindow_PropertyStrings[] = {
    "activeFocusItem:",
    "color::",
    "contentItem:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQuickWindow_methods[] = {
    {"accessibleRoot", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_accessibleRoot), METH_NOARGS},
    {"activeFocusItem", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_activeFocusItem), METH_NOARGS},
    {"beginExternalCommands", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_beginExternalCommands), METH_NOARGS},
    {"clearBeforeRendering", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_clearBeforeRendering), METH_NOARGS},
    {"color", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_color), METH_NOARGS},
    {"contentItem", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_contentItem), METH_NOARGS},
    {"createTextureFromId", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_createTextureFromId), METH_VARARGS|METH_KEYWORDS},
    {"createTextureFromImage", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_createTextureFromImage), METH_VARARGS},
    {"createTextureFromNativeObject", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_createTextureFromNativeObject), METH_VARARGS|METH_KEYWORDS},
    {"effectiveDevicePixelRatio", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_effectiveDevicePixelRatio), METH_NOARGS},
    {"endExternalCommands", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_endExternalCommands), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_event), METH_O},
    {"exposeEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_exposeEvent), METH_O},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_focusInEvent), METH_O},
    {"focusObject", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_focusObject), METH_NOARGS},
    {"focusOutEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_focusOutEvent), METH_O},
    {"grabWindow", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_grabWindow), METH_NOARGS},
    {"hasDefaultAlphaBuffer", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_hasDefaultAlphaBuffer), METH_NOARGS|METH_STATIC},
    {"hideEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_hideEvent), METH_O},
    {"incubationController", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_incubationController), METH_NOARGS},
    {"isPersistentOpenGLContext", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_isPersistentOpenGLContext), METH_NOARGS},
    {"isPersistentSceneGraph", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_isPersistentSceneGraph), METH_NOARGS},
    {"isSceneGraphInitialized", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_isSceneGraphInitialized), METH_NOARGS},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_keyPressEvent), METH_O},
    {"keyReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_keyReleaseEvent), METH_O},
    {"mouseDoubleClickEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_mouseDoubleClickEvent), METH_O},
    {"mouseGrabberItem", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_mouseGrabberItem), METH_NOARGS},
    {"mouseMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_mouseMoveEvent), METH_O},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_mousePressEvent), METH_O},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_mouseReleaseEvent), METH_O},
    {"openglContext", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_openglContext), METH_NOARGS},
    {"releaseResources", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_releaseResources), METH_NOARGS},
    {"renderTarget", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_renderTarget), METH_NOARGS},
    {"renderTargetId", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_renderTargetId), METH_NOARGS},
    {"renderTargetSize", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_renderTargetSize), METH_NOARGS},
    {"rendererInterface", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_rendererInterface), METH_NOARGS},
    {"resetOpenGLState", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_resetOpenGLState), METH_NOARGS},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_resizeEvent), METH_O},
    {"sceneGraphBackend", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_sceneGraphBackend), METH_NOARGS|METH_STATIC},
    {"scheduleRenderJob", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_scheduleRenderJob), METH_VARARGS},
    {"sendEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_sendEvent), METH_VARARGS},
    {"setClearBeforeRendering", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_setClearBeforeRendering), METH_O},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_setColor), METH_O},
    {"setDefaultAlphaBuffer", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_setDefaultAlphaBuffer), METH_O|METH_STATIC},
    {"setPersistentOpenGLContext", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_setPersistentOpenGLContext), METH_O},
    {"setPersistentSceneGraph", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_setPersistentSceneGraph), METH_O},
    {"setRenderTarget", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_setRenderTarget), METH_VARARGS},
    {"setSceneGraphBackend", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_setSceneGraphBackend), METH_O|METH_STATIC},
    {"setTextRenderType", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_setTextRenderType), METH_O|METH_STATIC},
    {"showEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_showEvent), METH_O},
    {"tabletEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_tabletEvent), METH_O},
    {"textRenderType", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_textRenderType), METH_NOARGS|METH_STATIC},
    {"update", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_update), METH_NOARGS},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickWindowFunc_wheelEvent), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQuickWindow_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQuickWindowWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QQuickWindow_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQuickWindow_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QQuickWindow__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickWindow *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

static void * Sbk_QQuickWindowSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QQuickWindow *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]))
        return static_cast< ::QWindow *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACE_IDX]))
        return static_cast< ::QSurface *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQuickWindow_Type = nullptr;
static SbkObjectType *Sbk_QQuickWindow_TypeF(void)
{
    return _Sbk_QQuickWindow_Type;
}

static PyType_Slot Sbk_QQuickWindow_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QQuickWindow__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQuickWindow_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQuickWindow_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQuickWindow_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQuickWindow_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQuickWindow_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQuickWindow_spec = {
    "2:PySide2.QtQuick.QQuickWindow",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQuickWindow_slots
};

} //extern "C"

static void *Sbk_QQuickWindow_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QQuickWindow *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QSurface >()))
        return dynamic_cast< ::QQuickWindow *>(reinterpret_cast< ::QSurface *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QQuickWindow::CreateTextureOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQuickWindow::CreateTextureOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQuickWindow::CreateTextureOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQuickWindow::CreateTextureOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQuickWindow::CreateTextureOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QQuickWindow::CreateTextureOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQuickWindow::CreateTextureOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQuickWindow::CreateTextureOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQuickWindow::CreateTextureOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQuickWindow::CreateTextureOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QQuickWindow::CreateTextureOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQuickWindow::CreateTextureOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQuickWindow::CreateTextureOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQuickWindow::CreateTextureOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQuickWindow::CreateTextureOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QQuickWindow::CreateTextureOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, self, &cppSelf);
    ::QQuickWindow::CreateTextureOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QQuickWindow_CreateTextureOption_PythonToCpp_QQuickWindow_CreateTextureOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickWindow::CreateTextureOption *>(cppOut) =
        static_cast<::QQuickWindow::CreateTextureOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickWindow_CreateTextureOption_PythonToCpp_QQuickWindow_CreateTextureOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX]))
        return QQuickWindow_CreateTextureOption_PythonToCpp_QQuickWindow_CreateTextureOption;
    return {};
}
static PyObject *QQuickWindow_CreateTextureOption_CppToPython_QQuickWindow_CreateTextureOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickWindow::CreateTextureOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX], castCppIn);

}

static void QFlags_QQuickWindow_CreateTextureOption__PythonToCpp_QFlags_QQuickWindow_CreateTextureOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QQuickWindow::CreateTextureOption> *>(cppOut) =
        ::QFlags<QQuickWindow::CreateTextureOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QQuickWindow_CreateTextureOption__PythonToCpp_QFlags_QQuickWindow_CreateTextureOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX]))
        return QFlags_QQuickWindow_CreateTextureOption__PythonToCpp_QFlags_QQuickWindow_CreateTextureOption_;
    return {};
}
static PyObject *QFlags_QQuickWindow_CreateTextureOption__CppToPython_QFlags_QQuickWindow_CreateTextureOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QQuickWindow::CreateTextureOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX]));

}

static void QQuickWindow_CreateTextureOption_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QQuickWindow::CreateTextureOption> *>(cppOut) =
        ::QFlags<QQuickWindow::CreateTextureOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QQuickWindow_CreateTextureOption_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX]))
        return QQuickWindow_CreateTextureOption_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QQuickWindow::CreateTextureOption> *>(cppOut) =
        ::QFlags<QQuickWindow::CreateTextureOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX]))
        return number_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption_;
    return {};
}
static void QQuickWindow_RenderStage_PythonToCpp_QQuickWindow_RenderStage(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickWindow::RenderStage *>(cppOut) =
        static_cast<::QQuickWindow::RenderStage>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickWindow_RenderStage_PythonToCpp_QQuickWindow_RenderStage_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX]))
        return QQuickWindow_RenderStage_PythonToCpp_QQuickWindow_RenderStage;
    return {};
}
static PyObject *QQuickWindow_RenderStage_CppToPython_QQuickWindow_RenderStage(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickWindow::RenderStage *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX], castCppIn);

}

static void QQuickWindow_SceneGraphError_PythonToCpp_QQuickWindow_SceneGraphError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickWindow::SceneGraphError *>(cppOut) =
        static_cast<::QQuickWindow::SceneGraphError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickWindow_SceneGraphError_PythonToCpp_QQuickWindow_SceneGraphError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_SCENEGRAPHERROR_IDX]))
        return QQuickWindow_SceneGraphError_PythonToCpp_QQuickWindow_SceneGraphError;
    return {};
}
static PyObject *QQuickWindow_SceneGraphError_CppToPython_QQuickWindow_SceneGraphError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickWindow::SceneGraphError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_SCENEGRAPHERROR_IDX], castCppIn);

}

static void QQuickWindow_TextRenderType_PythonToCpp_QQuickWindow_TextRenderType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickWindow::TextRenderType *>(cppOut) =
        static_cast<::QQuickWindow::TextRenderType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickWindow_TextRenderType_PythonToCpp_QQuickWindow_TextRenderType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX]))
        return QQuickWindow_TextRenderType_PythonToCpp_QQuickWindow_TextRenderType;
    return {};
}
static PyObject *QQuickWindow_TextRenderType_CppToPython_QQuickWindow_TextRenderType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickWindow::TextRenderType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX], castCppIn);

}

static void QQuickWindow_NativeObjectType_PythonToCpp_QQuickWindow_NativeObjectType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickWindow::NativeObjectType *>(cppOut) =
        static_cast<::QQuickWindow::NativeObjectType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickWindow_NativeObjectType_PythonToCpp_QQuickWindow_NativeObjectType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_NATIVEOBJECTTYPE_IDX]))
        return QQuickWindow_NativeObjectType_PythonToCpp_QQuickWindow_NativeObjectType;
    return {};
}
static PyObject *QQuickWindow_NativeObjectType_CppToPython_QQuickWindow_NativeObjectType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickWindow::NativeObjectType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_NATIVEOBJECTTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQuickWindow_PythonToCpp_QQuickWindow_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQuickWindow_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQuickWindow_PythonToCpp_QQuickWindow_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQuickWindow_TypeF())))
        return QQuickWindow_PythonToCpp_QQuickWindow_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQuickWindow_PTR_CppToPython_QQuickWindow(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QQuickWindow *>(const_cast<void *>(cppIn)), Sbk_QQuickWindow_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQuickWindow_SignatureStrings[] = {
    "1:PySide2.QtQuick.QQuickWindow(self,renderControl:PySide2.QtQuick.QQuickRenderControl)",
    "0:PySide2.QtQuick.QQuickWindow(self,parent:PySide2.QtGui.QWindow=nullptr)",
    "PySide2.QtQuick.QQuickWindow.accessibleRoot(self)->PySide2.QtGui.QAccessibleInterface",
    "PySide2.QtQuick.QQuickWindow.activeFocusItem(self)->PySide2.QtQuick.QQuickItem",
    "PySide2.QtQuick.QQuickWindow.beginExternalCommands(self)",
    "PySide2.QtQuick.QQuickWindow.clearBeforeRendering(self)->bool",
    "PySide2.QtQuick.QQuickWindow.color(self)->PySide2.QtGui.QColor",
    "PySide2.QtQuick.QQuickWindow.contentItem(self)->PySide2.QtQuick.QQuickItem",
    "PySide2.QtQuick.QQuickWindow.createTextureFromId(self,id:uint,size:PySide2.QtCore.QSize,options:PySide2.QtQuick.QQuickWindow.CreateTextureOptions=QQuickWindow.CreateTextureOption())->PySide2.QtQuick.QSGTexture",
    "1:PySide2.QtQuick.QQuickWindow.createTextureFromImage(self,image:PySide2.QtGui.QImage)->PySide2.QtQuick.QSGTexture",
    "0:PySide2.QtQuick.QQuickWindow.createTextureFromImage(self,image:PySide2.QtGui.QImage,options:PySide2.QtQuick.QQuickWindow.CreateTextureOptions)->PySide2.QtQuick.QSGTexture",
    "PySide2.QtQuick.QQuickWindow.createTextureFromNativeObject(self,type:PySide2.QtQuick.QQuickWindow.NativeObjectType,nativeObjectPtr:void,nativeLayout:int,size:PySide2.QtCore.QSize,options:PySide2.QtQuick.QQuickWindow.CreateTextureOptions=QQuickWindow.CreateTextureOption())->PySide2.QtQuick.QSGTexture",
    "PySide2.QtQuick.QQuickWindow.effectiveDevicePixelRatio(self)->qreal",
    "PySide2.QtQuick.QQuickWindow.endExternalCommands(self)",
    "PySide2.QtQuick.QQuickWindow.event(self,arg__1:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtQuick.QQuickWindow.exposeEvent(self,arg__1:PySide2.QtGui.QExposeEvent)",
    "PySide2.QtQuick.QQuickWindow.focusInEvent(self,arg__1:PySide2.QtGui.QFocusEvent)",
    "PySide2.QtQuick.QQuickWindow.focusObject(self)->PySide2.QtCore.QObject",
    "PySide2.QtQuick.QQuickWindow.focusOutEvent(self,arg__1:PySide2.QtGui.QFocusEvent)",
    "PySide2.QtQuick.QQuickWindow.grabWindow(self)->PySide2.QtGui.QImage",
    "PySide2.QtQuick.QQuickWindow.hasDefaultAlphaBuffer()->bool",
    "PySide2.QtQuick.QQuickWindow.hideEvent(self,arg__1:PySide2.QtGui.QHideEvent)",
    "PySide2.QtQuick.QQuickWindow.incubationController(self)->PySide2.QtQml.QQmlIncubationController",
    "PySide2.QtQuick.QQuickWindow.isPersistentOpenGLContext(self)->bool",
    "PySide2.QtQuick.QQuickWindow.isPersistentSceneGraph(self)->bool",
    "PySide2.QtQuick.QQuickWindow.isSceneGraphInitialized(self)->bool",
    "PySide2.QtQuick.QQuickWindow.keyPressEvent(self,arg__1:PySide2.QtGui.QKeyEvent)",
    "PySide2.QtQuick.QQuickWindow.keyReleaseEvent(self,arg__1:PySide2.QtGui.QKeyEvent)",
    "PySide2.QtQuick.QQuickWindow.mouseDoubleClickEvent(self,arg__1:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtQuick.QQuickWindow.mouseGrabberItem(self)->PySide2.QtQuick.QQuickItem",
    "PySide2.QtQuick.QQuickWindow.mouseMoveEvent(self,arg__1:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtQuick.QQuickWindow.mousePressEvent(self,arg__1:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtQuick.QQuickWindow.mouseReleaseEvent(self,arg__1:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtQuick.QQuickWindow.openglContext(self)->PySide2.QtGui.QOpenGLContext",
    "PySide2.QtQuick.QQuickWindow.releaseResources(self)",
    "PySide2.QtQuick.QQuickWindow.renderTarget(self)->PySide2.QtGui.QOpenGLFramebufferObject",
    "PySide2.QtQuick.QQuickWindow.renderTargetId(self)->uint",
    "PySide2.QtQuick.QQuickWindow.renderTargetSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtQuick.QQuickWindow.rendererInterface(self)->PySide2.QtQuick.QSGRendererInterface",
    "PySide2.QtQuick.QQuickWindow.resetOpenGLState(self)",
    "PySide2.QtQuick.QQuickWindow.resizeEvent(self,arg__1:PySide2.QtGui.QResizeEvent)",
    "PySide2.QtQuick.QQuickWindow.sceneGraphBackend()->QString",
    "PySide2.QtQuick.QQuickWindow.scheduleRenderJob(self,job:PySide2.QtCore.QRunnable,schedule:PySide2.QtQuick.QQuickWindow.RenderStage)",
    "PySide2.QtQuick.QQuickWindow.sendEvent(self,arg__1:PySide2.QtQuick.QQuickItem,arg__2:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtQuick.QQuickWindow.setClearBeforeRendering(self,enabled:bool)",
    "PySide2.QtQuick.QQuickWindow.setColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtQuick.QQuickWindow.setDefaultAlphaBuffer(useAlpha:bool)",
    "PySide2.QtQuick.QQuickWindow.setPersistentOpenGLContext(self,persistent:bool)",
    "PySide2.QtQuick.QQuickWindow.setPersistentSceneGraph(self,persistent:bool)",
    "1:PySide2.QtQuick.QQuickWindow.setRenderTarget(self,fbo:PySide2.QtGui.QOpenGLFramebufferObject)",
    "0:PySide2.QtQuick.QQuickWindow.setRenderTarget(self,fboId:uint,size:PySide2.QtCore.QSize)",
    "1:PySide2.QtQuick.QQuickWindow.setSceneGraphBackend(api:PySide2.QtQuick.QSGRendererInterface.GraphicsApi)",
    "0:PySide2.QtQuick.QQuickWindow.setSceneGraphBackend(backend:QString)",
    "PySide2.QtQuick.QQuickWindow.setTextRenderType(renderType:PySide2.QtQuick.QQuickWindow.TextRenderType)",
    "PySide2.QtQuick.QQuickWindow.showEvent(self,arg__1:PySide2.QtGui.QShowEvent)",
    "PySide2.QtQuick.QQuickWindow.tabletEvent(self,arg__1:PySide2.QtGui.QTabletEvent)",
    "PySide2.QtQuick.QQuickWindow.textRenderType()->PySide2.QtQuick.QQuickWindow.TextRenderType",
    "PySide2.QtQuick.QQuickWindow.update(self)",
    "PySide2.QtQuick.QQuickWindow.wheelEvent(self,arg__1:PySide2.QtGui.QWheelEvent)",
    nullptr}; // Sentinel

void init_QQuickWindow(PyObject *module)
{
    _Sbk_QQuickWindow_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQuickWindow",
        "QQuickWindow*",
        &Sbk_QQuickWindow_spec,
        &Shiboken::callCppDestructor< ::QQuickWindow >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQuickWindow_Type);
    InitSignatureStrings(pyType, QQuickWindow_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQuickWindow_Type), Sbk_QQuickWindow_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQuickWindow_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQuickWindow_TypeF(),
        QQuickWindow_PythonToCpp_QQuickWindow_PTR,
        is_QQuickWindow_PythonToCpp_QQuickWindow_PTR_Convertible,
        QQuickWindow_PTR_CppToPython_QQuickWindow);

    Shiboken::Conversions::registerConverterName(converter, "QQuickWindow");
    Shiboken::Conversions::registerConverterName(converter, "QQuickWindow*");
    Shiboken::Conversions::registerConverterName(converter, "QQuickWindow&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQuickWindow).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQuickWindowWrapper).name());


    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QQuickWindow_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QQuickWindow_TypeF(), &Sbk_QQuickWindowSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QQuickWindow_TypeF(), &Sbk_QQuickWindow_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'CreateTextureOption'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QQuickWindow.CreateTextureOptions", SbkPySide2_QtQuick_QQuickWindow_CreateTextureOption_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickWindow_TypeF(),
        "CreateTextureOption",
        "2:PySide2.QtQuick.QQuickWindow.CreateTextureOption",
        "QQuickWindow::CreateTextureOption",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX],
        Sbk_QQuickWindow_TypeF(), "TextureHasAlphaChannel", (long) QQuickWindow::CreateTextureOption::TextureHasAlphaChannel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX],
        Sbk_QQuickWindow_TypeF(), "TextureHasMipmaps", (long) QQuickWindow::CreateTextureOption::TextureHasMipmaps))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX],
        Sbk_QQuickWindow_TypeF(), "TextureOwnsGLTexture", (long) QQuickWindow::CreateTextureOption::TextureOwnsGLTexture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX],
        Sbk_QQuickWindow_TypeF(), "TextureCanUseAtlas", (long) QQuickWindow::CreateTextureOption::TextureCanUseAtlas))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX],
        Sbk_QQuickWindow_TypeF(), "TextureIsOpaque", (long) QQuickWindow::CreateTextureOption::TextureIsOpaque))
        return;
    // Register converter for enum 'QQuickWindow::CreateTextureOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX],
            QQuickWindow_CreateTextureOption_CppToPython_QQuickWindow_CreateTextureOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickWindow_CreateTextureOption_PythonToCpp_QQuickWindow_CreateTextureOption,
            is_QQuickWindow_CreateTextureOption_PythonToCpp_QQuickWindow_CreateTextureOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_CREATETEXTUREOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickWindow::CreateTextureOption");
        Shiboken::Conversions::registerConverterName(converter, "CreateTextureOption");
    }
    // Register converter for flag 'QFlags<QQuickWindow::CreateTextureOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX],
            QFlags_QQuickWindow_CreateTextureOption__CppToPython_QFlags_QQuickWindow_CreateTextureOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickWindow_CreateTextureOption_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption_,
            is_QQuickWindow_CreateTextureOption_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QQuickWindow_CreateTextureOption__PythonToCpp_QFlags_QQuickWindow_CreateTextureOption_,
            is_QFlags_QQuickWindow_CreateTextureOption__PythonToCpp_QFlags_QQuickWindow_CreateTextureOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption_,
            is_number_PythonToCpp_QFlags_QQuickWindow_CreateTextureOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKWINDOW_CREATETEXTUREOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickWindow::CreateTextureOptions");
        Shiboken::Conversions::registerConverterName(converter, "CreateTextureOptions");
    }
    // End of 'CreateTextureOption' enum/flags.

    // Initialization of enum 'RenderStage'.
    SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickWindow_TypeF(),
        "RenderStage",
        "2:PySide2.QtQuick.QQuickWindow.RenderStage",
        "QQuickWindow::RenderStage");
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX],
        Sbk_QQuickWindow_TypeF(), "BeforeSynchronizingStage", (long) QQuickWindow::RenderStage::BeforeSynchronizingStage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX],
        Sbk_QQuickWindow_TypeF(), "AfterSynchronizingStage", (long) QQuickWindow::RenderStage::AfterSynchronizingStage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX],
        Sbk_QQuickWindow_TypeF(), "BeforeRenderingStage", (long) QQuickWindow::RenderStage::BeforeRenderingStage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX],
        Sbk_QQuickWindow_TypeF(), "AfterRenderingStage", (long) QQuickWindow::RenderStage::AfterRenderingStage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX],
        Sbk_QQuickWindow_TypeF(), "AfterSwapStage", (long) QQuickWindow::RenderStage::AfterSwapStage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX],
        Sbk_QQuickWindow_TypeF(), "NoStage", (long) QQuickWindow::RenderStage::NoStage))
        return;
    // Register converter for enum 'QQuickWindow::RenderStage'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX],
            QQuickWindow_RenderStage_CppToPython_QQuickWindow_RenderStage);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickWindow_RenderStage_PythonToCpp_QQuickWindow_RenderStage,
            is_QQuickWindow_RenderStage_PythonToCpp_QQuickWindow_RenderStage_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_RENDERSTAGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickWindow::RenderStage");
        Shiboken::Conversions::registerConverterName(converter, "RenderStage");
    }
    // End of 'RenderStage' enum.

    // Initialization of enum 'SceneGraphError'.
    SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_SCENEGRAPHERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickWindow_TypeF(),
        "SceneGraphError",
        "2:PySide2.QtQuick.QQuickWindow.SceneGraphError",
        "QQuickWindow::SceneGraphError");
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_SCENEGRAPHERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_SCENEGRAPHERROR_IDX],
        Sbk_QQuickWindow_TypeF(), "ContextNotAvailable", (long) QQuickWindow::SceneGraphError::ContextNotAvailable))
        return;
    // Register converter for enum 'QQuickWindow::SceneGraphError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_SCENEGRAPHERROR_IDX],
            QQuickWindow_SceneGraphError_CppToPython_QQuickWindow_SceneGraphError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickWindow_SceneGraphError_PythonToCpp_QQuickWindow_SceneGraphError,
            is_QQuickWindow_SceneGraphError_PythonToCpp_QQuickWindow_SceneGraphError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_SCENEGRAPHERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickWindow::SceneGraphError");
        Shiboken::Conversions::registerConverterName(converter, "SceneGraphError");
    }
    // End of 'SceneGraphError' enum.

    // Initialization of enum 'TextRenderType'.
    SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickWindow_TypeF(),
        "TextRenderType",
        "2:PySide2.QtQuick.QQuickWindow.TextRenderType",
        "QQuickWindow::TextRenderType");
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX],
        Sbk_QQuickWindow_TypeF(), "QtTextRendering", (long) QQuickWindow::TextRenderType::QtTextRendering))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX],
        Sbk_QQuickWindow_TypeF(), "NativeTextRendering", (long) QQuickWindow::TextRenderType::NativeTextRendering))
        return;
    // Register converter for enum 'QQuickWindow::TextRenderType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX],
            QQuickWindow_TextRenderType_CppToPython_QQuickWindow_TextRenderType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickWindow_TextRenderType_PythonToCpp_QQuickWindow_TextRenderType,
            is_QQuickWindow_TextRenderType_PythonToCpp_QQuickWindow_TextRenderType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_TEXTRENDERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickWindow::TextRenderType");
        Shiboken::Conversions::registerConverterName(converter, "TextRenderType");
    }
    // End of 'TextRenderType' enum.

    // Initialization of enum 'NativeObjectType'.
    SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_NATIVEOBJECTTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickWindow_TypeF(),
        "NativeObjectType",
        "2:PySide2.QtQuick.QQuickWindow.NativeObjectType",
        "QQuickWindow::NativeObjectType");
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_NATIVEOBJECTTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_NATIVEOBJECTTYPE_IDX],
        Sbk_QQuickWindow_TypeF(), "NativeObjectTexture", (long) QQuickWindow::NativeObjectType::NativeObjectTexture))
        return;
    // Register converter for enum 'QQuickWindow::NativeObjectType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_NATIVEOBJECTTYPE_IDX],
            QQuickWindow_NativeObjectType_CppToPython_QQuickWindow_NativeObjectType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickWindow_NativeObjectType_PythonToCpp_QQuickWindow_NativeObjectType,
            is_QQuickWindow_NativeObjectType_PythonToCpp_QQuickWindow_NativeObjectType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_NATIVEOBJECTTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickWindow::NativeObjectType");
        Shiboken::Conversions::registerConverterName(converter, "NativeObjectType");
    }
    // End of 'NativeObjectType' enum.

    PySide::Signal::registerSignals(Sbk_QQuickWindow_TypeF(), &::QQuickWindow::staticMetaObject);
    qRegisterMetaType< ::QQuickWindow::CreateTextureOption >("QQuickWindow::CreateTextureOption");
    qRegisterMetaType< ::QQuickWindow::CreateTextureOptions >("QQuickWindow::CreateTextureOptions");
    qRegisterMetaType< ::QQuickWindow::RenderStage >("QQuickWindow::RenderStage");
    qRegisterMetaType< ::QQuickWindow::SceneGraphError >("QQuickWindow::SceneGraphError");
    qRegisterMetaType< ::QQuickWindow::TextRenderType >("QQuickWindow::TextRenderType");
    qRegisterMetaType< ::QQuickWindow::NativeObjectType >("QQuickWindow::NativeObjectType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QQuickWindow_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QQuickWindow_TypeF(), &::QQuickWindow::staticMetaObject, sizeof(QQuickWindowWrapper));
}
