/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsggeometry_coloredpoint2d_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGGeometry_ColoredPoint2D_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGGeometry::ColoredPoint2D >()))
        return -1;

    ::QSGGeometry::ColoredPoint2D *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.ColoredPoint2D.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "ColoredPoint2D", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: ColoredPoint2D::ColoredPoint2D()
    // 1: ColoredPoint2D::ColoredPoint2D(QSGGeometry::ColoredPoint2D)
    if (numArgs == 0) {
        overloadId = 0; // ColoredPoint2D()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX]), (pyArgs[0])))) {
        overloadId = 1; // ColoredPoint2D(QSGGeometry::ColoredPoint2D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometry_ColoredPoint2D_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // ColoredPoint2D()
        {

            if (!PyErr_Occurred()) {
                // ColoredPoint2D()
                cptr = new ::QSGGeometry::ColoredPoint2D();
            }
            break;
        }
        case 1: // ColoredPoint2D(const QSGGeometry::ColoredPoint2D & ColoredPoint2D)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSGGeometry::ColoredPoint2D cppArg0_local;
            ::QSGGeometry::ColoredPoint2D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // ColoredPoint2D(QSGGeometry::ColoredPoint2D)
                cptr = new ::QSGGeometry::ColoredPoint2D(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGGeometry::ColoredPoint2D >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSGGeometry_ColoredPoint2D_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSGGeometry_ColoredPoint2D_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSGGeometry_ColoredPoint2DFunc_set(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.ColoredPoint2D.set";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "set", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: ColoredPoint2D::set(float,float,uchar,uchar,uchar,uchar)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[3])))
        && SbkChar_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[4])))
        && SbkChar_Check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[5])))) {
        overloadId = 0; // set(float,float,uchar,uchar,uchar,uchar)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometry_ColoredPoint2DFunc_set_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        uchar cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        uchar cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        uchar cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        uchar cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // set(float,float,uchar,uchar,uchar,uchar)
            cppSelf->set(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometry_ColoredPoint2DFunc_set_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometry_ColoredPoint2D___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSGGeometry_ColoredPoint2D_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGGeometry_ColoredPoint2D_methods[] = {
    {"set", reinterpret_cast<PyCFunction>(Sbk_QSGGeometry_ColoredPoint2DFunc_set), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSGGeometry_ColoredPoint2D___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QSGGeometry_ColoredPoint2D_get_x(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppSelf->x);
    return pyOut;
}
static int Sbk_QSGGeometry_ColoredPoint2D_set_x(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'x' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'x', 'float' or convertible type expected");
        return -1;
    }

    float& cppOut_ptr = cppSelf->x;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QSGGeometry_ColoredPoint2D_get_y(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppSelf->y);
    return pyOut;
}
static int Sbk_QSGGeometry_ColoredPoint2D_set_y(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'y' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'y', 'float' or convertible type expected");
        return -1;
    }

    float& cppOut_ptr = cppSelf->y;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QSGGeometry_ColoredPoint2D_get_r(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    unsigned char cppOut_local = cppSelf->r;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_ColoredPoint2D_set_r(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'r' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!SbkChar_Check(pyIn) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'r', 'unsigned char' or convertible type expected");
        return -1;
    }

    unsigned char cppOut_local = cppSelf->r;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->r = cppOut_local;

    return 0;
}

static PyObject *Sbk_QSGGeometry_ColoredPoint2D_get_g(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    unsigned char cppOut_local = cppSelf->g;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_ColoredPoint2D_set_g(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'g' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!SbkChar_Check(pyIn) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'g', 'unsigned char' or convertible type expected");
        return -1;
    }

    unsigned char cppOut_local = cppSelf->g;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->g = cppOut_local;

    return 0;
}

static PyObject *Sbk_QSGGeometry_ColoredPoint2D_get_b(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    unsigned char cppOut_local = cppSelf->b;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_ColoredPoint2D_set_b(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'b' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!SbkChar_Check(pyIn) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'b', 'unsigned char' or convertible type expected");
        return -1;
    }

    unsigned char cppOut_local = cppSelf->b;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->b = cppOut_local;

    return 0;
}

static PyObject *Sbk_QSGGeometry_ColoredPoint2D_get_a(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    unsigned char cppOut_local = cppSelf->a;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_ColoredPoint2D_set_a(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'a' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!SbkChar_Check(pyIn) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'a', 'unsigned char' or convertible type expected");
        return -1;
    }

    unsigned char cppOut_local = cppSelf->a;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->a = cppOut_local;

    return 0;
}

// Getters and Setters for ColoredPoint2D
static PyGetSetDef Sbk_QSGGeometry_ColoredPoint2D_getsetlist[] = {
    {const_cast<char *>("x"), Sbk_QSGGeometry_ColoredPoint2D_get_x, Sbk_QSGGeometry_ColoredPoint2D_set_x},
    {const_cast<char *>("y"), Sbk_QSGGeometry_ColoredPoint2D_get_y, Sbk_QSGGeometry_ColoredPoint2D_set_y},
    {const_cast<char *>("r"), Sbk_QSGGeometry_ColoredPoint2D_get_r, Sbk_QSGGeometry_ColoredPoint2D_set_r},
    {const_cast<char *>("g"), Sbk_QSGGeometry_ColoredPoint2D_get_g, Sbk_QSGGeometry_ColoredPoint2D_set_g},
    {const_cast<char *>("b"), Sbk_QSGGeometry_ColoredPoint2D_get_b, Sbk_QSGGeometry_ColoredPoint2D_set_b},
    {const_cast<char *>("a"), Sbk_QSGGeometry_ColoredPoint2D_get_a, Sbk_QSGGeometry_ColoredPoint2D_set_a},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSGGeometry_ColoredPoint2D_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGGeometry_ColoredPoint2D_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGGeometry_ColoredPoint2D_Type = nullptr;
static SbkObjectType *Sbk_QSGGeometry_ColoredPoint2D_TypeF(void)
{
    return _Sbk_QSGGeometry_ColoredPoint2D_Type;
}

static PyType_Slot Sbk_QSGGeometry_ColoredPoint2D_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGGeometry_ColoredPoint2D_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGGeometry_ColoredPoint2D_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGGeometry_ColoredPoint2D_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QSGGeometry_ColoredPoint2D_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGGeometry_ColoredPoint2D_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGGeometry_ColoredPoint2D_spec = {
    "2:PySide2.QtQuick.QSGGeometry.ColoredPoint2D",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGGeometry_ColoredPoint2D_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ColoredPoint2D_PythonToCpp_ColoredPoint2D_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGGeometry_ColoredPoint2D_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ColoredPoint2D_PythonToCpp_ColoredPoint2D_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometry_ColoredPoint2D_TypeF())))
        return ColoredPoint2D_PythonToCpp_ColoredPoint2D_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ColoredPoint2D_PTR_CppToPython_ColoredPoint2D(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSGGeometry::ColoredPoint2D *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSGGeometry_ColoredPoint2D_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *ColoredPoint2D_COPY_CppToPython_ColoredPoint2D(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSGGeometry_ColoredPoint2D_TypeF(), new ::QSGGeometry::ColoredPoint2D(*reinterpret_cast<const ::QSGGeometry::ColoredPoint2D *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void ColoredPoint2D_PythonToCpp_ColoredPoint2D_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGGeometry::ColoredPoint2D *>(cppOut) = *reinterpret_cast< ::QSGGeometry::ColoredPoint2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_ColoredPoint2D_PythonToCpp_ColoredPoint2D_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometry_ColoredPoint2D_TypeF())))
        return ColoredPoint2D_PythonToCpp_ColoredPoint2D_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGGeometry_ColoredPoint2D_SignatureStrings[] = {
    "1:PySide2.QtQuick.QSGGeometry.ColoredPoint2D(self)",
    "0:PySide2.QtQuick.QSGGeometry.ColoredPoint2D(self,ColoredPoint2D:PySide2.QtQuick.QSGGeometry.ColoredPoint2D)",
    "PySide2.QtQuick.QSGGeometry.ColoredPoint2D.set(self,nx:float,ny:float,nr:uchar,ng:uchar,nb:uchar,na:uchar)",
    "PySide2.QtQuick.QSGGeometry.ColoredPoint2D.__copy__()",
    nullptr}; // Sentinel

void init_QSGGeometry_ColoredPoint2D(PyObject *enclosingClass)
{
    _Sbk_QSGGeometry_ColoredPoint2D_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "ColoredPoint2D",
        "QSGGeometry::ColoredPoint2D",
        &Sbk_QSGGeometry_ColoredPoint2D_spec,
        &Shiboken::callCppDestructor< ::QSGGeometry::ColoredPoint2D >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGGeometry_ColoredPoint2D_Type);
    InitSignatureStrings(pyType, QSGGeometry_ColoredPoint2D_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGGeometry_ColoredPoint2D_Type), Sbk_QSGGeometry_ColoredPoint2D_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometry_ColoredPoint2D_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGGeometry_ColoredPoint2D_TypeF(),
        ColoredPoint2D_PythonToCpp_ColoredPoint2D_PTR,
        is_ColoredPoint2D_PythonToCpp_ColoredPoint2D_PTR_Convertible,
        ColoredPoint2D_PTR_CppToPython_ColoredPoint2D,
        ColoredPoint2D_COPY_CppToPython_ColoredPoint2D);

    Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::ColoredPoint2D");
    Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::ColoredPoint2D*");
    Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::ColoredPoint2D&");
    Shiboken::Conversions::registerConverterName(converter, "ColoredPoint2D");
    Shiboken::Conversions::registerConverterName(converter, "ColoredPoint2D*");
    Shiboken::Conversions::registerConverterName(converter, "ColoredPoint2D&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGGeometry::ColoredPoint2D).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        ColoredPoint2D_PythonToCpp_ColoredPoint2D_COPY,
        is_ColoredPoint2D_PythonToCpp_ColoredPoint2D_COPY_Convertible);

    qRegisterMetaType< ::QSGGeometry::ColoredPoint2D >("ColoredPoint2D");
    qRegisterMetaType< ::QSGGeometry::ColoredPoint2D >("QSGGeometry::ColoredPoint2D");
}
