/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsggeometrynode_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGGeometryNodeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGGeometryNodeWrapper::QSGGeometryNodeWrapper() : QSGGeometryNode()
{
    resetPyMethodCache();
    // ... middle
}

bool QSGGeometryNodeWrapper::isSubtreeBlocked() const
{
    if (m_PyMethodCache[0])
        return this->::QSGNode::isSubtreeBlocked();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSubtreeBlocked";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QSGNode::isSubtreeBlocked();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGGeometryNode.isSubtreeBlocked", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSGGeometryNodeWrapper::preprocess()
{
    if (m_PyMethodCache[1]) {
        return this->::QSGNode::preprocess();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "preprocess";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSGNode::preprocess();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QSGGeometryNodeWrapper::~QSGGeometryNodeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGGeometryNode_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGGeometryNode >()))
        return -1;

    ::QSGGeometryNodeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometryNode.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QSGGeometryNode()
            cptr = new ::QSGGeometryNodeWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGGeometryNode >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QSGGeometryNodeFunc_inheritedOpacity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometryNode.inheritedOpacity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inheritedOpacity()const
            qreal cppResult = const_cast<const ::QSGGeometryNode *>(cppSelf)->inheritedOpacity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryNodeFunc_renderOrder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometryNode.renderOrder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderOrder()const
            int cppResult = const_cast<const ::QSGGeometryNode *>(cppSelf)->renderOrder();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryNodeFunc_setInheritedOpacity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometryNode.setInheritedOpacity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGGeometryNode::setInheritedOpacity(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setInheritedOpacity(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryNodeFunc_setInheritedOpacity_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInheritedOpacity(qreal)
            cppSelf->setInheritedOpacity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryNodeFunc_setInheritedOpacity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometryNodeFunc_setRenderOrder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometryNode.setRenderOrder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGGeometryNode::setRenderOrder(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setRenderOrder(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryNodeFunc_setRenderOrder_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRenderOrder(int)
            cppSelf->setRenderOrder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryNodeFunc_setRenderOrder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QSGGeometryNode_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGGeometryNode_methods[] = {
    {"inheritedOpacity", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryNodeFunc_inheritedOpacity), METH_NOARGS},
    {"renderOrder", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryNodeFunc_renderOrder), METH_NOARGS},
    {"setInheritedOpacity", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryNodeFunc_setInheritedOpacity), METH_O},
    {"setRenderOrder", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryNodeFunc_setRenderOrder), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGGeometryNode_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGGeometryNodeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGGeometryNode_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGGeometryNode_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSGGeometryNode__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometryNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRYNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGGeometryNode_Type = nullptr;
static SbkObjectType *Sbk_QSGGeometryNode_TypeF(void)
{
    return _Sbk_QSGGeometryNode_Type;
}

static PyType_Slot Sbk_QSGGeometryNode_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSGGeometryNode__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGGeometryNode_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGGeometryNode_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGGeometryNode_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGGeometryNode_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGGeometryNode_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGGeometryNode_spec = {
    "2:PySide2.QtQuick.QSGGeometryNode",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGGeometryNode_slots
};

} //extern "C"

static void *Sbk_QSGGeometryNode_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QSGNode >()))
        return dynamic_cast< ::QSGGeometryNode *>(reinterpret_cast< ::QSGNode *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGGeometryNode_PythonToCpp_QSGGeometryNode_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGGeometryNode_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGGeometryNode_PythonToCpp_QSGGeometryNode_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometryNode_TypeF())))
        return QSGGeometryNode_PythonToCpp_QSGGeometryNode_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGGeometryNode_PTR_CppToPython_QSGGeometryNode(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSGGeometryNode *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSGGeometryNode_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGGeometryNode_SignatureStrings[] = {
    "PySide2.QtQuick.QSGGeometryNode(self)",
    "PySide2.QtQuick.QSGGeometryNode.inheritedOpacity(self)->qreal",
    "PySide2.QtQuick.QSGGeometryNode.renderOrder(self)->int",
    "PySide2.QtQuick.QSGGeometryNode.setInheritedOpacity(self,opacity:qreal)",
    "PySide2.QtQuick.QSGGeometryNode.setRenderOrder(self,order:int)",
    nullptr}; // Sentinel

void init_QSGGeometryNode(PyObject *module)
{
    _Sbk_QSGGeometryNode_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGGeometryNode",
        "QSGGeometryNode*",
        &Sbk_QSGGeometryNode_spec,
        &Shiboken::callCppDestructor< ::QSGGeometryNode >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGBASICGEOMETRYNODE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGGeometryNode_Type);
    InitSignatureStrings(pyType, QSGGeometryNode_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGGeometryNode_Type), Sbk_QSGGeometryNode_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRYNODE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometryNode_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGGeometryNode_TypeF(),
        QSGGeometryNode_PythonToCpp_QSGGeometryNode_PTR,
        is_QSGGeometryNode_PythonToCpp_QSGGeometryNode_PTR_Convertible,
        QSGGeometryNode_PTR_CppToPython_QSGGeometryNode);

    Shiboken::Conversions::registerConverterName(converter, "QSGGeometryNode");
    Shiboken::Conversions::registerConverterName(converter, "QSGGeometryNode*");
    Shiboken::Conversions::registerConverterName(converter, "QSGGeometryNode&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGGeometryNode).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGGeometryNodeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSGGeometryNode_TypeF(), &Sbk_QSGGeometryNode_typeDiscovery);

}
