/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsgsimplerectnode_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGSimpleRectNodeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGSimpleRectNodeWrapper::QSGSimpleRectNodeWrapper() : QSGSimpleRectNode()
{
    resetPyMethodCache();
    // ... middle
}

QSGSimpleRectNodeWrapper::QSGSimpleRectNodeWrapper(const ::QRectF & rect, const ::QColor & color) : QSGSimpleRectNode(rect, color)
{
    resetPyMethodCache();
    // ... middle
}

bool QSGSimpleRectNodeWrapper::isSubtreeBlocked() const
{
    if (m_PyMethodCache[0])
        return this->::QSGNode::isSubtreeBlocked();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSubtreeBlocked";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QSGNode::isSubtreeBlocked();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGSimpleRectNode.isSubtreeBlocked", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSGSimpleRectNodeWrapper::preprocess()
{
    if (m_PyMethodCache[1]) {
        return this->::QSGNode::preprocess();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "preprocess";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSGNode::preprocess();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QSGSimpleRectNodeWrapper::~QSGSimpleRectNodeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGSimpleRectNode_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGSimpleRectNode >()))
        return -1;

    ::QSGSimpleRectNodeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleRectNode.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto Sbk_QSGSimpleRectNode_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QSGSimpleRectNode", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QSGSimpleRectNode::QSGSimpleRectNode()
    // 1: QSGSimpleRectNode::QSGSimpleRectNode(QRectF,QColor)
    if (numArgs == 0) {
        overloadId = 0; // QSGSimpleRectNode()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
        overloadId = 1; // QSGSimpleRectNode(QRectF,QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGSimpleRectNode_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSGSimpleRectNode()
        {

            if (!PyErr_Occurred()) {
                // QSGSimpleRectNode()
                cptr = new ::QSGSimpleRectNodeWrapper();
            }
            break;
        }
        case 1: // QSGSimpleRectNode(const QRectF & rect, const QColor & color)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QSGSimpleRectNode(QRectF,QColor)
                cptr = new ::QSGSimpleRectNodeWrapper(*cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGSimpleRectNode >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSGSimpleRectNode_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSGSimpleRectNode_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSGSimpleRectNodeFunc_color(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleRectNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLERECTNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleRectNode.color";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // color()const
            QColor cppResult = const_cast<const ::QSGSimpleRectNode *>(cppSelf)->color();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGSimpleRectNodeFunc_rect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleRectNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLERECTNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleRectNode.rect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rect()const
            QRectF cppResult = const_cast<const ::QSGSimpleRectNode *>(cppSelf)->rect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGSimpleRectNodeFunc_setColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleRectNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLERECTNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleRectNode.setColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGSimpleRectNode::setColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGSimpleRectNodeFunc_setColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setColor(QColor)
            cppSelf->setColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGSimpleRectNodeFunc_setColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGSimpleRectNodeFunc_setRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleRectNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLERECTNODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleRectNode.setRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QSGSimpleRectNodeFunc_setRect_TypeError;

    if (!PyArg_UnpackTuple(args, "setRect", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QSGSimpleRectNode::setRect(QRectF)
    // 1: QSGSimpleRectNode::setRect(qreal,qreal,qreal,qreal)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 1; // setRect(qreal,qreal,qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGSimpleRectNodeFunc_setRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setRect(const QRectF & rect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setRect(QRectF)
                cppSelf->setRect(*cppArg0);
            }
            break;
        }
        case 1: // setRect(qreal x, qreal y, qreal w, qreal h)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setRect(qreal,qreal,qreal,qreal)
                cppSelf->setRect(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGSimpleRectNodeFunc_setRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QSGSimpleRectNode_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGSimpleRectNode_methods[] = {
    {"color", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleRectNodeFunc_color), METH_NOARGS},
    {"rect", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleRectNodeFunc_rect), METH_NOARGS},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleRectNodeFunc_setColor), METH_O},
    {"setRect", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleRectNodeFunc_setRect), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGSimpleRectNode_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGSimpleRectNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLERECTNODE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGSimpleRectNodeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGSimpleRectNode_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGSimpleRectNode_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGSimpleRectNode_Type = nullptr;
static SbkObjectType *Sbk_QSGSimpleRectNode_TypeF(void)
{
    return _Sbk_QSGSimpleRectNode_Type;
}

static PyType_Slot Sbk_QSGSimpleRectNode_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGSimpleRectNode_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGSimpleRectNode_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGSimpleRectNode_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGSimpleRectNode_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGSimpleRectNode_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGSimpleRectNode_spec = {
    "2:PySide2.QtQuick.QSGSimpleRectNode",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGSimpleRectNode_slots
};

} //extern "C"

static void *Sbk_QSGSimpleRectNode_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QSGNode >()))
        return dynamic_cast< ::QSGSimpleRectNode *>(reinterpret_cast< ::QSGNode *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGSimpleRectNode_PythonToCpp_QSGSimpleRectNode_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGSimpleRectNode_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGSimpleRectNode_PythonToCpp_QSGSimpleRectNode_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGSimpleRectNode_TypeF())))
        return QSGSimpleRectNode_PythonToCpp_QSGSimpleRectNode_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGSimpleRectNode_PTR_CppToPython_QSGSimpleRectNode(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSGSimpleRectNode *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSGSimpleRectNode_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGSimpleRectNode_SignatureStrings[] = {
    "1:PySide2.QtQuick.QSGSimpleRectNode(self)",
    "0:PySide2.QtQuick.QSGSimpleRectNode(self,rect:PySide2.QtCore.QRectF,color:PySide2.QtGui.QColor)",
    "PySide2.QtQuick.QSGSimpleRectNode.color(self)->PySide2.QtGui.QColor",
    "PySide2.QtQuick.QSGSimpleRectNode.rect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QSGSimpleRectNode.setColor(self,color:PySide2.QtGui.QColor)",
    "1:PySide2.QtQuick.QSGSimpleRectNode.setRect(self,rect:PySide2.QtCore.QRectF)",
    "0:PySide2.QtQuick.QSGSimpleRectNode.setRect(self,x:qreal,y:qreal,w:qreal,h:qreal)",
    nullptr}; // Sentinel

void init_QSGSimpleRectNode(PyObject *module)
{
    _Sbk_QSGSimpleRectNode_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGSimpleRectNode",
        "QSGSimpleRectNode*",
        &Sbk_QSGSimpleRectNode_spec,
        &Shiboken::callCppDestructor< ::QSGSimpleRectNode >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRYNODE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGSimpleRectNode_Type);
    InitSignatureStrings(pyType, QSGSimpleRectNode_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGSimpleRectNode_Type), Sbk_QSGSimpleRectNode_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGSIMPLERECTNODE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGSimpleRectNode_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGSimpleRectNode_TypeF(),
        QSGSimpleRectNode_PythonToCpp_QSGSimpleRectNode_PTR,
        is_QSGSimpleRectNode_PythonToCpp_QSGSimpleRectNode_PTR_Convertible,
        QSGSimpleRectNode_PTR_CppToPython_QSGSimpleRectNode);

    Shiboken::Conversions::registerConverterName(converter, "QSGSimpleRectNode");
    Shiboken::Conversions::registerConverterName(converter, "QSGSimpleRectNode*");
    Shiboken::Conversions::registerConverterName(converter, "QSGSimpleRectNode&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGSimpleRectNode).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGSimpleRectNodeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSGSimpleRectNode_TypeF(), &Sbk_QSGSimpleRectNode_typeDiscovery);

}
