/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsgsimpletexturenode_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGSimpleTextureNodeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGSimpleTextureNodeWrapper::QSGSimpleTextureNodeWrapper() : QSGSimpleTextureNode()
{
    resetPyMethodCache();
    // ... middle
}

bool QSGSimpleTextureNodeWrapper::isSubtreeBlocked() const
{
    if (m_PyMethodCache[0])
        return this->::QSGNode::isSubtreeBlocked();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSubtreeBlocked";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QSGNode::isSubtreeBlocked();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGSimpleTextureNode.isSubtreeBlocked", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSGSimpleTextureNodeWrapper::preprocess()
{
    if (m_PyMethodCache[1]) {
        return this->::QSGNode::preprocess();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "preprocess";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSGNode::preprocess();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QSGSimpleTextureNodeWrapper::~QSGSimpleTextureNodeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGSimpleTextureNode_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGSimpleTextureNode >()))
        return -1;

    ::QSGSimpleTextureNodeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QSGSimpleTextureNode()
            cptr = new ::QSGSimpleTextureNodeWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGSimpleTextureNode >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_filtering(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.filtering";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filtering()const
            QSGTexture::Filtering cppResult = const_cast<const ::QSGSimpleTextureNode *>(cppSelf)->filtering();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_ownsTexture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.ownsTexture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ownsTexture()const
            bool cppResult = const_cast<const ::QSGSimpleTextureNode *>(cppSelf)->ownsTexture();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_rect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.rect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rect()const
            QRectF cppResult = const_cast<const ::QSGSimpleTextureNode *>(cppSelf)->rect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_setFiltering(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.setFiltering";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGSimpleTextureNode::setFiltering(QSGTexture::Filtering)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFiltering(QSGTexture::Filtering)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGSimpleTextureNodeFunc_setFiltering_TypeError;

    // Call function/method
    {
        ::QSGTexture::Filtering cppArg0{QSGTexture::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFiltering(QSGTexture::Filtering)
            cppSelf->setFiltering(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGSimpleTextureNodeFunc_setFiltering_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_setOwnsTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.setOwnsTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGSimpleTextureNode::setOwnsTexture(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOwnsTexture(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGSimpleTextureNodeFunc_setOwnsTexture_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOwnsTexture(bool)
            cppSelf->setOwnsTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGSimpleTextureNodeFunc_setOwnsTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_setRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.setRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QSGSimpleTextureNodeFunc_setRect_TypeError;

    if (!PyArg_UnpackTuple(args, "setRect", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QSGSimpleTextureNode::setRect(QRectF)
    // 1: QSGSimpleTextureNode::setRect(qreal,qreal,qreal,qreal)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 1; // setRect(qreal,qreal,qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGSimpleTextureNodeFunc_setRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setRect(const QRectF & rect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setRect(QRectF)
                cppSelf->setRect(*cppArg0);
            }
            break;
        }
        case 1: // setRect(qreal x, qreal y, qreal w, qreal h)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setRect(qreal,qreal,qreal,qreal)
                cppSelf->setRect(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGSimpleTextureNodeFunc_setRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_setSourceRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.setSourceRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QSGSimpleTextureNodeFunc_setSourceRect_TypeError;

    if (!PyArg_UnpackTuple(args, "setSourceRect", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QSGSimpleTextureNode::setSourceRect(QRectF)
    // 1: QSGSimpleTextureNode::setSourceRect(qreal,qreal,qreal,qreal)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 1; // setSourceRect(qreal,qreal,qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setSourceRect(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGSimpleTextureNodeFunc_setSourceRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setSourceRect(const QRectF & r)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setSourceRect(QRectF)
                cppSelf->setSourceRect(*cppArg0);
            }
            break;
        }
        case 1: // setSourceRect(qreal x, qreal y, qreal w, qreal h)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setSourceRect(qreal,qreal,qreal,qreal)
                cppSelf->setSourceRect(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGSimpleTextureNodeFunc_setSourceRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_setTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.setTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGSimpleTextureNode::setTexture(QSGTexture*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), (pyArg)))) {
        overloadId = 0; // setTexture(QSGTexture*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGSimpleTextureNodeFunc_setTexture_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSGTexture *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTexture(QSGTexture*)
            cppSelf->setTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGSimpleTextureNodeFunc_setTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_setTextureCoordinatesTransform(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.setTextureCoordinatesTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGSimpleTextureNode::setTextureCoordinatesTransform(QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTextureCoordinatesTransform(QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGSimpleTextureNodeFunc_setTextureCoordinatesTransform_TypeError;

    // Call function/method
    {
        ::QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag> cppArg0 = QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextureCoordinatesTransform(QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag>)
            cppSelf->setTextureCoordinatesTransform(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGSimpleTextureNodeFunc_setTextureCoordinatesTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_sourceRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.sourceRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceRect()const
            QRectF cppResult = const_cast<const ::QSGSimpleTextureNode *>(cppSelf)->sourceRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_texture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.texture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // texture()const
            QSGTexture * cppResult = const_cast<const ::QSGSimpleTextureNode *>(cppSelf)->texture();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGSimpleTextureNodeFunc_textureCoordinatesTransform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGSimpleTextureNode.textureCoordinatesTransform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureCoordinatesTransform()const
            QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag> cppResult = const_cast<const ::QSGSimpleTextureNode *>(cppSelf)->textureCoordinatesTransform();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSGSimpleTextureNode_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGSimpleTextureNode_methods[] = {
    {"filtering", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_filtering), METH_NOARGS},
    {"ownsTexture", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_ownsTexture), METH_NOARGS},
    {"rect", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_rect), METH_NOARGS},
    {"setFiltering", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_setFiltering), METH_O},
    {"setOwnsTexture", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_setOwnsTexture), METH_O},
    {"setRect", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_setRect), METH_VARARGS},
    {"setSourceRect", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_setSourceRect), METH_VARARGS},
    {"setTexture", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_setTexture), METH_O},
    {"setTextureCoordinatesTransform", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_setTextureCoordinatesTransform), METH_O},
    {"sourceRect", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_sourceRect), METH_NOARGS},
    {"texture", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_texture), METH_NOARGS},
    {"textureCoordinatesTransform", reinterpret_cast<PyCFunction>(Sbk_QSGSimpleTextureNodeFunc_textureCoordinatesTransform), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGSimpleTextureNode_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGSimpleTextureNode *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGSimpleTextureNodeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGSimpleTextureNode_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGSimpleTextureNode_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGSimpleTextureNode_Type = nullptr;
static SbkObjectType *Sbk_QSGSimpleTextureNode_TypeF(void)
{
    return _Sbk_QSGSimpleTextureNode_Type;
}

static PyType_Slot Sbk_QSGSimpleTextureNode_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGSimpleTextureNode_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGSimpleTextureNode_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGSimpleTextureNode_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGSimpleTextureNode_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGSimpleTextureNode_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGSimpleTextureNode_spec = {
    "2:PySide2.QtQuick.QSGSimpleTextureNode",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGSimpleTextureNode_slots
};

} //extern "C"

static void *Sbk_QSGSimpleTextureNode_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QSGNode >()))
        return dynamic_cast< ::QSGSimpleTextureNode *>(reinterpret_cast< ::QSGNode *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QSGSimpleTextureNode::TextureCoordinatesTransformMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QSGSimpleTextureNode::TextureCoordinatesTransformMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSGSimpleTextureNode::TextureCoordinatesTransformMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGSimpleTextureNode::TextureCoordinatesTransformMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSGSimpleTextureNode::TextureCoordinatesTransformMode cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])->converter, self, &cppSelf);
    ::QSGSimpleTextureNode::TextureCoordinatesTransformMode cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QSGSimpleTextureNode_TextureCoordinatesTransformFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGSimpleTextureNode::TextureCoordinatesTransformFlag *>(cppOut) =
        static_cast<::QSGSimpleTextureNode::TextureCoordinatesTransformFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX]))
        return QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QSGSimpleTextureNode_TextureCoordinatesTransformFlag;
    return {};
}
static PyObject *QSGSimpleTextureNode_TextureCoordinatesTransformFlag_CppToPython_QSGSimpleTextureNode_TextureCoordinatesTransformFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGSimpleTextureNode::TextureCoordinatesTransformFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX], castCppIn);

}

static void QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag> *>(cppOut) =
        ::QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX]))
        return QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_;
    return {};
}
static PyObject *QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__CppToPython_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX]));

}

static void QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag> *>(cppOut) =
        ::QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX]))
        return QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag> *>(cppOut) =
        ::QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX]))
        return number_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGSimpleTextureNode_PythonToCpp_QSGSimpleTextureNode_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGSimpleTextureNode_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGSimpleTextureNode_PythonToCpp_QSGSimpleTextureNode_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGSimpleTextureNode_TypeF())))
        return QSGSimpleTextureNode_PythonToCpp_QSGSimpleTextureNode_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGSimpleTextureNode_PTR_CppToPython_QSGSimpleTextureNode(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSGSimpleTextureNode *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSGSimpleTextureNode_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGSimpleTextureNode_SignatureStrings[] = {
    "PySide2.QtQuick.QSGSimpleTextureNode(self)",
    "PySide2.QtQuick.QSGSimpleTextureNode.filtering(self)->PySide2.QtQuick.QSGTexture.Filtering",
    "PySide2.QtQuick.QSGSimpleTextureNode.ownsTexture(self)->bool",
    "PySide2.QtQuick.QSGSimpleTextureNode.rect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QSGSimpleTextureNode.setFiltering(self,filtering:PySide2.QtQuick.QSGTexture.Filtering)",
    "PySide2.QtQuick.QSGSimpleTextureNode.setOwnsTexture(self,owns:bool)",
    "1:PySide2.QtQuick.QSGSimpleTextureNode.setRect(self,rect:PySide2.QtCore.QRectF)",
    "0:PySide2.QtQuick.QSGSimpleTextureNode.setRect(self,x:qreal,y:qreal,w:qreal,h:qreal)",
    "1:PySide2.QtQuick.QSGSimpleTextureNode.setSourceRect(self,r:PySide2.QtCore.QRectF)",
    "0:PySide2.QtQuick.QSGSimpleTextureNode.setSourceRect(self,x:qreal,y:qreal,w:qreal,h:qreal)",
    "PySide2.QtQuick.QSGSimpleTextureNode.setTexture(self,texture:PySide2.QtQuick.QSGTexture)",
    "PySide2.QtQuick.QSGSimpleTextureNode.setTextureCoordinatesTransform(self,mode:PySide2.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformMode)",
    "PySide2.QtQuick.QSGSimpleTextureNode.sourceRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QSGSimpleTextureNode.texture(self)->PySide2.QtQuick.QSGTexture",
    "PySide2.QtQuick.QSGSimpleTextureNode.textureCoordinatesTransform(self)->PySide2.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformMode",
    nullptr}; // Sentinel

void init_QSGSimpleTextureNode(PyObject *module)
{
    _Sbk_QSGSimpleTextureNode_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGSimpleTextureNode",
        "QSGSimpleTextureNode*",
        &Sbk_QSGSimpleTextureNode_spec,
        &Shiboken::callCppDestructor< ::QSGSimpleTextureNode >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRYNODE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGSimpleTextureNode_Type);
    InitSignatureStrings(pyType, QSGSimpleTextureNode_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGSimpleTextureNode_Type), Sbk_QSGSimpleTextureNode_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGSimpleTextureNode_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGSimpleTextureNode_TypeF(),
        QSGSimpleTextureNode_PythonToCpp_QSGSimpleTextureNode_PTR,
        is_QSGSimpleTextureNode_PythonToCpp_QSGSimpleTextureNode_PTR_Convertible,
        QSGSimpleTextureNode_PTR_CppToPython_QSGSimpleTextureNode);

    Shiboken::Conversions::registerConverterName(converter, "QSGSimpleTextureNode");
    Shiboken::Conversions::registerConverterName(converter, "QSGSimpleTextureNode*");
    Shiboken::Conversions::registerConverterName(converter, "QSGSimpleTextureNode&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGSimpleTextureNode).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGSimpleTextureNodeWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSGSimpleTextureNode_TypeF(), &Sbk_QSGSimpleTextureNode_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'TextureCoordinatesTransformFlag'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformMode", SbkPySide2_QtQuick_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGSimpleTextureNode_TypeF(),
        "TextureCoordinatesTransformFlag",
        "2:PySide2.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformFlag",
        "QSGSimpleTextureNode::TextureCoordinatesTransformFlag",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX],
        Sbk_QSGSimpleTextureNode_TypeF(), "NoTransform", (long) QSGSimpleTextureNode::TextureCoordinatesTransformFlag::NoTransform))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX],
        Sbk_QSGSimpleTextureNode_TypeF(), "MirrorHorizontally", (long) QSGSimpleTextureNode::TextureCoordinatesTransformFlag::MirrorHorizontally))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX],
        Sbk_QSGSimpleTextureNode_TypeF(), "MirrorVertically", (long) QSGSimpleTextureNode::TextureCoordinatesTransformFlag::MirrorVertically))
        return;
    // Register converter for enum 'QSGSimpleTextureNode::TextureCoordinatesTransformFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX],
            QSGSimpleTextureNode_TextureCoordinatesTransformFlag_CppToPython_QSGSimpleTextureNode_TextureCoordinatesTransformFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QSGSimpleTextureNode_TextureCoordinatesTransformFlag,
            is_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGSimpleTextureNode::TextureCoordinatesTransformFlag");
        Shiboken::Conversions::registerConverterName(converter, "TextureCoordinatesTransformFlag");
    }
    // Register converter for flag 'QFlags<QSGSimpleTextureNode::TextureCoordinatesTransformFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX],
            QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__CppToPython_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_,
            is_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_,
            is_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag_,
            is_number_PythonToCpp_QFlags_QSGSimpleTextureNode_TextureCoordinatesTransformFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGSIMPLETEXTURENODE_TEXTURECOORDINATESTRANSFORMFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGSimpleTextureNode::TextureCoordinatesTransformMode");
        Shiboken::Conversions::registerConverterName(converter, "TextureCoordinatesTransformMode");
    }
    // End of 'TextureCoordinatesTransformFlag' enum/flags.

    qRegisterMetaType< ::QSGSimpleTextureNode::TextureCoordinatesTransformFlag >("QSGSimpleTextureNode::TextureCoordinatesTransformFlag");
    qRegisterMetaType< ::QSGSimpleTextureNode::TextureCoordinatesTransformMode >("QSGSimpleTextureNode::TextureCoordinatesTransformMode");
}
