/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtremoteobjects_python.h"

// main header
#include "qremoteobjecthostbase_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QRemoteObjectHostBaseWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QRemoteObjectHostBaseWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRemoteObjectHostBaseWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QRemoteObjectHostBaseWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRemoteObjectHostBaseWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QRemoteObjectHostBaseWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHostBase.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QRemoteObjectHostBaseWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHostBase.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QUrl QRemoteObjectHostBaseWrapper::hostUrl() const
{
    if (m_PyMethodCache[6])
        return this->::QRemoteObjectHostBase::hostUrl();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hostUrl";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QRemoteObjectHostBase::hostUrl();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHostBase.hostUrl", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QUrl >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QUrl cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QRemoteObjectHostBaseWrapper::setHostUrl(const ::QUrl & hostAddress, ::QRemoteObjectHostBase::AllowedSchemas allowedSchemas)
{
    if (m_PyMethodCache[8])
        return this->::QRemoteObjectHostBase::setHostUrl(hostAddress, allowedSchemas);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setHostUrl";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QRemoteObjectHostBase::setHostUrl(hostAddress, allowedSchemas);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &hostAddress),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX])->converter, &allowedSchemas)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHostBase.setHostUrl", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QRemoteObjectHostBaseWrapper::setName(const ::QString & name)
{
    if (m_PyMethodCache[9]) {
        return this->::QRemoteObjectHostBase::setName(name);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setName";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QRemoteObjectHostBase::setName(name);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &name)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QRemoteObjectHostBaseWrapper::setRegistryUrl(const ::QUrl & registryAddress)
{
    if (m_PyMethodCache[10])
        return this->::QRemoteObjectNode::setRegistryUrl(registryAddress);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setRegistryUrl";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QRemoteObjectNode::setRegistryUrl(registryAddress);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &registryAddress)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHostBase.setRegistryUrl", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QRemoteObjectHostBaseWrapper::timerEvent(::QTimerEvent * arg__1)
{
    if (m_PyMethodCache[11]) {
        return this->::QRemoteObjectNode::timerEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QRemoteObjectNode::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QRemoteObjectHostBaseWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QRemoteObjectHostBase::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QRemoteObjectHostBaseWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QRemoteObjectHostBase::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QRemoteObjectHostBaseWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QRemoteObjectHostBaseWrapper *>(this));
        return QRemoteObjectHostBase::qt_metacast(_clname);
}

QRemoteObjectHostBaseWrapper::~QRemoteObjectHostBaseWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QRemoteObjectHostBaseFunc_addHostSideConnection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHostBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHostBase.addHostSideConnection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRemoteObjectHostBase::addHostSideConnection(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // addHostSideConnection(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectHostBaseFunc_addHostSideConnection_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addHostSideConnection(QIODevice*)
            cppSelf->addHostSideConnection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRemoteObjectHostBaseFunc_addHostSideConnection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectHostBaseFunc_disableRemoting(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHostBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHostBase.disableRemoting";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRemoteObjectHostBase::disableRemoting(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // disableRemoting(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectHostBaseFunc_disableRemoting_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // disableRemoting(QObject*)
            bool cppResult = cppSelf->disableRemoting(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectHostBaseFunc_disableRemoting_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectHostBaseFunc_enableRemoting(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHostBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHostBase.enableRemoting";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:enableRemoting", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectHostBase::enableRemoting(QAbstractItemModel*,QString,QVector<int>,QItemSelectionModel*)
    // 1: QRemoteObjectHostBase::enableRemoting(QObject*,QString)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtRemoteObjectsTypeConverters[SBK_QTREMOTEOBJECTS_QVECTOR_INT_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // enableRemoting(QAbstractItemModel*,QString,QVector<int>,QItemSelectionModel*)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONMODEL_IDX]), (pyArgs[3])))) {
            overloadId = 0; // enableRemoting(QAbstractItemModel*,QString,QVector<int>,QItemSelectionModel*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // enableRemoting(QObject*,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // enableRemoting(QObject*,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // enableRemoting(QAbstractItemModel * model, const QString & name, const QVector<int > roles, QItemSelectionModel * selectionModel)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_selectionModel = Shiboken::String::createStaticString("selectionModel");
                if (PyDict_Contains(kwds, key_selectionModel)) {
                    value = PyDict_GetItem(kwds, key_selectionModel);
                    if (value && pyArgs[3]) {
                        errInfo = key_selectionModel;
                        Py_INCREF(errInfo);
                        goto Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QITEMSELECTIONMODEL_IDX]), (pyArgs[3]))))
                            goto Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_selectionModel);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QVector<int > cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QItemSelectionModel *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // enableRemoting(QAbstractItemModel*,QString,QVector<int>,QItemSelectionModel*)
                bool cppResult = cppSelf->enableRemoting(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // enableRemoting(QObject * object, const QString & name)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_name = Shiboken::String::createStaticString("name");
                if (PyDict_Contains(kwds, key_name)) {
                    value = PyDict_GetItem(kwds, key_name);
                    if (value && pyArgs[1]) {
                        errInfo = key_name;
                        Py_INCREF(errInfo);
                        goto Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_name);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // enableRemoting(QObject*,QString)
                bool cppResult = cppSelf->enableRemoting(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectHostBaseFunc_enableRemoting_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectHostBaseFunc_hostUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHostBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHostBase.hostUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hostUrl()const
            QUrl cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QRemoteObjectHostBase *>(cppSelf)->::QRemoteObjectHostBase::hostUrl()
                : const_cast<const ::QRemoteObjectHostBase *>(cppSelf)->hostUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectHostBaseFunc_proxy(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHostBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHostBase.proxy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectHostBaseFunc_proxy_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectHostBaseFunc_proxy_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:proxy", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectHostBase::proxy(QUrl,QUrl)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // proxy(QUrl,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 0; // proxy(QUrl,QUrl)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectHostBaseFunc_proxy_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_hostUrl = Shiboken::String::createStaticString("hostUrl");
            if (PyDict_Contains(kwds, key_hostUrl)) {
                value = PyDict_GetItem(kwds, key_hostUrl);
                if (value && pyArgs[1]) {
                    errInfo = key_hostUrl;
                    Py_INCREF(errInfo);
                    goto Sbk_QRemoteObjectHostBaseFunc_proxy_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                        goto Sbk_QRemoteObjectHostBaseFunc_proxy_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_hostUrl);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRemoteObjectHostBaseFunc_proxy_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local = {};
        ::QUrl *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // proxy(QUrl,QUrl)
            bool cppResult = cppSelf->proxy(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectHostBaseFunc_proxy_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectHostBaseFunc_reverseProxy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHostBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHostBase.reverseProxy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reverseProxy()
            bool cppResult = cppSelf->reverseProxy();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectHostBaseFunc_setHostUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHostBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHostBase.setHostUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectHostBaseFunc_setHostUrl_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectHostBaseFunc_setHostUrl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setHostUrl", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectHostBase::setHostUrl(QUrl,QRemoteObjectHostBase::AllowedSchemas)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setHostUrl(QUrl,QRemoteObjectHostBase::AllowedSchemas)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setHostUrl(QUrl,QRemoteObjectHostBase::AllowedSchemas)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectHostBaseFunc_setHostUrl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_allowedSchemas = Shiboken::String::createStaticString("allowedSchemas");
            if (PyDict_Contains(kwds, key_allowedSchemas)) {
                value = PyDict_GetItem(kwds, key_allowedSchemas);
                if (value && pyArgs[1]) {
                    errInfo = key_allowedSchemas;
                    Py_INCREF(errInfo);
                    goto Sbk_QRemoteObjectHostBaseFunc_setHostUrl_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QRemoteObjectHostBaseFunc_setHostUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_allowedSchemas);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRemoteObjectHostBaseFunc_setHostUrl_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QRemoteObjectHostBase::AllowedSchemas cppArg1 = QRemoteObjectHostBase::AllowedSchemas::BuiltInSchemasOnly;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setHostUrl(QUrl,QRemoteObjectHostBase::AllowedSchemas)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QRemoteObjectHostBase::setHostUrl(*cppArg0, cppArg1)
                : cppSelf->setHostUrl(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectHostBaseFunc_setHostUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectHostBaseFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHostBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHostBase.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRemoteObjectNode::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectHostBaseFunc_setName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setName(QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QRemoteObjectHostBase::setName(cppArg0)
                : cppSelf->setName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRemoteObjectHostBaseFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QRemoteObjectHostBase_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRemoteObjectHostBase_methods[] = {
    {"addHostSideConnection", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostBaseFunc_addHostSideConnection), METH_O},
    {"disableRemoting", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostBaseFunc_disableRemoting), METH_O},
    {"enableRemoting", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostBaseFunc_enableRemoting), METH_VARARGS|METH_KEYWORDS},
    {"hostUrl", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostBaseFunc_hostUrl), METH_NOARGS},
    {"proxy", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostBaseFunc_proxy), METH_VARARGS|METH_KEYWORDS},
    {"reverseProxy", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostBaseFunc_reverseProxy), METH_NOARGS},
    {"setHostUrl", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostBaseFunc_setHostUrl), METH_VARARGS|METH_KEYWORDS},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostBaseFunc_setName), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QRemoteObjectHostBase_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QRemoteObjectHostBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QRemoteObjectHostBaseWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QRemoteObjectHostBase_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRemoteObjectHostBase_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRemoteObjectHostBase_Type = nullptr;
static SbkObjectType *Sbk_QRemoteObjectHostBase_TypeF(void)
{
    return _Sbk_QRemoteObjectHostBase_Type;
}

static PyType_Slot Sbk_QRemoteObjectHostBase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QRemoteObjectHostBase_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRemoteObjectHostBase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRemoteObjectHostBase_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRemoteObjectHostBase_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRemoteObjectHostBase_spec = {
    "2:PySide2.QtRemoteObjects.QRemoteObjectHostBase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRemoteObjectHostBase_slots
};

} //extern "C"

static void *Sbk_QRemoteObjectHostBase_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QRemoteObjectHostBase *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QRemoteObjectHostBase_AllowedSchemas_PythonToCpp_QRemoteObjectHostBase_AllowedSchemas(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRemoteObjectHostBase::AllowedSchemas *>(cppOut) =
        static_cast<::QRemoteObjectHostBase::AllowedSchemas>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRemoteObjectHostBase_AllowedSchemas_PythonToCpp_QRemoteObjectHostBase_AllowedSchemas_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX]))
        return QRemoteObjectHostBase_AllowedSchemas_PythonToCpp_QRemoteObjectHostBase_AllowedSchemas;
    return {};
}
static PyObject *QRemoteObjectHostBase_AllowedSchemas_CppToPython_QRemoteObjectHostBase_AllowedSchemas(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRemoteObjectHostBase::AllowedSchemas *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRemoteObjectHostBase_PythonToCpp_QRemoteObjectHostBase_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRemoteObjectHostBase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRemoteObjectHostBase_PythonToCpp_QRemoteObjectHostBase_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRemoteObjectHostBase_TypeF())))
        return QRemoteObjectHostBase_PythonToCpp_QRemoteObjectHostBase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRemoteObjectHostBase_PTR_CppToPython_QRemoteObjectHostBase(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QRemoteObjectHostBase *>(const_cast<void *>(cppIn)), Sbk_QRemoteObjectHostBase_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRemoteObjectHostBase_SignatureStrings[] = {
    "PySide2.QtRemoteObjects.QRemoteObjectHostBase.addHostSideConnection(self,ioDevice:PySide2.QtCore.QIODevice)",
    "PySide2.QtRemoteObjects.QRemoteObjectHostBase.disableRemoting(self,remoteObject:PySide2.QtCore.QObject)->bool",
    "1:PySide2.QtRemoteObjects.QRemoteObjectHostBase.enableRemoting(self,model:PySide2.QtCore.QAbstractItemModel,name:QString,roles:QVector[int],selectionModel:PySide2.QtCore.QItemSelectionModel=nullptr)->bool",
    "0:PySide2.QtRemoteObjects.QRemoteObjectHostBase.enableRemoting(self,object:PySide2.QtCore.QObject,name:QString=QString())->bool",
    "PySide2.QtRemoteObjects.QRemoteObjectHostBase.hostUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtRemoteObjects.QRemoteObjectHostBase.proxy(self,registryUrl:PySide2.QtCore.QUrl,hostUrl:PySide2.QtCore.QUrl={})->bool",
    "PySide2.QtRemoteObjects.QRemoteObjectHostBase.reverseProxy(self)->bool",
    "PySide2.QtRemoteObjects.QRemoteObjectHostBase.setHostUrl(self,hostAddress:PySide2.QtCore.QUrl,allowedSchemas:PySide2.QtRemoteObjects.QRemoteObjectHostBase.AllowedSchemas=BuiltInSchemasOnly)->bool",
    "PySide2.QtRemoteObjects.QRemoteObjectHostBase.setName(self,name:QString)",
    nullptr}; // Sentinel

void init_QRemoteObjectHostBase(PyObject *module)
{
    _Sbk_QRemoteObjectHostBase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRemoteObjectHostBase",
        "QRemoteObjectHostBase*",
        &Sbk_QRemoteObjectHostBase_spec,
        &Shiboken::callCppDestructor< ::QRemoteObjectHostBase >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTNODE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRemoteObjectHostBase_Type);
    InitSignatureStrings(pyType, QRemoteObjectHostBase_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRemoteObjectHostBase_Type), Sbk_QRemoteObjectHostBase_PropertyStrings);
    SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRemoteObjectHostBase_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRemoteObjectHostBase_TypeF(),
        QRemoteObjectHostBase_PythonToCpp_QRemoteObjectHostBase_PTR,
        is_QRemoteObjectHostBase_PythonToCpp_QRemoteObjectHostBase_PTR_Convertible,
        QRemoteObjectHostBase_PTR_CppToPython_QRemoteObjectHostBase);

    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectHostBase");
    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectHostBase*");
    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectHostBase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRemoteObjectHostBase).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRemoteObjectHostBaseWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QRemoteObjectHostBase_TypeF(), &Sbk_QRemoteObjectHostBase_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'AllowedSchemas'.
    SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRemoteObjectHostBase_TypeF(),
        "AllowedSchemas",
        "2:PySide2.QtRemoteObjects.QRemoteObjectHostBase.AllowedSchemas",
        "QRemoteObjectHostBase::AllowedSchemas");
    if (!SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX],
        Sbk_QRemoteObjectHostBase_TypeF(), "BuiltInSchemasOnly", (long) QRemoteObjectHostBase::AllowedSchemas::BuiltInSchemasOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX],
        Sbk_QRemoteObjectHostBase_TypeF(), "AllowExternalRegistration", (long) QRemoteObjectHostBase::AllowedSchemas::AllowExternalRegistration))
        return;
    // Register converter for enum 'QRemoteObjectHostBase::AllowedSchemas'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX],
            QRemoteObjectHostBase_AllowedSchemas_CppToPython_QRemoteObjectHostBase_AllowedSchemas);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRemoteObjectHostBase_AllowedSchemas_PythonToCpp_QRemoteObjectHostBase_AllowedSchemas,
            is_QRemoteObjectHostBase_AllowedSchemas_PythonToCpp_QRemoteObjectHostBase_AllowedSchemas_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectHostBase::AllowedSchemas");
        Shiboken::Conversions::registerConverterName(converter, "AllowedSchemas");
    }
    // End of 'AllowedSchemas' enum.

    PySide::Signal::registerSignals(Sbk_QRemoteObjectHostBase_TypeF(), &::QRemoteObjectHostBase::staticMetaObject);
    qRegisterMetaType< ::QRemoteObjectHostBase::AllowedSchemas >("QRemoteObjectHostBase::AllowedSchemas");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QRemoteObjectHostBase_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QRemoteObjectHostBase_TypeF(), &::QRemoteObjectHostBase::staticMetaObject, sizeof(QRemoteObjectHostBaseWrapper));
}
