/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtscript_python.h"

// main header
#include "qscriptengine_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QScriptEngineWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QScriptEngineWrapper::QScriptEngineWrapper() : QScriptEngine()
{
    resetPyMethodCache();
    // ... middle
}

QScriptEngineWrapper::QScriptEngineWrapper(::QObject * parent) : QScriptEngine(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QScriptEngineWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QScriptEngineWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScriptEngineWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QScriptEngineWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QScriptEngineWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptEngine.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QScriptEngineWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptEngine.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QScriptEngineWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QScriptEngineWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QScriptEngine::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QScriptEngineWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QScriptEngine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QScriptEngineWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QScriptEngineWrapper *>(this));
        return QScriptEngine::qt_metacast(_clname);
}

QScriptEngineWrapper::~QScriptEngineWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScriptEngine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScriptEngine >()))
        return -1;

    ::QScriptEngineWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScriptEngine", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QScriptEngine::QScriptEngine()
    // 1: QScriptEngine::QScriptEngine(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QScriptEngine()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QScriptEngine(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngine_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QScriptEngine()
        {

            if (!PyErr_Occurred()) {
                // QScriptEngine()
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QScriptEngineWrapper();
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QScriptEngineWrapper();
                }

            }
            break;
        }
        case 1: // QScriptEngine(QObject * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScriptEngine(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QScriptEngineWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QScriptEngineWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScriptEngine >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScriptEngine_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QScriptEngine_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QScriptEngine_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScriptEngineFunc_abortEvaluation(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.abortEvaluation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_abortEvaluation_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:abortEvaluation", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::abortEvaluation(QScriptValue)
    if (numArgs == 0) {
        overloadId = 0; // abortEvaluation(QScriptValue)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // abortEvaluation(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_abortEvaluation_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_result = Shiboken::String::createStaticString("result");
            if (PyDict_Contains(kwds, key_result)) {
                value = PyDict_GetItem(kwds, key_result);
                if (value && pyArgs[0]) {
                    errInfo = key_result;
                    Py_INCREF(errInfo);
                    goto Sbk_QScriptEngineFunc_abortEvaluation_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0]))))
                        goto Sbk_QScriptEngineFunc_abortEvaluation_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_result);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QScriptEngineFunc_abortEvaluation_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QScriptValue cppArg0_local = QScriptValue();
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // abortEvaluation(QScriptValue)
            cppSelf->abortEvaluation(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineFunc_abortEvaluation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_agent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.agent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // agent()const
            QScriptEngineAgent * cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->agent();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_availableExtensions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.availableExtensions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableExtensions()const
            QStringList cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->availableExtensions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_canEvaluate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.canEvaluate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::canEvaluate(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // canEvaluate(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_canEvaluate_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // canEvaluate(QString)const
            bool cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->canEvaluate(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_canEvaluate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_clearExceptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.clearExceptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearExceptions()
            cppSelf->clearExceptions();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptEngineFunc_collectGarbage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.collectGarbage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // collectGarbage()
            cppSelf->collectGarbage();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptEngineFunc_currentContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.currentContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentContext()const
            QScriptContext * cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->currentContext();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_defaultPrototype(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.defaultPrototype";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::defaultPrototype(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // defaultPrototype(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_defaultPrototype_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // defaultPrototype(int)const
            QScriptValue cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->defaultPrototype(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_defaultPrototype_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_evaluate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.evaluate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_evaluate_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_evaluate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:evaluate", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::evaluate(QScriptProgram)
    // 1: QScriptEngine::evaluate(QString,QString,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // evaluate(QString,QString,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // evaluate(QString,QString,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 1; // evaluate(QString,QString,int)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTPROGRAM_IDX]), (pyArgs[0])))) {
        overloadId = 0; // evaluate(QScriptProgram)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_evaluate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // evaluate(const QScriptProgram & program)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QScriptEngineFunc_evaluate_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptProgram cppArg0_local;
            ::QScriptProgram *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTPROGRAM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // evaluate(QScriptProgram)
                QScriptValue cppResult = cppSelf->evaluate(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // evaluate(const QString & program, const QString & fileName, int lineNumber)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_fileName = Shiboken::String::createStaticString("fileName");
                if (PyDict_Contains(kwds, key_fileName)) {
                    value = PyDict_GetItem(kwds, key_fileName);
                    if (value && pyArgs[1]) {
                        errInfo = key_fileName;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptEngineFunc_evaluate_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QScriptEngineFunc_evaluate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_fileName);
                }
                static PyObject *const key_lineNumber = Shiboken::String::createStaticString("lineNumber");
                if (PyDict_Contains(kwds, key_lineNumber)) {
                    value = PyDict_GetItem(kwds, key_lineNumber);
                    if (value && pyArgs[2]) {
                        errInfo = key_lineNumber;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptEngineFunc_evaluate_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QScriptEngineFunc_evaluate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_lineNumber);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptEngineFunc_evaluate_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // evaluate(QString,QString,int)
                QScriptValue cppResult = cppSelf->evaluate(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_evaluate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_globalObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.globalObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalObject()const
            QScriptValue cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->globalObject();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_hasUncaughtException(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.hasUncaughtException";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasUncaughtException()const
            bool cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->hasUncaughtException();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_importExtension(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.importExtension";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::importExtension(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // importExtension(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_importExtension_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // importExtension(QString)
            QScriptValue cppResult = cppSelf->importExtension(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_importExtension_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_importedExtensions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.importedExtensions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // importedExtensions()const
            QStringList cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->importedExtensions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_installTranslatorFunctions(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.installTranslatorFunctions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_installTranslatorFunctions_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:installTranslatorFunctions", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::installTranslatorFunctions(QScriptValue)
    if (numArgs == 0) {
        overloadId = 0; // installTranslatorFunctions(QScriptValue)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // installTranslatorFunctions(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_installTranslatorFunctions_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_object = Shiboken::String::createStaticString("object");
            if (PyDict_Contains(kwds, key_object)) {
                value = PyDict_GetItem(kwds, key_object);
                if (value && pyArgs[0]) {
                    errInfo = key_object;
                    Py_INCREF(errInfo);
                    goto Sbk_QScriptEngineFunc_installTranslatorFunctions_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0]))))
                        goto Sbk_QScriptEngineFunc_installTranslatorFunctions_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_object);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QScriptEngineFunc_installTranslatorFunctions_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QScriptValue cppArg0_local = QScriptValue();
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // installTranslatorFunctions(QScriptValue)
            cppSelf->installTranslatorFunctions(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineFunc_installTranslatorFunctions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_isEvaluating(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.isEvaluating";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEvaluating()const
            bool cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->isEvaluating();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_newActivationObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.newActivationObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // newActivationObject()
            QScriptValue cppResult = cppSelf->newActivationObject();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_newArray(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.newArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_newArray_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:newArray", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::newArray(uint)
    if (numArgs == 0) {
        overloadId = 0; // newArray(uint)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // newArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_newArray_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_length = Shiboken::String::createStaticString("length");
            if (PyDict_Contains(kwds, key_length)) {
                value = PyDict_GetItem(kwds, key_length);
                if (value && pyArgs[0]) {
                    errInfo = key_length;
                    Py_INCREF(errInfo);
                    goto Sbk_QScriptEngineFunc_newArray_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))
                        goto Sbk_QScriptEngineFunc_newArray_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_length);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QScriptEngineFunc_newArray_TypeError;
            }
        }
        uint cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // newArray(uint)
            QScriptValue cppResult = cppSelf->newArray(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_newArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_newDate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.newDate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::newDate(QDateTime)
    // 1: QScriptEngine::newDate(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 1; // newDate(double)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // newDate(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_newDate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // newDate(const QDateTime & value)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDateTime cppArg0_local;
            ::QDateTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // newDate(QDateTime)
                QScriptValue cppResult = cppSelf->newDate(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // newDate(double value)
        {
            double cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // newDate(double)
                QScriptValue cppResult = cppSelf->newDate(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_newDate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_newObject(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.newObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_newObject_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:newObject", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::newObject()
    // 1: QScriptEngine::newObject(QScriptClass*,QScriptValue)
    if (numArgs == 0) {
        overloadId = 0; // newObject()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // newObject(QScriptClass*,QScriptValue)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // newObject(QScriptClass*,QScriptValue)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_newObject_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // newObject()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QScriptEngineFunc_newObject_TypeError;
            }

            if (!PyErr_Occurred()) {
                // newObject()
                QScriptValue cppResult = cppSelf->newObject();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // newObject(QScriptClass * scriptClass, const QScriptValue & data)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_data = Shiboken::String::createStaticString("data");
                if (PyDict_Contains(kwds, key_data)) {
                    value = PyDict_GetItem(kwds, key_data);
                    if (value && pyArgs[1]) {
                        errInfo = key_data;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptEngineFunc_newObject_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1]))))
                            goto Sbk_QScriptEngineFunc_newObject_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_data);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptEngineFunc_newObject_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptClass *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QScriptValue cppArg1_local = QScriptValue();
            ::QScriptValue *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // newObject(QScriptClass*,QScriptValue)
                QScriptValue cppResult = cppSelf->newObject(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_newObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_newQMetaObject(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.newQMetaObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_newQMetaObject_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_newQMetaObject_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:newQMetaObject", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::newQMetaObject(const QMetaObject*,QScriptValue)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // newQMetaObject(const QMetaObject*,QScriptValue)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))) {
            overloadId = 0; // newQMetaObject(const QMetaObject*,QScriptValue)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_newQMetaObject_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_ctor = Shiboken::String::createStaticString("ctor");
            if (PyDict_Contains(kwds, key_ctor)) {
                value = PyDict_GetItem(kwds, key_ctor);
                if (value && pyArgs[1]) {
                    errInfo = key_ctor;
                    Py_INCREF(errInfo);
                    goto Sbk_QScriptEngineFunc_newQMetaObject_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1]))))
                        goto Sbk_QScriptEngineFunc_newQMetaObject_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_ctor);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QScriptEngineFunc_newQMetaObject_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMetaObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QScriptValue cppArg1_local = QScriptValue();
        ::QScriptValue *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // newQMetaObject(const QMetaObject*,QScriptValue)
            QScriptValue cppResult = cppSelf->newQMetaObject(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_newQMetaObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_newQObject(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.newQObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_newQObject_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScriptEngineFunc_newQObject_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:newQObject", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::newQObject(QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
    // 1: QScriptEngine::newQObject(QScriptValue,QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // newQObject(QScriptValue,QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // newQObject(QScriptValue,QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, (pyArgs[3])))) {
                overloadId = 1; // newQObject(QScriptValue,QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // newQObject(QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // newQObject(QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // newQObject(QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_newQObject_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // newQObject(QObject * object, QScriptEngine::ValueOwnership ownership, const QFlags<QScriptEngine::QObjectWrapOption> & options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_ownership = Shiboken::String::createStaticString("ownership");
                if (PyDict_Contains(kwds, key_ownership)) {
                    value = PyDict_GetItem(kwds, key_ownership);
                    if (value && pyArgs[1]) {
                        errInfo = key_ownership;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_ownership);
                }
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QScriptEngine::ValueOwnership cppArg1 = QScriptEngine::ValueOwnership::QtOwnership;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QScriptEngine::QObjectWrapOption> cppArg2 = QScriptEngine::QObjectWrapOptions();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // newQObject(QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
                QScriptValue cppResult = cppSelf->newQObject(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // newQObject(const QScriptValue & scriptObject, QObject * qtObject, QScriptEngine::ValueOwnership ownership, const QFlags<QScriptEngine::QObjectWrapOption> & options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_ownership = Shiboken::String::createStaticString("ownership");
                if (PyDict_Contains(kwds, key_ownership)) {
                    value = PyDict_GetItem(kwds, key_ownership);
                    if (value && pyArgs[2]) {
                        errInfo = key_ownership;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_ownership);
                }
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[3]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QScriptEngineFunc_newQObject_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptValue cppArg0_local;
            ::QScriptValue *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QScriptEngine::ValueOwnership cppArg2 = QScriptEngine::ValueOwnership::QtOwnership;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<QScriptEngine::QObjectWrapOption> cppArg3 = QScriptEngine::QObjectWrapOptions();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // newQObject(QScriptValue,QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
                QScriptValue cppResult = cppSelf->newQObject(*cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_newQObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_newRegExp(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.newRegExp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "newRegExp", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::newRegExp(QRegExp)
    // 1: QScriptEngine::newRegExp(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 1; // newRegExp(QString,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArgs[0])))) {
        overloadId = 0; // newRegExp(QRegExp)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_newRegExp_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // newRegExp(const QRegExp & regexp)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRegExp cppArg0_local;
            ::QRegExp *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // newRegExp(QRegExp)
                QScriptValue cppResult = cppSelf->newRegExp(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // newRegExp(const QString & pattern, const QString & flags)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // newRegExp(QString,QString)
                QScriptValue cppResult = cppSelf->newRegExp(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_newRegExp_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_newVariant(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.newVariant";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "newVariant", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::newVariant(QScriptValue,QVariant)
    // 1: QScriptEngine::newVariant(QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // newVariant(QScriptValue,QVariant)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[0])))) {
        overloadId = 1; // newVariant(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_newVariant_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // newVariant(const QScriptValue & object, const QVariant & value)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QScriptValue cppArg0_local;
            ::QScriptValue *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QVariant cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // newVariant(QScriptValue,QVariant)
                QScriptValue cppResult = cppSelf->newVariant(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // newVariant(const QVariant & value)
        {
            ::QVariant cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // newVariant(QVariant)
                QScriptValue cppResult = cppSelf->newVariant(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_newVariant_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_nullValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.nullValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nullValue()
            QScriptValue cppResult = cppSelf->nullValue();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_objectById(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.objectById";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::objectById(qint64)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // objectById(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_objectById_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // objectById(qint64)const
            QScriptValue cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->objectById(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_objectById_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_popContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.popContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // popContext()
            cppSelf->popContext();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScriptEngineFunc_processEventsInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.processEventsInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // processEventsInterval()const
            int cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->processEventsInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_pushContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.pushContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pushContext()
            QScriptContext * cppResult = cppSelf->pushContext();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_reportAdditionalMemoryCost(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.reportAdditionalMemoryCost";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::reportAdditionalMemoryCost(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // reportAdditionalMemoryCost(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_reportAdditionalMemoryCost_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // reportAdditionalMemoryCost(int)
            cppSelf->reportAdditionalMemoryCost(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineFunc_reportAdditionalMemoryCost_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_setAgent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.setAgent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::setAgent(QScriptEngineAgent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINEAGENT_IDX]), (pyArg)))) {
        overloadId = 0; // setAgent(QScriptEngineAgent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_setAgent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptEngineAgent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAgent(QScriptEngineAgent*)
            cppSelf->setAgent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineFunc_setAgent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_setDefaultPrototype(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.setDefaultPrototype";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setDefaultPrototype", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptEngine::setDefaultPrototype(int,QScriptValue)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setDefaultPrototype(int,QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_setDefaultPrototype_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QScriptValue cppArg1_local;
        ::QScriptValue *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setDefaultPrototype(int,QScriptValue)
            cppSelf->setDefaultPrototype(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineFunc_setDefaultPrototype_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_setGlobalObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.setGlobalObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::setGlobalObject(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // setGlobalObject(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_setGlobalObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGlobalObject(QScriptValue)
            cppSelf->setGlobalObject(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineFunc_setGlobalObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_setProcessEventsInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.setProcessEventsInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::setProcessEventsInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setProcessEventsInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_setProcessEventsInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProcessEventsInterval(int)
            cppSelf->setProcessEventsInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptEngineFunc_setProcessEventsInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_toObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.toObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::toObject(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // toObject(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_toObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // toObject(QScriptValue)
            QScriptValue cppResult = cppSelf->toObject(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_toObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_toStringHandle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.toStringHandle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptEngine::toStringHandle(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // toStringHandle(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptEngineFunc_toStringHandle_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // toStringHandle(QString)
            QScriptString cppResult = cppSelf->toStringHandle(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptEngineFunc_toStringHandle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptEngineFunc_uncaughtException(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.uncaughtException";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uncaughtException()const
            QScriptValue cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->uncaughtException();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_uncaughtExceptionBacktrace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.uncaughtExceptionBacktrace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uncaughtExceptionBacktrace()const
            QStringList cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->uncaughtExceptionBacktrace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_uncaughtExceptionLineNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.uncaughtExceptionLineNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uncaughtExceptionLineNumber()const
            int cppResult = const_cast<const ::QScriptEngine *>(cppSelf)->uncaughtExceptionLineNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptEngineFunc_undefinedValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptEngine.undefinedValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // undefinedValue()
            QScriptValue cppResult = cppSelf->undefinedValue();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScriptEngine_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScriptEngine_methods[] = {
    {"abortEvaluation", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_abortEvaluation), METH_VARARGS|METH_KEYWORDS},
    {"agent", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_agent), METH_NOARGS},
    {"availableExtensions", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_availableExtensions), METH_NOARGS},
    {"canEvaluate", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_canEvaluate), METH_O},
    {"clearExceptions", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_clearExceptions), METH_NOARGS},
    {"collectGarbage", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_collectGarbage), METH_NOARGS},
    {"currentContext", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_currentContext), METH_NOARGS},
    {"defaultPrototype", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_defaultPrototype), METH_O},
    {"evaluate", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_evaluate), METH_VARARGS|METH_KEYWORDS},
    {"globalObject", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_globalObject), METH_NOARGS},
    {"hasUncaughtException", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_hasUncaughtException), METH_NOARGS},
    {"importExtension", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_importExtension), METH_O},
    {"importedExtensions", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_importedExtensions), METH_NOARGS},
    {"installTranslatorFunctions", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_installTranslatorFunctions), METH_VARARGS|METH_KEYWORDS},
    {"isEvaluating", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_isEvaluating), METH_NOARGS},
    {"newActivationObject", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_newActivationObject), METH_NOARGS},
    {"newArray", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_newArray), METH_VARARGS|METH_KEYWORDS},
    {"newDate", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_newDate), METH_O},
    {"newObject", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_newObject), METH_VARARGS|METH_KEYWORDS},
    {"newQMetaObject", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_newQMetaObject), METH_VARARGS|METH_KEYWORDS},
    {"newQObject", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_newQObject), METH_VARARGS|METH_KEYWORDS},
    {"newRegExp", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_newRegExp), METH_VARARGS},
    {"newVariant", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_newVariant), METH_VARARGS},
    {"nullValue", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_nullValue), METH_NOARGS},
    {"objectById", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_objectById), METH_O},
    {"popContext", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_popContext), METH_NOARGS},
    {"processEventsInterval", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_processEventsInterval), METH_NOARGS},
    {"pushContext", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_pushContext), METH_NOARGS},
    {"reportAdditionalMemoryCost", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_reportAdditionalMemoryCost), METH_O},
    {"setAgent", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_setAgent), METH_O},
    {"setDefaultPrototype", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_setDefaultPrototype), METH_VARARGS},
    {"setGlobalObject", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_setGlobalObject), METH_O},
    {"setProcessEventsInterval", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_setProcessEventsInterval), METH_O},
    {"toObject", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_toObject), METH_O},
    {"toStringHandle", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_toStringHandle), METH_O},
    {"uncaughtException", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_uncaughtException), METH_NOARGS},
    {"uncaughtExceptionBacktrace", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_uncaughtExceptionBacktrace), METH_NOARGS},
    {"uncaughtExceptionLineNumber", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_uncaughtExceptionLineNumber), METH_NOARGS},
    {"undefinedValue", reinterpret_cast<PyCFunction>(Sbk_QScriptEngineFunc_undefinedValue), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScriptEngine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QScriptEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QScriptEngineWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QScriptEngine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScriptEngine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScriptEngine_Type = nullptr;
static SbkObjectType *Sbk_QScriptEngine_TypeF(void)
{
    return _Sbk_QScriptEngine_Type;
}

static PyType_Slot Sbk_QScriptEngine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScriptEngine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScriptEngine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScriptEngine_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScriptEngine_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScriptEngine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScriptEngine_spec = {
    "2:PySide2.QtScript.QScriptEngine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScriptEngine_slots
};

} //extern "C"

static void *Sbk_QScriptEngine_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QScriptEngine *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QScriptEngine::QObjectWrapOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QScriptEngine::QObjectWrapOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QScriptEngine::QObjectWrapOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QScriptEngine::QObjectWrapOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QScriptEngine::QObjectWrapOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QScriptEngine::QObjectWrapOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QScriptEngine::QObjectWrapOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QScriptEngine::QObjectWrapOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QScriptEngine::QObjectWrapOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QScriptEngine::QObjectWrapOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QScriptEngine::QObjectWrapOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QScriptEngine::QObjectWrapOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QScriptEngine::QObjectWrapOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QScriptEngine::QObjectWrapOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QScriptEngine::QObjectWrapOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QScriptEngine::QObjectWrapOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, self, &cppSelf);
    ::QScriptEngine::QObjectWrapOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QScriptEngine_ValueOwnership_PythonToCpp_QScriptEngine_ValueOwnership(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptEngine::ValueOwnership *>(cppOut) =
        static_cast<::QScriptEngine::ValueOwnership>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptEngine_ValueOwnership_PythonToCpp_QScriptEngine_ValueOwnership_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX]))
        return QScriptEngine_ValueOwnership_PythonToCpp_QScriptEngine_ValueOwnership;
    return {};
}
static PyObject *QScriptEngine_ValueOwnership_CppToPython_QScriptEngine_ValueOwnership(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptEngine::ValueOwnership *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX], castCppIn);

}

static void QScriptEngine_QObjectWrapOption_PythonToCpp_QScriptEngine_QObjectWrapOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptEngine::QObjectWrapOption *>(cppOut) =
        static_cast<::QScriptEngine::QObjectWrapOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptEngine_QObjectWrapOption_PythonToCpp_QScriptEngine_QObjectWrapOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX]))
        return QScriptEngine_QObjectWrapOption_PythonToCpp_QScriptEngine_QObjectWrapOption;
    return {};
}
static PyObject *QScriptEngine_QObjectWrapOption_CppToPython_QScriptEngine_QObjectWrapOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptEngine::QObjectWrapOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX], castCppIn);

}

static void QFlags_QScriptEngine_QObjectWrapOption__PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QScriptEngine::QObjectWrapOption> *>(cppOut) =
        ::QFlags<QScriptEngine::QObjectWrapOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QScriptEngine_QObjectWrapOption__PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX]))
        return QFlags_QScriptEngine_QObjectWrapOption__PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption_;
    return {};
}
static PyObject *QFlags_QScriptEngine_QObjectWrapOption__CppToPython_QFlags_QScriptEngine_QObjectWrapOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QScriptEngine::QObjectWrapOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX]));

}

static void QScriptEngine_QObjectWrapOption_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QScriptEngine::QObjectWrapOption> *>(cppOut) =
        ::QFlags<QScriptEngine::QObjectWrapOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QScriptEngine_QObjectWrapOption_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX]))
        return QScriptEngine_QObjectWrapOption_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QScriptEngine::QObjectWrapOption> *>(cppOut) =
        ::QFlags<QScriptEngine::QObjectWrapOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX]))
        return number_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScriptEngine_PythonToCpp_QScriptEngine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScriptEngine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScriptEngine_PythonToCpp_QScriptEngine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScriptEngine_TypeF())))
        return QScriptEngine_PythonToCpp_QScriptEngine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScriptEngine_PTR_CppToPython_QScriptEngine(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QScriptEngine *>(const_cast<void *>(cppIn)), Sbk_QScriptEngine_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScriptEngine_SignatureStrings[] = {
    "1:PySide2.QtScript.QScriptEngine(self)",
    "0:PySide2.QtScript.QScriptEngine(self,parent:PySide2.QtCore.QObject)",
    "PySide2.QtScript.QScriptEngine.abortEvaluation(self,result:PySide2.QtScript.QScriptValue=QScriptValue())",
    "PySide2.QtScript.QScriptEngine.agent(self)->PySide2.QtScript.QScriptEngineAgent",
    "PySide2.QtScript.QScriptEngine.availableExtensions(self)->QStringList",
    "PySide2.QtScript.QScriptEngine.canEvaluate(self,program:QString)->bool",
    "PySide2.QtScript.QScriptEngine.clearExceptions(self)",
    "PySide2.QtScript.QScriptEngine.collectGarbage(self)",
    "PySide2.QtScript.QScriptEngine.currentContext(self)->PySide2.QtScript.QScriptContext",
    "PySide2.QtScript.QScriptEngine.defaultPrototype(self,metaTypeId:int)->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptEngine.evaluate(self,program:PySide2.QtScript.QScriptProgram)->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptEngine.evaluate(self,program:QString,fileName:QString=QString(),lineNumber:int=1)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.globalObject(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.hasUncaughtException(self)->bool",
    "PySide2.QtScript.QScriptEngine.importExtension(self,extension:QString)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.importedExtensions(self)->QStringList",
    "PySide2.QtScript.QScriptEngine.installTranslatorFunctions(self,object:PySide2.QtScript.QScriptValue=QScriptValue())",
    "PySide2.QtScript.QScriptEngine.isEvaluating(self)->bool",
    "PySide2.QtScript.QScriptEngine.newActivationObject(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.newArray(self,length:uint=0)->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptEngine.newDate(self,value:PySide2.QtCore.QDateTime)->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptEngine.newDate(self,value:double)->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptEngine.newObject(self)->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptEngine.newObject(self,scriptClass:PySide2.QtScript.QScriptClass,data:PySide2.QtScript.QScriptValue=QScriptValue())->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.newQMetaObject(self,metaObject:PySide2.QtCore.QMetaObject,ctor:PySide2.QtScript.QScriptValue=QScriptValue())->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptEngine.newQObject(self,object:PySide2.QtCore.QObject,ownership:PySide2.QtScript.QScriptEngine.ValueOwnership=QtOwnership,options:PySide2.QtScript.QScriptEngine.QObjectWrapOptions=QScriptEngine.QObjectWrapOptions())->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptEngine.newQObject(self,scriptObject:PySide2.QtScript.QScriptValue,qtObject:PySide2.QtCore.QObject,ownership:PySide2.QtScript.QScriptEngine.ValueOwnership=QtOwnership,options:PySide2.QtScript.QScriptEngine.QObjectWrapOptions=QScriptEngine.QObjectWrapOptions())->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptEngine.newRegExp(self,regexp:PySide2.QtCore.QRegExp)->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptEngine.newRegExp(self,pattern:QString,flags:QString)->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptEngine.newVariant(self,object:PySide2.QtScript.QScriptValue,value:QVariant)->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptEngine.newVariant(self,value:QVariant)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.nullValue(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.objectById(self,id:qint64)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.popContext(self)",
    "PySide2.QtScript.QScriptEngine.processEventsInterval(self)->int",
    "PySide2.QtScript.QScriptEngine.pushContext(self)->PySide2.QtScript.QScriptContext",
    "PySide2.QtScript.QScriptEngine.reportAdditionalMemoryCost(self,size:int)",
    "PySide2.QtScript.QScriptEngine.setAgent(self,agent:PySide2.QtScript.QScriptEngineAgent)",
    "PySide2.QtScript.QScriptEngine.setDefaultPrototype(self,metaTypeId:int,prototype:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptEngine.setGlobalObject(self,object:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptEngine.setProcessEventsInterval(self,interval:int)",
    "PySide2.QtScript.QScriptEngine.toObject(self,value:PySide2.QtScript.QScriptValue)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.toStringHandle(self,str:QString)->PySide2.QtScript.QScriptString",
    "PySide2.QtScript.QScriptEngine.uncaughtException(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptEngine.uncaughtExceptionBacktrace(self)->QStringList",
    "PySide2.QtScript.QScriptEngine.uncaughtExceptionLineNumber(self)->int",
    "PySide2.QtScript.QScriptEngine.undefinedValue(self)->PySide2.QtScript.QScriptValue",
    nullptr}; // Sentinel

void init_QScriptEngine(PyObject *module)
{
    _Sbk_QScriptEngine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScriptEngine",
        "QScriptEngine*",
        &Sbk_QScriptEngine_spec,
        &Shiboken::callCppDestructor< ::QScriptEngine >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScriptEngine_Type);
    InitSignatureStrings(pyType, QScriptEngine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScriptEngine_Type), Sbk_QScriptEngine_PropertyStrings);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScriptEngine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScriptEngine_TypeF(),
        QScriptEngine_PythonToCpp_QScriptEngine_PTR,
        is_QScriptEngine_PythonToCpp_QScriptEngine_PTR_Convertible,
        QScriptEngine_PTR_CppToPython_QScriptEngine);

    Shiboken::Conversions::registerConverterName(converter, "QScriptEngine");
    Shiboken::Conversions::registerConverterName(converter, "QScriptEngine*");
    Shiboken::Conversions::registerConverterName(converter, "QScriptEngine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptEngine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptEngineWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QScriptEngine_TypeF(), &Sbk_QScriptEngine_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ValueOwnership'.
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptEngine_TypeF(),
        "ValueOwnership",
        "2:PySide2.QtScript.QScriptEngine.ValueOwnership",
        "QScriptEngine::ValueOwnership");
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX],
        Sbk_QScriptEngine_TypeF(), "QtOwnership", (long) QScriptEngine::ValueOwnership::QtOwnership))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX],
        Sbk_QScriptEngine_TypeF(), "ScriptOwnership", (long) QScriptEngine::ValueOwnership::ScriptOwnership))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX],
        Sbk_QScriptEngine_TypeF(), "AutoOwnership", (long) QScriptEngine::ValueOwnership::AutoOwnership))
        return;
    // Register converter for enum 'QScriptEngine::ValueOwnership'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX],
            QScriptEngine_ValueOwnership_CppToPython_QScriptEngine_ValueOwnership);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptEngine_ValueOwnership_PythonToCpp_QScriptEngine_ValueOwnership,
            is_QScriptEngine_ValueOwnership_PythonToCpp_QScriptEngine_ValueOwnership_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptEngine::ValueOwnership");
        Shiboken::Conversions::registerConverterName(converter, "ValueOwnership");
    }
    // End of 'ValueOwnership' enum.

    // Initialization of enum 'QObjectWrapOption'.
    SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtScript.QScriptEngine.QObjectWrapOptions", SbkPySide2_QtScript_QScriptEngine_QObjectWrapOption_number_slots);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptEngine_TypeF(),
        "QObjectWrapOption",
        "2:PySide2.QtScript.QScriptEngine.QObjectWrapOption",
        "QScriptEngine::QObjectWrapOption",
        SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX]);
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
        Sbk_QScriptEngine_TypeF(), "ExcludeChildObjects", (long) QScriptEngine::QObjectWrapOption::ExcludeChildObjects))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
        Sbk_QScriptEngine_TypeF(), "ExcludeSuperClassMethods", (long) QScriptEngine::QObjectWrapOption::ExcludeSuperClassMethods))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
        Sbk_QScriptEngine_TypeF(), "ExcludeSuperClassProperties", (long) QScriptEngine::QObjectWrapOption::ExcludeSuperClassProperties))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
        Sbk_QScriptEngine_TypeF(), "ExcludeSuperClassContents", (long) QScriptEngine::QObjectWrapOption::ExcludeSuperClassContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
        Sbk_QScriptEngine_TypeF(), "SkipMethodsInEnumeration", (long) QScriptEngine::QObjectWrapOption::SkipMethodsInEnumeration))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
        Sbk_QScriptEngine_TypeF(), "ExcludeDeleteLater", (long) QScriptEngine::QObjectWrapOption::ExcludeDeleteLater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
        Sbk_QScriptEngine_TypeF(), "ExcludeSlots", (long) QScriptEngine::QObjectWrapOption::ExcludeSlots))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
        Sbk_QScriptEngine_TypeF(), "AutoCreateDynamicProperties", (long) QScriptEngine::QObjectWrapOption::AutoCreateDynamicProperties))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
        Sbk_QScriptEngine_TypeF(), "PreferExistingWrapperObject", (long) QScriptEngine::QObjectWrapOption::PreferExistingWrapperObject))
        return;
    // Register converter for enum 'QScriptEngine::QObjectWrapOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
            QScriptEngine_QObjectWrapOption_CppToPython_QScriptEngine_QObjectWrapOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptEngine_QObjectWrapOption_PythonToCpp_QScriptEngine_QObjectWrapOption,
            is_QScriptEngine_QObjectWrapOption_PythonToCpp_QScriptEngine_QObjectWrapOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptEngine::QObjectWrapOption");
        Shiboken::Conversions::registerConverterName(converter, "QObjectWrapOption");
    }
    // Register converter for flag 'QFlags<QScriptEngine::QObjectWrapOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX],
            QFlags_QScriptEngine_QObjectWrapOption__CppToPython_QFlags_QScriptEngine_QObjectWrapOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptEngine_QObjectWrapOption_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption_,
            is_QScriptEngine_QObjectWrapOption_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QScriptEngine_QObjectWrapOption__PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption_,
            is_QFlags_QScriptEngine_QObjectWrapOption__PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption_,
            is_number_PythonToCpp_QFlags_QScriptEngine_QObjectWrapOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptEngine::QObjectWrapOptions");
        Shiboken::Conversions::registerConverterName(converter, "QObjectWrapOptions");
    }
    // End of 'QObjectWrapOption' enum/flags.

    PySide::Signal::registerSignals(Sbk_QScriptEngine_TypeF(), &::QScriptEngine::staticMetaObject);
    qRegisterMetaType< ::QScriptEngine::ValueOwnership >("QScriptEngine::ValueOwnership");
    qRegisterMetaType< ::QScriptEngine::QObjectWrapOption >("QScriptEngine::QObjectWrapOption");
    qRegisterMetaType< ::QScriptEngine::QObjectWrapOptions >("QScriptEngine::QObjectWrapOptions");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QScriptEngine_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QScriptEngine_TypeF(), &::QScriptEngine::staticMetaObject, sizeof(QScriptEngineWrapper));
}
