/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QSCRIPTENGINEAGENTWRAPPER_H
#define SBK_QSCRIPTENGINEAGENTWRAPPER_H

#define protected public

#include <QtScript/qscriptengineagent.h>


// Extra includes
#include <QtScript/qscriptengine.h>
#include <QtScript/qscriptvalue.h>
class QScriptEngineAgentWrapper : public QScriptEngineAgent
{
public:
    QScriptEngineAgentWrapper(::QScriptEngine * engine);
    void contextPop() override;
    void contextPush() override;
    void exceptionCatch(qint64 scriptId, const ::QScriptValue & exception) override;
    void exceptionThrow(qint64 scriptId, const ::QScriptValue & exception, bool hasHandler) override;
    ::QVariant extension(::QScriptEngineAgent::Extension extension, const ::QVariant & argument = QVariant()) override;
    void functionEntry(qint64 scriptId) override;
    void functionExit(qint64 scriptId, const ::QScriptValue & returnValue) override;
    void positionChange(qint64 scriptId, int lineNumber, int columnNumber) override;
    void scriptLoad(qint64 id, const ::QString & program, const ::QString & fileName, int baseLineNumber) override;
    void scriptUnload(qint64 id) override;
    bool supportsExtension(::QScriptEngineAgent::Extension extension) const override;
    ~QScriptEngineAgentWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[11];
};

#endif // SBK_QSCRIPTENGINEAGENTWRAPPER_H

