/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscxml_python.h"

// main header
#include "qscxmldatamodel_foreachloopbody_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void ForeachLoopBodyWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

ForeachLoopBodyWrapper::ForeachLoopBodyWrapper() : QScxmlDataModel::ForeachLoopBody()
{
    resetPyMethodCache();
    // ... middle
}

void ForeachLoopBodyWrapper::run(bool * ok)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'ForeachLoopBody.run()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "run";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'ForeachLoopBody.run()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

ForeachLoopBodyWrapper::~ForeachLoopBodyWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScxmlDataModel_ForeachLoopBody_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLDATAMODEL_FOREACHLOOPBODY_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QScxmlDataModel::ForeachLoopBody' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScxmlDataModel::ForeachLoopBody >()))
        return -1;

    ::ForeachLoopBodyWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlDataModel.ForeachLoopBody.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ForeachLoopBody()
            cptr = new ::ForeachLoopBodyWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScxmlDataModel::ForeachLoopBody >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QScxmlDataModel_ForeachLoopBodyFunc_run(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlDataModel::ForeachLoopBody *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLDATAMODEL_FOREACHLOOPBODY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlDataModel.ForeachLoopBody.run";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ForeachLoopBody::run(bool*)
    if (PyBool_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // run(bool*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlDataModel_ForeachLoopBodyFunc_run_TypeError;

    // Call function/method
    {
        bool *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // run(bool*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'ForeachLoopBody.run()' not implemented.");
                return {};
            }
            cppSelf->run(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlDataModel_ForeachLoopBodyFunc_run_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QScxmlDataModel_ForeachLoopBody_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScxmlDataModel_ForeachLoopBody_methods[] = {
    {"run", reinterpret_cast<PyCFunction>(Sbk_QScxmlDataModel_ForeachLoopBodyFunc_run), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScxmlDataModel_ForeachLoopBody_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QScxmlDataModel::ForeachLoopBody *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLDATAMODEL_FOREACHLOOPBODY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<ForeachLoopBodyWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QScxmlDataModel_ForeachLoopBody_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScxmlDataModel_ForeachLoopBody_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScxmlDataModel_ForeachLoopBody_Type = nullptr;
static SbkObjectType *Sbk_QScxmlDataModel_ForeachLoopBody_TypeF(void)
{
    return _Sbk_QScxmlDataModel_ForeachLoopBody_Type;
}

static PyType_Slot Sbk_QScxmlDataModel_ForeachLoopBody_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScxmlDataModel_ForeachLoopBody_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScxmlDataModel_ForeachLoopBody_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScxmlDataModel_ForeachLoopBody_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScxmlDataModel_ForeachLoopBody_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScxmlDataModel_ForeachLoopBody_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScxmlDataModel_ForeachLoopBody_spec = {
    "2:PySide2.QtScxml.QScxmlDataModel.ForeachLoopBody",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScxmlDataModel_ForeachLoopBody_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ForeachLoopBody_PythonToCpp_ForeachLoopBody_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScxmlDataModel_ForeachLoopBody_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ForeachLoopBody_PythonToCpp_ForeachLoopBody_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScxmlDataModel_ForeachLoopBody_TypeF())))
        return ForeachLoopBody_PythonToCpp_ForeachLoopBody_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ForeachLoopBody_PTR_CppToPython_ForeachLoopBody(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScxmlDataModel::ForeachLoopBody *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScxmlDataModel_ForeachLoopBody_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScxmlDataModel_ForeachLoopBody_SignatureStrings[] = {
    "PySide2.QtScxml.QScxmlDataModel.ForeachLoopBody(self)",
    "PySide2.QtScxml.QScxmlDataModel.ForeachLoopBody.run(self,ok:bool*)",
    nullptr}; // Sentinel

void init_QScxmlDataModel_ForeachLoopBody(PyObject *enclosingClass)
{
    _Sbk_QScxmlDataModel_ForeachLoopBody_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "ForeachLoopBody",
        "QScxmlDataModel::ForeachLoopBody*",
        &Sbk_QScxmlDataModel_ForeachLoopBody_spec,
        &Shiboken::callCppDestructor< ::QScxmlDataModel::ForeachLoopBody >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlDataModel_ForeachLoopBody_Type);
    InitSignatureStrings(pyType, QScxmlDataModel_ForeachLoopBody_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlDataModel_ForeachLoopBody_Type), Sbk_QScxmlDataModel_ForeachLoopBody_PropertyStrings);
    SbkPySide2_QtScxmlTypes[SBK_QSCXMLDATAMODEL_FOREACHLOOPBODY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScxmlDataModel_ForeachLoopBody_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScxmlDataModel_ForeachLoopBody_TypeF(),
        ForeachLoopBody_PythonToCpp_ForeachLoopBody_PTR,
        is_ForeachLoopBody_PythonToCpp_ForeachLoopBody_PTR_Convertible,
        ForeachLoopBody_PTR_CppToPython_ForeachLoopBody);

    Shiboken::Conversions::registerConverterName(converter, "QScxmlDataModel::ForeachLoopBody");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlDataModel::ForeachLoopBody*");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlDataModel::ForeachLoopBody&");
    Shiboken::Conversions::registerConverterName(converter, "ForeachLoopBody");
    Shiboken::Conversions::registerConverterName(converter, "ForeachLoopBody*");
    Shiboken::Conversions::registerConverterName(converter, "ForeachLoopBody&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScxmlDataModel::ForeachLoopBody).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::ForeachLoopBodyWrapper).name());


}
