/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QSCXMLDATAMODELWRAPPER_H
#define SBK_QSCXMLDATAMODELWRAPPER_H

#define protected public

#include <QtScxml/qscxmldatamodel.h>


// Extra includes
#include <qobject.h>
#include <QtScxml/qscxmlstatemachine.h>
#include <QMap>
#include <QtScxml/qscxmldatamodel.h>
#include <QtScxml/qscxmlevent.h>
#include <qcoreevent.h>
#include <qobjectdefs.h>
#include <qmetaobject.h>
#include <QList>
#include <qthread.h>
#include <qbytearray.h>
namespace PySide { class DynamicQMetaObject; }

class QScxmlDataModelWrapper : public QScxmlDataModel
{
public:
    QScxmlDataModelWrapper(::QObject * parent = nullptr);
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void evaluateAssignment(int id, bool * ok) override;
    void evaluateForeach(int id, bool * ok, ::QScxmlDataModel::ForeachLoopBody * body) override;
    void evaluateInitialization(int id, bool * ok) override;
    bool evaluateToBool(int id, bool * ok) override;
    ::QString evaluateToString(int id, bool * ok) override;
    ::QVariant evaluateToVariant(int id, bool * ok) override;
    void evaluateToVoid(int id, bool * ok) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool hasScxmlProperty(const ::QString & name) const override;
    const ::QMetaObject * metaObject() const override;
    ::QVariant scxmlProperty(const ::QString & name) const override;
    void setScxmlEvent(const ::QScxmlEvent & event) override;
    bool setScxmlProperty(const ::QString & name, const ::QVariant & value, const ::QString & context) override;
    bool setup(const ::QMap<QString,QVariant > & initialDataValues) override;
    void timerEvent(::QTimerEvent * event) override;
    ~QScxmlDataModelWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[20];
};

#endif // SBK_QSCXMLDATAMODELWRAPPER_H

