/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscxml_python.h"

// main header
#include "qscxmlevent_wrapper.h"

// inner classes

// Extra includes
#include <QtScxml/qscxmlevent.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScxmlEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScxmlEvent >()))
        return -1;

    ::QScxmlEvent *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScxmlEvent", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QScxmlEvent::QScxmlEvent()
    // 1: QScxmlEvent::QScxmlEvent(QScxmlEvent)
    if (numArgs == 0) {
        overloadId = 0; // QScxmlEvent()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QScxmlEvent(QScxmlEvent)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QScxmlEvent()
        {

            if (!PyErr_Occurred()) {
                // QScxmlEvent()
                cptr = new ::QScxmlEvent();
            }
            break;
        }
        case 1: // QScxmlEvent(const QScxmlEvent & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScxmlEvent *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScxmlEvent(QScxmlEvent)
                cptr = new ::QScxmlEvent(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScxmlEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScxmlEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScxmlEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScxmlEventFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScxmlEventFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            QVariant cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_delay(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.delay";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // delay()const
            int cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->delay();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_errorMessage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.errorMessage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorMessage()const
            QString cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->errorMessage();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_eventType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.eventType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // eventType()const
            QScxmlEvent::EventType cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->eventType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_invokeId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.invokeId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // invokeId()const
            QString cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->invokeId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_isErrorEvent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.isErrorEvent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isErrorEvent()const
            bool cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->isErrorEvent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_origin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.origin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // origin()const
            QString cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->origin();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_originType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.originType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // originType()const
            QString cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->originType();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_scxmlType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.scxmlType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scxmlType()const
            QString cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->scxmlType();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_sendId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.sendId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sendId()const
            QString cppResult = const_cast<const ::QScxmlEvent *>(cppSelf)->sendId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlEventFunc_setData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlEvent::setData(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setData(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEventFunc_setData_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setData(QVariant)
            cppSelf->setData(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlEventFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlEventFunc_setDelay(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.setDelay";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlEvent::setDelay(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDelay(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEventFunc_setDelay_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDelay(int)
            cppSelf->setDelay(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlEventFunc_setDelay_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlEventFunc_setErrorMessage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.setErrorMessage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlEvent::setErrorMessage(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setErrorMessage(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEventFunc_setErrorMessage_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setErrorMessage(QString)
            cppSelf->setErrorMessage(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlEventFunc_setErrorMessage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlEventFunc_setEventType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.setEventType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlEvent::setEventType(QScxmlEvent::EventType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setEventType(QScxmlEvent::EventType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEventFunc_setEventType_TypeError;

    // Call function/method
    {
        ::QScxmlEvent::EventType cppArg0{QScxmlEvent::PlatformEvent};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEventType(QScxmlEvent::EventType)
            cppSelf->setEventType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlEventFunc_setEventType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlEventFunc_setInvokeId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.setInvokeId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlEvent::setInvokeId(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setInvokeId(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEventFunc_setInvokeId_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInvokeId(QString)
            cppSelf->setInvokeId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlEventFunc_setInvokeId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlEventFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlEvent::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEventFunc_setName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->setName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlEventFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlEventFunc_setOrigin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.setOrigin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlEvent::setOrigin(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setOrigin(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEventFunc_setOrigin_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOrigin(QString)
            cppSelf->setOrigin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlEventFunc_setOrigin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlEventFunc_setOriginType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.setOriginType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlEvent::setOriginType(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setOriginType(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEventFunc_setOriginType_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOriginType(QString)
            cppSelf->setOriginType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlEventFunc_setOriginType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlEventFunc_setSendId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlEvent.setSendId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlEvent::setSendId(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setSendId(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlEventFunc_setSendId_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSendId(QString)
            cppSelf->setSendId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScxmlEventFunc_setSendId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QScxmlEvent_PropertyStrings[] = {
    "data::",
    "delay::",
    "errorEvent:isErrorEvent",
    "errorMessage::",
    "eventType::",
    "invokeId::",
    "name::",
    "origin::",
    "originType::",
    "scxmlType:",
    "sendId::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScxmlEvent_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_clear), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_data), METH_NOARGS},
    {"delay", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_delay), METH_NOARGS},
    {"errorMessage", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_errorMessage), METH_NOARGS},
    {"eventType", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_eventType), METH_NOARGS},
    {"invokeId", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_invokeId), METH_NOARGS},
    {"isErrorEvent", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_isErrorEvent), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_name), METH_NOARGS},
    {"origin", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_origin), METH_NOARGS},
    {"originType", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_originType), METH_NOARGS},
    {"scxmlType", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_scxmlType), METH_NOARGS},
    {"sendId", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_sendId), METH_NOARGS},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_setData), METH_O},
    {"setDelay", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_setDelay), METH_O},
    {"setErrorMessage", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_setErrorMessage), METH_O},
    {"setEventType", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_setEventType), METH_O},
    {"setInvokeId", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_setInvokeId), METH_O},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_setName), METH_O},
    {"setOrigin", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_setOrigin), METH_O},
    {"setOriginType", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_setOriginType), METH_O},
    {"setSendId", reinterpret_cast<PyCFunction>(Sbk_QScxmlEventFunc_setSendId), METH_O},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QScxmlEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScxmlEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScxmlEvent_Type = nullptr;
static SbkObjectType *Sbk_QScxmlEvent_TypeF(void)
{
    return _Sbk_QScxmlEvent_Type;
}

static PyType_Slot Sbk_QScxmlEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScxmlEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScxmlEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScxmlEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScxmlEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScxmlEvent_spec = {
    "2:PySide2.QtScxml.QScxmlEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScxmlEvent_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QScxmlEvent_EventType_PythonToCpp_QScxmlEvent_EventType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScxmlEvent::EventType *>(cppOut) =
        static_cast<::QScxmlEvent::EventType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScxmlEvent_EventType_PythonToCpp_QScxmlEvent_EventType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX]))
        return QScxmlEvent_EventType_PythonToCpp_QScxmlEvent_EventType;
    return {};
}
static PyObject *QScxmlEvent_EventType_CppToPython_QScxmlEvent_EventType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScxmlEvent::EventType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScxmlEvent_PythonToCpp_QScxmlEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScxmlEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScxmlEvent_PythonToCpp_QScxmlEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScxmlEvent_TypeF())))
        return QScxmlEvent_PythonToCpp_QScxmlEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScxmlEvent_PTR_CppToPython_QScxmlEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScxmlEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScxmlEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScxmlEvent_SignatureStrings[] = {
    "1:PySide2.QtScxml.QScxmlEvent(self)",
    "0:PySide2.QtScxml.QScxmlEvent(self,other:PySide2.QtScxml.QScxmlEvent)",
    "PySide2.QtScxml.QScxmlEvent.clear(self)",
    "PySide2.QtScxml.QScxmlEvent.data(self)->QVariant",
    "PySide2.QtScxml.QScxmlEvent.delay(self)->int",
    "PySide2.QtScxml.QScxmlEvent.errorMessage(self)->QString",
    "PySide2.QtScxml.QScxmlEvent.eventType(self)->PySide2.QtScxml.QScxmlEvent.EventType",
    "PySide2.QtScxml.QScxmlEvent.invokeId(self)->QString",
    "PySide2.QtScxml.QScxmlEvent.isErrorEvent(self)->bool",
    "PySide2.QtScxml.QScxmlEvent.name(self)->QString",
    "PySide2.QtScxml.QScxmlEvent.origin(self)->QString",
    "PySide2.QtScxml.QScxmlEvent.originType(self)->QString",
    "PySide2.QtScxml.QScxmlEvent.scxmlType(self)->QString",
    "PySide2.QtScxml.QScxmlEvent.sendId(self)->QString",
    "PySide2.QtScxml.QScxmlEvent.setData(self,data:QVariant)",
    "PySide2.QtScxml.QScxmlEvent.setDelay(self,delayInMiliSecs:int)",
    "PySide2.QtScxml.QScxmlEvent.setErrorMessage(self,message:QString)",
    "PySide2.QtScxml.QScxmlEvent.setEventType(self,type:PySide2.QtScxml.QScxmlEvent.EventType)",
    "PySide2.QtScxml.QScxmlEvent.setInvokeId(self,invokeId:QString)",
    "PySide2.QtScxml.QScxmlEvent.setName(self,name:QString)",
    "PySide2.QtScxml.QScxmlEvent.setOrigin(self,origin:QString)",
    "PySide2.QtScxml.QScxmlEvent.setOriginType(self,originType:QString)",
    "PySide2.QtScxml.QScxmlEvent.setSendId(self,sendId:QString)",
    nullptr}; // Sentinel

void init_QScxmlEvent(PyObject *module)
{
    _Sbk_QScxmlEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScxmlEvent",
        "QScxmlEvent*",
        &Sbk_QScxmlEvent_spec,
        &Shiboken::callCppDestructor< ::QScxmlEvent >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlEvent_Type);
    InitSignatureStrings(pyType, QScxmlEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlEvent_Type), Sbk_QScxmlEvent_PropertyStrings);
    SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScxmlEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScxmlEvent_TypeF(),
        QScxmlEvent_PythonToCpp_QScxmlEvent_PTR,
        is_QScxmlEvent_PythonToCpp_QScxmlEvent_PTR_Convertible,
        QScxmlEvent_PTR_CppToPython_QScxmlEvent);

    Shiboken::Conversions::registerConverterName(converter, "QScxmlEvent");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScxmlEvent).name());


    // Initialization of enums.

    // Initialization of enum 'EventType'.
    SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScxmlEvent_TypeF(),
        "EventType",
        "2:PySide2.QtScxml.QScxmlEvent.EventType",
        "QScxmlEvent::EventType");
    if (!SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX],
        Sbk_QScxmlEvent_TypeF(), "PlatformEvent", (long) QScxmlEvent::EventType::PlatformEvent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX],
        Sbk_QScxmlEvent_TypeF(), "InternalEvent", (long) QScxmlEvent::EventType::InternalEvent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX],
        Sbk_QScxmlEvent_TypeF(), "ExternalEvent", (long) QScxmlEvent::EventType::ExternalEvent))
        return;
    // Register converter for enum 'QScxmlEvent::EventType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX],
            QScxmlEvent_EventType_CppToPython_QScxmlEvent_EventType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScxmlEvent_EventType_PythonToCpp_QScxmlEvent_EventType,
            is_QScxmlEvent_EventType_PythonToCpp_QScxmlEvent_EventType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEVENT_EVENTTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScxmlEvent::EventType");
        Shiboken::Conversions::registerConverterName(converter, "EventType");
    }
    // End of 'EventType' enum.

    qRegisterMetaType< ::QScxmlEvent::EventType >("QScxmlEvent::EventType");
}
