/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtscxml_python.h"

// main header
#include "qscxmlstaticscxmlservicefactory_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QScxmlStaticScxmlServiceFactoryWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QScxmlStaticScxmlServiceFactoryWrapper::QScxmlStaticScxmlServiceFactoryWrapper(const ::QMetaObject * metaObject, const ::QScxmlExecutableContent::InvokeInfo & invokeInfo, const ::QVector<int > & nameList, const ::QVector<QScxmlExecutableContent::ParameterInfo > & parameters, ::QObject * parent) : QScxmlStaticScxmlServiceFactory(metaObject, invokeInfo, nameList, parameters, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QScxmlStaticScxmlServiceFactoryWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QScxmlStaticScxmlServiceFactoryWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QScxmlStaticScxmlServiceFactoryWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QScxmlStaticScxmlServiceFactoryWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QScxmlStaticScxmlServiceFactoryWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlStaticScxmlServiceFactory.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QScxmlStaticScxmlServiceFactoryWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlStaticScxmlServiceFactory.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QScxmlInvokableService * QScxmlStaticScxmlServiceFactoryWrapper::invoke(::QScxmlStateMachine * parentStateMachine)
{
    if (m_PyMethodCache[6])
        return this->::QScxmlStaticScxmlServiceFactory::invoke(parentStateMachine);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "invoke";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QScxmlStaticScxmlServiceFactory::invoke(parentStateMachine);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLSTATEMACHINE_IDX]), parentStateMachine)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLINVOKABLESERVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlStaticScxmlServiceFactory.invoke", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QScxmlInvokableService >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QScxmlInvokableService *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QScxmlStaticScxmlServiceFactoryWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QScxmlStaticScxmlServiceFactoryWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QScxmlStaticScxmlServiceFactory::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QScxmlStaticScxmlServiceFactoryWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QScxmlStaticScxmlServiceFactory::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QScxmlStaticScxmlServiceFactoryWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QScxmlStaticScxmlServiceFactoryWrapper *>(this));
        return QScxmlStaticScxmlServiceFactory::qt_metacast(_clname);
}

QScxmlStaticScxmlServiceFactoryWrapper::~QScxmlStaticScxmlServiceFactoryWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScxmlStaticScxmlServiceFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScxmlStaticScxmlServiceFactory >()))
        return -1;

    ::QScxmlStaticScxmlServiceFactoryWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlStaticScxmlServiceFactory.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScxmlStaticScxmlServiceFactory_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:QScxmlStaticScxmlServiceFactory", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QScxmlStaticScxmlServiceFactory::QScxmlStaticScxmlServiceFactory(const QMetaObject*,QScxmlExecutableContent::InvokeInfo,QVector<int>,QVector<QScxmlExecutableContent::ParameterInfo>,QObject*)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_INVOKEINFO_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_INT_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtScxmlTypeConverters[SBK_QTSCXML_QVECTOR_QSCXMLEXECUTABLECONTENT_PARAMETERINFO_IDX], (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // QScxmlStaticScxmlServiceFactory(const QMetaObject*,QScxmlExecutableContent::InvokeInfo,QVector<int>,QVector<QScxmlExecutableContent::ParameterInfo>,QObject*)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4])))) {
            overloadId = 0; // QScxmlStaticScxmlServiceFactory(const QMetaObject*,QScxmlExecutableContent::InvokeInfo,QVector<int>,QVector<QScxmlExecutableContent::ParameterInfo>,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlStaticScxmlServiceFactory_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[4]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QScxmlStaticScxmlServiceFactory_Init_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[4]))))
                        goto Sbk_QScxmlStaticScxmlServiceFactory_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QMetaObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QScxmlExecutableContent::InvokeInfo cppArg1_local;
        ::QScxmlExecutableContent::InvokeInfo *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_INVOKEINFO_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QVector<int > cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QVector<QScxmlExecutableContent::ParameterInfo > cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return -1;
        ::QObject *cppArg4 = nullptr;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // QScxmlStaticScxmlServiceFactory(const QMetaObject*,QScxmlExecutableContent::InvokeInfo,QVector<int>,QVector<QScxmlExecutableContent::ParameterInfo>,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QScxmlStaticScxmlServiceFactoryWrapper(cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QScxmlStaticScxmlServiceFactoryWrapper(cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4);
            }

            Shiboken::Object::setParent(pyArgs[4], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScxmlStaticScxmlServiceFactory >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScxmlStaticScxmlServiceFactory_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QScxmlStaticScxmlServiceFactory_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QScxmlStaticScxmlServiceFactory_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScxmlStaticScxmlServiceFactoryFunc_invoke(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlStaticScxmlServiceFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLSTATICSCXMLSERVICEFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlStaticScxmlServiceFactory.invoke";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlInvokableServiceFactory::invoke(QScxmlStateMachine*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLSTATEMACHINE_IDX]), (pyArg)))) {
        overloadId = 0; // invoke(QScxmlStateMachine*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlStaticScxmlServiceFactoryFunc_invoke_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScxmlStateMachine *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // invoke(QScxmlStateMachine*)
            QScxmlInvokableService * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScxmlStaticScxmlServiceFactory::invoke(cppArg0)
                : cppSelf->invoke(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLINVOKABLESERVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScxmlStaticScxmlServiceFactoryFunc_invoke_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QScxmlStaticScxmlServiceFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScxmlStaticScxmlServiceFactory_methods[] = {
    {"invoke", reinterpret_cast<PyCFunction>(Sbk_QScxmlStaticScxmlServiceFactoryFunc_invoke), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScxmlStaticScxmlServiceFactory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QScxmlStaticScxmlServiceFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLSTATICSCXMLSERVICEFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QScxmlStaticScxmlServiceFactoryWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QScxmlStaticScxmlServiceFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScxmlStaticScxmlServiceFactory_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScxmlStaticScxmlServiceFactory_Type = nullptr;
static SbkObjectType *Sbk_QScxmlStaticScxmlServiceFactory_TypeF(void)
{
    return _Sbk_QScxmlStaticScxmlServiceFactory_Type;
}

static PyType_Slot Sbk_QScxmlStaticScxmlServiceFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScxmlStaticScxmlServiceFactory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScxmlStaticScxmlServiceFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScxmlStaticScxmlServiceFactory_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScxmlStaticScxmlServiceFactory_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScxmlStaticScxmlServiceFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScxmlStaticScxmlServiceFactory_spec = {
    "2:PySide2.QtScxml.QScxmlStaticScxmlServiceFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScxmlStaticScxmlServiceFactory_slots
};

} //extern "C"

static void *Sbk_QScxmlStaticScxmlServiceFactory_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QScxmlStaticScxmlServiceFactory *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScxmlStaticScxmlServiceFactory_PythonToCpp_QScxmlStaticScxmlServiceFactory_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScxmlStaticScxmlServiceFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScxmlStaticScxmlServiceFactory_PythonToCpp_QScxmlStaticScxmlServiceFactory_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScxmlStaticScxmlServiceFactory_TypeF())))
        return QScxmlStaticScxmlServiceFactory_PythonToCpp_QScxmlStaticScxmlServiceFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScxmlStaticScxmlServiceFactory_PTR_CppToPython_QScxmlStaticScxmlServiceFactory(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QScxmlStaticScxmlServiceFactory *>(const_cast<void *>(cppIn)), Sbk_QScxmlStaticScxmlServiceFactory_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScxmlStaticScxmlServiceFactory_SignatureStrings[] = {
    "PySide2.QtScxml.QScxmlStaticScxmlServiceFactory(self,metaObject:PySide2.QtCore.QMetaObject,invokeInfo:PySide2.QtScxml.QScxmlExecutableContent.InvokeInfo,nameList:QVector[int],parameters:QVector[PySide2.QtScxml.QScxmlExecutableContent.ParameterInfo],parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtScxml.QScxmlStaticScxmlServiceFactory.invoke(self,parentStateMachine:PySide2.QtScxml.QScxmlStateMachine)->PySide2.QtScxml.QScxmlInvokableService",
    nullptr}; // Sentinel

void init_QScxmlStaticScxmlServiceFactory(PyObject *module)
{
    _Sbk_QScxmlStaticScxmlServiceFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScxmlStaticScxmlServiceFactory",
        "QScxmlStaticScxmlServiceFactory*",
        &Sbk_QScxmlStaticScxmlServiceFactory_spec,
        &Shiboken::callCppDestructor< ::QScxmlStaticScxmlServiceFactory >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLINVOKABLESERVICEFACTORY_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlStaticScxmlServiceFactory_Type);
    InitSignatureStrings(pyType, QScxmlStaticScxmlServiceFactory_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlStaticScxmlServiceFactory_Type), Sbk_QScxmlStaticScxmlServiceFactory_PropertyStrings);
    SbkPySide2_QtScxmlTypes[SBK_QSCXMLSTATICSCXMLSERVICEFACTORY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScxmlStaticScxmlServiceFactory_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScxmlStaticScxmlServiceFactory_TypeF(),
        QScxmlStaticScxmlServiceFactory_PythonToCpp_QScxmlStaticScxmlServiceFactory_PTR,
        is_QScxmlStaticScxmlServiceFactory_PythonToCpp_QScxmlStaticScxmlServiceFactory_PTR_Convertible,
        QScxmlStaticScxmlServiceFactory_PTR_CppToPython_QScxmlStaticScxmlServiceFactory);

    Shiboken::Conversions::registerConverterName(converter, "QScxmlStaticScxmlServiceFactory");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlStaticScxmlServiceFactory*");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlStaticScxmlServiceFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScxmlStaticScxmlServiceFactory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScxmlStaticScxmlServiceFactoryWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QScxmlStaticScxmlServiceFactory_TypeF(), &Sbk_QScxmlStaticScxmlServiceFactory_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QScxmlStaticScxmlServiceFactory_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QScxmlStaticScxmlServiceFactory_TypeF(), &::QScxmlStaticScxmlServiceFactory::staticMetaObject, sizeof(QScxmlStaticScxmlServiceFactoryWrapper));
}
